/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class BufferedStreamGobbler
implements Runnable {
    private static final Logger sLogger = Logger.getLogger(BufferedStreamGobbler.class);
    private InputStream mInStream;
    private PipedInputStream mPipedInputStream;
    private PipedOutputStream mPipedOutputStream;
    private BufferedReader mPipedInputStreamReader;
    private ExecutorService mExecSvc = Executors.newSingleThreadExecutor();

    public BufferedStreamGobbler(InputStream inStream) throws IOException {
        this(inStream, -1);
    }

    public BufferedStreamGobbler(InputStream inStream, int bufferSize) throws IOException {
        this.mInStream = inStream;
        this.initPipedStreams(bufferSize);
    }

    private void initPipedStreams(int bufferSize) throws IOException {
        this.mPipedInputStream = bufferSize > 0 ? new PipedInputStream(bufferSize) : new PipedInputStream();
        this.mPipedOutputStream = new PipedOutputStream();
        this.mPipedOutputStream.connect(this.mPipedInputStream);
        this.mPipedInputStreamReader = new BufferedReader(new InputStreamReader(this.mPipedInputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread t = Thread.currentThread();
        InputStreamReader ir = new InputStreamReader(this.mInStream);
        BufferedReader br = new BufferedReader(ir);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(this.mPipedOutputStream));
        try {
            String line = br.readLine();
            while (line != null) {
                if (sLogger.isDebugEnabled()) {
                    sLogger.debug((Object)String.format("Receive data from %s: %s", t.getName(), line));
                }
                pw.println(line);
                pw.flush();
                line = br.readLine();
            }
        }
        catch (IOException e) {
            sLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            pw.close();
            try {
                this.mPipedOutputStream.close();
            }
            catch (IOException e) {
                sLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                br.close();
            }
            catch (IOException e) {
                sLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                ir.close();
            }
            catch (IOException e) {
                sLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getLastGobbledLine() throws IOException {
        return this.mPipedInputStreamReader.readLine();
    }

    public String getLastGobbledLine(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Future<String> f = null;
        try {
            f = this.mExecSvc.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return BufferedStreamGobbler.this.mPipedInputStreamReader.readLine();
                }
            });
            return f.get(timeout, unit);
        }
        catch (TimeoutException e) {
            if (f != null) {
                boolean isCancelled = f.cancel(true);
                sLogger.debug((Object)String.format("Attempt to cancel future: %s", isCancelled));
            }
            throw e;
        }
    }
}

