/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.inject;

import com.google.gson.JsonObject;
import edu.mayo.pipes.JSON.inject.BaseInjector;
import edu.mayo.pipes.JSON.inject.ColumnAware;
import edu.mayo.pipes.JSON.inject.Injector;
import edu.mayo.pipes.JSON.inject.JsonType;
import edu.mayo.pipes.history.History;

public class ColumnArrayInjector
extends BaseInjector
implements Injector,
ColumnAware {
    private int mCol;
    private String mKey;
    private JsonType mType;
    private String mDelimiterRegex;
    private boolean strip = false;

    public ColumnArrayInjector(int column, JsonType type, String delimiterRegex) {
        this(column, null, type, delimiterRegex);
    }

    public ColumnArrayInjector(int column, String key, JsonType type, String delimiterRegex, boolean stripWhitespace) {
        this.init(column, key, type, delimiterRegex);
        this.strip = stripWhitespace;
    }

    public ColumnArrayInjector(int column, String key, JsonType type, String delimiterRegex) {
        this.init(column, key, type, delimiterRegex);
    }

    private void init(int column, String key, JsonType type, String delimiterRegex) {
        if (column == 0) {
            throw new IllegalArgumentException("Zero is not a valid column - columns begin with 1.");
        }
        this.mCol = column;
        this.mKey = key;
        this.mType = type;
        this.mDelimiterRegex = delimiterRegex;
    }

    @Override
    public void inject(JsonObject object, History history) {
        String key = this.mKey == null ? history.getMetaData().getColumns().get(this.mCol - 1).getColumnName() : this.mKey;
        String value = (String)history.get(this.mCol - 1);
        String[] values = this.isNull(value) ? new String[]{} : value.split(this.mDelimiterRegex);
        if (this.strip) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
        }
        super.injectAsArray(object, key, values, this.mType);
    }

    @Override
    public int getColumn() {
        return this.mCol;
    }
}

