/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import gnu.trove.procedure.TIntIntProcedure;
import java.io.Serializable;

class StatsProcedure
implements TIntIntProcedure,
Serializable {
    int minKey = Integer.MAX_VALUE;
    int maxKey = Integer.MIN_VALUE;
    int minValue = Integer.MAX_VALUE;
    int maxValue = Integer.MIN_VALUE;
    long sum = 0L;
    double variance = 0.0;
    double mean = 0.0;
    double s2sum = 0.0;
    int count = 0;

    StatsProcedure(double mean) {
        this.mean = mean;
    }

    public boolean execute(int key, int value) {
        if (key < this.minKey) {
            this.minKey = key;
        }
        if (key > this.maxKey) {
            this.maxKey = key;
        }
        if (value < this.minValue) {
            this.minValue = value;
        }
        if (value > this.maxValue) {
            this.maxValue = value;
        }
        this.sum += (long)(key * value);
        this.count += value;
        double s2 = ((double)key - this.mean) * ((double)key - this.mean) * (double)value;
        this.s2sum += s2;
        return true;
    }

    double mean() {
        this.mean = this.count <= 0 ? 0.0 : (double)this.sum / (double)this.count;
        return this.mean;
    }

    double variance() {
        if (this.maxKey == this.minKey) {
            return 0.0;
        }
        if (this.count <= 0) {
            return 0.0;
        }
        return this.s2sum / (double)(this.count - 1);
    }
}

