/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.stats.CountByType;
import ca.mcgill.mcb.pcingola.stats.GeneCountByTypeTable;
import ca.mcgill.mcb.pcingola.stats.SamplingStats;
import ca.mcgill.mcb.pcingola.stats.plot.GoogleGenePercentBar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ChangeEffectResutStats
implements SamplingStats<ChangeEffect> {
    public static final String CHANGE_SEPARATOR = "\t";
    Genome genome;
    CountByType countByEffect;
    CountByType countByCodon;
    CountByType countByAa;
    CountByType countByGeneRegion;
    CountByType countByImpact;
    CountByType countByFunctionalClass;
    CountByType countByBioType;
    HashSet<String> codonSet;
    HashSet<String> aaSet;
    HashSet<String> geneSet;
    int aaChangeCountMax = Integer.MIN_VALUE;
    int codonChangeCountMax = Integer.MIN_VALUE;
    int countWarnings = 0;
    GeneCountByTypeTable geneCountByRegionTable;
    GeneCountByTypeTable geneCountByEffectTable;

    public ChangeEffectResutStats(Genome genome) {
        this.genome = genome;
        this.countByEffect = new CountByType();
        this.countByCodon = new CountByType();
        this.countByAa = new CountByType();
        this.countByGeneRegion = new CountByType();
        this.countByImpact = new CountByType();
        this.countByFunctionalClass = new CountByType();
        this.codonSet = new HashSet();
        this.aaSet = new HashSet();
        this.geneSet = new HashSet();
        this.geneCountByRegionTable = new GeneCountByTypeTable();
        this.geneCountByEffectTable = new GeneCountByTypeTable();
    }

    private String changeKey(String oldItem, String newItem) {
        return oldItem + CHANGE_SEPARATOR + newItem;
    }

    public String getAaChangeColor(String oldAa, String newAa) {
        return this.countByAa.getColorHtml(this.changeKey(oldAa, newAa));
    }

    public long getAaChangeCount(String oldAa, String newAa) {
        return this.countByAa.get(this.changeKey(oldAa, newAa));
    }

    public List<String> getAaList() {
        ArrayList<String> aas = new ArrayList<String>();
        aas.addAll(this.aaSet);
        Collections.sort(aas);
        return aas;
    }

    public String getCodonChangeColor(String oldCodon, String newCodon) {
        return this.countByCodon.getColorHtml(this.changeKey(oldCodon, newCodon));
    }

    public long getCodonChangeCount(String oldCodon, String newCodon) {
        return this.countByCodon.get(this.changeKey(oldCodon, newCodon));
    }

    public List<String> getCodonList() {
        ArrayList<String> codons = new ArrayList<String>();
        codons.addAll(this.codonSet);
        Collections.sort(codons);
        return codons;
    }

    public CountByType getCountByEffect() {
        return this.countByEffect;
    }

    public CountByType getCountByFunctionalClass() {
        return this.countByFunctionalClass;
    }

    public CountByType getCountByGeneRegion() {
        return this.countByGeneRegion;
    }

    public CountByType getCountByImpact() {
        return this.countByImpact;
    }

    public int getCountWarnings() {
        return this.countWarnings;
    }

    public GeneCountByTypeTable getGeneCountByEffectTable() {
        return this.geneCountByEffectTable;
    }

    public GeneCountByTypeTable getGeneCountByRegionTable() {
        return this.geneCountByRegionTable;
    }

    public String getPlotGene() {
        GoogleGenePercentBar gb = new GoogleGenePercentBar("Variations", "", "%", 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)ChangeEffect.EffectType.INTERGENIC)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)ChangeEffect.EffectType.UPSTREAM)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)ChangeEffect.EffectType.UTR_5_PRIME)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)ChangeEffect.EffectType.EXON)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)ChangeEffect.EffectType.SPLICE_SITE_DONOR)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)ChangeEffect.EffectType.INTRON)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)ChangeEffect.EffectType.SPLICE_SITE_ACCEPTOR)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)ChangeEffect.EffectType.UTR_3_PRIME)), 100.0 * this.countByGeneRegion.percent("" + (Object)((Object)ChangeEffect.EffectType.DOWNSTREAM)));
        return gb.toURLString();
    }

    public double getSilentRatio() {
        long mis = this.countByFunctionalClass.get(ChangeEffect.FunctionalClass.MISSENSE.toString());
        long silent = this.countByFunctionalClass.get(ChangeEffect.FunctionalClass.SILENT.toString());
        return (double)mis / (double)silent;
    }

    @Override
    public boolean hasData() {
        return this.countByEffect.hasData();
    }

    @Override
    public void sample(ChangeEffect changeEffect) {
        int i;
        int max;
        Gene gene;
        Marker marker;
        if (changeEffect.getWarning() != null && changeEffect.getWarning().length() > 0) {
            ++this.countWarnings;
        }
        String effect = changeEffect.effect(true, false, false);
        this.countByEffect.inc(effect);
        String geneRegion = changeEffect.getGeneRegion();
        this.countByGeneRegion.inc(geneRegion);
        String impact = changeEffect.getEffectImpact().toString();
        this.countByImpact.inc(impact);
        ChangeEffect.FunctionalClass fc = changeEffect.getFunctionalClass();
        if (fc != ChangeEffect.FunctionalClass.NONE) {
            this.countByFunctionalClass.inc(fc.toString());
        }
        if ((marker = changeEffect.getMarker()) != null && (gene = changeEffect.getGene()) != null) {
            this.geneCountByRegionTable.sample(gene, marker, geneRegion, changeEffect);
            this.geneCountByRegionTable.sample(gene, gene, ChangeEffect.EffectType.GENE.toString(), changeEffect);
            String eff = changeEffect.effect(true, false, false);
            this.geneCountByEffectTable.sample(gene, marker, eff, changeEffect);
        }
        if (changeEffect.getCodonsOld() != null && changeEffect.getCodonsOld().length() > 0) {
            String[] oldCodons = this.split(changeEffect.getCodonsOld(), 3);
            String[] newCodons = this.split(changeEffect.getCodonsNew(), 3);
            max = Math.max(oldCodons.length, newCodons.length);
            for (i = 0; i < max; ++i) {
                String oldCodon = "-";
                String newCodon = "-";
                if (i < oldCodons.length) {
                    oldCodon = oldCodons[i].toUpperCase();
                }
                if (i < newCodons.length) {
                    newCodon = newCodons[i].toUpperCase();
                }
                String codonChangeKey = this.changeKey(oldCodon, newCodon);
                this.codonSet.add(oldCodon);
                this.codonSet.add(newCodon);
                this.countByCodon.inc(codonChangeKey);
            }
        }
        if (changeEffect.getAaOld() != null && changeEffect.getAaOld().length() > 0) {
            String[] oldAas = this.split(changeEffect.getAaOld(), 1);
            String[] newAas = this.split(changeEffect.getAaNew(), 1);
            max = Math.max(oldAas.length, newAas.length);
            for (i = 0; i < max; ++i) {
                String oldAa = "-";
                String newAa = "-";
                if (i < oldAas.length) {
                    oldAa = oldAas[i].toUpperCase();
                }
                if (i < newAas.length) {
                    newAa = newAas[i].toUpperCase();
                }
                String aaChangeKey = this.changeKey(oldAa, newAa);
                this.aaSet.add(oldAa);
                this.aaSet.add(newAa);
                this.countByAa.inc(aaChangeKey);
            }
        }
    }

    String[] split(String str, int size) {
        int numStr = str.length() / size;
        String[] splitStr = new String[numStr];
        char[] chars = str.toCharArray();
        int i = 0;
        for (int h = 0; i < chars.length && h < splitStr.length; ++h) {
            String newStr = "";
            for (int j = 0; j < size && i < chars.length; ++j, ++i) {
                newStr = newStr + chars[i];
            }
            splitStr[h] = newStr;
        }
        return splitStr;
    }
}

