/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.binseq.comparator;

import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.binseq.coder.DnaCoder;
import ca.mcgill.mcb.pcingola.binseq.comparator.SubsequenceComparator;

public class DnaSubsequenceComparator<T extends DnaSequence>
extends SubsequenceComparator<T> {
    boolean differentLengthsAreEqual;
    int maxDifferentBases = 0;

    public DnaSubsequenceComparator(boolean differentLengthsAreEqual) {
        this.differentLengthsAreEqual = differentLengthsAreEqual;
    }

    public DnaSubsequenceComparator(boolean differentLengthsAreEqual, int maxDifferentBases) {
        this.differentLengthsAreEqual = differentLengthsAreEqual;
        this.maxDifferentBases = maxDifferentBases;
    }

    @Override
    public int compare(DnaSequence seq1, int index1, DnaSequence seq2, int index2) {
        int i2;
        if (index1 >= seq1.length()) {
            return -1;
        }
        if (index2 >= seq2.length()) {
            return 1;
        }
        int i1 = index1;
        for (i2 = index2; i1 < seq1.length() && i2 < seq2.length(); ++i1, ++i2) {
            int base2;
            int base1 = seq1.getCode(i1);
            int comp = base1 - (base2 = seq2.getCode(i2));
            if (comp == 0) continue;
            return comp;
        }
        if (this.differentLengthsAreEqual) {
            return 0;
        }
        int comp = seq1.length() - i1 - (seq2.length() - i2);
        return comp;
    }

    @Override
    public int score(DnaSequence seq1, int index1, DnaSequence seq2, int index2) {
        if (index1 == 0) {
            return DnaCoder.get().score(seq1.getCodes(), seq2.getCodes(), index2, Math.min(seq1.length(), seq2.length() - index2), this.maxDifferentBases);
        }
        if (index2 == 0) {
            return DnaCoder.get().score(seq2.getCodes(), seq1.getCodes(), index1, Math.min(seq2.length(), seq1.length() - index1), this.maxDifferentBases);
        }
        return this.scoreSlow(seq1, index1, seq2, index2);
    }

    public int scoreSlow(DnaSequence seq1, int index1, DnaSequence seq2, int index2) {
        if (index1 >= seq1.length()) {
            return 0;
        }
        if (index2 >= seq2.length()) {
            return 0;
        }
        int score = 0;
        int i1 = index1;
        int countDiff = 0;
        for (int i2 = index2; i1 < seq1.length() && i2 < seq2.length(); ++i1, ++i2) {
            int base2;
            int base1 = seq1.getCode(i1);
            int comp = base1 - (base2 = seq2.getCode(i2));
            if (comp != 0 && ++countDiff > this.maxDifferentBases) {
                return 0;
            }
            ++score;
        }
        return score;
    }
}

