/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.TagValueAndUnsignedArrayFlag;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.StringUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class ReadTag
implements Comparable<ReadTag> {
    private static final long MAX_INT = Integer.MAX_VALUE;
    private static final long MAX_UINT = 0xFFFFFFFFL;
    private static final long MAX_SHORT = 32767L;
    private static final long MAX_USHORT = 65535L;
    private static final long MAX_BYTE = 127L;
    private static final long MAX_UBYTE = 255L;
    private String key;
    private String keyAndType;
    public String keyType3Bytes;
    public int keyType3BytesAsInt;
    private char type;
    private Object value;
    private short code;
    private byte index;
    private static final ThreadLocal<ByteBuffer> bufferLocal = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(0xA00000);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            return byteBuffer;
        }
    };
    private static final Charset charset = Charset.forName("US-ASCII");

    public ReadTag(int n, byte[] byArray, ValidationStringency validationStringency) {
        this.type = (char)(0xFF & n);
        this.key = new String(new char[]{(char)(n >> 16 & 0xFF), (char)(n >> 8 & 0xFF)});
        this.value = ReadTag.restoreValueFromByteArray(this.type, byArray, validationStringency);
        this.keyType3Bytes = this.key + this.type;
        this.keyType3BytesAsInt = n;
        this.code = SAMTagUtil.getSingleton().makeBinaryTag(this.key);
    }

    private ReadTag(String string, char c, Object object) {
        if (string == null) {
            throw new NullPointerException("Tag key cannot be null.");
        }
        if (object == null) {
            throw new NullPointerException("Tag value cannot be null.");
        }
        this.value = object;
        if (string.length() == 2) {
            this.key = string;
            this.type = c;
            this.keyAndType = string + ":" + this.getType();
        } else if (string.length() == 4) {
            this.key = string.substring(0, 2);
            this.type = string.charAt(3);
        }
        this.keyType3Bytes = this.key + this.type;
        this.keyType3BytesAsInt = ReadTag.nameType3BytesToInt(this.key, this.type);
        this.code = SAMTagUtil.getSingleton().makeBinaryTag(this.key);
    }

    public static int name3BytesToInt(byte[] byArray) {
        int n = 0xFF & byArray[0];
        n <<= 8;
        n |= 0xFF & byArray[1];
        n <<= 8;
        return n |= 0xFF & byArray[2];
    }

    public static int nameType3BytesToInt(String string, char c) {
        int n = 0xFF & string.charAt(0);
        n <<= 8;
        n |= 0xFF & string.charAt(1);
        n <<= 8;
        return n |= 0xFF & c;
    }

    public static String intToNameType3Bytes(int n) {
        byte by = (byte)(0xFF & n);
        byte by2 = (byte)(0xFF & n >> 8);
        byte by3 = (byte)(0xFF & n >> 16);
        return new String(new byte[]{by3, by2, by});
    }

    public static String intToNameType4Bytes(int n) {
        byte by = (byte)(0xFF & n);
        byte by2 = (byte)(0xFF & n >> 8);
        byte by3 = (byte)(0xFF & n >> 16);
        return new String(new byte[]{by3, by2, 58, by});
    }

    public SAMRecord.SAMTagAndValue createSAMTag() {
        return new SAMRecord.SAMTagAndValue(this.key, this.value);
    }

    public static ReadTag deriveTypeFromKeyAndType(String string, Object object) {
        if (string.length() != 4) {
            throw new RuntimeException("Tag key and type must be 4 char long: " + string);
        }
        return new ReadTag(string.substring(0, 2), string.charAt(3), object);
    }

    public static ReadTag deriveTypeFromValue(String string, Object object) {
        if (string.length() != 2) {
            throw new RuntimeException("Tag key must be 2 char long: " + string);
        }
        return new ReadTag(string, ReadTag.getTagValueType(object), object);
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public int compareTo(ReadTag readTag) {
        return this.key.compareTo(readTag.key);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReadTag)) {
            return false;
        }
        ReadTag readTag = (ReadTag)object;
        return this.key.equals(readTag.key) && (this.value == null && readTag.value == null || this.value != null && this.value.equals(readTag.value));
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public Object getValue() {
        return this.value;
    }

    char getType() {
        return this.type;
    }

    public String getKeyAndType() {
        return this.keyAndType;
    }

    public byte[] getValueAsByteArray() {
        return ReadTag.writeSingleValue((byte)this.type, this.value, false);
    }

    private static Object restoreValueFromByteArray(char c, byte[] byArray, ValidationStringency validationStringency) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return ReadTag.readSingleValue((byte)c, byteBuffer, validationStringency);
    }

    private static char getTagValueType(Object object) {
        if (object instanceof String) {
            return 'Z';
        }
        if (object instanceof Character) {
            return 'A';
        }
        if (object instanceof Float) {
            return 'f';
        }
        if (object instanceof Number) {
            if (!(object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long)) {
                throw new IllegalArgumentException("Unrecognized tag type " + object.getClass().getName());
            }
            return ReadTag.getIntegerType(((Number)object).longValue());
        }
        if (object instanceof byte[] || object instanceof short[] || object instanceof int[] || object instanceof float[]) {
            return 'B';
        }
        throw new IllegalArgumentException("When writing BAM, unrecognized tag type " + object.getClass().getName());
    }

    private static char getIntegerType(long l) {
        if (l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Integer attribute value too large: " + l);
        }
        if (l > Integer.MAX_VALUE) {
            return 'I';
        }
        if (l > 65535L) {
            return 'i';
        }
        if (l > 32767L) {
            return 'S';
        }
        if (l > 255L) {
            return 's';
        }
        if (l > 127L) {
            return 'C';
        }
        if (l >= -128L) {
            return 'c';
        }
        if (l >= -32768L) {
            return 's';
        }
        if (l >= Integer.MIN_VALUE) {
            return 'i';
        }
        throw new IllegalArgumentException("Integer attribute value too negative to be encoded in BAM");
    }

    public void setIndex(byte by) {
        this.index = by;
    }

    public byte getIndex() {
        return this.index;
    }

    public static byte[] writeSingleValue(byte by, Object object, boolean bl) {
        Object object2;
        ByteBuffer byteBuffer = bufferLocal.get();
        byteBuffer.clear();
        switch (by) {
            case 90: {
                object2 = (String)object;
                byteBuffer.put(((String)object2).getBytes(charset));
                byteBuffer.put((byte)0);
                break;
            }
            case 65: {
                byteBuffer.put((byte)((Character)object).charValue());
                break;
            }
            case 73: {
                byteBuffer.putLong((Long)object);
                byteBuffer.position(byteBuffer.position() - 4);
                break;
            }
            case 105: {
                byteBuffer.putInt(((Number)object).intValue());
                break;
            }
            case 115: {
                byteBuffer.putShort(((Number)object).shortValue());
                break;
            }
            case 83: {
                byteBuffer.putInt(((Number)object).intValue());
                byteBuffer.position(byteBuffer.position() - 2);
                break;
            }
            case 99: {
                byteBuffer.put(((Number)object).byteValue());
                break;
            }
            case 67: {
                byteBuffer.putShort(((Integer)object).shortValue());
                byteBuffer.position(byteBuffer.position() - 1);
                break;
            }
            case 102: {
                byteBuffer.putFloat(((Float)object).floatValue());
                break;
            }
            case 72: {
                object2 = StringUtil.bytesToHexString((byte[])object);
                byteBuffer.put(((String)object2).getBytes(charset));
                byteBuffer.put((byte)0);
                break;
            }
            case 66: {
                ReadTag.writeArray(object, bl, byteBuffer);
                break;
            }
            default: {
                throw new SAMFormatException("Unrecognized tag type: " + (char)by);
            }
        }
        byteBuffer.flip();
        object2 = new byte[byteBuffer.limit()];
        byteBuffer.get((byte[])object2);
        return object2;
    }

    private static void writeArray(Object object, boolean bl, ByteBuffer byteBuffer) {
        if (object instanceof byte[]) {
            byteBuffer.put((byte)(bl ? 67 : 99));
            byte[] byArray = (byte[])object;
            byteBuffer.putInt(byArray.length);
            for (byte by : byArray) {
                byteBuffer.put(by);
            }
        } else if (object instanceof short[]) {
            byteBuffer.put((byte)(bl ? 83 : 115));
            short[] sArray = (short[])object;
            byteBuffer.putInt(sArray.length);
            for (short s : sArray) {
                byteBuffer.putShort(s);
            }
        } else if (object instanceof int[]) {
            byteBuffer.put((byte)(bl ? 73 : 105));
            int[] nArray = (int[])object;
            byteBuffer.putInt(nArray.length);
            for (int n : nArray) {
                byteBuffer.putInt(n);
            }
        } else if (object instanceof float[]) {
            byteBuffer.put((byte)102);
            float[] fArray = (float[])object;
            byteBuffer.putInt(fArray.length);
            for (float f : fArray) {
                byteBuffer.putFloat(f);
            }
        } else {
            throw new SAMException("Unrecognized array value type: " + object.getClass());
        }
    }

    public static Object readSingleValue(byte by, ByteBuffer byteBuffer, ValidationStringency validationStringency) {
        switch (by) {
            case 90: {
                return ReadTag.readNullTerminatedString(byteBuffer);
            }
            case 65: {
                return Character.valueOf((char)byteBuffer.get());
            }
            case 73: {
                long l = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                if (l <= Integer.MAX_VALUE) {
                    return (int)l;
                }
                if (!SAMUtils.isValidUnsignedIntegerAttribute(l)) {
                    SAMUtils.processValidationError(new SAMValidationError(SAMValidationError.Type.TAG_VALUE_TOO_LARGE, "Unsigned integer is out of range for a 32-bit unsigned value: " + l, null), validationStringency);
                }
                return l;
            }
            case 105: {
                return byteBuffer.getInt();
            }
            case 115: {
                return (int)byteBuffer.getShort();
            }
            case 83: {
                return byteBuffer.getShort() & 0xFFFF;
            }
            case 99: {
                return (int)byteBuffer.get();
            }
            case 67: {
                return byteBuffer.get() & 0xFF;
            }
            case 102: {
                return Float.valueOf(byteBuffer.getFloat());
            }
            case 72: {
                String string = ReadTag.readNullTerminatedString(byteBuffer);
                return StringUtil.hexStringToBytes(string);
            }
            case 66: {
                TagValueAndUnsignedArrayFlag tagValueAndUnsignedArrayFlag = ReadTag.readArray(byteBuffer);
                return tagValueAndUnsignedArrayFlag.value;
            }
        }
        throw new SAMFormatException("Unrecognized tag type: " + (char)by);
    }

    private static TagValueAndUnsignedArrayFlag readArray(ByteBuffer byteBuffer) {
        Object[] objectArray;
        byte by = byteBuffer.get();
        boolean bl = Character.isUpperCase(by);
        int n = byteBuffer.getInt();
        switch (Character.toLowerCase(by)) {
            case 99: {
                byte[] byArray;
                objectArray = byArray = new byte[n];
                byteBuffer.get(byArray);
                break;
            }
            case 115: {
                short[] sArray = new short[n];
                objectArray = sArray;
                for (int i = 0; i < n; ++i) {
                    sArray[i] = byteBuffer.getShort();
                }
                break;
            }
            case 105: {
                int[] nArray = new int[n];
                objectArray = nArray;
                for (int i = 0; i < n; ++i) {
                    nArray[i] = byteBuffer.getInt();
                }
                break;
            }
            case 102: {
                float[] fArray = new float[n];
                objectArray = fArray;
                for (int i = 0; i < n; ++i) {
                    fArray[i] = byteBuffer.getFloat();
                }
                break;
            }
            default: {
                throw new SAMFormatException("Unrecognized tag array type: " + (char)by);
            }
        }
        return new TagValueAndUnsignedArrayFlag(objectArray, bl);
    }

    private static String readNullTerminatedString(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        int n = byteBuffer.position();
        while (byteBuffer.get() != 0) {
        }
        int n2 = byteBuffer.position();
        byte[] byArray = new byte[n2 - n - 1];
        byteBuffer.reset();
        byteBuffer.get(byArray);
        byteBuffer.get();
        return StringUtil.bytesToString(byArray);
    }
}

