/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.io.CRC32InputStream;
import htsjdk.samtools.cram.io.CRC32OutputStream;
import htsjdk.samtools.cram.io.CramInt;
import htsjdk.samtools.cram.io.ExternalCompression;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.BlockContentType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class Block {
    private BlockCompressionMethod method;
    private BlockContentType contentType;
    private int contentId;
    private int compressedContentSize;
    private int rawContentSize;
    private byte[] rawContent;
    private byte[] compressedContent;

    public Block() {
    }

    public static Block readFromInputStream(int n, InputStream inputStream) throws IOException {
        boolean bl;
        Block block = new Block();
        boolean bl2 = bl = n >= CramVersions.CRAM_v3.major;
        if (bl) {
            inputStream = new CRC32InputStream(inputStream);
        }
        block.setMethod(BlockCompressionMethod.values()[inputStream.read()]);
        int n2 = inputStream.read();
        block.setContentType(BlockContentType.values()[n2]);
        block.setContentId(ITF8.readUnsignedITF8(inputStream));
        block.compressedContentSize = ITF8.readUnsignedITF8(inputStream);
        block.rawContentSize = ITF8.readUnsignedITF8(inputStream);
        block.compressedContent = new byte[block.compressedContentSize];
        InputStreamUtils.readFully(inputStream, block.compressedContent, 0, block.compressedContent.length);
        if (bl) {
            int n3 = ((CRC32InputStream)inputStream).getCRC32();
            int n4 = CramInt.int32(inputStream);
            if (n4 != n3) {
                throw new RuntimeException(String.format("Block CRC32 mismatch: %04x vs %04x", n4, n3));
            }
        }
        block.uncompress();
        return block;
    }

    public static Block buildNewSliceHeaderBlock(byte[] byArray) {
        return new Block(BlockContentType.MAPPED_SLICE, byArray);
    }

    public static Block buildNewCore(byte[] byArray) {
        return new Block(BlockContentType.CORE, byArray);
    }

    public static Block buildNewFileHeaderBlock(byte[] byArray) {
        Block block = new Block(BlockContentType.FILE_HEADER, byArray);
        block.compress();
        return block;
    }

    private Block(BlockContentType blockContentType, byte[] byArray) {
        this.setMethod(BlockCompressionMethod.RAW);
        this.setContentType(blockContentType);
        this.setContentId(0);
        if (byArray != null) {
            this.setRawContent(byArray);
        }
    }

    public String toString() {
        String string = this.rawContent == null ? "NULL" : Arrays.toString(Arrays.copyOf(this.rawContent, Math.min(5, this.rawContent.length)));
        String string2 = this.compressedContent == null ? "NULL" : Arrays.toString(Arrays.copyOf(this.compressedContent, Math.min(5, this.compressedContent.length)));
        return String.format("method=%s, type=%s, id=%d, raw size=%d, compressed size=%d, raw=%s, comp=%s.", this.getMethod().name(), this.getContentType().name(), this.getContentId(), this.rawContentSize, this.compressedContentSize, string, string2);
    }

    boolean isCompressed() {
        return this.compressedContent != null;
    }

    boolean isUncompressed() {
        return this.rawContent != null;
    }

    public void setRawContent(byte[] byArray) {
        this.rawContent = byArray;
        this.rawContentSize = byArray == null ? 0 : byArray.length;
        this.compressedContent = null;
        this.compressedContentSize = 0;
    }

    public byte[] getRawContent() {
        if (this.rawContent == null) {
            this.uncompress();
        }
        return this.rawContent;
    }

    public int getRawContentSize() {
        return this.rawContentSize;
    }

    public void setContent(byte[] byArray, byte[] byArray2) {
        this.rawContent = byArray;
        this.compressedContent = byArray2;
        this.rawContentSize = byArray == null ? 0 : byArray.length;
        this.compressedContentSize = byArray2 == null ? 0 : byArray2.length;
    }

    void setCompressedContent(byte[] byArray) {
        this.compressedContent = byArray;
        this.compressedContentSize = byArray == null ? 0 : byArray.length;
        this.rawContent = null;
        this.rawContentSize = 0;
    }

    byte[] getCompressedContent() {
        if (this.compressedContent == null) {
            this.compress();
        }
        return this.compressedContent;
    }

    private void compress() {
        if (this.compressedContent != null || this.rawContent == null) {
            return;
        }
        switch (this.getMethod()) {
            case RAW: {
                this.compressedContent = this.rawContent;
                this.compressedContentSize = this.rawContentSize;
                break;
            }
            case GZIP: {
                try {
                    this.compressedContent = ExternalCompression.gzip(this.rawContent);
                }
                catch (IOException iOException) {
                    throw new RuntimeException("This should have never happened.", iOException);
                }
                this.compressedContentSize = this.compressedContent.length;
                break;
            }
            case RANS: {
                this.compressedContent = ExternalCompression.rans(this.rawContent, 1);
                this.compressedContentSize = this.compressedContent.length;
                break;
            }
        }
    }

    private void uncompress() {
        if (this.rawContent != null || this.compressedContent == null) {
            return;
        }
        switch (this.getMethod()) {
            case RAW: {
                this.rawContent = this.compressedContent;
                this.rawContentSize = this.compressedContentSize;
                break;
            }
            case GZIP: {
                try {
                    this.rawContent = ExternalCompression.gunzip(this.compressedContent);
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException("This should have never happened.", iOException);
                }
            }
            case BZIP2: {
                try {
                    this.rawContent = ExternalCompression.unbzip2(this.compressedContent);
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException("This should have never happened.", iOException);
                }
            }
            case LZMA: {
                try {
                    this.rawContent = ExternalCompression.unxz(this.compressedContent);
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException("This should have never happened.", iOException);
                }
            }
            case RANS: {
                this.rawContent = ExternalCompression.unrans(this.compressedContent);
                break;
            }
            default: {
                throw new RuntimeException("Unknown block compression method: " + this.getMethod().name());
            }
        }
    }

    public void write(int n, OutputStream outputStream) throws IOException {
        if (n >= CramVersions.CRAM_v3.major) {
            CRC32OutputStream cRC32OutputStream = new CRC32OutputStream(outputStream);
            this.doWrite(cRC32OutputStream);
            outputStream.write(cRC32OutputStream.getCrc32_LittleEndian());
        } else {
            this.doWrite(outputStream);
        }
    }

    private void doWrite(OutputStream outputStream) throws IOException {
        if (!this.isCompressed()) {
            this.compress();
        }
        if (!this.isUncompressed()) {
            this.uncompress();
        }
        outputStream.write(this.getMethod().ordinal());
        outputStream.write(this.getContentType().ordinal());
        ITF8.writeUnsignedITF8(this.getContentId(), outputStream);
        ITF8.writeUnsignedITF8(this.compressedContentSize, outputStream);
        ITF8.writeUnsignedITF8(this.rawContentSize, outputStream);
        outputStream.write(this.getCompressedContent());
    }

    BlockCompressionMethod getMethod() {
        return this.method;
    }

    public void setMethod(BlockCompressionMethod blockCompressionMethod) {
        this.method = blockCompressionMethod;
    }

    public BlockContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(BlockContentType blockContentType) {
        this.contentType = blockContentType;
    }

    public int getContentId() {
        return this.contentId;
    }

    public void setContentId(int n) {
        this.contentId = n;
    }

    public int getCompressedContentSize() {
        return this.compressedContentSize;
    }
}

