/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.cram.build.Utils;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Sam2CramRecordFactory {
    public static final String UNKNOWN_READ_GROUP_ID = "UNKNOWN";
    public static final String UNKNOWN_READ_GROUP_SAMPLE = "UNKNOWN";
    private static final byte QS_asciiOffset = 33;
    public static final byte unsetQualityScore = 32;
    public static final byte ignorePositionsWithQualityScore = -1;
    private byte[] refBases;
    private final Version version;
    private byte[] refSNPs;
    private static final Log log = Log.getInstance(Sam2CramRecordFactory.class);
    private final Map<String, Integer> readGroupMap = new HashMap<String, Integer>();
    private long landedRefMaskScores = 0L;
    private long landedTotalScores = 0L;
    public boolean captureAllTags = false;
    public boolean preserveReadNames = false;
    public final Set<String> captureTags = new TreeSet<String>();
    public final Set<String> ignoreTags = new TreeSet<String>();
    private final List<ReadTag> readTagList;
    private long baseCount;
    private long featureCount;

    public Sam2CramRecordFactory(byte[] byArray, SAMFileHeader sAMFileHeader, Version version) {
        this.ignoreTags.add(SAMTag.NM.name());
        this.ignoreTags.add(SAMTag.MD.name());
        this.ignoreTags.add(SAMTag.RG.name());
        this.readTagList = new ArrayList<ReadTag>();
        this.baseCount = 0L;
        this.featureCount = 0L;
        this.refBases = byArray;
        this.version = version;
        List<SAMReadGroupRecord> list = sAMFileHeader.getReadGroups();
        for (int i = 0; i < list.size(); ++i) {
            SAMReadGroupRecord sAMReadGroupRecord = list.get(i);
            this.readGroupMap.put(sAMReadGroupRecord.getId(), i);
        }
    }

    public CramCompressionRecord createCramRecord(SAMRecord sAMRecord) {
        CramCompressionRecord cramCompressionRecord = new CramCompressionRecord();
        if (sAMRecord.getReadPairedFlag()) {
            cramCompressionRecord.mateAlignmentStart = sAMRecord.getMateAlignmentStart();
            cramCompressionRecord.setMateUnmapped(sAMRecord.getMateUnmappedFlag());
            cramCompressionRecord.setMateNegativeStrand(sAMRecord.getMateNegativeStrandFlag());
            cramCompressionRecord.mateSequenceID = sAMRecord.getMateReferenceIndex();
        } else {
            cramCompressionRecord.mateSequenceID = -1;
        }
        cramCompressionRecord.sequenceId = sAMRecord.getReferenceIndex();
        cramCompressionRecord.readName = sAMRecord.getReadName();
        cramCompressionRecord.alignmentStart = sAMRecord.getAlignmentStart();
        cramCompressionRecord.setMultiFragment(sAMRecord.getReadPairedFlag());
        cramCompressionRecord.setProperPair(sAMRecord.getReadPairedFlag() && sAMRecord.getProperPairFlag());
        cramCompressionRecord.setSegmentUnmapped(sAMRecord.getReadUnmappedFlag());
        cramCompressionRecord.setNegativeStrand(sAMRecord.getReadNegativeStrandFlag());
        cramCompressionRecord.setFirstSegment(sAMRecord.getReadPairedFlag() && sAMRecord.getFirstOfPairFlag());
        cramCompressionRecord.setLastSegment(sAMRecord.getReadPairedFlag() && sAMRecord.getSecondOfPairFlag());
        cramCompressionRecord.setSecondaryAlignment(sAMRecord.getNotPrimaryAlignmentFlag());
        cramCompressionRecord.setVendorFiltered(sAMRecord.getReadFailsVendorQualityCheckFlag());
        cramCompressionRecord.setDuplicate(sAMRecord.getDuplicateReadFlag());
        cramCompressionRecord.setSupplementary(sAMRecord.getSupplementaryAlignmentFlag());
        cramCompressionRecord.readLength = sAMRecord.getReadLength();
        cramCompressionRecord.mappingQuality = sAMRecord.getMappingQuality();
        cramCompressionRecord.setDuplicate(sAMRecord.getDuplicateReadFlag());
        cramCompressionRecord.templateSize = sAMRecord.getInferredInsertSize();
        SAMReadGroupRecord sAMReadGroupRecord = sAMRecord.getReadGroup();
        cramCompressionRecord.readGroupID = sAMReadGroupRecord != null ? this.readGroupMap.get(sAMReadGroupRecord.getId()) : -1;
        if (!sAMRecord.getReadPairedFlag()) {
            cramCompressionRecord.setLastSegment(false);
        } else if (sAMRecord.getFirstOfPairFlag()) {
            cramCompressionRecord.setLastSegment(false);
        } else if (sAMRecord.getSecondOfPairFlag()) {
            cramCompressionRecord.setLastSegment(true);
        }
        cramCompressionRecord.readFeatures = !sAMRecord.getReadUnmappedFlag() && sAMRecord.getAlignmentStart() != 0 ? this.checkedCreateVariations(cramCompressionRecord, sAMRecord) : Collections.emptyList();
        cramCompressionRecord.readBases = sAMRecord.getReadBases();
        cramCompressionRecord.qualityScores = sAMRecord.getBaseQualities();
        this.landedTotalScores += (long)cramCompressionRecord.readLength;
        if (this.version.compatibleWith(CramVersions.CRAM_v3)) {
            cramCompressionRecord.setUnknownBases(sAMRecord.getReadBases() == SAMRecord.NULL_SEQUENCE);
        }
        this.readTagList.clear();
        if (this.captureAllTags) {
            List<SAMRecord.SAMTagAndValue> list = sAMRecord.getAttributes();
            for (SAMRecord.SAMTagAndValue sAMTagAndValue : list) {
                if (this.ignoreTags.contains(sAMTagAndValue.tag)) continue;
                this.readTagList.add(ReadTag.deriveTypeFromValue(sAMTagAndValue.tag, sAMTagAndValue.value));
            }
        } else if (!this.captureTags.isEmpty()) {
            List<SAMRecord.SAMTagAndValue> list = sAMRecord.getAttributes();
            cramCompressionRecord.tags = new ReadTag[list.size()];
            for (SAMRecord.SAMTagAndValue sAMTagAndValue : list) {
                if (!this.captureTags.contains(sAMTagAndValue.tag)) continue;
                this.readTagList.add(ReadTag.deriveTypeFromValue(sAMTagAndValue.tag, sAMTagAndValue.value));
            }
        }
        cramCompressionRecord.tags = this.readTagList.toArray(new ReadTag[this.readTagList.size()]);
        cramCompressionRecord.setVendorFiltered(sAMRecord.getReadFailsVendorQualityCheckFlag());
        if (this.preserveReadNames) {
            cramCompressionRecord.readName = sAMRecord.getReadName();
        }
        return cramCompressionRecord;
    }

    private List<ReadFeature> checkedCreateVariations(CramCompressionRecord cramCompressionRecord, SAMRecord sAMRecord) {
        try {
            return this.createVariations(cramCompressionRecord, sAMRecord);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            log.error("Reference bases array length=" + this.refBases.length);
            log.error("Offensive CRAM record: " + cramCompressionRecord.toString());
            log.error("Offensive SAM record: " + sAMRecord.getSAMString());
            throw arrayIndexOutOfBoundsException;
        }
    }

    private List<ReadFeature> createVariations(CramCompressionRecord cramCompressionRecord, SAMRecord sAMRecord) {
        LinkedList<ReadFeature> linkedList = new LinkedList<ReadFeature>();
        int n = 0;
        int n2 = 0;
        List<CigarElement> list = sAMRecord.getCigar().getCigarElements();
        int n3 = 0;
        for (CigarElement object2 : list) {
            if (!object2.getOperator().consumesReadBases()) continue;
            n3 += object2.getLength();
        }
        Object object3 = sAMRecord.getReadBases();
        if (((Object)object3).length == 0) {
            object3 = new byte[n3];
            Arrays.fill((byte[])object3, (byte)78);
        }
        byte[] byArray = sAMRecord.getBaseQualities();
        for (CigarElement cigarElement : list) {
            int n4 = cigarElement.getLength();
            CigarOperator cigarOperator = cigarElement.getOperator();
            switch (cigarOperator) {
                case D: {
                    linkedList.add(new Deletion(n + 1, n4));
                    break;
                }
                case N: {
                    linkedList.add(new RefSkip(n + 1, n4));
                    break;
                }
                case P: {
                    linkedList.add(new Padding(n + 1, n4));
                    break;
                }
                case H: {
                    linkedList.add(new HardClip(n + 1, n4));
                    break;
                }
                case S: {
                    this.addSoftClip(linkedList, n, n4, (byte[])object3);
                    break;
                }
                case I: {
                    this.addInsertion(linkedList, n, n4, (byte[])object3);
                    break;
                }
                case M: 
                case X: 
                case EQ: {
                    this.addSubstitutionsAndMaskedBases(cramCompressionRecord, linkedList, n, n2, n4, (byte[])object3, byArray);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported cigar operator: " + (Object)((Object)cigarElement.getOperator()));
                }
            }
            if (cigarElement.getOperator().consumesReadBases()) {
                n += n4;
            }
            if (!cigarElement.getOperator().consumesReferenceBases()) continue;
            n2 += n4;
        }
        this.baseCount += (long)((Object)object3).length;
        this.featureCount += (long)linkedList.size();
        return linkedList;
    }

    private void addSoftClip(List<ReadFeature> list, int n, int n2, byte[] byArray) {
        byte[] byArray2 = Arrays.copyOfRange(byArray, n, n + n2);
        SoftClip softClip = new SoftClip(n + 1, byArray2);
        list.add(softClip);
    }

    private void addHardClip(List<ReadFeature> list, int n, int n2, byte[] byArray) {
        byte[] byArray2 = Arrays.copyOfRange(byArray, n, n + n2);
        HardClip hardClip = new HardClip(n + 1, byArray2.length);
        list.add(hardClip);
    }

    private void addInsertion(List<ReadFeature> list, int n, int n2, byte[] byArray) {
        byte[] byArray2 = Arrays.copyOfRange(byArray, n, n + n2);
        for (int i = 0; i < byArray2.length; ++i) {
            InsertBase insertBase = new InsertBase();
            insertBase.setPosition(n + 1 + i);
            insertBase.setBase(byArray2[i]);
            list.add(insertBase);
        }
    }

    private void addSubstitutionsAndMaskedBases(CramCompressionRecord cramCompressionRecord, List<ReadFeature> list, int n, int n2, int n3, byte[] byArray, byte[] byArray2) {
        boolean bl = byArray2.length == 0;
        for (int i = 0; i < n3; ++i) {
            byte by;
            int n4 = i + n + 1;
            int n5 = cramCompressionRecord.alignmentStart + i + n2 - 1;
            boolean bl2 = false;
            byte by2 = n5 >= this.refBases.length ? (byte)78 : this.refBases[n5];
            if (byArray[i + n] != (by2 = Utils.normalizeBase(by2))) {
                Substitution substitution = new Substitution();
                substitution.setPosition(n4);
                substitution.setBase(byArray[i + n]);
                substitution.setReferenceBase(by2);
                list.add(substitution);
                if (bl) continue;
            }
            if (bl) continue;
            if (this.refSNPs != null && (by = this.refSNPs[n5]) != 0) {
                byte by3 = (byte)(33 + byArray2[i + n]);
                list.add(new BaseQualityScore(n4, by3));
                bl2 = true;
                ++this.landedRefMaskScores;
            }
            if (!bl2) continue;
            ++this.landedTotalScores;
        }
    }

    public long getLandedRefMaskScores() {
        return this.landedRefMaskScores;
    }

    public long getLandedTotalScores() {
        return this.landedTotalScores;
    }

    public byte[] getRefBases() {
        return this.refBases;
    }

    public void setRefBases(byte[] byArray) {
        this.refBases = byArray;
    }

    public byte[] getRefSNPs() {
        return this.refSNPs;
    }

    public void setRefSNPs(byte[] byArray) {
        this.refSNPs = byArray;
    }

    public Map<String, Integer> getReadGroupMap() {
        return this.readGroupMap;
    }

    public long getBaseCount() {
        return this.baseCount;
    }

    public long getFeatureCount() {
        return this.featureCount;
    }
}

