/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import java.util.BitSet;

public class GenomicIndexUtil {
    public static final int BIN_GENOMIC_SPAN = 0x20000000;
    public static final int[] LEVEL_STARTS = new int[]{0, 1, 9, 73, 585, 4681};
    public static final int MAX_BINS = 37450;
    public static final int MAX_LINEAR_INDEX_SIZE = 37451 - LEVEL_STARTS[LEVEL_STARTS.length - 1];
    public static final int UNSET_GENOMIC_LOCATION = 0;

    static int reg2bin(int n, int n2) {
        if (n >> 14 == --n2 >> 14) {
            return 4681 + (n >> 14);
        }
        if (n >> 17 == n2 >> 17) {
            return 585 + (n >> 17);
        }
        if (n >> 20 == n2 >> 20) {
            return 73 + (n >> 20);
        }
        if (n >> 23 == n2 >> 23) {
            return 9 + (n >> 23);
        }
        if (n >> 26 == n2 >> 26) {
            return 1 + (n >> 26);
        }
        return 0;
    }

    public static BitSet regionToBins(int n, int n2) {
        int n3;
        int n4;
        int n5 = n <= 0 ? 0 : n - 1 & 0x1FFFFFFF;
        int n6 = n4 = n2 <= 0 ? 0x1FFFFFFF : n2 - 1 & 0x1FFFFFFF;
        if (n5 > n4) {
            return null;
        }
        BitSet bitSet = new BitSet(37450);
        bitSet.set(0);
        for (n3 = 1 + (n5 >> 26); n3 <= 1 + (n4 >> 26); ++n3) {
            bitSet.set(n3);
        }
        for (n3 = 9 + (n5 >> 23); n3 <= 9 + (n4 >> 23); ++n3) {
            bitSet.set(n3);
        }
        for (n3 = 73 + (n5 >> 20); n3 <= 73 + (n4 >> 20); ++n3) {
            bitSet.set(n3);
        }
        for (n3 = 585 + (n5 >> 17); n3 <= 585 + (n4 >> 17); ++n3) {
            bitSet.set(n3);
        }
        for (n3 = 4681 + (n5 >> 14); n3 <= 4681 + (n4 >> 14); ++n3) {
            bitSet.set(n3);
        }
        return bitSet;
    }
}

