/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordDuplicateComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DuplicateSet {
    private final List<SAMRecord> records = new ArrayList<SAMRecord>(10);
    private static final SAMRecordDuplicateComparator defaultComparator = new SAMRecordDuplicateComparator();
    private final SAMRecordDuplicateComparator comparator;
    private SAMRecord representative = null;
    private boolean needsSorting = false;
    private boolean setDuplicateFlag = false;

    public DuplicateSet() {
        this(true);
    }

    public DuplicateSet(boolean bl) {
        this(bl, defaultComparator);
    }

    public DuplicateSet(SAMRecordDuplicateComparator sAMRecordDuplicateComparator) {
        this(true, sAMRecordDuplicateComparator);
    }

    public DuplicateSet(boolean bl, SAMRecordDuplicateComparator sAMRecordDuplicateComparator) {
        this.setDuplicateFlag = bl;
        this.comparator = sAMRecordDuplicateComparator;
    }

    public int add(SAMRecord sAMRecord) {
        if (!this.records.isEmpty()) {
            int n = this.comparator.duplicateSetCompare(this.representative, sAMRecord);
            if (0 != n) {
                return n;
            }
            if (0 < this.comparator.compare(this.representative, sAMRecord)) {
                this.representative = sAMRecord;
            }
        } else {
            this.representative = sAMRecord;
        }
        this.records.add(sAMRecord);
        this.needsSorting = true;
        return 0;
    }

    private void sort() {
        if (!this.records.isEmpty()) {
            if (1 < this.records.size()) {
                Collections.sort(this.records, this.comparator);
            }
            if (this.setDuplicateFlag) {
                for (SAMRecord sAMRecord : this.records) {
                    if (sAMRecord.getReadUnmappedFlag() || sAMRecord.isSecondaryOrSupplementary() || sAMRecord.getReadName().equals(this.representative.getReadName())) continue;
                    sAMRecord.setDuplicateReadFlag(true);
                }
                this.records.get(0).setDuplicateReadFlag(false);
            }
            if (!this.records.get(0).equals(this.representative)) {
                throw new SAMException("BUG: the representative was not the first record after sorting.\nFIRST: " + this.records.get(0).getSAMString() + "\nSECOND: " + this.representative.getSAMString());
            }
        }
        this.needsSorting = false;
    }

    public List<SAMRecord> getRecords(boolean bl) {
        if (bl && this.needsSorting) {
            this.sort();
        }
        return this.records;
    }

    public List<SAMRecord> getRecords() {
        return this.getRecords(true);
    }

    public SAMRecord getRepresentative() {
        return this.representative;
    }

    public int size() {
        return this.records.size();
    }

    public int numDuplicates() {
        int n = 0;
        for (SAMRecord sAMRecord : this.records) {
            if (sAMRecord.getReadUnmappedFlag() || sAMRecord.isSecondaryOrSupplementary()) continue;
            ++n;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public void setDuplicateFlag(boolean bl) {
        this.setDuplicateFlag = bl;
    }
}

