/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.integration.Integration;
import flanagan.io.Db;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.math.Minimisation;
import flanagan.physchem.FunctionPatX;
import flanagan.physchem.GCSminim;
import flanagan.physprop.IonicRadii;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class GouyChapmanStern {
    private ArrayList<Object> vec = new ArrayList();
    private boolean unpackArrayList = false;
    private int numOfIons = 0;
    private int numOfAnions = 0;
    private int numOfCations = 0;
    private String[] ionNames = null;
    private double[] initConcnM = null;
    private double[] initConcn = null;
    private double[] siteConcn = null;
    private double[] sternConcn = null;
    private double[] bulkConcn = null;
    private double electrolyteConcn = 0.0;
    private double ionicStrength = 0.0;
    private int[] indexK = null;
    private int nonZeroAssocK = 0;
    private double[] radii = null;
    private boolean radiusType = true;
    private double[] charges = null;
    private double tolNeutral = 1.0E-6;
    private double[] assocConstsM = null;
    private double[] assocConsts = null;
    private double surfaceSiteDensity = 0.0;
    private double freeSurfaceSiteDensity = 0.0;
    private boolean surfaceDensitySet = false;
    private double epsilon = 0.0;
    private double epsilonStern = 0.0;
    private boolean epsilonSet = false;
    private double temp = 25.0;
    private double tempK = 298.15;
    private boolean tempSet = false;
    private double surfacePotential = 0.0;
    private boolean psi0set = false;
    private double diffPotential = 0.0;
    private double sternPotential = 0.0;
    private double surfaceArea = 1.0;
    private boolean surfaceAreaSet = false;
    private double volume = 1.0;
    private boolean volumeSet = false;
    private double sternCap = 0.0;
    private double diffCap = 0.0;
    private double totalCap = 0.0;
    private double sternDelta = 0.0;
    private double chargeValue = 0.0;
    private boolean chargeSame = true;
    private double averageCharge = 0.0;
    private double surfaceChargeDensity = 0.0;
    private double adsorbedChargeDensity = 0.0;
    private double diffuseChargeDensity = 0.0;
    private boolean sigmaSet = false;
    private double surfaceCharge = 0.0;
    private boolean chargeSet = false;
    private double recipKappa = 0.0;
    private boolean sternOption = true;
    private double expTerm = 0.0;
    private double expTermOver2 = 0.0;
    private double twoTerm = 0.0;
    private double eightTerm = 0.0;

    public void setHydratedRadii() {
        this.radiusType = true;
    }

    public void setBareRadii() {
        this.radiusType = false;
    }

    public void ignoreStern() {
        this.sternOption = false;
    }

    public void includeStern() {
        this.sternOption = true;
    }

    public void setIon(String ion, double concn, double radius, int charge, double assocK) {
        this.vec.add(ion);
        this.vec.add(new Double(concn));
        this.vec.add(new Double(radius));
        this.vec.add(new Integer(charge));
        this.vec.add(new Double(assocK));
        if (assocK != 0.0) {
            ++this.nonZeroAssocK;
        }
        ++this.numOfIons;
        this.unpackArrayList = false;
    }

    public void setIon(String ion, double concn, double radius, int charge) {
        this.vec.add(ion);
        this.vec.add(new Double(concn));
        this.vec.add(new Double(radius));
        this.vec.add(new Integer(charge));
        this.vec.add(new Double(0.0));
        ++this.numOfIons;
        this.unpackArrayList = false;
    }

    public void setIon(String ion, double concn, double assocK) {
        IonicRadii ir = new IonicRadii();
        this.vec.add(ion);
        this.vec.add(new Double(concn));
        double rad = 0.0;
        rad = this.radiusType ? IonicRadii.hydratedRadius(ion) : IonicRadii.radius(ion);
        if (rad == 0.0) {
            String mess1 = ion + " radius is not in the IonicRadii list\n";
            String mess2 = "Please enter radius in metres\n";
            rad = Db.readDouble(mess1 + mess2);
        }
        this.vec.add(new Double(rad));
        int charg = 0;
        charg = IonicRadii.charge(ion);
        if (charg == 0) {
            String mess1 = ion + " charge is not in the IonicRadii list\n";
            String mess2 = "Please enter charge as, e.g +2";
            charg = Db.readInt(mess1 + mess2);
        }
        this.vec.add(new Integer(charg));
        this.vec.add(new Double(assocK));
        if (assocK != 0.0) {
            ++this.nonZeroAssocK;
        }
        ++this.numOfIons;
        this.unpackArrayList = false;
    }

    public void setIon(String ion, double concn) {
        IonicRadii ir = new IonicRadii();
        this.vec.add(ion);
        this.vec.add(new Double(concn));
        double rad = 0.0;
        rad = this.radiusType ? IonicRadii.hydratedRadius(ion) : IonicRadii.radius(ion);
        if (rad == 0.0) {
            String mess1 = ion + " radius is not in the IonicRadii list\n";
            String mess2 = "Please enter radius in metres\n";
            rad = Db.readDouble(mess1 + mess2);
        }
        this.vec.add(new Double(rad));
        int charg = 0;
        charg = IonicRadii.charge(ion);
        if (charg == 0) {
            String mess1 = ion + " charge is not in the IonicRadii list\n";
            String mess2 = "Please enter charge as, e.g +2";
            charg = Db.readInt(mess1 + mess2);
        }
        this.vec.add(new Integer(charg));
        this.vec.add(new Double(0.0));
        ++this.numOfIons;
        this.unpackArrayList = false;
    }

    public void setSurfaceSiteDensity(double density) {
        this.surfaceSiteDensity = density / 6.0221419947E23;
        this.surfaceDensitySet = true;
    }

    public void setSurfaceArea(double area) {
        this.surfaceArea = area;
        this.surfaceAreaSet = true;
    }

    public void setVolume(double vol) {
        this.volume = vol;
        this.volumeSet = true;
    }

    public void setRelPerm(double epsilon, double epsilonStern) {
        this.epsilon = epsilon;
        this.epsilonStern = epsilonStern;
        this.epsilonSet = true;
    }

    public void setRelPerm(double epsilon) {
        this.epsilon = epsilon;
        this.epsilonSet = true;
    }

    public void setTemp(double temp) {
        this.tempK = temp - -273.15;
        this.tempSet = true;
    }

    public void setSurfaceChargeDensity(double sigma) {
        if (this.psi0set) {
            System.out.println("You have already entered a surface potential");
            System.out.println("This class allows the calculation of a surface charge density for a given surface potential");
            System.out.println("or the calculation of a surface potential for a given surface charge density");
            System.out.println("The previously entered surface potential will now be ignored");
            this.psi0set = false;
        }
        this.surfaceChargeDensity = sigma;
        this.sigmaSet = true;
        if (this.surfaceAreaSet) {
            this.surfaceCharge = sigma * this.surfaceArea;
            this.chargeSet = true;
        }
    }

    public void setSurfaceCharge(double charge, double area) {
        if (this.psi0set) {
            System.out.println("You have already entered a surface potential");
            System.out.println("This class allows the calculation of a surface charge density for a given surface potential");
            System.out.println("or the calculation of a surface potential for a given surface charge density");
            System.out.println("The previously entered surface potential will now be ignored");
            this.psi0set = false;
        }
        this.surfaceCharge = charge;
        this.chargeSet = true;
        this.surfaceArea = area;
        this.surfaceAreaSet = true;
        this.surfaceChargeDensity = charge / this.surfaceArea;
        this.sigmaSet = true;
    }

    public void setSurfaceCharge(double charge) {
        if (this.psi0set) {
            System.out.println("You have already entered a surface potential");
            System.out.println("This class allows the calculation of a surface charge density for a given surface potential");
            System.out.println("or the calculation of a surface potential for a given surface charge density");
            System.out.println("The previously entered surface potential will now be ignored");
            this.psi0set = false;
        }
        this.surfaceCharge = charge;
        this.chargeSet = true;
        if (this.surfaceAreaSet) {
            this.surfaceChargeDensity = charge / this.surfaceArea;
            this.sigmaSet = true;
        }
    }

    public void setSurfacePotential(double psi0) {
        if (this.sigmaSet) {
            System.out.println("You have already entered a surface charge density");
            System.out.println("This class allows the calculation of a surface potential for a given surface charge density");
            System.out.println("or the calculation of a surface charge density for a given surface potential");
            System.out.println("The previously entered surface charge density will now be ignored");
            this.sigmaSet = false;
        }
        this.surfacePotential = psi0;
        this.psi0set = true;
    }

    public double getDiffuseLayerPotential() {
        if (!this.sternOption) {
            System.out.println("Class: GouyChapmanStern\nMethod: getDiffuseLayerPotential\nThe Stern modification was not included");
            System.out.println("The value of the diffuse layer potential has been set equal to the surface potential");
            return this.getSurfacePotential();
        }
        if (this.psi0set && this.sigmaSet) {
            return this.diffPotential;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.diffPotential;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.diffPotential;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getDiffuseLayerPotential\nThe value of the diffuse layer potential has not been calculated\nzero returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return 0.0;
    }

    public double getSternLayerPotential() {
        if (!this.sternOption) {
            System.out.println("Class: GouyChapmanStern\nMethod: getSternLayerPotential\nThe Stern modification has not been included");
            System.out.println("The value of zero has been returned");
            return 0.0;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.sternPotential;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.sternPotential;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.sternPotential;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getSternLayerPotential\nThe value of the Stern layer potential has not been calculated\nzero returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return 0.0;
    }

    public double getSternCapPerSquareMetre() {
        if (!this.sternOption) {
            System.out.println("Class: GouyChapmanStern\nMethod: getSternCapacitance\nThe Stern modification has not been included");
            System.out.println("A value of infinity has been returned");
            return Double.POSITIVE_INFINITY;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.sternCap;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.sternCap;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.sternCap;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getSternCap\nThe value of the Stern capacitance has not been calculated\ninfinity returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return Double.POSITIVE_INFINITY;
    }

    public double getSternCapacitance() {
        if (!this.sternOption) {
            System.out.println("Class: GouyChapmanStern\nMethod: getSternCapacitance\nThe Stern modification has not been included");
            System.out.println("A value of infinity has been returned");
            return Double.POSITIVE_INFINITY;
        }
        if (!this.surfaceAreaSet) {
            System.out.println("Class: GouyChapmanStern\nMethod: getSternCapacitance\nThe surface area has not bee included");
            System.out.println("A value per square metre has been returned");
            return this.sternCap;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.sternCap * this.surfaceArea;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.sternCap * this.surfaceArea;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.sternCap * this.surfaceArea;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getSternCapacitance\nThe value of the Stern capacitance has not been calculated\ninfinity returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return Double.POSITIVE_INFINITY;
    }

    public double getDiffuseLayerCapPerSquareMetre() {
        if (this.psi0set && this.sigmaSet) {
            return this.diffCap;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.diffCap;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.diffCap;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getDiffuseLayerCapPerSquareMetre\nThe value of the diffuse layer capacitance has not been calculated\ninfinity returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return Double.POSITIVE_INFINITY;
    }

    public double getDiffuseLayerCapacitance() {
        if (!this.surfaceAreaSet) {
            System.out.println("Class: GouyChapmanStern\nMethod: getDiffuseLayerCapacitance\nThe surface area has not bee included");
            System.out.println("A value per square metre has been returned");
            return this.diffCap;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.diffCap * this.surfaceArea;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.diffCap * this.surfaceArea;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.diffCap * this.surfaceArea;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getDiffuseLayerCap\nThe value of the diffuse layer capacitance has not been calculated\ninfinity returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return Double.POSITIVE_INFINITY;
    }

    public double getTotalCapPerSquareMetre() {
        if (this.psi0set && this.sigmaSet) {
            return this.totalCap;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.totalCap;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.totalCap;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getTotalCapPerSquareMetre\nThe value of the total capacitance has not been calculated\ninfinity returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return Double.POSITIVE_INFINITY;
    }

    public double getTotalCapacitance() {
        if (!this.surfaceAreaSet) {
            System.out.println("Class: GouyChapmanStern\nMethod: getTotalCapacitance\nThe surface area has not bee included");
            System.out.println("A value per square metre has been returned");
            return this.diffCap;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.totalCap * this.surfaceArea;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.totalCap * this.surfaceArea;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.totalCap * this.surfaceArea;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getTotalCapacitance\nThe value of the total capacitance has not been calculated\ninfinity returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return Double.POSITIVE_INFINITY;
    }

    public double getSternThickness() {
        if (!this.sternOption) {
            System.out.println("Class: GouyChapmanStern\nMethod: getSternThickness");
            System.out.println("The Stern modification has not been included");
            System.out.println("A value of zero has been returned");
            return 0.0;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.sternDelta;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.sternDelta;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.sternDelta;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getSternThickness\nThe value of the Stern thickness has not been calculated\nzero returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return 0.0;
    }

    public double getDebyeLength() {
        if (!this.unpackArrayList) {
            this.unpack();
        }
        return this.calcDebyeLength();
    }

    private double calcDebyeLength() {
        if (!this.epsilonSet) {
            throw new IllegalArgumentException("The relative permittivitie/s have not been entered");
        }
        if (!this.tempSet) {
            System.out.println("The temperature has not been entered\na value of 25 degrees Celsius has been used");
        }
        double preterm = 2.0 * Fmath.square(-1.60217646263E-19) * 6.0221419947E23 / (8.854187817E-12 * this.epsilon * 1.380650324E-23 * this.tempK);
        this.recipKappa = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            this.recipKappa += this.bulkConcn[i] * this.charges[i] * this.charges[i];
        }
        this.recipKappa = 1.0 / Math.sqrt(this.recipKappa * preterm);
        return this.recipKappa;
    }

    public double getIonicStrength() {
        if (!this.unpackArrayList) {
            this.unpack();
        }
        return this.ionicStrength;
    }

    private void unpack() {
        int i;
        if (this.numOfIons == 0) {
            throw new IllegalArgumentException("No ions have been entered");
        }
        this.ionNames = new String[this.numOfIons];
        this.siteConcn = new double[this.numOfIons];
        this.sternConcn = new double[this.numOfIons];
        this.initConcnM = new double[this.numOfIons];
        this.initConcn = new double[this.numOfIons];
        this.bulkConcn = new double[this.numOfIons];
        this.radii = new double[this.numOfIons];
        this.charges = new double[this.numOfIons];
        this.assocConsts = new double[this.numOfIons];
        this.assocConstsM = new double[this.numOfIons];
        this.indexK = new int[this.nonZeroAssocK];
        Double hold = null;
        Integer holi = null;
        int ii = 0;
        this.chargeValue = 0.0;
        this.chargeSame = true;
        for (int i2 = 0; i2 < this.numOfIons; ++i2) {
            this.ionNames[i2] = (String)this.vec.get(0 + i2 * 5);
            hold = (Double)this.vec.get(1 + i2 * 5);
            this.initConcnM[i2] = hold;
            this.initConcn[i2] = this.initConcnM[i2] * 1000.0;
            hold = (Double)this.vec.get(2 + i2 * 5);
            this.radii[i2] = hold;
            holi = (Integer)this.vec.get(3 + i2 * 5);
            this.charges[i2] = holi.intValue();
            hold = (Double)this.vec.get(4 + i2 * 5);
            this.assocConstsM[i2] = hold;
            this.assocConsts[i2] = this.assocConstsM[i2] * 0.001;
            if (this.assocConsts[i2] > 0.0) {
                this.indexK[ii] = i2;
                ++ii;
            }
            if (i2 == 0) {
                this.chargeValue = Math.abs(this.charges[0]);
            } else if (Math.abs(this.charges[i2]) != this.chargeValue) {
                this.chargeSame = false;
            }
            if (this.charges[i2] < 0.0) {
                ++this.numOfAnions;
            } else {
                ++this.numOfCations;
            }
            if (this.surfaceSiteDensity != 0.0) continue;
            this.nonZeroAssocK = 0;
        }
        this.averageCharge = 0.0;
        this.ionicStrength = 0.0;
        double overallCharge = 0.0;
        double positives = 0.0;
        double negatives = 0.0;
        for (int i3 = 0; i3 < this.numOfIons; ++i3) {
            if (this.charges[i3] > 0.0) {
                positives += this.initConcn[i3] * this.charges[i3];
            } else {
                negatives += this.initConcn[i3] * this.charges[i3];
            }
            overallCharge = positives + negatives;
        }
        if (Math.abs(overallCharge) > positives * this.tolNeutral) {
            String quest0 = "Class: GouyChapmanStern, method: unpack()\n";
            String quest1 = "Total charge = " + overallCharge + " mol/dm, i.e. is not equal to zero\n";
            String quest2 = "Positive charge = " + positives + " mol/dm\n";
            String quest3 = "Do you wish to continue?";
            String quest = quest0 + quest1 + quest2 + quest3;
            int res = JOptionPane.showConfirmDialog(null, quest, "Neutrality check", 0, 3);
            if (res == 1) {
                System.exit(0);
            }
        }
        double numer = 0.0;
        double denom = 0.0;
        double anionConc = 0.0;
        double cationConc = 0.0;
        for (i = 0; i < this.numOfIons; ++i) {
            this.ionicStrength += this.initConcn[i] * this.charges[i] * this.charges[i];
            if (this.charges[i] > 0.0) {
                cationConc += this.initConcn[i];
            } else {
                anionConc += this.initConcn[i];
            }
            if (!(this.initConcn[i] > 0.0)) continue;
            numer += this.initConcn[i] * Math.abs(this.charges[i]);
            denom += this.initConcn[i];
        }
        this.ionicStrength = this.ionicStrength * 0.001 / 2.0;
        this.averageCharge = numer / denom;
        this.electrolyteConcn = (anionConc + cationConc) / 2.0;
        for (i = 0; i < this.numOfIons; ++i) {
            this.bulkConcn[i] = this.initConcn[i];
            this.siteConcn[i] = 0.0;
            this.sternConcn[i] = 0.0;
        }
        this.expTerm = 1.60217646263E-19 / (1.380650324E-23 * this.tempK);
        this.expTermOver2 = this.expTerm / 2.0;
        this.twoTerm = 1.4723579861882691E-10 * this.epsilon * this.tempK;
        this.eightTerm = 4.0 * this.twoTerm;
        this.unpackArrayList = true;
    }

    public double getSurfaceChargeDensity() {
        if (this.sigmaSet && this.psi0set) {
            return this.surfaceChargeDensity;
        }
        if (!this.psi0set) {
            throw new IllegalArgumentException("No surface potential has been entered");
        }
        return this.getSurfaceChargeDensity(this.surfacePotential);
    }

    public double getSurfaceChargeDensity(double psi) {
        this.surfaceChargeDensity = this.calcSurfaceChargeDensity(psi);
        this.sigmaSet = true;
        if (this.surfaceAreaSet) {
            this.surfaceCharge = this.surfaceChargeDensity * this.surfaceArea;
            this.chargeSet = true;
        }
        return this.surfaceChargeDensity;
    }

    private double calcSurfaceChargeDensity(double psi) {
        double surCharDen = 0.0;
        if (!this.epsilonSet) {
            throw new IllegalArgumentException("The relative permittivitie/s have not been entered");
        }
        if (!this.tempSet) {
            System.out.println("The temperature has not been entered\na value of 25 degrees Celsius has been used");
        }
        if (!this.unpackArrayList) {
            this.unpack();
        }
        if (this.sternOption) {
            if (!this.surfaceAreaSet) {
                throw new IllegalArgumentException("The surface area has not been entered");
            }
            if (!this.volumeSet) {
                throw new IllegalArgumentException("The electrolyte volume has not been entered");
            }
            surCharDen = this.nonZeroAssocK == 0 ? (this.chargeSame ? this.surfaceChargeDensity0(psi) : this.surfaceChargeDensity1(psi)) : (this.chargeSame ? this.surfaceChargeDensity2(psi) : this.surfaceChargeDensity3(psi));
        } else if (this.chargeSame) {
            surCharDen = Math.sqrt(this.eightTerm * this.electrolyteConcn) * Fmath.sinh(this.chargeValue * this.expTermOver2 * psi);
        } else {
            double sigmaSum = 0.0;
            for (int i = 0; i < this.numOfIons; ++i) {
                sigmaSum += this.bulkConcn[i] * (Math.exp(-this.expTerm * psi * this.charges[i]) - 1.0);
            }
            surCharDen = Fmath.sign(psi) * Math.sqrt(this.twoTerm * sigmaSum);
        }
        this.totalCap = surCharDen / psi;
        if (!this.sternOption) {
            this.diffPotential = psi;
            this.sternCap = Double.POSITIVE_INFINITY;
            this.sternPotential = 0.0;
            this.diffCap = this.totalCap;
        } else {
            this.diffPotential = psi - surCharDen / this.sternCap;
            this.sternPotential = psi - this.diffPotential;
            this.diffCap = (surCharDen + this.adsorbedChargeDensity) / this.diffPotential;
        }
        return surCharDen;
    }

    public double getSurfaceCharge() {
        return this.getSurfaceCharge(this.surfacePotential);
    }

    public double getSurfaceCharge(double psi) {
        if (!this.surfaceAreaSet) {
            throw new IllegalArgumentException("No surface area has been entered");
        }
        if (this.sigmaSet) {
            this.surfaceCharge = this.surfaceChargeDensity * this.surfaceArea;
        } else {
            if (!this.psi0set) {
                throw new IllegalArgumentException("No surface potential has been entered");
            }
            this.surfaceCharge = this.getSurfaceChargeDensity(psi) * this.surfaceArea;
        }
        return this.surfaceCharge;
    }

    private double surfaceChargeDensity0(double psi) {
        double surCharDen = 0.0;
        double ionSum = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            if (!(this.charges[i] > 0.0)) continue;
            ionSum += this.bulkConcn[i];
        }
        double sigmaLow = 0.0;
        double sFuncLow = this.sigmaFunction0(sigmaLow, psi);
        double sigmaHigh = Math.sqrt(this.eightTerm * ionSum) * Fmath.sinh(this.chargeValue * this.expTermOver2 * psi);
        double sFuncHigh = this.sigmaFunction0(sigmaHigh, psi);
        if (sFuncHigh * sFuncLow > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double check = Math.abs(sigmaHigh) * 1.0E-6;
        boolean test = true;
        double sigmaMid = 0.0;
        double sFuncMid = 0.0;
        int nIter = 0;
        while (test) {
            sigmaMid = (sigmaLow + sigmaHigh) / 2.0;
            sFuncMid = this.sigmaFunction0(sigmaMid, psi);
            if (Math.abs(sFuncMid) <= check) {
                surCharDen = sigmaMid;
                test = false;
                continue;
            }
            if (++nIter > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: surfaceChargeDensity0\nnumber of iterations exceeded in bisection\ncurrent value of sigma returned");
                surCharDen = sigmaMid;
                test = false;
                continue;
            }
            if (sFuncMid * sFuncLow > 0.0) {
                sigmaLow = sigmaMid;
                sFuncLow = sFuncMid;
                continue;
            }
            sigmaHigh = sigmaMid;
            sFuncHigh = sFuncMid;
        }
        return surCharDen;
    }

    private double sigmaFunction0(double sigma, double psi) {
        this.calcSurfacePotential(sigma);
        return this.diffPotential - psi + sigma / this.sternCap;
    }

    private double surfaceChargeDensity1(double psi) {
        double surCharDen = 0.0;
        double sigmaLow = 0.0;
        double sFuncLow = this.sigmaFunction0(sigmaLow, psi);
        double sigmaHigh = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            sigmaHigh += this.bulkConcn[i] * this.twoTerm * (Math.exp(-this.expTerm * this.charges[i] * psi) - 1.0);
        }
        sigmaHigh = Fmath.sign(psi) * Math.sqrt(this.twoTerm * sigmaHigh);
        double sFuncHigh = this.sigmaFunction0(sigmaHigh, psi);
        if (sFuncHigh * sFuncLow > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double check = Math.abs(sigmaHigh) * 1.0E-6;
        boolean test = true;
        double sigmaMid = 0.0;
        double sFuncMid = 0.0;
        int nIter = 0;
        while (test) {
            sigmaMid = (sigmaLow + sigmaHigh) / 2.0;
            sFuncMid = this.sigmaFunction0(sigmaMid, psi);
            if (Math.abs(sFuncMid) <= check) {
                surCharDen = sigmaMid;
                test = false;
                continue;
            }
            if (++nIter > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: surfaceChargeDensity1\nnumber of iterations exceeded in outer bisection\ncurrent value of sigma returned");
                surCharDen = sigmaMid;
                test = false;
                continue;
            }
            if (sFuncLow * sFuncMid > 0.0) {
                sigmaLow = sigmaMid;
                sFuncLow = sFuncMid;
                continue;
            }
            sigmaHigh = sigmaMid;
            sFuncHigh = sFuncMid;
        }
        return surCharDen;
    }

    private double calcDelta(double psi) {
        double numer = 0.0;
        double denom = 0.0;
        double delta = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            this.sternConcn[i] = this.bulkConcn[i] * Math.exp(-this.charges[i] * this.expTerm);
            numer += this.sternConcn[i] * this.radii[i];
            denom += this.sternConcn[i];
        }
        this.sternDelta = numer / denom;
        return this.sternDelta;
    }

    private double surfaceChargeDensity2(double psi) {
        double surCharDen = 0.0;
        double sigmaAdsPos = 0.0;
        double sigmaAdsNeg = 0.0;
        for (int i = 0; i < this.nonZeroAssocK; ++i) {
            if (this.charges[this.indexK[i]] > 0.0) {
                sigmaAdsPos = this.surfaceSiteDensity;
                continue;
            }
            sigmaAdsNeg = -this.surfaceSiteDensity;
        }
        double sigmaLow = 0.0;
        double sigmaHigh = 0.0;
        double ionSum = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            ionSum += this.bulkConcn[i];
        }
        sigmaHigh = Math.sqrt((ionSum /= 2.0) * this.eightTerm) * Fmath.sinh(this.expTermOver2 * psi * this.chargeValue);
        if (sigmaHigh > 0.0) {
            sigmaHigh += sigmaAdsPos;
            sigmaLow -= sigmaAdsNeg;
        } else {
            sigmaHigh -= sigmaAdsNeg;
            sigmaLow += sigmaAdsPos;
        }
        double sFuncLow = this.sigmaFunction2(sigmaLow, psi);
        double sFuncHigh = this.sigmaFunction2(sigmaHigh, psi);
        if (sFuncHigh * sFuncLow > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double check = Math.abs(sigmaHigh) * 1.0E-6;
        boolean test = true;
        double sigmaMid = 0.0;
        double sFuncMid = 0.0;
        int nIter = 0;
        while (test) {
            sigmaMid = (sigmaLow + sigmaHigh) / 2.0;
            sFuncMid = this.sigmaFunction2(sigmaMid, psi);
            if (Math.abs(sFuncMid) <= check) {
                surCharDen = sigmaMid;
                test = false;
                continue;
            }
            if (++nIter > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: surfaceChargeDensity2\nnumber of iterations exceeded in outer bisection\ncurrent value of sigma returned");
                surCharDen = sigmaMid;
                test = false;
                continue;
            }
            if (sFuncLow * sFuncMid > 0.0) {
                sigmaLow = sigmaMid;
                sFuncLow = sFuncMid;
                continue;
            }
            sigmaHigh = sigmaMid;
            sFuncHigh = sFuncMid;
        }
        return surCharDen;
    }

    private double sigmaFunction2(double sigma, double psi) {
        double psiLow = -10.0 * psi;
        double pFuncLow = this.psiFunctionQ(psiLow, psi, sigma);
        double psiHigh = 10.0 * psi;
        double pFuncHigh = this.psiFunctionQ(psiHigh, psi, sigma);
        if (pFuncHigh * pFuncLow > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double check = Math.abs(psi) * 1.0E-6;
        boolean test = true;
        double psiMid = 0.0;
        double pFuncMid = 0.0;
        int nIter = 0;
        while (test) {
            psiMid = (psiLow + psiHigh) / 2.0;
            pFuncMid = this.psiFunctionQ(psiMid, psi, sigma);
            if (Math.abs(pFuncMid) <= check) {
                test = false;
                continue;
            }
            if (++nIter > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: surfaceChargeDensity3\nnumber of iterations exceeded in inner bisection\ncurrent value of sigma returned");
                test = false;
            }
            if (pFuncMid * pFuncHigh > 0.0) {
                psiHigh = psiMid;
                pFuncHigh = pFuncMid;
                continue;
            }
            psiLow = psiMid;
            pFuncLow = pFuncMid;
        }
        double sigmaEst = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            sigmaEst += this.bulkConcn[i];
        }
        sigmaEst = Math.sqrt(this.eightTerm * sigmaEst / 2.0) * Fmath.sinh(this.expTermOver2 * psi * this.chargeValue);
        return sigma + this.adsorbedChargeDensity - sigmaEst;
    }

    private double surfaceChargeDensity3(double psi) {
        double surCharDen = 0.0;
        double sigmaAdsPos = 0.0;
        double sigmaAdsNeg = 0.0;
        for (int i = 0; i < this.nonZeroAssocK; ++i) {
            if (this.charges[this.indexK[i]] > 0.0) {
                sigmaAdsPos = this.surfaceSiteDensity;
                continue;
            }
            sigmaAdsNeg = -this.surfaceSiteDensity;
        }
        double sigmaLow = 0.0;
        double sigmaHigh = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            sigmaHigh += this.bulkConcn[i] * this.twoTerm * (Math.exp(-this.expTerm * this.charges[i] * psi) - 1.0);
        }
        sigmaHigh = Fmath.sign(psi) * Math.sqrt(sigmaHigh);
        if (sigmaHigh > 0.0) {
            sigmaHigh += sigmaAdsPos;
            sigmaLow -= sigmaAdsNeg;
        } else {
            sigmaHigh -= sigmaAdsNeg;
            sigmaLow += sigmaAdsPos;
        }
        double sFuncLow = this.sigmaFunction3(sigmaLow, psi);
        double sFuncHigh = this.sigmaFunction3(sigmaHigh, psi);
        if (sFuncHigh * sFuncLow > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double check = Math.abs(sigmaHigh) * 1.0E-6;
        boolean test = true;
        double sigmaMid = 0.0;
        double sFuncMid = 0.0;
        int nIter = 0;
        while (test) {
            sigmaMid = (sigmaLow + sigmaHigh) / 2.0;
            sFuncMid = this.sigmaFunction3(sigmaMid, psi);
            if (Math.abs(sFuncMid) <= check) {
                surCharDen = sigmaMid;
                test = false;
                continue;
            }
            if (++nIter > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: surfaceChargeDensity3\nnumber of iterations exceeded in outer bisection\ncurrent value of sigma returned");
                surCharDen = sigmaMid;
                test = false;
                continue;
            }
            if (sFuncLow * sFuncMid > 0.0) {
                sigmaLow = sigmaMid;
                sFuncLow = sFuncMid;
                continue;
            }
            sigmaHigh = sigmaMid;
            sFuncHigh = sFuncMid;
        }
        return surCharDen;
    }

    private double sigmaFunction3(double sigma, double psi) {
        double psiLow = 0.0;
        double pFuncLow = this.psiFunctionQ(psiLow, psi, sigma);
        double psiHigh = psi;
        double pFuncHigh = this.psiFunctionQ(psiHigh, psi, sigma);
        if (pFuncHigh * pFuncLow > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double check = Math.abs(psi) * 1.0E-6;
        boolean test = true;
        double psiMid = 0.0;
        double pFuncMid = 0.0;
        int nIter = 0;
        while (test) {
            psiMid = (psiLow + psiHigh) / 2.0;
            pFuncMid = this.psiFunctionQ(psiMid, psi, sigma);
            if (Math.abs(pFuncMid) <= check) {
                test = false;
                continue;
            }
            if (++nIter > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: sigmaFunction3\nnumber of iterations exceeded in inner bisection\ncurrent value of sigma returned");
                test = false;
            }
            if (pFuncMid * pFuncHigh > 0.0) {
                psiHigh = psiMid;
                pFuncHigh = pFuncMid;
                continue;
            }
            psiLow = psiMid;
            pFuncLow = pFuncMid;
        }
        double sigmaEst = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            sigmaEst += this.bulkConcn[i] * this.twoTerm * (Math.exp(-this.expTerm * this.charges[i] * psiMid) - 1.0);
        }
        sigmaEst = Fmath.sign(psiMid) * Math.sqrt(sigmaEst);
        return sigma + this.adsorbedChargeDensity - sigmaEst;
    }

    private double psiFunctionQ(double psiDelta, double psi0, double sigma) {
        this.sternDelta = this.calcDeltaQ(psiDelta);
        this.diffPotential = psiDelta;
        this.sternCap = this.epsilonStern * 8.854187817E-12 / this.sternDelta;
        return psiDelta - psi0 + sigma / this.sternCap;
    }

    private double calcDeltaQ(double psi) {
        double numer = 0.0;
        double denom = 0.0;
        double convFac = this.surfaceArea / this.volume;
        int ii = 0;
        if (this.nonZeroAssocK == 1) {
            double cc;
            double aa;
            ii = this.indexK[0];
            double hold = this.assocConsts[ii] * Math.exp(-this.charges[ii] * psi * this.expTerm);
            double bb = -(1.0 + this.initConcn[ii] * hold + this.surfaceSiteDensity * hold * convFac);
            double root = bb * bb - 4.0 * (aa = hold * convFac) * (cc = this.initConcn[ii] * this.surfaceSiteDensity * hold);
            if (root < 0.0) {
                System.out.println("Class: GouyChapmanStern\nMethod: calcDeltaQ\nthe square root term (b2-4ac) of the quadratic = " + root);
                System.out.println("this term was set to zero as the negative value MAY have arisen from rounding errors");
                root = 0.0;
            }
            double qq = -0.5 * (bb + Fmath.sign(bb) * Math.sqrt(root));
            double root1 = qq / aa;
            double root2 = cc / qq;
            double limit = this.surfaceSiteDensity * 1.001;
            if (root1 >= 0.0 && root1 <= limit) {
                if (root2 < 0.0 || root2 > limit) {
                    this.siteConcn[this.indexK[0]] = root1;
                    this.bulkConcn[this.indexK[0]] = this.initConcn[this.indexK[0]] - this.siteConcn[this.indexK[0]] * this.surfaceArea / this.volume;
                } else {
                    System.out.println("Class: GouyChapmanStern\nMethod: ionConcns");
                    System.out.println("error1: no physically meaningfull root");
                    System.out.println("root1 = " + root1 + " root2 = " + root2 + " limit = " + limit);
                    System.exit(0);
                }
            } else if (root2 >= 0.0 && root2 <= limit) {
                if (root1 < 0.0 || root1 > limit) {
                    this.siteConcn[this.indexK[0]] = root2;
                    this.bulkConcn[this.indexK[0]] = this.initConcn[this.indexK[0]] - this.siteConcn[this.indexK[0]] * this.surfaceArea / this.volume;
                } else {
                    System.out.println("Class: GouyChapmanStern\nMethod: ionConcns");
                    System.out.println("error2: no physically meaningfull root");
                    System.out.println("root1 = " + root1 + " root2 = " + root2 + " limit = " + limit);
                    System.exit(0);
                }
            } else {
                System.out.println("Class: GouyChapmanStern\nMethod: ionConcns");
                System.out.println("error3: no physically meaningfull root");
                System.out.println("root1 = " + root1 + " root2 = " + root2 + " limit = " + limit);
                System.exit(0);
            }
        } else {
            double[] vec = new double[this.nonZeroAssocK];
            double[][] mat = new double[this.nonZeroAssocK][this.nonZeroAssocK];
            double expPsiTerm = -psi * this.expTerm;
            for (int i = 0; i < this.nonZeroAssocK; ++i) {
                ii = this.indexK[i];
                vec[i] = this.assocConsts[ii] * this.initConcn[ii] * this.surfaceSiteDensity * Math.exp(this.charges[ii] * expPsiTerm);
                for (int j = 0; j < this.nonZeroAssocK; ++j) {
                    mat[i][j] = this.assocConsts[ii] * this.initConcn[ii] * Math.exp(this.charges[ii] * expPsiTerm);
                    if (i != j) continue;
                    double[] dArray = mat[i];
                    int n = j;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
            Matrix matrix = new Matrix(mat);
            vec = matrix.solveLinearSet(vec);
            for (int i = 0; i < this.nonZeroAssocK; ++i) {
                this.siteConcn[this.indexK[i]] = vec[i];
            }
        }
        Minimisation min = new Minimisation();
        GCSminim functA = new GCSminim();
        functA.psiDelta = psi;
        functA.tempK = this.tempK;
        functA.surfaceSiteDensity = this.surfaceSiteDensity;
        functA.surfaceArea = this.surfaceArea;
        functA.volume = this.volume;
        functA.nonZeroAssocK = this.nonZeroAssocK;
        functA.assocK = this.assocConsts;
        functA.initConcn = this.initConcn;
        functA.charges = this.charges;
        functA.indexK = this.indexK;
        double[] start = new double[this.nonZeroAssocK];
        double[] step = new double[this.nonZeroAssocK];
        for (int i = 0; i < this.nonZeroAssocK; ++i) {
            start[i] = this.surfaceSiteDensity / (double)this.nonZeroAssocK;
            step[i] = start[i] * 0.05;
        }
        double tolerance = this.surfaceSiteDensity * 1.0E-8;
        int maxIter = 100000;
        min.nelderMead(functA, start, step, tolerance, maxIter);
        double[] param = min.getParamValues();
        for (int i = 0; i < this.nonZeroAssocK; ++i) {
            ii = this.indexK[i];
            this.siteConcn[ii] = param[i];
            this.bulkConcn[ii] = this.initConcn[ii] - param[i] * this.surfaceArea / this.volume;
        }
        this.adsorbedChargeDensity = 0.0;
        double factor1 = 96485.34158524018;
        double factor2 = this.surfaceArea / this.volume;
        for (int i = 0; i < this.numOfIons; ++i) {
            this.sternConcn[i] = this.bulkConcn[i] * Math.exp(-this.charges[i] * this.expTerm);
            this.adsorbedChargeDensity += this.siteConcn[i] * this.charges[i] * factor1;
            numer += (this.sternConcn[i] + this.siteConcn[i] * factor2) * this.radii[i];
            denom += this.sternConcn[i] + this.siteConcn[i] * factor2;
        }
        double delta = numer / denom;
        return delta;
    }

    public double getAdsorbedChargeDensity() {
        if (!this.sternOption || this.nonZeroAssocK == 0) {
            return 0.0;
        }
        if (this.psi0set && this.sigmaSet) {
            return this.adsorbedChargeDensity;
        }
        if (this.sigmaSet) {
            this.getSurfacePotential();
            return this.sternPotential;
        }
        if (this.psi0set) {
            this.getSurfaceChargeDensity();
            return this.adsorbedChargeDensity;
        }
        System.out.println("Class: GouyChapmanStern\nMethod: getAdsorbedChargeDensity\nThe value of the adsorbed ion charge density has not been calculated\nzero returned");
        System.out.println("Neither a surface potential nor a surface charge density have been entered");
        return 0.0;
    }

    public double getDiffuseChargeDensity() {
        double ads = this.getAdsorbedChargeDensity();
        this.diffuseChargeDensity = -(this.surfaceChargeDensity + ads);
        return this.diffuseChargeDensity;
    }

    public double getSurfacePotential(double sigma) {
        this.surfacePotential = this.calcSurfacePotential(sigma);
        this.psi0set = true;
        return this.surfacePotential;
    }

    private double calcSurfacePotential(double sigma) {
        double surPot = 0.0;
        if (!this.epsilonSet) {
            throw new IllegalArgumentException("The relative permittivitie/s have not been entered");
        }
        if (!this.tempSet) {
            System.out.println("The temperature has not been entered\na value of 25 degrees Celsius has been used");
        }
        if (this.psi0set && this.sigmaSet) {
            return this.surfacePotential;
        }
        if (!this.unpackArrayList) {
            this.unpack();
        }
        if (this.sternOption) {
            if (this.nonZeroAssocK == 0) {
                this.diffPotential = this.chargeSame ? Fmath.asinh(sigma / Math.sqrt(this.eightTerm * this.electrolyteConcn)) / (this.chargeValue * this.expTermOver2) : this.surfacePotential1(sigma);
                this.sternCap = 8.854187817E-12 * this.epsilonStern / this.calcDelta(this.diffPotential);
                surPot = this.diffPotential + sigma / this.sternCap;
                this.totalCap = sigma / this.surfacePotential;
                this.diffCap = sigma / this.diffPotential;
            } else {
                surPot = this.chargeSame ? this.surfacePotential2(sigma) : this.surfacePotential3(sigma);
            }
        } else {
            if (this.chargeSame) {
                double preterm = Math.sqrt(this.eightTerm * this.electrolyteConcn);
                this.surfacePotential = Fmath.asinh(this.surfaceChargeDensity / preterm) / (this.chargeValue * this.expTermOver2);
            } else {
                surPot = this.surfacePotential4(sigma);
            }
            this.diffPotential = surPot;
            this.sternPotential = 0.0;
            this.totalCap = sigma / surPot;
            this.diffCap = sigma / this.diffPotential;
            this.sternCap = Double.POSITIVE_INFINITY;
        }
        return surPot;
    }

    public double getSurfacePotential() {
        if (!this.sigmaSet) {
            throw new IllegalArgumentException("No surface charge density has been entered");
        }
        return this.getSurfacePotential(this.surfaceChargeDensity);
    }

    private double surfacePotential4(double sigma) {
        double surPot = 0.0;
        double psiLow = 0.0;
        double pFuncLow = this.psiFunction4(psiLow, sigma);
        double asinhDenom = Math.sqrt(this.eightTerm * this.electrolyteConcn);
        double psiHigh = 10.0 / (this.averageCharge * this.expTerm) * Fmath.asinh(sigma / asinhDenom);
        double pFuncHigh = this.psiFunction4(psiHigh, sigma);
        if (pFuncHigh * pFuncLow > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double check = Math.abs(psiHigh) * 1.0E-6;
        boolean test = true;
        double psiMid = 0.0;
        double pFuncMid = 0.0;
        int nIter = 0;
        while (test) {
            psiMid = (psiLow + psiHigh) / 2.0;
            pFuncMid = this.psiFunction4(psiMid, sigma);
            if (Math.abs(pFuncMid) <= check) {
                surPot = psiMid;
                test = false;
                continue;
            }
            if (++nIter > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: getSurfacePotential\nnumber of iterations exceeded in outer bisection\ncurrent value of sigma returned");
                surPot = psiMid;
                test = false;
                continue;
            }
            if (pFuncLow * pFuncMid > 0.0) {
                psiLow = psiMid;
                pFuncLow = pFuncMid;
                continue;
            }
            psiHigh = psiMid;
            pFuncHigh = pFuncMid;
        }
        return surPot;
    }

    private double psiFunction4(double psi, double sigma) {
        double sigmaEst = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            sigmaEst += this.bulkConcn[i] * this.twoTerm * (Math.exp(-this.expTerm * this.charges[i] * psi) - 1.0);
        }
        sigmaEst = Fmath.sign(sigma) * Math.sqrt(sigmaEst);
        return sigma - sigmaEst;
    }

    private double surfacePotential1(double sigma) {
        double difPot = 0.0;
        double psiLow = 0.0;
        double pFuncLow = this.psiFunction1(psiLow, sigma);
        double psiHigh = 5.0 / (this.expTerm * this.chargeValue) * Fmath.asinh(sigma / Math.sqrt(this.eightTerm * this.electrolyteConcn));
        double pFuncHigh = this.psiFunction1(psiHigh, sigma);
        if (pFuncHigh * pFuncLow > 0.0) {
            throw new IllegalArgumentException("root not bounded");
        }
        double check = Math.abs(psiHigh) * 1.0E-6;
        boolean test = true;
        double psiMid = 0.0;
        double pFuncMid = 0.0;
        int nIter = 0;
        while (test) {
            psiMid = (psiLow + psiHigh) / 2.0;
            pFuncMid = this.psiFunction1(psiMid, sigma);
            if (Math.abs(pFuncMid) <= check) {
                this.diffPotential = psiMid;
                test = false;
                continue;
            }
            if (++nIter > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: getSurfacePotential\nnumber of iterations exceeded in outer bisection\ncurrent value of sigma returned");
                this.diffPotential = psiMid;
                test = false;
                continue;
            }
            if (pFuncLow * pFuncMid > 0.0) {
                psiLow = psiMid;
                pFuncLow = pFuncMid;
                continue;
            }
            psiHigh = psiMid;
            pFuncHigh = pFuncMid;
        }
        return difPot;
    }

    private double psiFunction1(double psi, double sigma) {
        double func = 0.0;
        for (int i = 0; i < this.numOfIons; ++i) {
            func += this.twoTerm * this.bulkConcn[i] * (Math.exp(-this.charges[i] * psi * this.expTerm) - 1.0);
        }
        return sigma - Fmath.sign(sigma) * Math.sqrt(func);
    }

    public double getPotentialAtX(double xDistance) {
        if (!this.psi0set && !this.sigmaSet) {
            throw new IllegalArgumentException("Neither a surface potential nor a surface charge/density have been entered");
        }
        if (this.sigmaSet && !this.psi0set) {
            this.getSurfacePotential();
        }
        if (this.psi0set && !this.sigmaSet) {
            this.getSurfaceChargeDensity();
        }
        double potAtX = 0.0;
        potAtX = xDistance == 0.0 ? this.surfacePotential : (this.sternOption ? (xDistance == this.sternDelta ? this.diffPotential : (xDistance < this.sternDelta ? this.surfacePotential - xDistance / this.sternDelta * (this.surfacePotential - this.diffPotential) : this.calcPotAtX(this.diffPotential, xDistance))) : this.calcPotAtX(this.surfacePotential, xDistance));
        return potAtX;
    }

    private double calcPotAtX(double psiL, double xDistance) {
        double potAtX = 0.0;
        if (this.chargeSame) {
            double kappa = Math.sqrt(2.0 * Fmath.square(-1.60217646263E-19 * this.chargeValue) * 6.0221419947E23 * this.electrolyteConcn / (8.854187817E-12 * this.epsilon * 1.380650324E-23 * this.tempK));
            double expPart = Math.exp(this.expTerm * this.chargeValue * psiL / 2.0);
            double gamma = (expPart - 1.0) / (expPart + 1.0);
            double gammaExp = gamma * Math.exp(-kappa * xDistance);
            potAtX = 2.0 * Math.log((1.0 + gammaExp) / (1.0 - gammaExp)) / (this.expTerm * this.chargeValue);
        } else {
            FunctionPatX func = new FunctionPatX();
            func.numOfIons = this.numOfIons;
            func.termOne = 16.628944592313125 * this.tempK / (8.854187817E-12 * this.epsilon);
            func.expTerm = this.expTerm;
            func.bulkConcn = this.bulkConcn;
            func.charges = this.charges;
            int nPointsGQ = 2000;
            double psiXlow = 0.0;
            double pFuncLow = xDistance - Integration.trapezium(func, psiXlow, psiL, nPointsGQ);
            double psiXhigh = psiL;
            double pFuncHigh = xDistance - Integration.trapezium(func, psiXhigh, psiL, nPointsGQ);
            if (pFuncHigh * pFuncLow > 0.0) {
                throw new IllegalArgumentException("root not bounded");
            }
            double check = Math.abs(xDistance) * 0.01;
            boolean test = true;
            double psiXmid = 0.0;
            double pFuncMid = 0.0;
            int nIter = 0;
            while (test) {
                psiXmid = (psiXlow + psiXhigh) / 2.0;
                pFuncMid = xDistance - Integration.trapezium(func, psiXmid, psiL, nPointsGQ);
                if (Math.abs(pFuncMid) <= check) {
                    potAtX = psiXmid;
                    test = false;
                    continue;
                }
                if (++nIter > 10000) {
                    System.out.println("Class: GouyChapmanStern\nMethod: getPotentialAtX\nnumber of iterations exceeded in outer bisection\ncurrent value of psi(x) returned");
                    potAtX = psiXmid;
                    test = false;
                    continue;
                }
                if (pFuncLow * pFuncMid > 0.0) {
                    psiXlow = psiXmid;
                    pFuncLow = pFuncMid;
                    continue;
                }
                psiXhigh = psiXmid;
                pFuncHigh = pFuncMid;
            }
        }
        return potAtX;
    }

    public double[] getConcnsAtX(double xDistance) {
        if (!this.psi0set && !this.sigmaSet) {
            throw new IllegalArgumentException("Neither a surface potential nor a surface charge/density have been entered");
        }
        if (this.sigmaSet && !this.psi0set) {
            this.getSurfacePotential();
        }
        if (this.psi0set && !this.sigmaSet) {
            this.getSurfaceChargeDensity();
        }
        double[] conc = new double[this.numOfIons];
        if (this.sternOption && xDistance < this.sternDelta) {
            for (int i = 0; i < this.numOfIons; ++i) {
                conc[i] = 0.0;
            }
        } else {
            double psi = this.getPotentialAtX(xDistance);
            for (int i = 0; i < this.numOfIons; ++i) {
                conc[i] = this.bulkConcn[i] * Math.exp(-this.expTerm * this.charges[i] * psi);
            }
        }
        return conc;
    }

    public double[] getInitConcns() {
        if (!this.psi0set && !this.sigmaSet) {
            this.unpack();
        }
        double[] conc = Conv.copy(this.initConcn);
        int i = 0;
        while (i < this.numOfIons) {
            int n = i++;
            conc[n] = conc[n] * 0.001;
        }
        return conc;
    }

    public double[] getBulkConcns() {
        if (!this.psi0set && !this.sigmaSet) {
            throw new IllegalArgumentException("Neither a surface potential nor a surface charge/density have been entered");
        }
        if (this.sigmaSet && !this.psi0set) {
            this.getSurfacePotential();
        }
        if (this.psi0set && !this.sigmaSet) {
            this.getSurfaceChargeDensity();
        }
        double[] conc = Conv.copy(this.bulkConcn);
        int i = 0;
        while (i < this.numOfIons) {
            int n = i++;
            conc[n] = conc[n] * 0.001;
        }
        return conc;
    }

    public double[] getSiteConcns() {
        if (!this.psi0set && !this.sigmaSet) {
            throw new IllegalArgumentException("Neither a surface potential nor a surface charge/density have been entered");
        }
        if (this.sigmaSet && !this.psi0set) {
            this.getSurfacePotential();
        }
        if (this.psi0set && !this.sigmaSet) {
            this.getSurfaceChargeDensity();
        }
        return this.siteConcn;
    }

    private double surfacePotential2(double sigma) {
        double surPot = 0.0;
        double diffPot = Fmath.asinh(sigma / Math.sqrt(this.eightTerm * this.electrolyteConcn)) / (this.chargeValue * this.expTermOver2);
        double pLow = 0.0;
        double pHigh = 0.0;
        if (diffPot > 0.0) {
            pHigh = 2.0 * diffPot;
        } else {
            pLow = 2.0 * diffPot;
        }
        surPot = this.surfacePotentialBisection(pLow, pHigh, sigma, 2);
        return surPot;
    }

    private double surfacePotentialBisection(double pLow, double pHigh, double sigma, int n) {
        double surPot = 0.0;
        boolean testC = true;
        int testCiter = 0;
        int testCmax = 10;
        double pDiff = pHigh - pLow;
        double cLow = this.cFunction(pLow, sigma);
        double cHigh = this.cFunction(pHigh, sigma);
        while (testC) {
            if (pHigh * pLow > 0.0) {
                if (++testCiter > testCmax) {
                    throw new IllegalArgumentException("root not bounded after " + testCiter + "expansions");
                }
                cLow = this.cFunction(pLow -= pDiff, sigma);
                cHigh = this.cFunction(pHigh += pDiff, sigma);
                continue;
            }
            testC = false;
        }
        double check = Math.abs(sigma) * 1.0E-6;
        boolean test = true;
        double cMid = 0.0;
        int nIter = 0;
        while (test) {
            surPot = (pLow + pHigh) / 2.0;
            cMid = this.cFunction(surPot, sigma);
            if (Math.abs(cMid) <= check) {
                test = false;
                continue;
            }
            if (++nIter > 10000) {
                System.out.println("Class: GouyChapmanStern\nMethod: surfacePotential" + n + "\nnumber of iterations exceeded in bisection\ncurrent value of sigma returned");
                test = false;
            }
            if (cMid * cHigh > 0.0) {
                pHigh = surPot;
                cHigh = cMid;
                continue;
            }
            pLow = surPot;
            cLow = cMid;
        }
        return surPot;
    }

    private double cFunction(double psi, double sigma) {
        double sigmaEst = this.calcSurfaceChargeDensity(psi);
        return sigmaEst - sigma;
    }

    private double surfacePotential3(double sigma) {
        double surPot = 0.0;
        double diffPot = Fmath.asinh(sigma / Math.sqrt(this.eightTerm * this.electrolyteConcn)) / (this.chargeValue * this.expTermOver2);
        double pLow = 0.0;
        double pHigh = 0.0;
        if (diffPot > 0.0) {
            pHigh = 2.0 * diffPot;
        } else {
            pLow = 2.0 * diffPot;
        }
        surPot = this.surfacePotentialBisection(pLow, pHigh, sigma, 3);
        return surPot;
    }
}

