/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.fileIterator.SeekableBufferedReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesSeekableReader
extends TestCase {
    long calcHash(String fileName) throws IOException {
        String line;
        SeekableBufferedReader sbr = new SeekableBufferedReader(fileName);
        long hash = 0L;
        while ((line = sbr.readLine()) != null) {
            hash += (long)line.hashCode();
        }
        return hash;
    }

    long calcHashBufferedReader(String fileName) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(new File(fileName)));
        long hash = 0L;
        while ((line = br.readLine()) != null) {
            hash += (long)line.hashCode();
        }
        return hash;
    }

    public void test_01() throws IOException {
        String dirName = "./tests/";
        File dir = new File(dirName);
        for (String fileName : dir.list()) {
            if (!fileName.endsWith(".txt") && !fileName.endsWith(".vcf")) continue;
            fileName = dirName + fileName;
            long hashExp = this.calcHashBufferedReader(fileName);
            long hash = this.calcHash(fileName);
            System.out.println(String.format("%016x\t%016x\t%s", hashExp, hash, fileName));
            Assert.assertEquals((long)hashExp, (long)hash);
        }
    }
}

