/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.probablility;

import DistLib.normal;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;

public class NormalDistribution {
    static final double SIXTEN = 1.6;
    public static final double MAX_NORM_DOUBLE = 700.0;

    public static Apfloat pdf(double x, double mu, double sigma) {
        double z = (x - mu) * (x - mu) / (2.0 * sigma * sigma);
        if (z > 700.0) {
            return NormalDistribution.pdfApfloat(x, mu, sigma);
        }
        double pdf = normal.density((double)x, (double)mu, (double)sigma);
        return new Apfloat(pdf);
    }

    public static Apfloat pdfApfloat(double x, double mu, double sigma) {
        Apfloat apk = new Apfloat(1.0 / (sigma * Math.sqrt(Math.PI * 2)));
        Apfloat zAp = new Apfloat(-((x - mu) * (x - mu)) / (2.0 * sigma * sigma));
        Apfloat pdfAp = ApfloatMath.exp((Apfloat)zAp).multiply(apk);
        return pdfAp;
    }

    public static Apfloat cdf(double x, double mu, double sigma) {
        double result;
        double[] c = new double[]{0.39894151208813466, 8.883149794388377, 93.50665613217785, 597.2702763948002, 2494.5375852903726, 6848.190450536283, 11602.65143764735, 9842.714838383978, 1.0765576773720192E-8};
        double[] d = new double[]{22.266688044328117, 235.387901782625, 1519.3775994075547, 6485.558298266761, 18615.571640885097, 34900.95272114598, 38912.00328609327, 19685.429676859992};
        double[] p = new double[]{0.215898534057957, 0.12740116116024736, 0.022235277870649807, 0.0014216191932278934, 2.9112874951168793E-5, 0.023073441764940174};
        double[] q = new double[]{1.284260096144911, 0.4682382124808651, 0.06598813786892856, 0.0037823963320275824, 7.297515550839662E-5};
        double[] a = new double[]{2.2352520354606837, 161.02823106855587, 1067.6894854603709, 18154.98125334356, 0.06568233791820745};
        double[] b = new double[]{47.202581904688245, 976.0985517377767, 10260.932208618979, 45507.78933502673};
        if (Double.isNaN(x) || Double.isNaN(mu) || Double.isNaN(sigma)) {
            return new Apfloat(x + mu + sigma);
        }
        if (sigma < 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (Double.isInfinite(x = (x - mu) / sigma)) {
            if (x < 0.0) {
                return Apfloat.ZERO;
            }
            return Apfloat.ONE;
        }
        double eps = 1.110223E-16f;
        double min = Double.MIN_VALUE;
        double y = Math.abs(x);
        if (y <= 0.66291) {
            double xsq = 0.0;
            if (y > eps) {
                xsq = x * x;
            }
            double xnum = a[4] * xsq;
            double xden = xsq;
            for (int i = 1; i <= 3; ++i) {
                xnum = (xnum + a[i - 1]) * xsq;
                xden = (xden + b[i - 1]) * xsq;
            }
            double temp = result = x * (xnum + a[3]) / (xden + b[3]);
            result = 0.5 + temp;
            double ccum = 0.5 - temp;
        } else if (y <= 5.656854249492381) {
            double xnum = c[8] * y;
            double xden = y;
            for (int i = 1; i <= 7; ++i) {
                xnum = (xnum + c[i - 1]) * y;
                xden = (xden + d[i - 1]) * y;
            }
            result = (xnum + c[7]) / (xden + d[7]);
            double xsq = Math.floor(y * 1.6) / 1.6;
            double del = (y - xsq) * (y + xsq);
            result = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * result;
            double ccum = 1.0 - result;
            if (x > 0.0) {
                double temp = result;
                result = ccum;
                ccum = temp;
            }
        } else if (y < 38.0) {
            result = 0.0;
            double xsq = 1.0 / (x * x);
            double xnum = p[5] * xsq;
            double xden = xsq;
            for (int i = 1; i <= 4; ++i) {
                xnum = (xnum + p[i - 1]) * xsq;
                xden = (xden + q[i - 1]) * xsq;
            }
            result = xsq * (xnum + p[4]) / (xden + q[4]);
            result = (0.3989422804014327 - result) / y;
            xsq = Math.floor(x * 1.6) / 1.6;
            double del = (x - xsq) * (x + xsq);
            result = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * result;
            double ccum = 1.0 - result;
            if (x > 0.0) {
                double temp = result;
                result = ccum;
                ccum = temp;
            }
        } else {
            Apfloat res = NormalDistribution.cdfApfloat(x, y, p, q);
            return res;
        }
        return new Apfloat(result);
    }

    public static Apfloat cdfApfloat(double x, double y, double[] p, double[] q) {
        Apfloat xAp = new Apfloat(x);
        Apfloat mhalf = new Apfloat(-0.5);
        Apfloat result = new Apfloat(0.0);
        Apfloat xsq = new Apfloat(1.0 / (x * x));
        Apfloat xnum = xsq.multiply(new Apfloat(p[5]));
        Apfloat xden = xsq;
        for (int i = 1; i <= 4; ++i) {
            xnum = xnum.add(new Apfloat(p[i - 1])).multiply(xsq);
            xden = xden.add(new Apfloat(q[i - 1])).multiply(xsq);
        }
        result = xsq.multiply(xnum.add(new Apfloat(p[4])).divide(xden.add(new Apfloat(q[4]))));
        result = new Apfloat(0.3989422804014327).subtract(result).divide(new Apfloat(y));
        xsq = new Apfloat(Math.floor(x * 1.6) / 1.6);
        Apfloat del = xAp.subtract(xsq).multiply(xAp.add(xsq));
        result = ApfloatMath.exp((Apfloat)xsq.multiply(xsq).multiply(mhalf)).multiply(ApfloatMath.exp((Apfloat)del.multiply(mhalf))).multiply(result);
        Apfloat ccum = Apfloat.ONE.subtract(result);
        if (x > 0.0) {
            Apfloat temp = result;
            result = ccum;
            ccum = temp;
        }
        return result;
    }
}

