/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.MarkerFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.parser.Parser;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeader;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class VcfFileIterator
extends MarkerFileIterator<VcfEntry>
implements Parser<VcfEntry> {
    public static final String MISSING = ".";
    private static final String EMPTY = "";
    boolean parseNow = true;
    VcfHeader header = new VcfHeader();

    public VcfFileIterator(BufferedReader reader) {
        super(reader, 1);
    }

    public VcfFileIterator(Genome genome) {
        super((String)null, 1);
        this.genome = genome;
    }

    public VcfFileIterator(String fileName) {
        super(fileName, 1);
    }

    public VcfFileIterator(String fileName, Genome genome) {
        super(fileName, 1);
        this.genome = genome;
    }

    public List<String> getSampleNames() {
        return this.header.getSampleNames();
    }

    public VcfHeader getVcfHeader() {
        return this.header;
    }

    @Override
    public Collection<VcfEntry> parse(String str) {
        LinkedList<VcfEntry> list = new LinkedList<VcfEntry>();
        list.add(this.parseVcfLine(str));
        return list;
    }

    protected VcfEntry parseVcfLine(String line) {
        try {
            if (line.startsWith("#")) {
                this.header.addLine(line);
            } else if (line.length() > 0 && !line.startsWith("#")) {
                return new VcfEntry(this, line, this.lineNum, this.parseNow);
            }
        }
        catch (Throwable t) {
            Gpr.debug("Fatal error reading file '" + this.fileName + "' (line: " + this.lineNum + "):\n" + line);
            throw new RuntimeException(t);
        }
        return null;
    }

    public String readField(String[] fields, int fieldNum) {
        if (fields.length > fieldNum) {
            if (fields[fieldNum].equals(MISSING)) {
                return EMPTY;
            }
            return fields[fieldNum];
        }
        return EMPTY;
    }

    public VcfHeader readHeader() {
        if (this.nextLine != null && !this.nextLine.startsWith("#")) {
            return this.header;
        }
        try {
            while (this.ready()) {
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (!this.line.startsWith("#")) {
                    this.nextLine = this.line;
                    return this.header;
                }
                this.header.addLine(this.line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file '" + this.fileName + "'. Line ignored:\n\tLine (" + this.lineNum + "):\t'" + this.line + "'");
        }
        return this.header;
    }

    @Override
    protected VcfEntry readNext() {
        try {
            while (this.ready()) {
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                VcfEntry vcfEntry = this.parseVcfLine(this.line);
                if (vcfEntry == null) continue;
                return vcfEntry;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file '" + this.fileName + "'. Line ignored:\n\tLine (" + this.lineNum + "):\t'" + this.line + "'");
        }
        return null;
    }

    @Override
    public void setCreateChromos(boolean createChromos) {
        this.createChromos = createChromos;
    }

    public void setParseNow(boolean parseNow) {
        this.parseNow = parseNow;
    }
}

