/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.math.MinimisationFunction;

class GCSminim
implements MinimisationFunction {
    public double psiDelta = 0.0;
    public double tempK = 298.15;
    public double surfaceSiteDensity = 0.0;
    public double surfaceArea = 0.0;
    public double volume = 0.0;
    public int nonZeroAssocK = 0;
    public double[] assocK = null;
    public double[] initConcn = null;
    public double[] charges = null;
    public int[] indexK = null;

    @Override
    public double function(double[] x) {
        int i;
        double gFunction = 0.0;
        double arg = 0.0;
        int ii = 0;
        double convFac = this.surfaceArea / this.volume;
        double expTerm = this.psiDelta * -1.60217646263E-19 / (1.380650324E-23 * this.tempK);
        double innerSumTerm = 0.0;
        for (i = 0; i < this.nonZeroAssocK; ++i) {
            innerSumTerm += x[0];
        }
        innerSumTerm = this.surfaceSiteDensity - innerSumTerm;
        for (i = 0; i < this.nonZeroAssocK; ++i) {
            ii = this.indexK[i];
            arg = this.assocK[ii] * (this.initConcn[ii] - x[i] * convFac) * Math.exp(expTerm * this.charges[ii]) * innerSumTerm - x[0];
            gFunction += arg * arg;
        }
        return gFunction;
    }
}

