/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.analysis.Regression;
import flanagan.analysis.Stat;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Vector;

public class Matrix {
    private int numberOfRows = 0;
    private int numberOfColumns = 0;
    private double[][] matrix = null;
    private double[][] hessenberg = null;
    private boolean hessenbergDone = false;
    private int[] permutationIndex = null;
    private double rowSwapIndex = 1.0;
    private double[] eigenValues = null;
    private double[][] eigenVector = null;
    private double[] sortedEigenValues = null;
    private double[][] sortedEigenVector = null;
    private int numberOfRotations = 0;
    private int[] eigenIndices = null;
    private int maximumJacobiIterations = 100;
    private boolean eigenDone = false;
    private boolean matrixCheck = true;
    private boolean supressErrorMessage = false;
    private double tiny = 1.0E-100;

    public Matrix(int numberOfRows, int numberOfColumns) {
        this.numberOfRows = numberOfRows;
        this.numberOfColumns = numberOfColumns;
        this.matrix = new double[numberOfRows][numberOfColumns];
        this.permutationIndex = new int[numberOfRows];
        for (int i = 0; i < numberOfRows; ++i) {
            this.permutationIndex[i] = i;
        }
    }

    public Matrix(int numberOfRows, int numberOfColumns, double constant) {
        int i;
        this.numberOfRows = numberOfRows;
        this.numberOfColumns = numberOfColumns;
        this.matrix = new double[numberOfRows][numberOfColumns];
        for (i = 0; i < numberOfRows; ++i) {
            for (int j = 0; j < numberOfColumns; ++j) {
                this.matrix[i][j] = constant;
            }
        }
        this.permutationIndex = new int[numberOfRows];
        for (i = 0; i < numberOfRows; ++i) {
            this.permutationIndex[i] = i;
        }
    }

    public Matrix(double[][] twoD) {
        int i;
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length;
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        for (i = 0; i < this.numberOfRows; ++i) {
            if (twoD[i].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[i][j] = twoD[i][j];
            }
        }
        this.permutationIndex = new int[this.numberOfRows];
        for (i = 0; i < this.numberOfRows; ++i) {
            this.permutationIndex[i] = i;
        }
    }

    public Matrix(float[][] twoD) {
        int i;
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length;
        for (i = 1; i < this.numberOfRows; ++i) {
            if (twoD[i].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        for (i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[i][j] = twoD[i][j];
            }
        }
        this.permutationIndex = new int[this.numberOfRows];
        for (i = 0; i < this.numberOfRows; ++i) {
            this.permutationIndex[i] = i;
        }
    }

    public Matrix(long[][] twoD) {
        int i;
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length;
        for (i = 1; i < this.numberOfRows; ++i) {
            if (twoD[i].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        for (i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[i][j] = twoD[i][j];
            }
        }
        this.permutationIndex = new int[this.numberOfRows];
        for (i = 0; i < this.numberOfRows; ++i) {
            this.permutationIndex[i] = i;
        }
    }

    public Matrix(int[][] twoD) {
        int i;
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length;
        for (i = 1; i < this.numberOfRows; ++i) {
            if (twoD[i].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        for (i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[i][j] = twoD[i][j];
            }
        }
        this.permutationIndex = new int[this.numberOfRows];
        for (i = 0; i < this.numberOfRows; ++i) {
            this.permutationIndex[i] = i;
        }
    }

    public Matrix(ArrayMaths[] twoD) {
        int i;
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length();
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        for (i = 0; i < this.numberOfRows; ++i) {
            double[] arrayh = twoD[i].copy().array();
            if (arrayh.length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            this.matrix[i] = arrayh;
        }
        this.permutationIndex = new int[this.numberOfRows];
        for (i = 0; i < this.numberOfRows; ++i) {
            this.permutationIndex[i] = i;
        }
    }

    public Matrix(ArrayList<Object>[] twoDal) {
        int i;
        this.numberOfRows = twoDal.length;
        ArrayMaths[] twoD = new ArrayMaths[this.numberOfRows];
        for (i = 0; i < this.numberOfRows; ++i) {
            twoD[i] = new ArrayMaths(twoDal[i]);
        }
        this.numberOfColumns = twoD[0].length();
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        for (i = 0; i < this.numberOfRows; ++i) {
            double[] arrayh = twoD[i].copy().array();
            if (arrayh.length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            this.matrix[i] = arrayh;
        }
        this.permutationIndex = new int[this.numberOfRows];
        for (i = 0; i < this.numberOfRows; ++i) {
            this.permutationIndex[i] = i;
        }
    }

    public Matrix(Vector<Object>[] twoDv) {
        int i;
        this.numberOfRows = twoDv.length;
        ArrayMaths[] twoD = new ArrayMaths[this.numberOfRows];
        for (i = 0; i < this.numberOfRows; ++i) {
            twoD[i] = new ArrayMaths(twoDv[i]);
        }
        this.numberOfColumns = twoD[0].length();
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        for (i = 0; i < this.numberOfRows; ++i) {
            double[] arrayh = twoD[i].copy().array();
            if (arrayh.length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            this.matrix[i] = arrayh;
        }
        this.permutationIndex = new int[this.numberOfRows];
        for (i = 0; i < this.numberOfRows; ++i) {
            this.permutationIndex[i] = i;
        }
    }

    public Matrix(BigDecimal[][] twoD) {
        int i;
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length;
        for (i = 1; i < this.numberOfRows; ++i) {
            if (twoD[i].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        for (i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[i][j] = twoD[i][j].doubleValue();
            }
        }
        this.permutationIndex = new int[this.numberOfRows];
        for (i = 0; i < this.numberOfRows; ++i) {
            this.permutationIndex[i] = i;
        }
    }

    public Matrix(BigInteger[][] twoD) {
        int i;
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length;
        for (i = 1; i < this.numberOfRows; ++i) {
            if (twoD[i].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        for (i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[i][j] = twoD[i][j].doubleValue();
            }
        }
        this.permutationIndex = new int[this.numberOfRows];
        for (i = 0; i < this.numberOfRows; ++i) {
            this.permutationIndex[i] = i;
        }
    }

    public Matrix(Matrix bb) {
        this.numberOfRows = bb.numberOfRows;
        this.numberOfColumns = bb.numberOfColumns;
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[i][j] = bb.matrix[i][j];
            }
        }
        this.permutationIndex = Conv.copy(bb.permutationIndex);
        this.rowSwapIndex = bb.rowSwapIndex;
    }

    public void resetLUzero(double zeroValue) {
        this.tiny = zeroValue;
    }

    public void setTwoDarray(double[][] aarray) {
        if (this.numberOfRows != aarray.length) {
            throw new IllegalArgumentException("row length of this Matrix differs from that of the 2D array argument");
        }
        if (this.numberOfColumns != aarray[0].length) {
            throw new IllegalArgumentException("column length of this Matrix differs from that of the 2D array argument");
        }
        for (int i = 0; i < this.numberOfRows; ++i) {
            if (aarray[i].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[i][j] = aarray[i][j];
            }
        }
    }

    public void setElement(int i, int j, double aa) {
        this.matrix[i][j] = aa;
    }

    public void setSubMatrix(int i, int j, double[][] subMatrix) {
        int k = subMatrix.length;
        int l = subMatrix[0].length;
        if (i + k - 1 >= this.numberOfRows) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (j + l - 1 >= this.numberOfColumns) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix");
        }
        int m = 0;
        int n = 0;
        for (int p = 0; p < k; ++p) {
            n = 0;
            for (int q = 0; q < l; ++q) {
                this.matrix[i + p][j + q] = subMatrix[m][n];
                ++n;
            }
            ++m;
        }
    }

    public void setSubMatrix(int i, int j, int k, int l, double[][] subMatrix) {
        this.setSubMatrix(i, j, subMatrix);
    }

    public void setSubMatrix(int[] row, int[] col, double[][] subMatrix) {
        int n = row.length;
        int m = col.length;
        for (int p = 0; p < n; ++p) {
            for (int q = 0; q < m; ++q) {
                this.matrix[row[p]][col[q]] = subMatrix[p][q];
            }
        }
    }

    public boolean getMatrixCheck() {
        return this.matrixCheck;
    }

    public static Matrix identityMatrix(int numberOfRows) {
        Matrix special = new Matrix(numberOfRows, numberOfRows);
        for (int i = 0; i < numberOfRows; ++i) {
            special.matrix[i][i] = 1.0;
        }
        return special;
    }

    public static Matrix unitMatrix(int numberOfRows) {
        Matrix special = new Matrix(numberOfRows, numberOfRows);
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = 0; j < numberOfRows; ++j) {
                special.matrix[i][j] = 1.0;
            }
        }
        return special;
    }

    public static Matrix unitMatrix(int numberOfRows, int numberOfColumns) {
        Matrix special = new Matrix(numberOfRows, numberOfColumns);
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = 0; j < numberOfColumns; ++j) {
                special.matrix[i][j] = 1.0;
            }
        }
        return special;
    }

    public static Matrix scalarMatrix(int numberOfRows, double diagconst) {
        Matrix special = new Matrix(numberOfRows, numberOfRows);
        double[][] specialArray = special.getArrayReference();
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = i; j < numberOfRows; ++j) {
                if (i != j) continue;
                specialArray[i][j] = diagconst;
            }
        }
        return special;
    }

    public static Matrix scalarMatrix(int numberOfRows, int numberOfColumns, double diagconst) {
        Matrix special = new Matrix(numberOfRows, numberOfColumns);
        double[][] specialArray = special.getArrayReference();
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = i; j < numberOfColumns; ++j) {
                if (i != j) continue;
                specialArray[i][j] = diagconst;
            }
        }
        return special;
    }

    public static Matrix diagonalMatrix(int numberOfRows, double[] diag) {
        if (diag.length != numberOfRows) {
            throw new IllegalArgumentException("matrix dimension differs from diagonal array length");
        }
        Matrix special = new Matrix(numberOfRows, numberOfRows);
        double[][] specialArray = special.getArrayReference();
        for (int i = 0; i < numberOfRows; ++i) {
            specialArray[i][i] = diag[i];
        }
        return special;
    }

    public static Matrix diagonalMatrix(int numberOfRows, int numberOfColumns, double[] diag) {
        if (diag.length != numberOfRows) {
            throw new IllegalArgumentException("matrix dimension differs from diagonal array length");
        }
        Matrix special = new Matrix(numberOfRows, numberOfColumns);
        double[][] specialArray = special.getArrayReference();
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = i; j < numberOfColumns; ++j) {
                if (i != j) continue;
                specialArray[i][j] = diag[i];
            }
        }
        return special;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getNrow() {
        return this.numberOfRows;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getNcol() {
        return this.numberOfColumns;
    }

    public double[][] getArrayReference() {
        return this.matrix;
    }

    public double[][] getArrayPointer() {
        return this.matrix;
    }

    public double[][] getArrayCopy() {
        double[][] c = new double[this.numberOfRows][this.numberOfColumns];
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                c[i][j] = this.matrix[i][j];
            }
        }
        return c;
    }

    public double[] getRowCopy(int i) {
        if (i >= this.numberOfRows) {
            throw new IllegalArgumentException("Row index, " + i + ", must be less than the number of rows, " + this.numberOfRows);
        }
        if (i < 0) {
            throw new IllegalArgumentException("Row index, " + i + ", must be zero or positive");
        }
        return Conv.copy(this.matrix[i]);
    }

    public double[] getColumnCopy(int ii) {
        if (ii >= this.numberOfColumns) {
            throw new IllegalArgumentException("Column index, " + ii + ", must be less than the number of columns, " + this.numberOfColumns);
        }
        if (ii < 0) {
            throw new IllegalArgumentException("column index, " + ii + ", must be zero or positive");
        }
        double[] col = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            col[i] = this.matrix[i][ii];
        }
        return col;
    }

    public double getElement(int i, int j) {
        return this.matrix[i][j];
    }

    public double getElementCopy(int i, int j) {
        return this.matrix[i][j];
    }

    public double getElementPointer(int i, int j) {
        return this.matrix[i][j];
    }

    public Matrix getSubMatrix(int i, int j, int k, int l) {
        if (i > k) {
            throw new IllegalArgumentException("row indices inverted");
        }
        if (j > l) {
            throw new IllegalArgumentException("column indices inverted");
        }
        if (k >= this.numberOfRows) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (l >= this.numberOfColumns) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix" + i + " " + l);
        }
        int n = k - i + 1;
        int m = l - j + 1;
        Matrix subMatrix = new Matrix(n, m);
        double[][] sarray = subMatrix.getArrayReference();
        for (int p = 0; p < n; ++p) {
            for (int q = 0; q < m; ++q) {
                sarray[p][q] = this.matrix[i + p][j + q];
            }
        }
        return subMatrix;
    }

    public Matrix getSubMatrix(int[] row, int[] col) {
        int n = row.length;
        int m = col.length;
        Matrix subMatrix = new Matrix(n, m);
        double[][] sarray = subMatrix.getArrayReference();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                sarray[i][j] = this.matrix[row[i]][col[j]];
            }
        }
        return subMatrix;
    }

    public int[] getIndexReference() {
        return this.permutationIndex;
    }

    public int[] getIndexPointer() {
        return this.permutationIndex;
    }

    public int[] getIndexCopy() {
        int[] indcopy = new int[this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            indcopy[i] = this.permutationIndex[i];
        }
        return indcopy;
    }

    public double getSwap() {
        return this.rowSwapIndex;
    }

    public static Matrix copy(Matrix a) {
        int i;
        if (a == null) {
            return null;
        }
        int nr = a.getNumberOfRows();
        int nc = a.getNumberOfColumns();
        double[][] aarray = a.getArrayReference();
        Matrix b = new Matrix(nr, nc);
        b.numberOfRows = nr;
        b.numberOfColumns = nc;
        double[][] barray = b.getArrayReference();
        for (i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                barray[i][j] = aarray[i][j];
            }
        }
        for (i = 0; i < nr; ++i) {
            b.permutationIndex[i] = a.permutationIndex[i];
        }
        return b;
    }

    public Matrix copy() {
        int i;
        if (this == null) {
            return null;
        }
        int nr = this.numberOfRows;
        int nc = this.numberOfColumns;
        Matrix b = new Matrix(nr, nc);
        double[][] barray = b.getArrayReference();
        b.numberOfRows = nr;
        b.numberOfColumns = nc;
        for (i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                barray[i][j] = this.matrix[i][j];
            }
        }
        for (i = 0; i < nr; ++i) {
            b.permutationIndex[i] = this.permutationIndex[i];
        }
        return b;
    }

    public Object clone() {
        int i;
        if (this == null) {
            return null;
        }
        int nr = this.numberOfRows;
        int nc = this.numberOfColumns;
        Matrix b = new Matrix(nr, nc);
        double[][] barray = b.getArrayReference();
        b.numberOfRows = nr;
        b.numberOfColumns = nc;
        for (i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                barray[i][j] = this.matrix[i][j];
            }
        }
        for (i = 0; i < nr; ++i) {
            b.permutationIndex[i] = this.permutationIndex[i];
        }
        return b;
    }

    public static Matrix columnMatrix(double[] darray) {
        int nr = darray.length;
        Matrix pp = new Matrix(nr, 1);
        for (int i = 0; i < nr; ++i) {
            pp.matrix[i][0] = darray[i];
        }
        return pp;
    }

    public static Matrix rowMatrix(double[] darray) {
        int nc = darray.length;
        Matrix pp = new Matrix(1, nc);
        for (int i = 0; i < nc; ++i) {
            pp.matrix[0][i] = darray[i];
        }
        return pp;
    }

    public Matrix plus(Matrix bmat) {
        if (this.numberOfRows != bmat.numberOfRows || this.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.numberOfRows;
        int nc = bmat.numberOfColumns;
        Matrix cmat = new Matrix(nr, nc);
        double[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j] + bmat.matrix[i][j];
            }
        }
        return cmat;
    }

    public Matrix plus(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.numberOfRows != nr || this.numberOfColumns != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(nr, nc);
        double[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j] + bmat[i][j];
            }
        }
        return cmat;
    }

    public static Matrix plus(Matrix amat, Matrix bmat) {
        if (amat.numberOfRows != bmat.numberOfRows || amat.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = amat.numberOfRows;
        int nc = amat.numberOfColumns;
        Matrix cmat = new Matrix(nr, nc);
        double[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = amat.matrix[i][j] + bmat.matrix[i][j];
            }
        }
        return cmat;
    }

    public void plusEquals(Matrix bmat) {
        if (this.numberOfRows != bmat.numberOfRows || this.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.numberOfRows;
        int nc = bmat.numberOfColumns;
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                double[] dArray = this.matrix[i];
                int n = j;
                dArray[n] = dArray[n] + bmat.matrix[i][j];
            }
        }
    }

    public Matrix minus(Matrix bmat) {
        if (this.numberOfRows != bmat.numberOfRows || this.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = this.numberOfRows;
        int nc = this.numberOfColumns;
        Matrix cmat = new Matrix(nr, nc);
        double[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j] - bmat.matrix[i][j];
            }
        }
        return cmat;
    }

    public Matrix minus(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.numberOfRows != nr || this.numberOfColumns != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(nr, nc);
        double[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = this.matrix[i][j] - bmat[i][j];
            }
        }
        return cmat;
    }

    public static Matrix minus(Matrix amat, Matrix bmat) {
        if (amat.numberOfRows != bmat.numberOfRows || amat.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = amat.numberOfRows;
        int nc = amat.numberOfColumns;
        Matrix cmat = new Matrix(nr, nc);
        double[][] carray = cmat.getArrayReference();
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                carray[i][j] = amat.matrix[i][j] - bmat.matrix[i][j];
            }
        }
        return cmat;
    }

    public void minusEquals(Matrix bmat) {
        if (this.numberOfRows != bmat.numberOfRows || this.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.numberOfRows;
        int nc = bmat.numberOfColumns;
        for (int i = 0; i < nr; ++i) {
            for (int j = 0; j < nc; ++j) {
                double[] dArray = this.matrix[i];
                int n = j;
                dArray[n] = dArray[n] - bmat.matrix[i][j];
            }
        }
    }

    public Matrix times(Matrix bmat) {
        if (this.numberOfColumns != bmat.numberOfRows) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix cmat = new Matrix(this.numberOfRows, bmat.numberOfColumns);
        double[][] carray = cmat.getArrayReference();
        double sum = 0.0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < bmat.numberOfColumns; ++j) {
                sum = 0.0;
                for (int k = 0; k < this.numberOfColumns; ++k) {
                    sum += this.matrix[i][k] * bmat.matrix[k][j];
                }
                carray[i][j] = sum;
            }
        }
        return cmat;
    }

    public Matrix times(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.numberOfColumns != nr) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix cmat = new Matrix(this.numberOfRows, nc);
        double[][] carray = cmat.getArrayReference();
        double sum = 0.0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < nc; ++j) {
                sum = 0.0;
                for (int k = 0; k < this.numberOfColumns; ++k) {
                    sum += this.matrix[i][k] * bmat[k][j];
                }
                carray[i][j] = sum;
            }
        }
        return cmat;
    }

    public Matrix times(double constant) {
        Matrix cmat = new Matrix(this.numberOfRows, this.numberOfColumns);
        double[][] carray = cmat.getArrayReference();
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                carray[i][j] = this.matrix[i][j] * constant;
            }
        }
        return cmat;
    }

    public static Matrix times(Matrix amat, Matrix bmat) {
        if (amat.numberOfColumns != bmat.numberOfRows) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix cmat = new Matrix(amat.numberOfRows, bmat.numberOfColumns);
        double[][] carray = cmat.getArrayReference();
        double sum = 0.0;
        for (int i = 0; i < amat.numberOfRows; ++i) {
            for (int j = 0; j < bmat.numberOfColumns; ++j) {
                sum = 0.0;
                for (int k = 0; k < amat.numberOfColumns; ++k) {
                    sum += amat.matrix[i][k] * bmat.matrix[k][j];
                }
                carray[i][j] = sum;
            }
        }
        return cmat;
    }

    public static Matrix times(Matrix amat, double[][] bmat) {
        if (amat.numberOfColumns != bmat.length) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix cmat = new Matrix(amat.numberOfRows, bmat[0].length);
        Matrix dmat = new Matrix(bmat);
        double[][] carray = cmat.getArrayReference();
        double sum = 0.0;
        for (int i = 0; i < amat.numberOfRows; ++i) {
            for (int j = 0; j < dmat.numberOfColumns; ++j) {
                sum = 0.0;
                for (int k = 0; k < amat.numberOfColumns; ++k) {
                    sum += amat.matrix[i][k] * dmat.matrix[k][j];
                }
                carray[i][j] = sum;
            }
        }
        return cmat;
    }

    public static Matrix times(Matrix amat, double constant) {
        Matrix cmat = new Matrix(amat.numberOfRows, amat.numberOfColumns);
        double[][] carray = cmat.getArrayReference();
        for (int i = 0; i < amat.numberOfRows; ++i) {
            for (int j = 0; j < amat.numberOfColumns; ++j) {
                carray[i][j] = amat.matrix[i][j] * constant;
            }
        }
        return cmat;
    }

    public void timesEquals(Matrix bmat) {
        int j;
        int i;
        if (this.numberOfColumns != bmat.numberOfRows) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix cmat = new Matrix(this.numberOfRows, bmat.numberOfColumns);
        double[][] carray = cmat.getArrayReference();
        double sum = 0.0;
        for (i = 0; i < this.numberOfRows; ++i) {
            for (j = 0; j < bmat.numberOfColumns; ++j) {
                sum = 0.0;
                for (int k = 0; k < this.numberOfColumns; ++k) {
                    sum += this.matrix[i][k] * bmat.matrix[k][j];
                }
                carray[i][j] = sum;
            }
        }
        this.numberOfRows = cmat.numberOfRows;
        this.numberOfColumns = cmat.numberOfColumns;
        for (i = 0; i < this.numberOfRows; ++i) {
            for (j = 0; j < this.numberOfColumns; ++j) {
                this.matrix[i][j] = cmat.matrix[i][j];
            }
        }
    }

    public void timesEquals(double constant) {
        for (int i = 0; i < this.numberOfRows; ++i) {
            int j = 0;
            while (j < this.numberOfColumns) {
                double[] dArray = this.matrix[i];
                int n = j++;
                dArray[n] = dArray[n] * constant;
            }
        }
    }

    public Matrix over(Matrix bmat) {
        if (this.numberOfRows != bmat.numberOfRows || this.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return this.times(bmat.inverse());
    }

    public Matrix over(Matrix amat, Matrix bmat) {
        if (amat.numberOfRows != bmat.numberOfRows || amat.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return amat.times(bmat.inverse());
    }

    public Matrix over(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.numberOfRows != nr || this.numberOfColumns != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(bmat);
        return this.times(cmat.inverse());
    }

    public Matrix over(Matrix amat, double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (amat.numberOfRows != nr || amat.numberOfColumns != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(bmat);
        return amat.times(cmat.inverse());
    }

    public Matrix over(double[][] amat, Matrix bmat) {
        int nr = amat.length;
        int nc = amat[0].length;
        if (bmat.numberOfRows != nr || bmat.numberOfColumns != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(amat);
        return cmat.times(bmat.inverse());
    }

    public Matrix over(double[][] amat, double[][] bmat) {
        int nr = amat.length;
        int nc = amat[0].length;
        if (bmat.length != nr || bmat[0].length != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(amat);
        Matrix dmat = new Matrix(bmat);
        return cmat.times(dmat.inverse());
    }

    public void overEquals(Matrix bmat) {
        if (this.numberOfRows != bmat.numberOfRows || this.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(bmat);
        this.timesEquals(cmat.inverse());
    }

    public void overEquals(double[][] bmat) {
        Matrix pmat = new Matrix(bmat);
        this.overEquals(pmat);
    }

    public Matrix inverse() {
        int n = this.numberOfRows;
        if (n != this.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Matrix invmat = new Matrix(n, n);
        if (n == 1) {
            double[][] hold = this.getArrayCopy();
            if (hold[0][0] == 0.0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            hold[0][0] = 1.0 / hold[0][0];
            invmat = new Matrix(hold);
        } else if (n == 2) {
            double[][] hold = this.getArrayCopy();
            double det = hold[0][0] * hold[1][1] - hold[0][1] * hold[1][0];
            if (det == 0.0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            double[][] hold2 = new double[2][2];
            hold2[0][0] = hold[1][1] / det;
            hold2[1][1] = hold[0][0] / det;
            hold2[1][0] = -hold[1][0] / det;
            hold2[0][1] = -hold[0][1] / det;
            invmat = new Matrix(hold2);
        } else {
            double[] col = new double[n];
            double[] xvec = new double[n];
            double[][] invarray = invmat.getArrayReference();
            Matrix ludmat = this.luDecomp();
            for (int j = 0; j < n; ++j) {
                int i;
                for (i = 0; i < n; ++i) {
                    col[i] = 0.0;
                }
                col[j] = 1.0;
                xvec = ludmat.luBackSub(col);
                for (i = 0; i < n; ++i) {
                    invarray[i][j] = xvec[i];
                }
            }
        }
        return invmat;
    }

    public static Matrix inverse(Matrix amat) {
        int n = amat.numberOfRows;
        if (n != amat.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Matrix invmat = new Matrix(n, n);
        if (n == 1) {
            double[][] hold = amat.getArrayCopy();
            if (hold[0][0] == 0.0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            hold[0][0] = 1.0 / hold[0][0];
            invmat = new Matrix(hold);
        } else if (n == 2) {
            double[][] hold = amat.getArrayCopy();
            double det = hold[0][0] * hold[1][1] - hold[0][1] * hold[1][0];
            if (det == 0.0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            double[][] hold2 = new double[2][2];
            hold2[0][0] = hold[1][1] / det;
            hold2[1][1] = hold[0][0] / det;
            hold2[1][0] = -hold[1][0] / det;
            hold2[0][1] = -hold[0][1] / det;
            invmat = new Matrix(hold2);
        } else {
            double[] col = new double[n];
            double[] xvec = new double[n];
            double[][] invarray = invmat.getArrayReference();
            Matrix ludmat = amat.luDecomp();
            for (int j = 0; j < n; ++j) {
                int i;
                for (i = 0; i < n; ++i) {
                    col[i] = 0.0;
                }
                col[j] = 1.0;
                xvec = ludmat.luBackSub(col);
                for (i = 0; i < n; ++i) {
                    invarray[i][j] = xvec[i];
                }
            }
        }
        return invmat;
    }

    public Matrix transpose() {
        Matrix tmat = new Matrix(this.numberOfColumns, this.numberOfRows);
        double[][] tarray = tmat.getArrayReference();
        for (int i = 0; i < this.numberOfColumns; ++i) {
            for (int j = 0; j < this.numberOfRows; ++j) {
                tarray[i][j] = this.matrix[j][i];
            }
        }
        return tmat;
    }

    public static Matrix transpose(Matrix amat) {
        Matrix tmat = new Matrix(amat.numberOfColumns, amat.numberOfRows);
        double[][] tarray = tmat.getArrayReference();
        for (int i = 0; i < amat.numberOfColumns; ++i) {
            for (int j = 0; j < amat.numberOfRows; ++j) {
                tarray[i][j] = amat.matrix[j][i];
            }
        }
        return tmat;
    }

    public Matrix opposite() {
        Matrix opp = Matrix.copy(this);
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                opp.matrix[i][j] = -this.matrix[i][j];
            }
        }
        return opp;
    }

    public static Matrix opposite(Matrix amat) {
        Matrix opp = Matrix.copy(amat);
        for (int i = 0; i < amat.numberOfRows; ++i) {
            for (int j = 0; j < amat.numberOfColumns; ++j) {
                opp.matrix[i][j] = -amat.matrix[i][j];
            }
        }
        return opp;
    }

    public double trace() {
        double trac = 0.0;
        for (int i = 0; i < Math.min(this.numberOfColumns, this.numberOfColumns); ++i) {
            trac += this.matrix[i][i];
        }
        return trac;
    }

    public static double trace(Matrix amat) {
        double trac = 0.0;
        for (int i = 0; i < Math.min(amat.numberOfColumns, amat.numberOfColumns); ++i) {
            trac += amat.matrix[i][i];
        }
        return trac;
    }

    public double determinant() {
        int n = this.numberOfRows;
        if (n != this.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double det = 0.0;
        if (n == 2) {
            det = this.matrix[0][0] * this.matrix[1][1] - this.matrix[0][1] * this.matrix[1][0];
        } else {
            Matrix ludmat = this.luDecomp();
            det = ludmat.rowSwapIndex;
            for (int j = 0; j < n; ++j) {
                det *= ludmat.matrix[j][j];
            }
        }
        return det;
    }

    public static double determinant(Matrix amat) {
        int n = amat.numberOfRows;
        if (n != amat.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double det = 0.0;
        if (n == 2) {
            double[][] hold = amat.getArrayCopy();
            det = hold[0][0] * hold[1][1] - hold[0][1] * hold[1][0];
        } else {
            Matrix ludmat = amat.luDecomp();
            det = ludmat.rowSwapIndex;
            for (int j = 0; j < n; ++j) {
                det *= ludmat.matrix[j][j];
            }
        }
        return det;
    }

    public static double determinant(double[][] mat) {
        int n = mat.length;
        for (int i = 0; i < n; ++i) {
            if (n == mat[i].length) continue;
            throw new IllegalArgumentException("Matrix is not square");
        }
        double det = 0.0;
        if (n == 2) {
            det = mat[0][0] * mat[1][1] - mat[0][1] * mat[1][0];
        } else {
            Matrix amat = new Matrix(mat);
            Matrix ludmat = amat.luDecomp();
            det = ludmat.rowSwapIndex;
            for (int j = 0; j < n; ++j) {
                det *= ludmat.matrix[j][j];
            }
        }
        return det;
    }

    public double logDeterminant() {
        int n = this.numberOfRows;
        if (n != this.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double det = 0.0;
        Matrix ludmat = this.luDecomp();
        det = ludmat.rowSwapIndex;
        det = Math.log(det);
        for (int j = 0; j < n; ++j) {
            det += Math.log(ludmat.matrix[j][j]);
        }
        return det;
    }

    public static double logDeterminant(Matrix amat) {
        int n = amat.numberOfRows;
        if (n != amat.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double det = 0.0;
        Matrix ludmat = amat.luDecomp();
        det = ludmat.rowSwapIndex;
        det = Math.log(det);
        for (int j = 0; j < n; ++j) {
            det += Math.log(ludmat.matrix[j][j]);
        }
        return det;
    }

    public static double logDeterminant(double[][] mat) {
        int n = mat.length;
        for (int i = 0; i < n; ++i) {
            if (n == mat[i].length) continue;
            throw new IllegalArgumentException("Matrix is not square");
        }
        Matrix amat = new Matrix(mat);
        return amat.logDeterminant();
    }

    public Matrix cofactor() {
        double[][] cof = new double[this.numberOfRows][this.numberOfColumns];
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                cof[i][j] = this.cofactor(i, j);
            }
        }
        return new Matrix(cof);
    }

    public double cofactor(int ii, int jj) {
        if (ii < 0 || ii >= this.numberOfRows) {
            throw new IllegalArgumentException("The entered row index, " + ii + " must lie between 0 and " + (this.numberOfRows - 1) + " inclusive");
        }
        if (jj < 0 || jj >= this.numberOfColumns) {
            throw new IllegalArgumentException("The entered column index, " + jj + " must lie between 0 and " + (this.numberOfColumns - 1) + " inclusive");
        }
        int[] rowi = new int[this.numberOfRows - 1];
        int[] colj = new int[this.numberOfColumns - 1];
        int kk = 0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            if (i == ii) continue;
            rowi[kk] = i;
            ++kk;
        }
        kk = 0;
        for (int j = 0; j < this.numberOfColumns; ++j) {
            if (j == jj) continue;
            colj[kk] = j;
            ++kk;
        }
        Matrix aa = this.getSubMatrix(rowi, colj);
        double aadet = aa.determinant();
        return aadet * Math.pow(-1.0, ii + jj);
    }

    public Matrix reducedRowEchelonForm() {
        double[][] mat = new double[this.numberOfRows][this.numberOfColumns];
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                mat[i][j] = this.matrix[i][j];
            }
        }
        int leadingCoeff = 0;
        int rowPointer = 0;
        boolean testOuter = true;
        while (testOuter) {
            int counter = rowPointer;
            boolean testInner = true;
            while (testInner && mat[counter][leadingCoeff] == 0.0) {
                if (++counter != this.numberOfRows) continue;
                counter = rowPointer;
                if (++leadingCoeff != this.numberOfColumns) continue;
                testInner = false;
            }
            if (testInner) {
                double[] temp = mat[rowPointer];
                mat[rowPointer] = mat[counter];
                mat[counter] = temp;
                double pivot = mat[rowPointer][leadingCoeff];
                int j = 0;
                while (j < this.numberOfColumns) {
                    double[] dArray = mat[rowPointer];
                    int n = j++;
                    dArray[n] = dArray[n] / pivot;
                }
                for (int i = 0; i < this.numberOfRows; ++i) {
                    if (i == rowPointer) continue;
                    pivot = mat[i][leadingCoeff];
                    for (int j2 = 0; j2 < this.numberOfColumns; ++j2) {
                        double[] dArray = mat[i];
                        int n = j2;
                        dArray[n] = dArray[n] - pivot * mat[rowPointer][j2];
                    }
                }
                if (++leadingCoeff >= this.numberOfColumns) {
                    testOuter = false;
                }
            }
            if (++rowPointer < this.numberOfRows && testInner) continue;
            testOuter = false;
        }
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (mat[i][j] != -0.0) continue;
                mat[i][j] = 0.0;
            }
        }
        return new Matrix(mat);
    }

    public double frobeniusNorm() {
        double norm = 0.0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                norm = Matrix.hypot(norm, Math.abs(this.matrix[i][j]));
            }
        }
        return norm;
    }

    public double oneNorm() {
        double norm = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            sum = 0.0;
            for (int j = 0; j < this.numberOfColumns; ++j) {
                sum += Math.abs(this.matrix[i][j]);
            }
            norm = Math.max(norm, sum);
        }
        return norm;
    }

    public double infinityNorm() {
        double norm = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            sum = 0.0;
            for (int j = 0; j < this.numberOfColumns; ++j) {
                sum += Math.abs(this.matrix[i][j]);
            }
            norm = Math.max(norm, sum);
        }
        return norm;
    }

    public double sum() {
        double sum = 0.0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                sum += this.matrix[i][j];
            }
        }
        return sum;
    }

    public double[] rowSums() {
        double[] sums = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            sums[i] = 0.0;
            for (int j = 0; j < this.numberOfColumns; ++j) {
                int n = i;
                sums[n] = sums[n] + this.matrix[i][j];
            }
        }
        return sums;
    }

    public double[] columnSums() {
        double[] sums = new double[this.numberOfColumns];
        for (int i = 0; i < this.numberOfColumns; ++i) {
            sums[i] = 0.0;
            for (int j = 0; j < this.numberOfRows; ++j) {
                int n = i;
                sums[n] = sums[n] + this.matrix[j][i];
            }
        }
        return sums;
    }

    public double mean() {
        double mean = 0.0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                mean += this.matrix[i][j];
            }
        }
        return mean /= (double)(this.numberOfRows * this.numberOfColumns);
    }

    public double[] rowMeans() {
        double[] means = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            means[i] = 0.0;
            for (int j = 0; j < this.numberOfColumns; ++j) {
                int n = i;
                means[n] = means[n] + this.matrix[i][j];
            }
            int n = i++;
            means[n] = means[n] / (double)this.numberOfColumns;
        }
        return means;
    }

    public double[] columnMeans() {
        double[] means = new double[this.numberOfColumns];
        int i = 0;
        while (i < this.numberOfColumns) {
            means[i] = 0.0;
            for (int j = 0; j < this.numberOfRows; ++j) {
                int n = i;
                means[n] = means[n] + this.matrix[j][i];
            }
            int n = i++;
            means[n] = means[n] / (double)this.numberOfRows;
        }
        return means;
    }

    public Matrix subtractMean() {
        int j;
        int i;
        Matrix mat = new Matrix(this.numberOfRows, this.numberOfColumns);
        double mean = 0.0;
        for (i = 0; i < this.numberOfRows; ++i) {
            for (j = 0; j < this.numberOfColumns; ++j) {
                mean += this.matrix[i][j];
            }
        }
        mean /= (double)(this.numberOfRows * this.numberOfColumns);
        for (i = 0; i < this.numberOfRows; ++i) {
            for (j = 0; j < this.numberOfColumns; ++j) {
                mat.matrix[i][j] = this.matrix[i][j] - mean;
            }
        }
        return mat;
    }

    public Matrix subtractRowMeans() {
        Matrix mat = new Matrix(this.numberOfRows, this.numberOfColumns);
        for (int i = 0; i < this.numberOfRows; ++i) {
            int j;
            double mean = 0.0;
            for (j = 0; j < this.numberOfColumns; ++j) {
                mean += this.matrix[i][j];
            }
            mean /= (double)this.numberOfColumns;
            for (j = 0; j < this.numberOfColumns; ++j) {
                mat.matrix[i][j] = this.matrix[i][j] - mean;
            }
        }
        return mat;
    }

    public Matrix subtractColumnMeans() {
        Matrix mat = new Matrix(this.numberOfRows, this.numberOfColumns);
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int j;
            double mean = 0.0;
            for (j = 0; j < this.numberOfRows; ++j) {
                mean += this.matrix[j][i];
            }
            mean /= (double)this.numberOfRows;
            for (j = 0; j < this.numberOfRows; ++j) {
                mat.matrix[j][i] = this.matrix[j][i] - mean;
            }
        }
        return mat;
    }

    public double median() {
        Stat st = new Stat(this.matrix[0]);
        for (int i = 1; i < this.numberOfRows; ++i) {
            st.concatenate(this.matrix[i]);
        }
        return st.median();
    }

    public double[] rowMedians() {
        double[] medians = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            Stat st = new Stat(this.matrix[i]);
            medians[i] = st.median();
        }
        return medians;
    }

    public double[] columnMedians() {
        double[] medians = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfColumns; ++i) {
            double[] hold = new double[this.numberOfRows];
            for (int j = 0; j < this.numberOfRows; ++j) {
                hold[i] = this.matrix[j][i];
            }
            Stat st = new Stat(hold);
            medians[i] = st.median();
        }
        return medians;
    }

    public void setDenominatorToN() {
        Stat.setStaticDenominatorToN();
    }

    public double variance() {
        Stat st = new Stat(this.matrix[0]);
        for (int i = 1; i < this.numberOfRows; ++i) {
            st.concatenate(this.matrix[i]);
        }
        return st.variance();
    }

    public double[] rowVariances() {
        double[] variances = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            Stat st = new Stat(this.matrix[i]);
            variances[i] = st.variance();
        }
        return variances;
    }

    public double[] columnVariances() {
        double[] variances = new double[this.numberOfColumns];
        for (int i = 0; i < this.numberOfColumns; ++i) {
            double[] hold = new double[this.numberOfRows];
            for (int j = 0; j < this.numberOfRows; ++j) {
                hold[i] = this.matrix[j][i];
            }
            Stat st = new Stat(hold);
            variances[i] = st.variance();
        }
        return variances;
    }

    public double standardDeviation() {
        Stat st = new Stat(this.matrix[0]);
        for (int i = 1; i < this.numberOfRows; ++i) {
            st.concatenate(this.matrix[i]);
        }
        return st.standardDeviation();
    }

    public double[] rowStandardDeviations() {
        double[] standardDeviations = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            Stat st = new Stat(this.matrix[i]);
            standardDeviations[i] = st.standardDeviation();
        }
        return standardDeviations;
    }

    public double[] columnStandardDeviations() {
        double[] standardDeviations = new double[this.numberOfColumns];
        for (int i = 0; i < this.numberOfColumns; ++i) {
            double[] hold = new double[this.numberOfRows];
            for (int j = 0; j < this.numberOfRows; ++j) {
                hold[i] = this.matrix[j][i];
            }
            Stat st = new Stat(hold);
            standardDeviations[i] = st.standardDeviation();
        }
        return standardDeviations;
    }

    public double stanadardError() {
        Stat st = new Stat(this.matrix[0]);
        for (int i = 1; i < this.numberOfRows; ++i) {
            st.concatenate(this.matrix[i]);
        }
        return st.standardError();
    }

    public double[] rowStandardErrors() {
        double[] standardErrors = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            Stat st = new Stat(this.matrix[i]);
            standardErrors[i] = st.standardError();
        }
        return standardErrors;
    }

    public double[] columnStandardErrors() {
        double[] standardErrors = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfColumns; ++i) {
            double[] hold = new double[this.numberOfRows];
            for (int j = 0; j < this.numberOfRows; ++j) {
                hold[i] = this.matrix[j][i];
            }
            Stat st = new Stat(hold);
            standardErrors[i] = st.standardError();
        }
        return standardErrors;
    }

    public double[] maximumElement() {
        double[] ret = new double[3];
        double[] holdD = new double[this.numberOfRows];
        ArrayMaths am = null;
        int[] holdI = new int[this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            am = new ArrayMaths(this.matrix[i]);
            holdD[i] = am.maximum();
            holdI[i] = am.maximumIndex();
        }
        am = new ArrayMaths(holdD);
        ret[0] = am.maximum();
        int maxI = am.maximumIndex();
        ret[1] = maxI;
        ret[2] = holdI[maxI];
        return ret;
    }

    public double[] rowMaxima() {
        double[] maxima = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            Stat st = new Stat(this.matrix[i]);
            maxima[i] = st.maximum();
        }
        return maxima;
    }

    public double[] columnMaxima() {
        double[] maxima = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfColumns; ++i) {
            double[] hold = new double[this.numberOfRows];
            for (int j = 0; j < this.numberOfRows; ++j) {
                hold[i] = this.matrix[j][i];
            }
            Stat st = new Stat(hold);
            maxima[i] = st.maximum();
        }
        return maxima;
    }

    public double[] minimumElement() {
        double[] ret = new double[3];
        double[] holdD = new double[this.numberOfRows];
        ArrayMaths am = null;
        int[] holdI = new int[this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            am = new ArrayMaths(this.matrix[i]);
            holdD[i] = am.minimum();
            holdI[i] = am.minimumIndex();
        }
        am = new ArrayMaths(holdD);
        ret[0] = am.minimum();
        int minI = am.minimumIndex();
        ret[1] = minI;
        ret[2] = holdI[minI];
        return ret;
    }

    public double[] rowMinima() {
        double[] minima = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            Stat st = new Stat(this.matrix[i]);
            minima[i] = st.minimum();
        }
        return minima;
    }

    public double[] columnMinima() {
        double[] minima = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfColumns; ++i) {
            double[] hold = new double[this.numberOfRows];
            for (int j = 0; j < this.numberOfRows; ++j) {
                hold[i] = this.matrix[j][i];
            }
            Stat st = new Stat(hold);
            minima[i] = st.minimum();
        }
        return minima;
    }

    public double range() {
        return this.maximumElement()[0] - this.minimumElement()[0];
    }

    public double[] rowRanges() {
        double[] ranges = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            Stat st = new Stat(this.matrix[i]);
            ranges[i] = st.maximum() - st.minimum();
        }
        return ranges;
    }

    public double[] columnRanges() {
        double[] ranges = new double[this.numberOfRows];
        for (int i = 0; i < this.numberOfColumns; ++i) {
            double[] hold = new double[this.numberOfRows];
            for (int j = 0; j < this.numberOfRows; ++j) {
                hold[i] = this.matrix[j][i];
            }
            Stat st = new Stat(hold);
            ranges[i] = st.maximum() - st.minimum();
        }
        return ranges;
    }

    public int[] pivot() {
        double[] max = this.maximumElement();
        int maxI = (int)max[1];
        int maxJ = (int)max[2];
        double[] min = this.minimumElement();
        int minI = (int)min[1];
        int minJ = (int)min[2];
        if (Math.abs(min[0]) > Math.abs(max[0])) {
            maxI = minI;
            maxJ = minJ;
        }
        int[] ret = new int[]{maxI, maxJ};
        double[] hold1 = this.matrix[0];
        this.matrix[0] = this.matrix[maxI];
        this.matrix[maxI] = hold1;
        double hold2 = 0.0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            hold2 = this.matrix[i][0];
            this.matrix[i][0] = this.matrix[i][maxJ];
            this.matrix[i][maxJ] = hold2;
        }
        return ret;
    }

    public boolean isSquare() {
        boolean test = false;
        if (this.numberOfRows == this.numberOfColumns) {
            test = true;
        }
        return test;
    }

    public boolean isSymmetric() {
        boolean test = true;
        if (this.numberOfRows == this.numberOfColumns) {
            for (int i = 0; i < this.numberOfRows; ++i) {
                for (int j = i + 1; j < this.numberOfColumns; ++j) {
                    if (this.matrix[i][j] == this.matrix[j][i]) continue;
                    test = false;
                }
            }
        } else {
            test = false;
        }
        return test;
    }

    public boolean isZero() {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (this.matrix[i][j] == 0.0) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isUnit() {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (this.matrix[i][j] == 1.0) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isDiagonal() {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (i == j || this.matrix[i][j] == 0.0) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isUpperTriagonal() {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (j >= i || this.matrix[i][j] == 0.0) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isLowerTriagonal() {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (i <= j || this.matrix[i][j] == 0.0) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isTridiagonal() {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (i < j + 1 && this.matrix[i][j] != 0.0) {
                    test = false;
                }
                if (j <= i + 1 || this.matrix[i][j] == 0.0) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isUpperHessenberg() {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (j >= i + 1 || this.matrix[i][j] == 0.0) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isLowerHessenberg() {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (i <= j + 1 || this.matrix[i][j] == 0.0) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isIdentity() {
        boolean test = true;
        if (this.numberOfRows == this.numberOfColumns) {
            for (int i = 0; i < this.numberOfRows; ++i) {
                if (this.matrix[i][i] != 1.0) {
                    test = false;
                }
                for (int j = i + 1; j < this.numberOfColumns; ++j) {
                    if (this.matrix[i][j] != 0.0) {
                        test = false;
                    }
                    if (this.matrix[j][i] == 0.0) continue;
                    test = false;
                }
            }
        } else {
            test = false;
        }
        return test;
    }

    public boolean isNearlySymmetric(double tolerance) {
        boolean test = true;
        if (this.numberOfRows == this.numberOfColumns) {
            for (int i = 0; i < this.numberOfRows; ++i) {
                for (int j = i + 1; j < this.numberOfColumns; ++j) {
                    if (!(Math.abs(this.matrix[i][j] - this.matrix[j][i]) > Math.abs(tolerance))) continue;
                    test = false;
                }
            }
        } else {
            test = false;
        }
        return test;
    }

    public boolean isNearlyZero(double tolerance) {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (!(Math.abs(this.matrix[i][j]) > Math.abs(tolerance))) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isNearlyUnit(double tolerance) {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (!(Math.abs(this.matrix[i][j] - 1.0) > Math.abs(tolerance))) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isNearlyUpperTriagonal(double tolerance) {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (j >= i || !(Math.abs(this.matrix[i][j]) > Math.abs(tolerance))) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isNearlyLowerTriagonal(double tolerance) {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (i <= j || !(Math.abs(this.matrix[i][j]) > Math.abs(tolerance))) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isNearlyIdenty(double tolerance) {
        boolean test = true;
        if (this.numberOfRows == this.numberOfColumns) {
            for (int i = 0; i < this.numberOfRows; ++i) {
                if (Math.abs(this.matrix[i][i] - 1.0) > Math.abs(tolerance)) {
                    test = false;
                }
                for (int j = i + 1; j < this.numberOfColumns; ++j) {
                    if (Math.abs(this.matrix[i][j]) > Math.abs(tolerance)) {
                        test = false;
                    }
                    if (!(Math.abs(this.matrix[j][i]) > Math.abs(tolerance))) continue;
                    test = false;
                }
            }
        } else {
            test = false;
        }
        return test;
    }

    public boolean isTridiagonal(double tolerance) {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (i < j + 1 && Math.abs(this.matrix[i][j]) > Math.abs(tolerance)) {
                    test = false;
                }
                if (j <= i + 1 || !(Math.abs(this.matrix[i][j]) > Math.abs(tolerance))) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isNearlyTridiagonal(double tolerance) {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (i < j + 1 && Math.abs(this.matrix[i][j]) > Math.abs(tolerance)) {
                    test = false;
                }
                if (j <= i + 1 || !(Math.abs(this.matrix[i][j]) > Math.abs(tolerance))) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isNearlyUpperHessenberg(double tolerance) {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (j >= i + 1 || !(Math.abs(this.matrix[i][j]) > Math.abs(tolerance))) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isNearlyLowerHessenberg(double tolerance) {
        boolean test = true;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (i <= j + 1 || !(Math.abs(this.matrix[i][j]) > Math.abs(tolerance))) continue;
                test = false;
            }
        }
        return test;
    }

    public boolean isSingular() {
        boolean test = false;
        double det = this.determinant();
        if (det == 0.0) {
            test = true;
        }
        return test;
    }

    public boolean isNearlySingular(double tolerance) {
        boolean test = false;
        double det = this.determinant();
        if (Math.abs(det) <= Math.abs(tolerance)) {
            test = true;
        }
        return test;
    }

    public ArrayList<Integer> identicalRows() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int nIdentical = 0;
        for (int i = 0; i < this.numberOfRows - 1; ++i) {
            for (int j = i + 1; j < this.numberOfRows; ++j) {
                int m = 0;
                for (int k = 0; k < this.numberOfColumns; ++k) {
                    if (this.matrix[i][k] != this.matrix[j][k]) continue;
                    ++m;
                }
                if (m != this.numberOfColumns) continue;
                ++nIdentical;
                ret.add(new Integer(i));
                ret.add(new Integer(j));
            }
        }
        ret.add(0, new Integer(nIdentical));
        return ret;
    }

    public ArrayList<Integer> identicalColumns() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int nIdentical = 0;
        for (int i = 0; i < this.numberOfColumns; ++i) {
            for (int j = i + 1; j < this.numberOfColumns - 1; ++j) {
                int m = 0;
                for (int k = 0; k < this.numberOfRows; ++k) {
                    if (this.matrix[k][i] != this.matrix[k][j]) continue;
                    ++m;
                }
                if (m != this.numberOfRows) continue;
                ++nIdentical;
                ret.add(new Integer(i));
                ret.add(new Integer(j));
            }
        }
        ret.add(0, new Integer(nIdentical));
        return ret;
    }

    public ArrayList<Integer> zeroRows() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int nZero = 0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            int m = 0;
            for (int k = 0; k < this.numberOfColumns; ++k) {
                if (this.matrix[i][k] != 0.0) continue;
                ++m;
            }
            if (m != this.numberOfColumns) continue;
            ++nZero;
            ret.add(new Integer(i));
        }
        ret.add(0, new Integer(nZero));
        return ret;
    }

    public ArrayList<Integer> zeroColumns() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int nZero = 0;
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int m = 0;
            for (int k = 0; k < this.numberOfRows; ++k) {
                if (this.matrix[k][i] != 0.0) continue;
                ++m;
            }
            if (m != this.numberOfRows) continue;
            ++nZero;
            ret.add(new Integer(i));
        }
        ret.add(0, new Integer(nZero));
        return ret;
    }

    public Matrix luDecomp() {
        int k;
        if (this.numberOfRows != this.numberOfColumns) {
            throw new IllegalArgumentException("A matrix is not square");
        }
        int n = this.numberOfRows;
        int imax = 0;
        double dum = 0.0;
        double temp = 0.0;
        double big = 0.0;
        double[] vv = new double[n];
        double sum = 0.0;
        double dumm = 0.0;
        this.matrixCheck = true;
        Matrix ludmat = Matrix.copy(this);
        double[][] ludarray = ludmat.getArrayReference();
        ludmat.rowSwapIndex = 1.0;
        for (int i = 0; i < n; ++i) {
            big = 0.0;
            for (int j = 0; j < n; ++j) {
                double d;
                temp = Math.abs(ludarray[i][j]);
                if (!(d > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                if (!this.supressErrorMessage) {
                    System.out.println("Attempted LU Decomposition of a singular matrix in Matrix.luDecomp()");
                    System.out.println("NaN matrix returned and matrixCheck set to false");
                }
                this.matrixCheck = false;
                for (k = 0; k < n; ++k) {
                    for (int j = 0; j < n; ++j) {
                        ludarray[k][j] = Double.NaN;
                    }
                }
                return ludmat;
            }
            vv[i] = 1.0 / big;
        }
        for (int j = 0; j < n; ++j) {
            int k2;
            int i;
            for (i = 0; i < j; ++i) {
                sum = ludarray[i][j];
                for (k2 = 0; k2 < i; ++k2) {
                    sum -= ludarray[i][k2] * ludarray[k2][j];
                }
                ludarray[i][j] = sum;
            }
            big = 0.0;
            for (i = j; i < n; ++i) {
                double d;
                sum = ludarray[i][j];
                for (k2 = 0; k2 < j; ++k2) {
                    sum -= ludarray[i][k2] * ludarray[k2][j];
                }
                ludarray[i][j] = sum;
                dum = vv[i] * Math.abs(sum);
                if (!(d >= big)) continue;
                big = dum;
                imax = i;
            }
            if (j != imax) {
                for (k = 0; k < n; ++k) {
                    dumm = ludarray[imax][k];
                    ludarray[imax][k] = ludarray[j][k];
                    ludarray[j][k] = dumm;
                }
                ludmat.rowSwapIndex = -ludmat.rowSwapIndex;
                vv[imax] = vv[j];
            }
            ludmat.permutationIndex[j] = imax;
            if (ludarray[j][j] == 0.0) {
                ludarray[j][j] = this.tiny;
            }
            if (j == n - 1) continue;
            dumm = 1.0 / ludarray[j][j];
            for (i = j + 1; i < n; ++i) {
                double[] dArray = ludarray[i];
                int n2 = j;
                dArray[n2] = dArray[n2] * dumm;
            }
        }
        return ludmat;
    }

    public double[] luBackSub(double[] bvec) {
        int j;
        int i;
        int ii = 0;
        int ip = 0;
        int n = bvec.length;
        if (n != this.numberOfColumns) {
            throw new IllegalArgumentException("vector length is not equal to matrix dimension");
        }
        if (this.numberOfColumns != this.numberOfRows) {
            throw new IllegalArgumentException("matrix is not square");
        }
        double sum = 0.0;
        double[] xvec = new double[n];
        for (i = 0; i < n; ++i) {
            xvec[i] = bvec[i];
        }
        for (i = 0; i < n; ++i) {
            ip = this.permutationIndex[i];
            sum = xvec[ip];
            xvec[ip] = xvec[i];
            if (ii == 0) {
                for (j = ii; j <= i - 1; ++j) {
                    sum -= this.matrix[i][j] * xvec[j];
                }
            } else if (sum == 0.0) {
                ii = i;
            }
            xvec[i] = sum;
        }
        for (i = n - 1; i >= 0; --i) {
            sum = xvec[i];
            for (j = i + 1; j < n; ++j) {
                sum -= this.matrix[i][j] * xvec[j];
            }
            xvec[i] = sum / this.matrix[i][i];
        }
        return xvec;
    }

    public double[] solveLinearSet(double[] bvec) {
        double[] xvec = null;
        if (this.numberOfRows == this.numberOfColumns) {
            Matrix ludmat = this.luDecomp();
            xvec = ludmat.luBackSub(bvec);
        } else if (this.numberOfRows > this.numberOfColumns) {
            int n = bvec.length;
            if (this.numberOfRows != n) {
                throw new IllegalArgumentException("Overdetermined equation solution - vector length is not equal to matrix column length");
            }
            Matrix avecT = this.transpose();
            double[][] avec = avecT.getArrayCopy();
            Regression reg = new Regression(avec, bvec);
            reg.linearGeneral();
            xvec = reg.getCoeff();
        } else {
            throw new IllegalArgumentException("This class does not handle underdetermined equations");
        }
        return xvec;
    }

    public void supressErrorMessage() {
        this.supressErrorMessage = true;
    }

    public void hessenbergMatrix() {
        int j;
        int i;
        this.hessenberg = this.getArrayCopy();
        double pivot = 0.0;
        int pivotIndex = 0;
        double hold = 0.0;
        for (i = 1; i < this.numberOfRows - 1; ++i) {
            pivot = 0.0;
            pivotIndex = i;
            for (j = i; j < this.numberOfRows; ++j) {
                if (!(Math.abs(this.hessenberg[j][i - 1]) > Math.abs(pivot))) continue;
                pivot = this.hessenberg[j][i - 1];
                pivotIndex = j;
            }
            if (pivotIndex == i) continue;
            for (j = i - 1; j < this.numberOfRows; ++j) {
                hold = this.hessenberg[pivotIndex][j];
                this.hessenberg[pivotIndex][j] = this.hessenberg[i][j];
                this.hessenberg[i][j] = hold;
            }
            for (j = 0; j < this.numberOfRows; ++j) {
                hold = this.hessenberg[j][pivotIndex];
                this.hessenberg[j][pivotIndex] = this.hessenberg[j][i];
                this.hessenberg[j][i] = hold;
            }
            if (pivot == 0.0) continue;
            for (j = i + 1; j < this.numberOfRows; ++j) {
                int k;
                hold = this.hessenberg[j][i - 1];
                if (hold == 0.0) continue;
                this.hessenberg[j][i - 1] = hold /= pivot;
                for (k = i; k < this.numberOfRows; ++k) {
                    double[] dArray = this.hessenberg[j];
                    int n = k;
                    dArray[n] = dArray[n] - hold * this.hessenberg[i][k];
                }
                for (k = 0; k < this.numberOfRows; ++k) {
                    double[] dArray = this.hessenberg[k];
                    int n = i;
                    dArray[n] = dArray[n] + hold * this.hessenberg[k][j];
                }
            }
        }
        for (i = 2; i < this.numberOfRows; ++i) {
            for (j = 0; j < i - 1; ++j) {
                this.hessenberg[i][j] = 0.0;
            }
        }
        this.hessenbergDone = true;
    }

    public double[][] getHessenbergMatrix() {
        if (!this.hessenbergDone) {
            this.hessenbergMatrix();
        }
        return this.hessenberg;
    }

    public double[] getEigenValues() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.eigenValues;
    }

    public double[] getSortedEigenValues() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.sortedEigenValues;
    }

    public double[][] getEigenVectorsAsColumns() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.eigenVector;
    }

    public double[][] getEigenVector() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.eigenVector;
    }

    public double[][] getEigenVectorsAsRows() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        double[][] ret = new double[this.numberOfRows][this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfRows; ++j) {
                ret[i][j] = this.eigenVector[j][i];
            }
        }
        return ret;
    }

    public double[][] getSortedEigenVectorsAsColumns() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.sortedEigenVector;
    }

    public double[][] getSortedEigenVector() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.sortedEigenVector;
    }

    public double[][] getSortedEigenVectorsAsRows() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        double[][] ret = new double[this.numberOfRows][this.numberOfRows];
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfRows; ++j) {
                ret[i][j] = this.sortedEigenVector[j][i];
            }
        }
        return ret;
    }

    public int getNumberOfJacobiRotations() {
        return this.numberOfRotations;
    }

    private void symmetricEigen() {
        int p;
        if (!this.isSymmetric()) {
            throw new IllegalArgumentException("matrix is not symmetric");
        }
        double[][] amat = this.getArrayCopy();
        this.eigenVector = new double[this.numberOfRows][this.numberOfRows];
        this.eigenValues = new double[this.numberOfRows];
        double threshold = 0.0;
        double cot2rotationAngle = 0.0;
        double tanHalfRotationAngle = 0.0;
        double offDiagonalSum = 0.0;
        double scaledOffDiagonal = 0.0;
        double sElement = 0.0;
        double cElement = 0.0;
        double sOverC = 0.0;
        double vectorDifference = 0.0;
        double[] holdingVector1 = new double[this.numberOfRows];
        double[] holdingVector2 = new double[this.numberOfRows];
        for (p = 0; p < this.numberOfRows; ++p) {
            for (int q = 0; q < this.numberOfRows; ++q) {
                this.eigenVector[p][q] = 0.0;
            }
            this.eigenVector[p][p] = 1.0;
        }
        for (p = 0; p < this.numberOfRows; ++p) {
            holdingVector1[p] = amat[p][p];
            this.eigenValues[p] = amat[p][p];
            holdingVector2[p] = 0.0;
        }
        this.numberOfRotations = 0;
        for (int i = 1; i <= this.maximumJacobiIterations; ++i) {
            int q;
            int p2;
            offDiagonalSum = 0.0;
            for (p2 = 0; p2 < this.numberOfRows - 1; ++p2) {
                for (q = p2 + 1; q < this.numberOfRows; ++q) {
                    offDiagonalSum += Math.abs(amat[p2][q]);
                }
            }
            if (offDiagonalSum == 0.0) {
                this.eigenDone = true;
                this.eigenSort();
                return;
            }
            threshold = i < 4 ? 0.2 * offDiagonalSum / (double)(this.numberOfRows * this.numberOfRows) : 0.0;
            for (p2 = 0; p2 < this.numberOfRows - 1; ++p2) {
                for (q = p2 + 1; q < this.numberOfRows; ++q) {
                    int j;
                    scaledOffDiagonal = 100.0 * Math.abs(amat[p2][q]);
                    if (i > 4 && Math.abs(this.eigenValues[p2]) + scaledOffDiagonal == Math.abs(this.eigenValues[p2]) && Math.abs(this.eigenValues[q]) + scaledOffDiagonal == Math.abs(this.eigenValues[q])) {
                        amat[p2][q] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(amat[p2][q]) > threshold)) continue;
                    vectorDifference = this.eigenValues[q] - this.eigenValues[p2];
                    if (Math.abs(vectorDifference) + scaledOffDiagonal == Math.abs(vectorDifference)) {
                        sOverC = amat[p2][q] / vectorDifference;
                    } else {
                        cot2rotationAngle = 0.5 * vectorDifference / amat[p2][q];
                        sOverC = 1.0 / (Math.abs(cot2rotationAngle) + Math.sqrt(1.0 + cot2rotationAngle * cot2rotationAngle));
                        if (cot2rotationAngle < 0.0) {
                            sOverC = -sOverC;
                        }
                    }
                    cElement = 1.0 / Math.sqrt(1.0 + sOverC * sOverC);
                    sElement = sOverC * cElement;
                    tanHalfRotationAngle = sElement / (1.0 + cElement);
                    vectorDifference = sOverC * amat[p2][q];
                    int n = p2;
                    holdingVector2[n] = holdingVector2[n] - vectorDifference;
                    int n2 = q;
                    holdingVector2[n2] = holdingVector2[n2] + vectorDifference;
                    int n3 = p2;
                    this.eigenValues[n3] = this.eigenValues[n3] - vectorDifference;
                    int n4 = q;
                    this.eigenValues[n4] = this.eigenValues[n4] + vectorDifference;
                    amat[p2][q] = 0.0;
                    for (j = 0; j <= p2 - 1; ++j) {
                        this.rotation(amat, tanHalfRotationAngle, sElement, j, p2, j, q);
                    }
                    for (j = p2 + 1; j <= q - 1; ++j) {
                        this.rotation(amat, tanHalfRotationAngle, sElement, p2, j, j, q);
                    }
                    for (j = q + 1; j < this.numberOfRows; ++j) {
                        this.rotation(amat, tanHalfRotationAngle, sElement, p2, j, q, j);
                    }
                    for (j = 0; j < this.numberOfRows; ++j) {
                        this.rotation(this.eigenVector, tanHalfRotationAngle, sElement, j, p2, j, q);
                    }
                    ++this.numberOfRotations;
                }
            }
            for (p2 = 0; p2 < this.numberOfRows; ++p2) {
                int n = p2;
                holdingVector1[n] = holdingVector1[n] + holdingVector2[p2];
                this.eigenValues[p2] = holdingVector1[p2];
                holdingVector2[p2] = 0.0;
            }
        }
        System.out.println("Maximum iterations, " + this.maximumJacobiIterations + ", reached - values at this point returned");
        this.eigenDone = true;
        this.eigenSort();
    }

    private void rotation(double[][] a, double tau, double sElement, int i, int j, int k, int l) {
        double aHold1 = a[i][j];
        double aHold2 = a[k][l];
        a[i][j] = aHold1 - sElement * (aHold2 + aHold1 * tau);
        a[k][l] = aHold2 + sElement * (aHold1 - aHold2 * tau);
    }

    private void eigenSort() {
        int i;
        int k = 0;
        this.sortedEigenValues = Conv.copy(this.eigenValues);
        this.sortedEigenVector = Conv.copy(this.eigenVector);
        this.eigenIndices = new int[this.numberOfRows];
        for (i = 0; i < this.numberOfRows - 1; ++i) {
            int j;
            double holdingElement = this.sortedEigenValues[i];
            k = i;
            for (j = i + 1; j < this.numberOfRows; ++j) {
                if (!(this.sortedEigenValues[j] >= holdingElement)) continue;
                holdingElement = this.sortedEigenValues[j];
                k = j;
            }
            if (k == i) continue;
            this.sortedEigenValues[k] = this.sortedEigenValues[i];
            this.sortedEigenValues[i] = holdingElement;
            for (j = 0; j < this.numberOfRows; ++j) {
                holdingElement = this.sortedEigenVector[j][i];
                this.sortedEigenVector[j][i] = this.sortedEigenVector[j][k];
                this.sortedEigenVector[j][k] = holdingElement;
            }
        }
        this.eigenIndices = new int[this.numberOfRows];
        for (i = 0; i < this.numberOfRows; ++i) {
            boolean test = true;
            int j = 0;
            while (test) {
                if (this.sortedEigenValues[i] == this.eigenValues[j]) {
                    this.eigenIndices[i] = j;
                    test = false;
                    continue;
                }
                ++j;
            }
        }
    }

    public int[] eigenValueIndices() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.eigenIndices;
    }

    private static double hypot(double aa, double bb) {
        double cc = 0.0;
        double ratio = 0.0;
        double amod = Math.abs(aa);
        double bmod = Math.abs(bb);
        if (amod == 0.0) {
            cc = bmod;
        } else if (bmod == 0.0) {
            cc = amod;
        } else if (amod <= bmod) {
            ratio = amod / bmod;
            cc = bmod * Math.sqrt(1.0 + ratio * ratio);
        } else {
            ratio = bmod / amod;
            cc = amod * Math.sqrt(1.0 + ratio * ratio);
        }
        return cc;
    }
}

