/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.plot.PlotGraph;

public class Transducer
extends BlackBox {
    private double tGain = 1.0;
    private double tConst = 0.0;
    private double aConst = 1.0;
    private double bConst = 1.0;
    private double cConst = 0.0;

    public Transducer() {
        super("Transducer");
        this.sPoles = Complex.oneDarray(1);
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public Transducer(double tGain, double tConst) {
        super("Transducer");
        this.tGain = tGain;
        this.tConst = tConst;
        this.aConst = tConst;
        this.bConst = 1.0;
        this.cConst = tGain;
        this.sPoles = Complex.oneDarray(1);
        super.setSnumer(new ComplexPoly(this.cConst));
        super.setSdenom(new ComplexPoly(this.bConst, this.aConst));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public Transducer(double tGain) {
        super("Transducer");
        this.tGain = tGain;
        this.tConst = 0.0;
        this.aConst = 0.0;
        this.bConst = 1.0;
        this.cConst = tGain;
        this.sPoles = Complex.oneDarray(1);
        super.setSnumer(new ComplexPoly(this.cConst));
        super.setSdenom(new ComplexPoly(this.bConst, this.aConst));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public void setCoeff(double tGain, double tConst) {
        this.tGain = tGain;
        this.tConst = tConst;
        this.aConst = tConst;
        this.bConst = 1.0;
        this.cConst = tGain;
        Complex[] num = Complex.oneDarray(1);
        num[0].reset(this.cConst, 0.0);
        this.sNumer.resetPoly(num);
        Complex[] den = Complex.oneDarray(2);
        den[0].reset(this.bConst, 0.0);
        den[1].reset(this.aConst, 0.0);
        this.sDenom.resetPoly(den);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setTimeConstant(double tConst) {
        this.tConst = tConst;
        this.aConst = tConst;
        Complex co = new Complex(this.aConst, 0.0);
        this.sDenom.resetCoeff(1, co);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setGain(double tGain) {
        this.tGain = tGain;
        this.cConst = tGain;
        Complex co = new Complex(this.cConst, 0.0);
        this.sNumer.resetCoeff(0, co);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public double getGain() {
        return this.tGain;
    }

    public double getTimeConstant() {
        return this.tConst;
    }

    @Override
    protected void calcPolesZerosS() {
        this.sPoles = Complex.oneDarray(1);
        this.sPoles[0].setReal(-this.bConst / this.aConst);
        this.sNumerScaleFactor = this.sNumer.coeffCopy(0);
        this.sNumerScaleFactor = BlackBox.scaleFactor(this.sNumer, this.sPoles);
    }

    @Override
    public void stepInput(double stepMag, double finalTime) {
        if (this.tConst == 0.0) {
            int i;
            int n = 51;
            double incrT = finalTime / (double)(n - 2);
            double[][] cdata = new double[2][n];
            cdata[0][0] = 0.0;
            cdata[0][1] = 0.0;
            for (int i2 = 2; i2 < n; ++i2) {
                cdata[0][i2] = cdata[0][i2 - 1] + incrT;
            }
            double kpterm = this.tGain * stepMag;
            cdata[1][0] = 0.0;
            for (i = 1; i < n; ++i) {
                cdata[1][i] = kpterm;
            }
            if (this.deadTime != 0.0) {
                i = 0;
                while (i < n) {
                    double[] dArray = cdata[0];
                    int n2 = i++;
                    dArray[n2] = dArray[n2] + this.deadTime;
                }
            }
            PlotGraph pg = new PlotGraph(cdata);
            pg.setGraphTitle("Step Input Transient:   Step magnitude = " + stepMag);
            pg.setGraphTitle2(this.getName());
            pg.setXaxisLegend("Time");
            pg.setXaxisUnitsName("s");
            pg.setYaxisLegend("Output");
            pg.setPoint(0);
            pg.setLine(3);
            pg.plot();
        } else {
            super.stepInput(stepMag, finalTime);
        }
    }

    @Override
    public void zTransform() {
        if (this.deltaT == 0.0) {
            System.out.println("z-transform attempted in Transducer with a zero sampling period");
        }
        super.deadTimeWarning("zTransform");
        if (this.ztransMethod == 0) {
            this.mapstozAdHoc();
        } else {
            Complex[] ncoef = null;
            Complex[] dcoef = null;
            switch (this.integMethod) {
                case 0: {
                    ncoef = Complex.oneDarray(2);
                    ncoef[0].reset(this.deltaT * this.cConst, 0.0);
                    ncoef[1].reset(this.deltaT * this.cConst, 0.0);
                    this.zNumer = new ComplexPoly(1);
                    this.zNumer.resetPoly(ncoef);
                    this.zNumerDeg = 1;
                    dcoef = Complex.oneDarray(2);
                    dcoef[0].reset(this.bConst * this.deltaT - 2.0 * this.aConst, 0.0);
                    dcoef[1].reset(this.bConst * this.deltaT + 2.0 * this.aConst, 0.0);
                    this.zDenom = new ComplexPoly(1);
                    this.zDenom.resetPoly(dcoef);
                    this.zDenomDeg = 1;
                    this.zZeros = Complex.oneDarray(1);
                    this.zZeros[0].reset(-1.0, 0.0);
                    this.zPoles = Complex.oneDarray(1);
                    this.zPoles[0].reset((2.0 * this.aConst - this.deltaT * this.bConst) / (2.0 * this.aConst + this.deltaT * this.bConst), 0.0);
                    break;
                }
                case 1: {
                    ncoef = Complex.oneDarray(2);
                    ncoef[0].reset(0.0, 0.0);
                    ncoef[1].reset(this.cConst * this.deltaT, 0.0);
                    this.zNumer = new ComplexPoly(1);
                    this.zNumer.resetPoly(ncoef);
                    this.zNumerDeg = 1;
                    dcoef = Complex.oneDarray(2);
                    dcoef[0].reset(this.bConst * this.deltaT + this.aConst, 0.0);
                    dcoef[1].reset(this.aConst, 0.0);
                    this.zDenom = new ComplexPoly(1);
                    this.zDenom.resetPoly(dcoef);
                    this.zDenomDeg = 1;
                    this.zZeros = Complex.oneDarray(1);
                    this.zZeros[0].reset(0.0, 0.0);
                    this.zPoles = Complex.oneDarray(1);
                    this.zPoles[0].reset(this.aConst / (this.deltaT * this.bConst + this.aConst), 0.0);
                    break;
                }
                case 2: {
                    ncoef = Complex.oneDarray(1);
                    ncoef[0].reset(this.cConst * this.deltaT, 0.0);
                    this.zNumer = new ComplexPoly(0);
                    this.zNumer.resetPoly(ncoef);
                    this.zNumerDeg = 0;
                    dcoef = Complex.oneDarray(2);
                    dcoef[0].reset(-this.aConst, 0.0);
                    dcoef[1].reset(this.bConst * this.deltaT - this.aConst, 0.0);
                    this.zDenom = new ComplexPoly(1);
                    this.zDenom.resetPoly(dcoef);
                    this.zDenomDeg = 1;
                    this.zPoles = Complex.oneDarray(1);
                    this.zPoles[0].reset(this.aConst / (this.deltaT * this.bConst - this.aConst), 0.0);
                    break;
                }
                default: {
                    System.out.println("Integration method option in Transducer must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("z-transform not performed");
                }
            }
        }
    }

    @Override
    public void zTransform(double deltaT) {
        super.setDeltaT(deltaT);
        this.zTransform();
    }

    @Override
    public Complex getOutputS(Complex sValue, Complex iinput) {
        this.sValue = sValue;
        this.inputS = iinput;
        return this.getOutputS();
    }

    @Override
    public Complex getOutputS() {
        Complex num = Complex.plusOne();
        num = num.times(this.cConst);
        Complex den = new Complex();
        den = this.sValue.times(this.aConst);
        den = den.plus(this.bConst);
        Complex term = new Complex();
        term = num.over(den);
        this.outputS = term.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public void calcOutputT(double ttime, double inp) {
        super.setInputT(ttime, inp);
        this.calcOutputT();
    }

    public void calcOutputT() {
        super.deadTimeWarning("calcOutputT()");
        this.outputT[this.sampLen - 1] = (this.bConst * this.inputT[this.sampLen - 1] + this.aConst * (this.inputT[this.sampLen - 1] - this.inputT[this.sampLen - 2]) / this.deltaT) / this.cConst;
    }

    public Complex[] getSzeros() {
        System.out.println("This standard first order process (class Transducer) has no s-domain zeros");
        return null;
    }

    @Override
    public Transducer copy() {
        if (this == null) {
            return null;
        }
        Transducer bb = new Transducer();
        this.copyBBvariables(bb);
        bb.aConst = this.aConst;
        bb.bConst = this.bConst;
        bb.cConst = this.cConst;
        return bb;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

