/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.factory;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGff;

public class SnpEffPredictorFactoryGff2
extends SnpEffPredictorFactoryGff {
    public SnpEffPredictorFactoryGff2(Config config, int inOffset) {
        super(config, inOffset);
        this.version = "GFF2";
    }

    void addInterval(String id, String type, String chromo, int start, int end, int strand, String geneId, String trId) {
        Chromosome chromosome = this.getOrCreateChromosome(chromo);
        if (this.is(type, TRANSCRIPT)) {
            Transcript tint;
            Gene gene = this.findGene(geneId);
            if (gene == null) {
                gene = new Gene(chromosome, start, end, strand, geneId, geneId, "mRNA");
                this.add(gene);
            }
            if ((tint = this.findTranscript(trId)) == null) {
                tint = new Transcript(gene, start, end, strand, trId);
                this.add(tint);
            }
        } else if (this.is(type, EXON)) {
            Transcript tint = this.findTranscript(trId);
            if (tint == null) {
                System.err.println("Cannot find transcript '" + trId + "'");
                return;
            }
            int rank = 0;
            Exon exon = new Exon(tint, start, end, strand, id, rank);
            this.add(exon);
        }
    }

    @Override
    protected boolean parse(String line, String typeToRead) {
        String attrStr;
        String[] fields = line.split("\t");
        if (fields.length <= 6) {
            return false;
        }
        String type = fields[2];
        if (!this.is(type, typeToRead)) {
            return false;
        }
        String chromo = fields[0];
        int start = this.parsePosition(fields[3]);
        int end = this.parsePosition(fields[4]);
        int strand = fields[6].equals("-") ? -1 : 1;
        String geneId = "";
        String trId = "";
        if (fields.length >= 8 && (attrStr = fields[8]).length() > 0) {
            String[] attrs = attrStr.split(";");
            for (int i = 0; i < attrs.length; ++i) {
                attrs[i] = attrs[i].trim();
                String[] kv = attrs[i].split("\\s+");
                String key = kv[0];
                String value = this.unquote(kv[1]);
                if (key.equalsIgnoreCase("gene_id")) {
                    geneId = value;
                    continue;
                }
                if (!key.equalsIgnoreCase("transcript_id")) continue;
                trId = value;
            }
        }
        String id = typeToRead + "_" + chromo + "_" + (start + 1) + "_" + (end + 1);
        id = id.trim();
        geneId = geneId.trim();
        this.addInterval(id, type, chromo, start, end, strand, geneId, trId);
        return true;
    }
}

