/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.logStatsServer.LogStats;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class SnpEffCmdDownload
extends SnpEff {
    public static boolean debug = false;
    private static int BUFFER_SIZE = 102400;
    String version = "3.1";
    boolean update;

    void backupFile(ZipOutputStream zos, String fileName) {
        try {
            int len;
            FileInputStream fis = new FileInputStream(fileName);
            zos.putNextEntry(new ZipEntry(fileName));
            byte[] buf = new byte[BUFFER_SIZE];
            while ((len = fis.read(buf)) > 0) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            fis.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String baseName(String url) {
        String[] f = url.toString().split("/");
        return f[f.length - 1];
    }

    private URL buildUrl() {
        try {
            this.version = this.version.replace('.', '_');
            String urlRoot = this.config.getDatabaseRepository();
            StringBuilder urlsb = new StringBuilder();
            urlsb.append(urlRoot);
            if (urlsb.charAt(urlRoot.length() - 1) != '/') {
                urlsb.append("/");
            }
            urlsb.append("v" + this.version + "/snpEff_v" + this.version + "_" + this.genomeVer + ".zip");
            return new URL(urlsb.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    boolean download(URL url, String localFile) {
        boolean res = false;
        try {
            if (this.verbose) {
                Timer.show("Connecting to " + url);
            }
            URLConnection connection = url.openConnection();
            boolean followRedirect = true;
            while (followRedirect) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                int code = httpConnection.getResponseCode();
                if (code == 200) {
                    followRedirect = false;
                    continue;
                }
                if (code == 302) {
                    String newUrl = connection.getHeaderField("Location");
                    if (this.verbose) {
                        Timer.show("Following redirect: " + newUrl);
                    }
                    url = new URL(newUrl);
                    connection = url.openConnection();
                    continue;
                }
                if (code == 404) {
                    throw new RuntimeException("File not found on the server. Make sure the database name is correct.");
                }
                throw new RuntimeException("Error code from server: " + code);
            }
            InputStream is = url.openStream();
            Date date = new Date(connection.getLastModified());
            if (this.verbose) {
                Timer.show("Copying file (type: " + connection.getContentType() + ", modified on: " + date + ")");
            }
            if (this.verbose) {
                Timer.show("Local file name: '" + localFile + "'");
            }
            FileOutputStream os = null;
            os = new FileOutputStream(localFile);
            int count = 0;
            int total = 0;
            int lastShown = 0;
            byte[] data = new byte[BUFFER_SIZE];
            while ((count = is.read(data, 0, BUFFER_SIZE)) != -1) {
                os.write(data, 0, count);
                if ((total += count) - lastShown <= 0x100000) continue;
                if (this.verbose) {
                    Timer.show("Downloaded " + total + " bytes");
                }
                lastShown = total;
            }
            is.close();
            os.close();
            if (this.verbose) {
                Timer.show("Donwload finished. Total " + total + " bytes.");
            }
            res = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-c") || args[i].equalsIgnoreCase("-config")) {
                    if (i + 1 < args.length) {
                        this.configFile = args[++i];
                        continue;
                    }
                    this.usage("Option '-c' without config file argument");
                    continue;
                }
                if (args[i].equals("-v") || args[i].equalsIgnoreCase("-verbose")) {
                    this.verbose = true;
                    this.quiet = false;
                    continue;
                }
                if (args[i].equals("-h") || args[i].equalsIgnoreCase("-help")) {
                    this.usage(null);
                    System.exit(0);
                    continue;
                }
                this.usage("Unknow option '" + args[i] + "'");
                continue;
            }
            if (this.genomeVer.length() <= 0) {
                this.genomeVer = args[i];
                continue;
            }
            this.usage("Unknow parameter '" + args[i] + "'");
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String parseEntryPath(String entryName) {
        if (this.update) {
            int idx = entryName.indexOf(47);
            if (idx <= 0) throw new RuntimeException("Expecting at least one directory in path '" + entryName + "'");
            return this.config.getDirMain() + entryName.substring(idx);
        }
        String[] entryPath = entryName.split("/");
        String dataName = entryPath[entryPath.length - 2] + "/" + entryPath[entryPath.length - 1];
        entryName = this.config.getDirData() + "/" + dataName;
        if (!this.verbose) return entryName;
        Timer.show("Local file name: '" + entryName + "'");
        return entryName;
    }

    @Override
    public boolean run() {
        if (this.genomeVer.equals("snpeff")) {
            this.update = true;
            return this.runDownloadSnpEff();
        }
        return this.runDownloadGenome();
    }

    boolean runDownloadGenome() {
        String localFile;
        URL url;
        this.config = new Config(this.genomeVer, this.configFile);
        if (this.verbose) {
            Timer.show("Downloading database for '" + this.genomeVer + "'");
        }
        if (this.download(url = this.buildUrl(), localFile = this.baseName(url.toString())) && this.unzip(localFile) && this.verbose) {
            Timer.show("Unzip: OK");
        }
        if (this.verbose) {
            Timer.show("Done");
        }
        return true;
    }

    boolean runDownloadSnpEff() {
        URL url;
        this.config = new Config("", this.configFile);
        HashMap<String, String> reportValues = new HashMap<String, String>();
        LogStats logStats = LogStats.report("SnpEff", "3.1h", "SnpEff 3.1h (build 2012-12-04), by Pablo Cingolani", true, true, this.args, "", reportValues);
        if (!logStats.isNewVersion()) {
            Timer.showStdErr("No new version found. This seems to be the latest version (" + logStats.getLatestVersion() + ") or server could not be contacted. Nothing done.");
            return false;
        }
        Timer.showStdErr("New version: \n\tNew version  : " + logStats.getLatestVersion() + "\n\tRelease date : " + logStats.getLatestReleaseDate() + "\n\tDownload URL : " + logStats.getLatestUrl());
        if (this.verbose) {
            Timer.show("Downloading SnpEff");
        }
        try {
            url = new URL(logStats.getLatestUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String localFile = this.baseName(url.toString());
        if (this.download(url, localFile) && this.unzip(localFile) && this.verbose) {
            Timer.show("Unzip: OK");
        }
        if (this.verbose) {
            Timer.show("Done");
        }
        return true;
    }

    boolean unzip(String zipFile) {
        try {
            ZipEntry entry;
            FileInputStream fis = new FileInputStream(zipFile);
            ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(fis));
            ZipOutputStream zipBackup = null;
            String backupFile = "";
            if (this.update) {
                backupFile = String.format("%s/backup_%2$tY-%2$tm-%2$td_%2$tH:%2$tM:%2$tS.zip", this.config.getDirMain(), new GregorianCalendar());
                if (this.verbose) {
                    Timer.showStdErr("Creating backup file '" + backupFile + "'");
                }
                zipBackup = new ZipOutputStream(new FileOutputStream(backupFile));
            }
            while ((entry = zipIn.getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    String localEntryName = this.parseEntryPath(entry.getName());
                    if (this.verbose) {
                        Timer.showStdErr("Extracting file '" + entry.getName() + "' to '" + localEntryName + "'");
                    }
                    if (zipBackup != null) {
                        this.backupFile(zipBackup, localEntryName);
                    }
                    FileOutputStream fos = new FileOutputStream(localEntryName);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER_SIZE);
                    int count = 0;
                    byte[] data = new byte[BUFFER_SIZE];
                    while ((count = zipIn.read(data, 0, BUFFER_SIZE)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                    continue;
                }
                if (!entry.isDirectory()) continue;
                String dir = this.parseEntryPath(entry.getName());
                if (this.verbose) {
                    Timer.show("Extracting directory: '" + entry.getName() + "' to local directory '" + dir + "'");
                }
                new File(dir).mkdirs();
            }
            zipIn.close();
            if (zipBackup != null) {
                zipBackup.close();
                Timer.showStdErr("Backup file created: '" + backupFile + "'");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 3.1h (build 2012-12-04), by Pablo Cingolani");
        System.err.println("Usage: snpEff download [options] {snpeff | genome_version}");
        System.err.println("\nGeneric options:");
        System.err.println("\t-c , -config            : Specify config file");
        System.err.println("\t-h , -help              : Show this help and exit");
        System.err.println("\t-v , -verbose           : Verbose mode");
        System.err.println("\t-noLog                  : Do not report usage statistics to server");
        System.err.println("If 'snpeff' is used instead of a genome, SnpEff latest version will be downloaded");
        System.exit(-1);
    }
}

