/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.Config2DownloadTable;
import ca.mcgill.mcb.pcingola.logStatsServer.LogStats;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.CommandLine;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdBuild;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdCds;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdClosestExon;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdCountReads;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdDownload;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdDump;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdProtein;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdTest;
import ca.mcgill.mcb.pcingola.spliceSites.SpliceAnalysis;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;
import java.util.HashMap;

public class SnpEff
implements CommandLine {
    public static final int COMMAND_LINE_WIDTH = 40;
    public static final String SOFTWARE_NAME = "SnpEff";
    public static final String BUILD = "2012-12-04";
    public static final String VERSION_MAJOR = "3.1";
    public static final String REVISION = "h";
    public static final String VERSION_SHORT = "3.1h";
    public static final String VERSION = "SnpEff 3.1h (build 2012-12-04), by Pablo Cingolani";
    public static final String DEFAULT_SUMMARY_FILE = "snpEff_summary.html";
    public static final String DEFAULT_SUMMARY_GENES_FILE = "snpEff_genes.txt";
    protected String command = "";
    protected String[] args;
    protected String[] shiftArgs;
    protected boolean verbose = false;
    protected boolean quiet = false;
    protected boolean log = true;
    protected boolean multiThreaded = false;
    protected int numWorkers = Gpr.NUM_CORES;
    protected int inOffset = 1;
    protected int outOffset = 1;
    protected String configFile = "snpEff.config";
    protected String genomeVer = "";
    protected Config config;

    public static void main(String[] args) {
        SnpEff snpEff = new SnpEff();
        snpEff.parseArgs(args);
        boolean ok = snpEff.run();
        int retCode = ok ? 0 : -1;
        System.exit(retCode);
    }

    String commandLineStr(boolean splitLines) {
        StringBuilder argsList = new StringBuilder();
        argsList.append("SnpEff " + this.command + " ");
        int size = argsList.length();
        for (String arg : this.args) {
            argsList.append(arg);
            if (splitLines && (size += arg.length()) > 40) {
                argsList.append(" \n");
                size = 0;
                continue;
            }
            argsList.append(" ");
            ++size;
        }
        return argsList.toString();
    }

    public void error(Throwable e, String message) {
        if (this.verbose && e != null) {
            e.printStackTrace();
        }
        if (!this.quiet) {
            System.err.println(message);
        }
    }

    public void fatalError(String message) {
        System.err.println(message);
        System.exit(-1);
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        if (args.length <= 0) {
            this.usage("Missing command");
        }
        if (args[0].equalsIgnoreCase("build") || args[0].equalsIgnoreCase("dump") || args[0].equalsIgnoreCase("cds") || args[0].equalsIgnoreCase("eff") || args[0].equalsIgnoreCase("download") || args[0].equalsIgnoreCase("protein") || args[0].equalsIgnoreCase("closestExon") || args[0].equalsIgnoreCase("test") || args[0].equalsIgnoreCase("cfg2table") || args[0].equalsIgnoreCase("spliceAnalysis") || args[0].equalsIgnoreCase("countReads")) {
            this.command = args[0].toLowerCase();
            ArrayList<String> argsList = new ArrayList<String>();
            for (int i = 1; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-noLog")) {
                    this.log = false;
                } else {
                    argsList.add(args[i]);
                }
                if (args[i].equals("-v")) {
                    this.verbose = true;
                }
                if (!args[i].equals("-q")) continue;
                this.quiet = true;
            }
            this.shiftArgs = argsList.toArray(new String[0]);
        } else {
            this.command = "eff";
            this.shiftArgs = args;
        }
    }

    public HashMap<String, String> reportValues() {
        HashMap<String, String> reportValues = new HashMap<String, String>();
        return reportValues;
    }

    @Override
    public boolean run() {
        boolean ok = false;
        SnpEff snpEff = null;
        if (this.command.equals("build")) {
            snpEff = new SnpEffCmdBuild();
            snpEff.parseArgs(this.shiftArgs);
        } else if (this.command.equals("dump")) {
            snpEff = new SnpEffCmdDump();
            snpEff.parseArgs(this.shiftArgs);
        } else if (this.command.equals("download")) {
            snpEff = new SnpEffCmdDownload();
            snpEff.parseArgs(this.shiftArgs);
        } else if (this.command.equals("cds")) {
            snpEff = new SnpEffCmdCds();
            snpEff.parseArgs(this.shiftArgs);
        } else if (this.command.equals("eff")) {
            snpEff = new SnpEffCmdEff();
            snpEff.parseArgs(this.shiftArgs);
        } else if (this.command.equals("protein")) {
            snpEff = new SnpEffCmdProtein();
            snpEff.parseArgs(this.shiftArgs);
        } else if (this.command.equals("closestexon")) {
            snpEff = new SnpEffCmdClosestExon();
            snpEff.parseArgs(this.shiftArgs);
        } else if (this.command.equals("cfg2table")) {
            snpEff = new Config2DownloadTable();
            snpEff.parseArgs(this.shiftArgs);
        } else if (this.command.equals("test")) {
            snpEff = new SnpEffCmdTest();
            snpEff.parseArgs(this.shiftArgs);
        } else if (this.command.equals("spliceanalysis")) {
            snpEff = new SpliceAnalysis();
            snpEff.parseArgs(this.shiftArgs);
        } else if (this.command.equals("countreads")) {
            snpEff = new SnpEffCmdCountReads();
            snpEff.parseArgs(this.shiftArgs);
        } else {
            throw new RuntimeException("Unknown command '" + this.command + "'");
        }
        String err = "";
        try {
            ok = snpEff.run();
        }
        catch (Throwable t) {
            err = t.getMessage();
            t.printStackTrace();
        }
        if (this.log) {
            LogStats logStats = LogStats.report(SOFTWARE_NAME, VERSION_SHORT, VERSION, ok, this.verbose, this.args, err, snpEff.reportValues());
            if (!this.quiet && logStats.isNewVersion()) {
                System.err.println("New version available: \n\tNew version  : " + logStats.getLatestVersion() + "\n\tRelease date : " + logStats.getLatestReleaseDate() + "\n\tDownload URL : " + logStats.getLatestUrl() + "\n\nTo update run:\n\tjava snpEff.jar download -v snpeff\n");
            }
        }
        return ok;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 3.1h (build 2012-12-04), by Pablo Cingolani");
        System.err.println("Usage: snpEff [command] [options] [files]");
        System.err.println("\nAvailable vommands: ");
        System.err.println("   [eff]           : Calculate effect of variants. Default (no command or 'eff').");
        System.err.println("   download        : Download a SnpEff database.");
        System.err.println("   build           : Build a SnpEff database.");
        System.err.println("   dump            : Dump to STDOUT a SnpEff database (mostly used for debugging).");
        System.err.println("   cds             : Compare CDS sequences calculated form a SnpEff database to the one in a FASTA file. Used for checking databases correctness.");
        System.err.println("   protein         : Compare protein sequences calculated form a SnpEff database to the one in a FASTA file. Used for checking databases correctness.");
        System.err.println("   closestExon     : Calculate closes exon/s given a set of genomic positions or intervals.");
        System.err.println("   spliceAnalysis  : Perform an analysis of splice sites. Experimental feature.");
        System.err.println("   countReads      : Count how many reads (from a BAM file) overlap with each genomic interval. Experimental feature.");
        System.err.println("\nRun 'java -jar snpEff.jar command' for help on each specifig command");
        System.exit(-1);
    }

    public static enum OutputFormat {
        TXT,
        VCF,
        BED,
        BEDANN,
        GATK;

    }

    public static enum InputFormat {
        TXT,
        PILEUP,
        VCF,
        BED;

    }

    public static enum GeneDatabaseFormat {
        BIOMART,
        GFF3,
        GFF2,
        GTF22,
        REFSEQ,
        KNOWN_GENES,
        GENBANK,
        EMBL;

    }
}

