/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.codons.CodonTables;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class Config
implements Serializable,
Iterable<String> {
    public static final String DEFAULT_CONFIG_FILE = "snpEff.config";
    public static final String DEFAULT_DATA_DIR = "./data";
    public static String GENOMES_DIR = "genomes";
    public static final String KEY_GENOME = ".genome";
    public static final String KEY_REFERENCE = ".reference";
    public static final String KEY_CODON = "codon.";
    public static final String KEY_CODONTABLE = ".codonTable";
    public static final String KEY_LOF_IGNORE_PROTEIN_CODING_AFTER = "lof.ignoreProteinCodingAfter";
    public static final String KEY_LOF_IGNORE_PROTEIN_CODING_BEFORE = "lof.ignoreProteinCodingBefore";
    public static final String KEY_LOF_DELETE_PROTEIN_CODING_BASES = "lof.deleteProteinCodingBases";
    public static boolean debug = false;
    private static Config configInstance = null;
    boolean treatAllAsProteinCoding = true;
    boolean onlyRegulation = false;
    boolean errorOnMissingChromo = true;
    boolean errorChromoHit = true;
    double lofIgnoreProteinCodingAfter;
    double lofIgnoreProteinCodingBefore;
    double lofDeleteProteinCodingBases;
    String dataDir;
    Properties properties;
    Genome genome;
    HashMap<String, Genome> genomeByVersion;
    HashMap<String, String> referenceByVersion;
    HashMap<String, String> nameByVersion;
    SnpEffectPredictor snpEffectPredictor;
    String databaseRepository = "";

    public static Config get() {
        return configInstance;
    }

    public Config(String genomeVersion) {
        this.read(genomeVersion, DEFAULT_CONFIG_FILE);
        this.genome = this.genomeByVersion.get(genomeVersion);
        if (this.genome == null) {
            throw new RuntimeException("No such genome '" + genomeVersion + "'");
        }
        configInstance = this;
    }

    public Config(String genomeVersion, String configFileName) {
        this.read(genomeVersion, configFileName);
        if (!genomeVersion.isEmpty()) {
            this.genome = this.genomeByVersion.get(genomeVersion);
            if (this.genome == null) {
                throw new RuntimeException("No such genome '" + genomeVersion + "'");
            }
            configInstance = this;
        }
    }

    void createCodonTables(String genomeVersion, Properties properties) {
        for (Object key : properties.keySet()) {
            if (!key.toString().startsWith(KEY_CODON)) continue;
            String name = key.toString().substring(KEY_CODON.length());
            String table = properties.getProperty(key.toString());
            CodonTable codonTable = new CodonTable(name, table);
            CodonTables.getInstance().add(codonTable);
        }
        for (Object key : properties.keySet()) {
            int chrNameStart;
            String keyStr = key.toString();
            if (!keyStr.endsWith(KEY_CODONTABLE) || !keyStr.startsWith(genomeVersion + ".")) continue;
            int chrNameEnd = keyStr.length() - KEY_CODONTABLE.length();
            int chrNameLen = chrNameEnd - (chrNameStart = genomeVersion.length() + 1);
            if (chrNameLen < 0) {
                throw new RuntimeException("Error parsing config entry '" + keyStr + "'.\n\tExpected format: GENOME.CHROMOSOME.codonTable\n\tChromosome name not found!");
            }
            String chromo = keyStr.substring(chrNameStart, chrNameEnd);
            String codonTableName = properties.getProperty(key.toString());
            CodonTable codonTable = CodonTables.getInstance().getTable(codonTableName);
            if (this.genomeByVersion.get(genomeVersion) == null) {
                throw new RuntimeException("Error parsing property '" + key + "'. No such genome '" + genomeVersion + "'");
            }
            if (codonTable == null) {
                throw new RuntimeException("Error parsing property '" + key + "'. No such codon table '" + codonTableName + "'");
            }
            Chromosome chr = this.genomeByVersion.get(genomeVersion).getChromosome(chromo);
            if (chr == null) {
                Genome genome = this.genomeByVersion.get(genomeVersion);
                chr = new Chromosome(genome, 0, 0, 1, chromo);
                genome.add(chr);
            }
            CodonTables.getInstance().add(this.genomeByVersion.get(genomeVersion), chr, codonTable);
        }
    }

    String findGenome(String codonKeyStr) {
        for (String genVer : this.genomeByVersion.keySet()) {
            if (!codonKeyStr.startsWith(genVer + ".")) continue;
            return genVer;
        }
        return null;
    }

    public String getBaseFileNameGenes() {
        return this.dataDir + "/" + this.genome.getVersion() + "/genes";
    }

    public String getBaseFileNameRegulation() {
        return this.getDirDataVersion() + "/regulation";
    }

    public String getDatabaseRepository() {
        return this.databaseRepository;
    }

    public String getDirData() {
        return this.dataDir;
    }

    public String getDirDataVersion() {
        return this.dataDir + "/" + this.genome.getVersion();
    }

    public String getDirMain() {
        File dir = new File(this.dataDir);
        return dir.getParent();
    }

    public String getDirRegulationBed() {
        return this.getDirDataVersion() + "/regulation.bed/";
    }

    protected double getDouble(String propertyName, double defaultValue) {
        String val = this.getString(propertyName);
        if (val == null) {
            return defaultValue;
        }
        return Gpr.parseDoubleSafe(val);
    }

    public List<String> getFileListGenomeFasta() {
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.getDirData() + "/genomes/" + this.genome.getVersion() + ".fa");
        files.add(this.getDirData() + "/" + this.genome.getVersion() + "/sequences.fa");
        return files;
    }

    public String getFileNameCds() {
        return this.getDirDataVersion() + "/cds.fa";
    }

    public String getFileNameGenomeFasta() {
        for (String f : this.getFileListGenomeFasta()) {
            if (new File(f).exists()) {
                return f;
            }
            if (!new File(f + ".gz").exists()) continue;
            return f;
        }
        return null;
    }

    public String getFileNameProteins() {
        return this.getDirDataVersion() + "/protein.fa";
    }

    public String getFileSnpEffectPredictor() {
        return this.getDirData() + "/" + this.genome.getVersion() + "/snpEffectPredictor.bin";
    }

    public Genome getGenome() {
        return this.genome;
    }

    public double getLofDeleteProteinCodingBases() {
        return this.lofDeleteProteinCodingBases;
    }

    public double getLofIgnoreProteinCodingAfter() {
        return this.lofIgnoreProteinCodingAfter;
    }

    public double getLofIgnoreProteinCodingBefore() {
        return this.lofIgnoreProteinCodingBefore;
    }

    protected long getLong(String propertyName, long defaultValue) {
        String val = this.getString(propertyName);
        if (val == null) {
            return defaultValue;
        }
        return Gpr.parseLongSafe(val);
    }

    public String getName(String genomeVersion) {
        return this.nameByVersion.get(genomeVersion);
    }

    public String getReference(String genomeVersion) {
        return this.referenceByVersion.get(genomeVersion);
    }

    public SnpEffectPredictor getSnpEffectPredictor() {
        return this.snpEffectPredictor;
    }

    protected String getString(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public boolean isErrorChromoHit() {
        return this.errorChromoHit;
    }

    public boolean isErrorOnMissingChromo() {
        return this.errorOnMissingChromo;
    }

    public boolean isOnlyRegulation() {
        return this.onlyRegulation;
    }

    public boolean isTreatAllAsProteinCoding() {
        return this.treatAllAsProteinCoding;
    }

    @Override
    public Iterator<String> iterator() {
        return this.nameByVersion.keySet().iterator();
    }

    public SnpEffectPredictor loadSnpEffectPredictor() {
        this.snpEffectPredictor = SnpEffectPredictor.load(this);
        this.genome = this.snpEffectPredictor.genome;
        return this.snpEffectPredictor;
    }

    private void read(String genomeVersion, String configFileName) {
        this.properties = new Properties();
        try {
            this.properties.load(new FileReader(new File(configFileName)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot find config file '" + configFileName + "'");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String cfgDir = "";
        try {
            File configDir = new File(configFileName).getAbsoluteFile().getParentFile();
            cfgDir = configDir.getCanonicalPath();
        }
        catch (IOException e1) {
            // empty catch block
        }
        this.dataDir = this.properties.getProperty("data_dir", DEFAULT_DATA_DIR);
        if (this.dataDir.startsWith("~")) {
            this.dataDir = Gpr.HOME + "/" + this.dataDir.substring(1);
        } else if (!this.dataDir.startsWith("/")) {
            this.dataDir = cfgDir + "/" + this.dataDir;
        }
        while (this.dataDir.endsWith("/")) {
            this.dataDir = this.dataDir.substring(0, this.dataDir.length() - 1);
        }
        this.databaseRepository = this.properties.getProperty("database_repository", "");
        this.genomeByVersion = new HashMap();
        this.referenceByVersion = new HashMap();
        this.nameByVersion = new HashMap();
        for (Object k : this.properties.keySet()) {
            String key = k.toString();
            if (!key.endsWith(KEY_GENOME)) continue;
            String genVer = key.substring(0, key.length() - KEY_GENOME.length());
            String name = this.properties.getProperty(genVer + KEY_GENOME);
            this.nameByVersion.put(genVer, name);
            String ref = this.properties.getProperty(genVer + KEY_REFERENCE);
            this.referenceByVersion.put(genVer, ref);
        }
        if (!genomeVersion.isEmpty()) {
            this.readGenomeConfig(genomeVersion, this.properties);
            this.createCodonTables(genomeVersion, this.properties);
            this.setFromProperties();
        }
    }

    void readGenomeConfig(String genVer, Properties properties) {
        block4: {
            String genomePropsFileName = this.dataDir + "/" + genVer + "/snpEff.config";
            try {
                Properties genomeProps = new Properties();
                genomeProps.load(new FileReader(new File(genomePropsFileName)));
                for (Object propKey : genomeProps.keySet()) {
                    String pk = propKey.toString();
                    String propVal = genomeProps.getProperty(pk);
                    if (properties.getProperty(pk) == null) {
                        properties.setProperty(pk, propVal);
                        continue;
                    }
                    System.err.println("Ignoring property '" + pk + "' in file '" + genomePropsFileName + "'");
                }
            }
            catch (Exception e) {
                if (!debug) break block4;
                System.err.println("File '" + genomePropsFileName + "' not found");
            }
        }
        Genome genome = new Genome(genVer, properties);
        this.genomeByVersion.put(genVer, genome);
    }

    public void setErrorChromoHit(boolean errorChromoHit) {
        this.errorChromoHit = errorChromoHit;
    }

    public void setErrorOnMissingChromo(boolean errorOnMissingChromo) {
        this.errorOnMissingChromo = errorOnMissingChromo;
    }

    void setFromProperties() {
        this.lofIgnoreProteinCodingAfter = this.getDouble(KEY_LOF_IGNORE_PROTEIN_CODING_AFTER, 0.95);
        this.lofIgnoreProteinCodingBefore = this.getDouble(KEY_LOF_IGNORE_PROTEIN_CODING_BEFORE, 0.05);
        this.lofDeleteProteinCodingBases = this.getDouble(KEY_LOF_DELETE_PROTEIN_CODING_BASES, 0.5);
    }

    public void setOnlyRegulation(boolean onlyRegulation) {
        this.onlyRegulation = onlyRegulation;
    }

    public void setSnpEffectPredictor(SnpEffectPredictor snpEffectPredictor) {
        this.snpEffectPredictor = snpEffectPredictor;
    }

    public void setTreatAllAsProteinCoding(boolean treatAllAsProteinCoding) {
        this.treatAllAsProteinCoding = treatAllAsProteinCoding;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String genVer : this) {
            String name = this.nameByVersion.get(genVer).replace('_', ' ');
            String ref = this.referenceByVersion.get(genVer);
            sb.append("\t" + genVer);
            sb.append("\t" + name);
            if (ref != null) {
                sb.append("\t" + ref);
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

