/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.nmer;

import ca.mcgill.mcb.pcingola.nmer.Nmer;
import ca.mcgill.mcb.pcingola.spliceSites.AcgtTree;
import ca.mcgill.mcb.pcingola.stats.Counter;
import ca.mcgill.mcb.pcingola.stats.CounterDouble;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.procedure.TLongIntProcedure;
import java.io.Serializable;
import java.util.Random;

public class NmerCount
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static boolean debug = false;
    int nmerSize;
    TLongIntHashMap hash;

    public NmerCount(int nmerSize) {
        this.nmerSize = nmerSize;
        this.hash = new TLongIntHashMap();
    }

    public double avg() {
        double total = this.total();
        double size = this.size();
        return size > 0.0 ? total / size : 0.0;
    }

    public void count(Nmer nmer) {
        long key = nmer.getNmer();
        int count = this.hash.get(key) + 1;
        this.hash.put(key, count);
    }

    public long countLessThan(final int threshold) {
        final Counter counter = new Counter();
        this.hash.forEachEntry(new TLongIntProcedure(){

            public boolean execute(long key, int value) {
                if (value > threshold) {
                    counter.inc();
                }
                return true;
            }
        });
        return counter.count;
    }

    protected int get(long key) {
        return this.hash.get(key);
    }

    public int get(Nmer nmer) {
        long key = nmer.getNmer();
        return this.hash.get(key);
    }

    public long max() {
        final Counter counter = new Counter();
        this.hash.forEachEntry(new TLongIntProcedure(){

            public boolean execute(long key, int value) {
                if ((long)value > counter.get()) {
                    counter.set(value);
                }
                return true;
            }
        });
        return counter.count;
    }

    public long max(final NmerCount nullDistribution) {
        final CounterDouble max = new CounterDouble();
        final Counter counter = new Counter();
        this.hash.forEachEntry(new TLongIntProcedure(){

            public boolean execute(long key, int value) {
                int countNull = nullDistribution.get(key);
                double d = (double)value / (double)countNull;
                if (d > max.get()) {
                    max.set(d);
                    counter.set(value);
                }
                return true;
            }
        });
        return counter.count;
    }

    public void random(int iterations) {
        Nmer nmer = new Nmer(this.nmerSize);
        NmerCount nmerCount = new NmerCount(this.nmerSize);
        Random rand = new Random();
        for (int i = 0; i < iterations; ++i) {
            char base = AcgtTree.BASES[rand.nextInt(AcgtTree.BASES.length)];
            nmer.rol(base);
            nmerCount.count(nmer);
        }
    }

    public int size() {
        return this.hash.size();
    }

    public String toString() {
        return "Size: " + this.hash.size() + "\tTotal: " + this.total() + "\tAvg: " + this.avg() + "\tMax: " + this.max();
    }

    public String toStringAll() {
        return this.toStringAll(0);
    }

    public String toStringAll(final int minCount) {
        final StringBuilder sb = new StringBuilder();
        final Nmer nmer = new Nmer(this.nmerSize);
        this.hash.forEachEntry(new TLongIntProcedure(){

            public boolean execute(long key, int value) {
                nmer.setNmer(key);
                if (value >= minCount) {
                    sb.append(nmer + "\t" + value + "\n");
                }
                return true;
            }
        });
        return sb.toString();
    }

    public long total() {
        final Counter sum = new Counter();
        this.hash.forEachEntry(new TLongIntProcedure(){

            public boolean execute(long key, int value) {
                sum.set(sum.get() + (long)value);
                return true;
            }
        });
        return sum.get();
    }
}

