/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.motif;

import ca.mcgill.mcb.pcingola.motif.Pwm;
import ca.mcgill.mcb.pcingola.nmer.Nmer;
import ca.mcgill.mcb.pcingola.stats.Counter;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.procedure.TLongIntProcedure;

public class PwmAndSeqs
extends Pwm {
    TLongIntHashMap countSeqs = new TLongIntHashMap();
    TLongIntHashMap countRsIds = new TLongIntHashMap();
    Nmer nmer;

    public PwmAndSeqs(int len) {
        super(len);
        this.nmer = new Nmer(len);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        final Nmer nmer = new Nmer(this.length);
        sb.append(super.toString());
        sb.append("Sequence\tCount\n");
        final Counter counter = new Counter();
        this.countSeqs.forEachEntry(new TLongIntProcedure(){

            public boolean execute(long key, int count) {
                nmer.setNmer(key);
                sb.append(nmer.toString() + "\t" + count + "\n");
                counter.add(count);
                return true;
            }
        });
        sb.append("\tTotal\t" + counter.get() + "\n");
        counter.reset();
        sb.append("\nRsId\tCount\n");
        this.countRsIds.forEachEntry(new TLongIntProcedure(){

            public boolean execute(long rsNum, int count) {
                sb.append("rs" + rsNum + "\t" + count + "\n");
                counter.add(count);
                return true;
            }
        });
        sb.append("\tTotal\t" + counter.get() + "\n");
        return sb.toString();
    }

    public void updateCounts(String dna, int inc, long rsId) {
        this.updateCounts(dna, inc);
        this.nmer.set(dna);
        long nmerLong = this.nmer.getNmer();
        int count = this.countSeqs.get(nmerLong);
        this.countSeqs.put(nmerLong, count + inc);
        count = this.countRsIds.get(rsId);
        this.countRsIds.put(rsId, count + inc);
    }
}

