/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.sage;

import edu.mayo.sage.Logger;
import edu.mayo.sage.LoggerUtils;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JsonLoggerBase
implements Logger {
    JsonLoggerBase() {
    }

    void logEvent(Map<String, Object> data) {
        byte[] buffer = LoggerUtils.mapToJsonByteArray(data);
        this.sendData(buffer, 0, buffer.length);
    }

    void logEvent(Object ... data) {
        this.logEvent(LoggerUtils.arrayToMap(data));
    }

    @Override
    public void logBegin(String appName) {
        this.logEvent(appName, "BEGIN");
    }

    @Override
    public void logBegin(String appName, Map<String, Object> data) {
        this.logEvent(appName, "BEGIN", data);
    }

    @Override
    public void logBegin(String appName, Object ... data) {
        this.logEvent(appName, "BEGIN", data);
    }

    @Override
    public void logEnd(String appName) {
        this.logEvent(appName, "END");
    }

    @Override
    public void logEnd(String appName, Map<String, Object> data) {
        this.logEvent(appName, "END", data);
    }

    @Override
    public void logEnd(String appName, Object ... data) {
        this.logEvent(appName, "END", data);
    }

    @Override
    public void logEvent(String appName, String event) {
        Map<String, Object> m = this.getDefaultAttributes(appName, event);
        this.logEvent(m);
    }

    @Override
    public void logEvent(String appName, String event, Map<String, Object> data) {
        Map<String, Object> m = this.getDefaultAttributes(appName, event);
        m.putAll(data);
        this.logEvent(m);
    }

    @Override
    public void logEvent(String appName, String event, Object ... data) {
        Map<String, Object> m = this.getDefaultAttributes(appName, event);
        m.putAll(LoggerUtils.arrayToMap(data));
        this.logEvent(m);
    }

    @Override
    public void logError(String appName, Throwable t, int exitStatus) {
        Map<String, Object> m = this.getDefaultAttributes(appName, "ERROR");
        m.put("error", t.getMessage());
        m.put("exit_status", exitStatus);
        this.logEvent(m);
    }

    private Map<String, Object> getDefaultAttributes(String appName, String event) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("app", appName);
        m.put("evt", event);
        m.put("user", LoggerUtils.getUsername());
        m.put("mem", LoggerUtils.getHeapSize());
        m.put("pid", LoggerUtils.getProcessID());
        return m;
    }

    public abstract void sendData(byte[] var1, int var2, int var3);
}

