/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.receiver;

import edu.mayo.receiver.Receiver;
import edu.mayo.senders.Sender;
import java.io.BufferedReader;
import java.io.FileReader;

public class FileReceiver
implements Receiver {
    Tail tail = null;
    boolean keepgoing = true;
    String location;
    long delayMilis = 100L;

    public FileReceiver(String location, Sender s) {
        this.setSender(s);
        this.location = location;
    }

    public FileReceiver(String location, Sender s, long delay) {
        this.setSender(s);
        this.location = location;
        this.delayMilis = delay;
    }

    public void setSender(Sender s) {
        this.tail = new Tail();
        this.tail.sender = s;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void start() {
        this.tail.setDaemon(true);
        this.tail.start();
    }

    public void stop() {
        this.keepgoing = false;
    }

    public class Tail
    extends Thread {
        public Sender sender = null;

        public void run() {
            try {
                BufferedReader br = new BufferedReader(new FileReader(FileReceiver.this.location));
                while (FileReceiver.this.keepgoing) {
                    String line = br.readLine();
                    if (line == null) {
                        Thread.sleep(FileReceiver.this.delayMilis);
                        continue;
                    }
                    this.sender.write(line);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

