/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.internal;

import org.hamcrest.Description;
import org.jmock.States;
import org.jmock.internal.State;
import org.jmock.internal.StatePredicate;

public class StateMachine
implements States {
    private final String name;
    private String currentState = null;

    public StateMachine(String name) {
        this.name = name;
    }

    public States startsAs(String initialState) {
        this.become(initialState);
        return this;
    }

    public void become(String nextState) {
        this.currentState = nextState;
    }

    public State is(final String state) {
        return new State(){

            public void activate() {
                StateMachine.this.currentState = state;
            }

            public boolean isActive() {
                return state.equals(StateMachine.this.currentState);
            }

            public void describeTo(Description description) {
                description.appendText(StateMachine.this.name).appendText(" is ").appendText(state);
            }
        };
    }

    public StatePredicate isNot(final String state) {
        return new StatePredicate(){

            public boolean isActive() {
                return !state.equals(StateMachine.this.currentState);
            }

            public void describeTo(Description description) {
                description.appendText(StateMachine.this.name).appendText(" is not ").appendText(state);
            }
        };
    }

    public void describeTo(Description description) {
        description.appendText(this.name).appendText(this.currentState == null ? " has no current state" : " is " + this.currentState);
    }
}

