/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.VCFProgramPipes;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.History;
import java.util.NoSuchElementException;

public class VCFProgramPreProcessPipe
extends AbstractPipe<History, String> {
    private int mNumColsToSave = 7;
    private int mLineNumber = 0;

    public VCFProgramPreProcessPipe() {
    }

    public VCFProgramPreProcessPipe(int colsToSave) {
        this.mNumColsToSave = colsToSave;
    }

    protected String processNextStart() throws NoSuchElementException {
        History history = (History)this.starts.next();
        this.validateColumns(history);
        return this.getFirstXColumnsPlusDot(history);
    }

    private void validateColumns(History history) {
        ++this.mLineNumber;
        if (history.size() == 0 || history.size() == 1 && ((String)history.get(0)).trim().length() == 0) {
            throw new NoSuchElementException("Line " + this.mLineNumber + " (without headers): Blank line encountered - assuming end of input stream");
        }
        if (history.size() < this.mNumColsToSave) {
            throw new InvalidPipeInputException("Line " + this.mLineNumber + " (without headers): Number of columns in input file was less than " + this.mNumColsToSave + ".\nActual # of columns: " + history.size() + "\n" + "Line: [" + history.getMergedData("\t") + "]", (Pipe)this);
        }
    }

    private String getFirstXColumnsPlusDot(History history) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mNumColsToSave; ++i) {
            sb.append((String)history.get(i));
            sb.append("\t");
        }
        sb.append(".");
        return sb.toString();
    }
}

