/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat.format;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import edu.mayo.bior.pipeline.Treat.JsonColumn;
import edu.mayo.bior.pipeline.Treat.format.FormatUtils;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import java.util.Arrays;
import java.util.List;

public class NcbiGeneFormatter
implements Formatter {
    private static final String[] JSON_DRILL_PATHS = new String[]{"GeneID", "gene"};
    private static final JsonPath PATH_GENEID = JsonPath.compile((String)JSON_DRILL_PATHS[0], (Filter[])new Filter[0]);
    private static final JsonPath PATH_GENE = JsonPath.compile((String)JSON_DRILL_PATHS[1], (Filter[])new Filter[0]);

    @Override
    public JsonColumn getJSONColumn() {
        return JsonColumn.NCBI_GENE;
    }

    @Override
    public List<String> getHeaders() {
        return Arrays.asList("Entrez.GeneID", "Gene_Symbol");
    }

    @Override
    public List<String> format(String json) {
        return Arrays.asList(FormatUtils.drill(PATH_GENEID, json), FormatUtils.drill(PATH_GENE, json));
    }

    @Override
    public List<String> getJsonDrillPaths() {
        return Arrays.asList(JSON_DRILL_PATHS);
    }
}

