/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat.format;

import com.tinkerpop.pipes.PipeFunction;
import edu.mayo.bior.pipeline.Treat.JsonColumn;
import edu.mayo.bior.pipeline.Treat.format.BgiFormatter;
import edu.mayo.bior.pipeline.Treat.format.CosmicFormatter;
import edu.mayo.bior.pipeline.Treat.format.DbsnpClinvarFormatter;
import edu.mayo.bior.pipeline.Treat.format.DbsnpFormatter;
import edu.mayo.bior.pipeline.Treat.format.EspFormatter;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import edu.mayo.bior.pipeline.Treat.format.HapmapFormatter;
import edu.mayo.bior.pipeline.Treat.format.HgncFormatter;
import edu.mayo.bior.pipeline.Treat.format.MirBaseFormatter;
import edu.mayo.bior.pipeline.Treat.format.NcbiGeneFormatter;
import edu.mayo.bior.pipeline.Treat.format.OmimFormatter;
import edu.mayo.bior.pipeline.Treat.format.SNPEffFormatter;
import edu.mayo.bior.pipeline.Treat.format.ThousandGenomesFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscBlacklistedFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscConservationFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscEnhancerFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscRegulationFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscRepeatFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscTfbsFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscTssFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscUniqueFormatter;
import edu.mayo.bior.pipeline.Treat.format.VEPFormatter;
import edu.mayo.bior.pipeline.Treat.format.VEPHgncFormatter;
import edu.mayo.bior.util.ClasspathUtil;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class FormatterPipeFunction
implements PipeFunction<History, History> {
    Logger sLogger = Logger.getLogger(FormatterPipeFunction.class);
    private List<JsonColumn> mOrderOfAddedColumns = new ArrayList<JsonColumn>();
    private List<Formatter> mAllPossibleFormatters = new ArrayList<Formatter>();
    private List<String> mColsFromConfig;
    private List<ColumnFormatter> mColFormatters = new ArrayList<ColumnFormatter>();

    public FormatterPipeFunction(List<JsonColumn> order, List<String> colsFromConfig) {
        this.mOrderOfAddedColumns = order;
        this.mColsFromConfig = colsFromConfig;
        this.sLogger.info((Object)("columns from config file: " + this.mColsFromConfig));
        this.mColFormatters = this.createColFormatters(this.mOrderOfAddedColumns);
    }

    public List<String> getColumnsAdded() {
        ArrayList<String> colsAdded = new ArrayList<String>();
        for (ColumnFormatter colFmt : this.mColFormatters) {
            colsAdded.addAll(colFmt.userSelectedColNames);
        }
        return colsAdded;
    }

    private List<String> getHeadersUserWanted(JsonColumn jsonCol) {
        ArrayList<String> headers = new ArrayList<String>();
        Formatter fmt = this.getFormatterMatchingColumn(jsonCol);
        if (fmt == null) {
            return headers;
        }
        for (String colHeader : fmt.getHeaders()) {
            if (this.mColsFromConfig != null && !this.mColsFromConfig.contains(colHeader)) continue;
            headers.add(colHeader);
        }
        this.sLogger.info((Object)("Headers that user wanted: " + headers));
        return headers;
    }

    private Formatter getFormatterMatchingColumn(JsonColumn jsonCol) {
        for (Formatter fmt : this.mAllPossibleFormatters) {
            if (!jsonCol.equals((Object)fmt.getJSONColumn())) continue;
            return fmt;
        }
        return null;
    }

    private List<ColumnFormatter> createColFormatters(List<JsonColumn> orderOfColumnsAdded) {
        Map<JsonColumn, Integer> jsonToColIdxMap = this.createOrderIndex(orderOfColumnsAdded);
        this.mAllPossibleFormatters = FormatterPipeFunction.getAllPossibleFormatters();
        ArrayList<ColumnFormatter> colFormatters = new ArrayList<ColumnFormatter>();
        for (Formatter fmt : this.mAllPossibleFormatters) {
            List<String> userSelectedHeaders;
            Integer colIdx = jsonToColIdxMap.get((Object)fmt.getJSONColumn());
            if (colIdx == null || (userSelectedHeaders = this.getHeadersUserWanted(fmt.getJSONColumn())) == null || userSelectedHeaders.size() == 0) continue;
            ColumnFormatter colFmt = new ColumnFormatter();
            colFormatters.add(colFmt);
            colFmt.colIdx = colIdx;
            colFmt.formatter = fmt;
            colFmt.jsonColIn = fmt.getJSONColumn();
            colFmt.userSelectedColNames = userSelectedHeaders;
            List<String> fmtHeaders = fmt.getHeaders();
            for (int i = 0; i < fmtHeaders.size(); ++i) {
                if (!userSelectedHeaders.contains(fmtHeaders.get(i))) continue;
                colFmt.idxFormatterJsonHeader.add(i);
            }
        }
        this.sLogger.info((Object)"Column formatters:  idx, formatter, userSelectedColNames");
        for (int i = 0; i < colFormatters.size(); ++i) {
            ColumnFormatter colFormat = (ColumnFormatter)colFormatters.get(i);
            this.sLogger.info((Object)("    " + colFormat.colIdx + ") " + colFormat.formatter.getClass() + "." + colFormat.formatter.getHeaders() + ":  " + colFormat.userSelectedColNames));
        }
        return colFormatters;
    }

    public History compute(History history) {
        if (history.size() > 0 && ((String)history.get(0)).startsWith("#")) {
            return history;
        }
        int preAnnotateSize = history.size() - this.mOrderOfAddedColumns.size();
        History newHistory = new History(history.subList(0, preAnnotateSize));
        newHistory.setMetaData(history.getMetaData());
        for (ColumnFormatter colFmt : this.mColFormatters) {
            int colIdx = colFmt.colIdx + preAnnotateSize;
            List<String> fmtValues = colFmt.formatter.format((String)history.get(colIdx));
            for (Integer idxHeader : colFmt.idxFormatterJsonHeader) {
                newHistory.add((Object)fmtValues.get(idxHeader));
            }
        }
        return newHistory;
    }

    public List<Metadata> getMetadataForUserColumns(List<String> catalogPathsForColumns) throws URISyntaxException, IOException {
        ArrayList<Metadata> metas = new ArrayList<Metadata>();
        for (ColumnFormatter fmt : this.mColFormatters) {
            File columnProps;
            File dataSourceProps;
            String catalogPath = catalogPathsForColumns.get(fmt.colIdx);
            if (null == catalogPath || catalogPath.trim().length() == 0) continue;
            if (fmt.formatter.getClass().getSimpleName().contains("VEPFormatter")) {
                dataSourceProps = ClasspathUtil.loadResource("/tools/vep.datasource.properties");
                columnProps = ClasspathUtil.loadResource("/tools/vep.columns.tsv");
                metas.add(new Metadata("bior_annotate", dataSourceProps.getCanonicalPath(), columnProps.getCanonicalPath(), fmt.userSelectedColNames.toArray(new String[0]), fmt.getDrillPathsMatchingUserSelectedColumnSubset().toArray(new String[0])));
                continue;
            }
            if (fmt.formatter.getClass().getSimpleName().contains("SNPEffFormatter")) {
                dataSourceProps = ClasspathUtil.loadResource("/tools/snpeff.datasource.properties");
                columnProps = ClasspathUtil.loadResource("/tools/snpeff.columns.tsv");
                metas.add(new Metadata("bior_annotate", dataSourceProps.getCanonicalPath(), columnProps.getCanonicalPath(), fmt.userSelectedColNames.toArray(new String[0]), fmt.getDrillPathsMatchingUserSelectedColumnSubset().toArray(new String[0])));
                continue;
            }
            metas.add(new Metadata("bior_annotate", catalogPath, fmt.userSelectedColNames.toArray(new String[0]), fmt.getDrillPathsMatchingUserSelectedColumnSubset().toArray(new String[0])));
        }
        return metas;
    }

    private Map<JsonColumn, Integer> createOrderIndex(List<JsonColumn> order) {
        TreeMap<JsonColumn, Integer> index = new TreeMap<JsonColumn, Integer>();
        for (int i = 0; i < order.size(); ++i) {
            index.put(order.get(i), i);
        }
        return index;
    }

    public static List<String> getAllPossibleColumns() {
        ArrayList<String> allPossibleColumns = new ArrayList<String>();
        for (Formatter f : FormatterPipeFunction.getAllPossibleFormatters()) {
            allPossibleColumns.addAll(f.getHeaders());
        }
        return allPossibleColumns;
    }

    private static List<Formatter> getAllPossibleFormatters() {
        ArrayList<Formatter> allFormatters = new ArrayList<Formatter>();
        allFormatters.add(new DbsnpFormatter());
        allFormatters.add(new DbsnpClinvarFormatter());
        allFormatters.add(new CosmicFormatter());
        allFormatters.add(new ThousandGenomesFormatter());
        allFormatters.add(new BgiFormatter());
        allFormatters.add(new EspFormatter());
        allFormatters.add(new HapmapFormatter());
        allFormatters.add(new NcbiGeneFormatter());
        allFormatters.add(new HgncFormatter());
        allFormatters.add(new OmimFormatter());
        allFormatters.add(new MirBaseFormatter());
        allFormatters.add(new UcscBlacklistedFormatter());
        allFormatters.add(new UcscConservationFormatter());
        allFormatters.add(new UcscRegulationFormatter());
        allFormatters.add(new UcscTfbsFormatter());
        allFormatters.add(new UcscTssFormatter());
        allFormatters.add(new UcscEnhancerFormatter());
        allFormatters.add(new UcscUniqueFormatter());
        allFormatters.add(new UcscRepeatFormatter());
        allFormatters.add(new VEPFormatter());
        allFormatters.add(new VEPHgncFormatter());
        allFormatters.add(new SNPEffFormatter());
        return allFormatters;
    }

    private class ColumnFormatter {
        public int colIdx;
        public JsonColumn jsonColIn;
        public Formatter formatter;
        public List<String> userSelectedColNames = new ArrayList<String>();
        public List<Integer> idxFormatterJsonHeader = new ArrayList<Integer>();

        private ColumnFormatter() {
        }

        public List<String> getDrillPathsMatchingUserSelectedColumnSubset() {
            ArrayList<String> drillPathsForCol = new ArrayList<String>();
            for (String userCol : this.userSelectedColNames) {
                for (int i = 0; i < this.formatter.getHeaders().size(); ++i) {
                    if (!userCol.equalsIgnoreCase(this.formatter.getHeaders().get(i))) continue;
                    String drillPath = this.formatter.getJsonDrillPaths().get(i);
                    if (drillPath.endsWith("]") && drillPath.contains("[")) {
                        drillPath = drillPath.substring(0, drillPath.indexOf("["));
                    }
                    drillPathsForCol.add(drillPath);
                }
            }
            return drillPathsForCol;
        }
    }
}

