/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.UNIX.CatPipe;
import edu.mayo.pipes.WritePipe;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryInPipe;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class CreateCatalogCommand
implements CommandPlugin {
    private static final char OPTION_INPUT_FILE = 'i';
    private static final char OPTION_OUTPUT_FILE = 'o';
    private static final char OPTION_JSON_COLUMN = 'c';

    public void init(Properties props) throws Exception {
    }

    public void execute(CommandLine cl, Options optns) throws Exception {
        String infile = "";
        String outfile = "";
        if (cl.hasOption('i')) {
            infile = cl.getOptionValue('i');
        }
        if (cl.hasOption('o')) {
            outfile = cl.getOptionValue('o');
        }
        int jsoncol = -1;
        if (cl.hasOption('c')) {
            jsoncol = new Integer(cl.getOptionValue('c'));
        }
        TransformFunctionPipe tjson2cat = new TransformFunctionPipe((PipeFunction)new TJSON2Catalog(jsoncol));
        Pipeline p = new Pipeline(new Pipe[]{new CatPipe(), new HistoryInPipe(), tjson2cat, new WritePipe(outfile, false, true)});
        p.setStarts(Arrays.asList(infile));
        while (p.hasNext()) {
            p.next();
        }
    }

    public TJSON2Catalog newTJSON2Catalog(int c) {
        return new TJSON2Catalog(c);
    }

    public class TJSON2Catalog
    implements PipeFunction<History, String> {
        private JsonPath landmarkPath = JsonPath.compile((String)"_landmark", (Filter[])new Filter[0]);
        private JsonPath minBPPath = JsonPath.compile((String)"_minBP", (Filter[])new Filter[0]);
        private JsonPath maxBPPath = JsonPath.compile((String)"_maxBP", (Filter[])new Filter[0]);
        private int col = -1;
        private boolean firstRow = true;

        public TJSON2Catalog(int column) {
            this.col = column;
        }

        private void fixColumn(int historySize) {
            if (this.firstRow) {
                if (this.col > -1) {
                    --this.col;
                }
                if (this.col <= -1) {
                    this.col = historySize + this.col;
                }
            }
            this.firstRow = false;
        }

        public String extractLandmark(String json) {
            String landmark = "UNKNOWN";
            try {
                String s;
                Object o = this.landmarkPath.read(json);
                if (o != null && !(s = o.toString().trim()).equalsIgnoreCase(".")) {
                    landmark = s;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return landmark;
        }

        public String extractMinBP(String json) {
            String minbp = "0";
            try {
                String s;
                Object o = this.minBPPath.read(json);
                if (o != null && !(s = o.toString().trim()).equalsIgnoreCase(".") && !minbp.startsWith("-")) {
                    Integer i = new Integer(minbp);
                    minbp = s;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return minbp;
        }

        public String extractMaxBP(String json) {
            String maxbp = "0";
            try {
                String s;
                Object o = this.maxBPPath.read(json);
                if (o != null && !(s = o.toString().trim()).equalsIgnoreCase(".") && !maxbp.startsWith("-")) {
                    Integer i = new Integer(maxbp);
                    maxbp = s;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return maxbp;
        }

        public String compute(History h) {
            this.fixColumn(h.size());
            StringBuilder sb = new StringBuilder();
            String json = (String)h.get(this.col);
            String landmark = this.extractLandmark(json);
            String minbp = this.extractMinBP(json);
            String maxbp = this.extractMaxBP(json);
            sb.append(landmark);
            sb.append("\t");
            sb.append(minbp);
            sb.append("\t");
            sb.append(maxbp);
            sb.append("\t");
            sb.append(json);
            return sb.toString();
        }
    }
}

