/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.string;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.history.History;
import java.util.NoSuchElementException;

public class TrimSpacesPipe<S>
extends AbstractPipe<S, S> {
    protected S processNextStart() throws NoSuchElementException {
        Object line = this.starts.next();
        if (line instanceof String) {
            return (S)this.trimSpaces((String)line);
        }
        if (line instanceof History) {
            return (S)this.trimSpaces((History)line);
        }
        return (S)line;
    }

    protected String trimSpaces(String line) {
        if (line.startsWith("##")) {
            return line;
        }
        String[] cols = line.split("\t");
        StringBuilder str = new StringBuilder();
        for (String s : cols) {
            str.append(s.trim()).append("\t");
        }
        if (str.length() > 0 && str.charAt(str.length() - 1) == '\t') {
            str.deleteCharAt(str.length() - 1);
        }
        return str.toString();
    }

    protected History trimSpaces(History line) {
        if (line.size() > 0 && ((String)line.get(0)).startsWith("##")) {
            return line;
        }
        for (int i = 0; i < line.size(); ++i) {
            line.set(i, ((String)line.get(i)).trim());
        }
        return line;
    }
}

