/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.LongString;
import com.rabbitmq.client.MalformedFrameException;
import com.rabbitmq.client.impl.LongStringHelper;
import com.rabbitmq.client.impl.TruncatedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueReader {
    private static final long INT_MASK = 0xFFFFFFFFL;
    private final DataInputStream in;

    private static final long unsignedExtend(int value) {
        long extended = value;
        return extended & 0xFFFFFFFFL;
    }

    public ValueReader(DataInputStream in) {
        this.in = in;
    }

    private static final String readShortstr(DataInputStream in) throws IOException {
        byte[] b = new byte[in.readUnsignedByte()];
        in.readFully(b);
        return new String(b, "utf-8");
    }

    public final String readShortstr() throws IOException {
        return ValueReader.readShortstr(this.in);
    }

    private static final byte[] readBytes(DataInputStream in) throws IOException {
        long contentLength = ValueReader.unsignedExtend(in.readInt());
        if (contentLength < Integer.MAX_VALUE) {
            byte[] buffer = new byte[(int)contentLength];
            in.readFully(buffer);
            return buffer;
        }
        throw new UnsupportedOperationException("Very long byte vectors and strings not currently supported");
    }

    private static final LongString readLongstr(DataInputStream in) throws IOException {
        return LongStringHelper.asLongString(ValueReader.readBytes(in));
    }

    public final LongString readLongstr() throws IOException {
        return ValueReader.readLongstr(this.in);
    }

    public final int readShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public final int readLong() throws IOException {
        return this.in.readInt();
    }

    public final long readLonglong() throws IOException {
        return this.in.readLong();
    }

    private static final Map<String, Object> readTable(DataInputStream in) throws IOException {
        long tableLength = ValueReader.unsignedExtend(in.readInt());
        if (tableLength == 0L) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> table = new HashMap<String, Object>();
        DataInputStream tableIn = new DataInputStream(new TruncatedInputStream(in, tableLength));
        while (tableIn.available() > 0) {
            String name = ValueReader.readShortstr(tableIn);
            Object value = ValueReader.readFieldValue(tableIn);
            if (table.containsKey(name)) continue;
            table.put(name, value);
        }
        return table;
    }

    private static final Object readFieldValue(DataInputStream in) throws IOException {
        Object value = null;
        switch (in.readUnsignedByte()) {
            case 83: {
                value = ValueReader.readLongstr(in);
                break;
            }
            case 73: {
                value = in.readInt();
                break;
            }
            case 68: {
                int scale = in.readUnsignedByte();
                byte[] unscaled = new byte[4];
                in.readFully(unscaled);
                value = new BigDecimal(new BigInteger(unscaled), scale);
                break;
            }
            case 84: {
                value = ValueReader.readTimestamp(in);
                break;
            }
            case 70: {
                value = ValueReader.readTable(in);
                break;
            }
            case 65: {
                value = ValueReader.readArray(in);
                break;
            }
            case 98: {
                value = in.readByte();
                break;
            }
            case 100: {
                value = in.readDouble();
                break;
            }
            case 102: {
                value = Float.valueOf(in.readFloat());
                break;
            }
            case 108: {
                value = in.readLong();
                break;
            }
            case 115: {
                value = in.readShort();
                break;
            }
            case 116: {
                value = in.readBoolean();
                break;
            }
            case 120: {
                value = ValueReader.readBytes(in);
                break;
            }
            case 86: {
                value = null;
                break;
            }
            default: {
                throw new MalformedFrameException("Unrecognised type in table");
            }
        }
        return value;
    }

    private static final List<Object> readArray(DataInputStream in) throws IOException {
        long length = ValueReader.unsignedExtend(in.readInt());
        DataInputStream arrayIn = new DataInputStream(new TruncatedInputStream(in, length));
        ArrayList<Object> array = new ArrayList<Object>();
        while (arrayIn.available() > 0) {
            Object value = ValueReader.readFieldValue(arrayIn);
            array.add(value);
        }
        return array;
    }

    public final Map<String, Object> readTable() throws IOException {
        return ValueReader.readTable(this.in);
    }

    public final int readOctet() throws IOException {
        return this.in.readUnsignedByte();
    }

    private static final Date readTimestamp(DataInputStream in) throws IOException {
        return new Date(in.readLong() * 1000L);
    }

    public final Date readTimestamp() throws IOException {
        return ValueReader.readTimestamp(this.in);
    }
}

