/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.branch;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.AbstractMetaPipe;
import com.tinkerpop.pipes.util.MetaPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import com.tinkerpop.pipes.util.Pipeline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class CopySplitPipe<S>
extends AbstractMetaPipe<S, S>
implements MetaPipe {
    private final List<Pipeline> pipes = new ArrayList<Pipeline>();

    public CopySplitPipe(List<Pipe> pipes) {
        for (Pipe pipe : pipes) {
            if (pipe instanceof Pipeline) {
                ((Pipeline)pipe).addPipe(0, new CopyExpandablePipe(this));
                this.pipes.add((Pipeline)pipe);
                continue;
            }
            Pipeline pipeline = new Pipeline();
            pipeline.addPipe(new CopyExpandablePipe(this));
            pipeline.addPipe(pipe);
            this.pipes.add(pipeline);
        }
    }

    public CopySplitPipe(Pipe ... pipes) {
        this(Arrays.asList(pipes));
    }

    @Override
    public S processNextStart() {
        Object s = this.starts.next();
        ArrayList tempPath = null;
        if (this.pathEnabled) {
            tempPath = new ArrayList(this.getCurrentPath());
        }
        for (Pipeline pipeline : this.pipes) {
            CopyExpandablePipe temp = (CopyExpandablePipe)pipeline.get(0);
            temp.add(s);
            if (!this.pathEnabled) continue;
            temp.addCurrentPath(tempPath);
        }
        return (S)s;
    }

    @Override
    public List getCurrentPath() {
        List path = super.getCurrentPath();
        path.remove(path.size() - 1);
        return path;
    }

    @Override
    public List<Pipe> getPipes() {
        return this.pipes;
    }

    @Override
    public void enablePath(boolean enable) {
        this.pathEnabled = enable;
        if (this.starts instanceof Pipe) {
            ((Pipe)this.starts).enablePath(enable);
        }
    }

    @Override
    public String toString() {
        return PipeHelper.makePipeString(this, this.pipes);
    }

    private static class CopyExpandablePipe<S>
    extends AbstractPipe<S, S> {
        private static final Object TOKEN = new Object();
        protected Queue<Object> queue = new LinkedList<Object>();
        protected Queue<List> paths = new LinkedList<List>();
        private CopySplitPipe<S> parentPipe;

        public CopyExpandablePipe(CopySplitPipe<S> parentPipe) {
            this.parentPipe = parentPipe;
        }

        @Override
        public S processNextStart() {
            block2: {
                Object x;
                while (true) {
                    if (this.queue.isEmpty()) {
                        this.parentPipe.processNextStart();
                        continue;
                    }
                    if (!this.pathEnabled) break block2;
                    x = this.queue.remove();
                    if (x != TOKEN) break;
                    this.paths.remove();
                }
                return (S)x;
            }
            return (S)this.queue.remove();
        }

        @Override
        public List getCurrentPath() {
            if (this.pathEnabled) {
                return new ArrayList(this.paths.peek());
            }
            throw new RuntimeException("Path calculations are not enabled");
        }

        public void addCurrentPath(List path) {
            this.paths.add(path);
        }

        public void add(S s) {
            this.queue.add(s);
            if (this.pathEnabled) {
                this.queue.add(TOKEN);
            }
        }

        @Override
        public void reset() {
            this.queue.clear();
            super.reset();
        }

        @Override
        public void enablePath(boolean enablePath) {
            this.parentPipe.enablePath(enablePath);
            super.enablePath(enablePath);
        }
    }
}

