/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolPropertyTable;

public class SimpleSymbolPropertyTable
implements SymbolPropertyTable {
    private final Alphabet source;
    private String name;
    private final Map doublePropMap;

    public SimpleSymbolPropertyTable(Alphabet source, String name) {
        this.source = source;
        this.name = name;
        this.doublePropMap = new HashMap();
    }

    public void setDoubleProperty(Symbol s, String value) throws IllegalSymbolException {
        this.source.validate(s);
        this.doublePropMap.put(s, new Double(value));
    }

    public String getName() {
        return this.name;
    }

    public Alphabet getAlphabet() {
        return this.source;
    }

    public double getDoubleValue(Symbol s) throws IllegalSymbolException {
        this.source.validate(s);
        Double value = (Double)this.doublePropMap.get(s);
        if (value == null) {
            throw new IllegalSymbolException("Symbol " + s.getName() + " not found in property table " + this.getName());
        }
        return value;
    }
}

