/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics.aaindex;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.proteomics.aaindex.SymbolPropertyTableDB;
import org.biojava.bio.proteomics.aaindex.SymbolPropertyTableIterator;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.symbol.SymbolPropertyTable;

public class SimpleSymbolPropertyTableDB
implements SymbolPropertyTableDB {
    private Map map = new Hashtable();

    public SimpleSymbolPropertyTableDB() {
    }

    public SimpleSymbolPropertyTableDB(SymbolPropertyTableIterator tableIterator) throws BioException {
        this();
        if (tableIterator == null) {
            throw new NullPointerException("tableIterator is null.");
        }
        while (tableIterator.hasNext()) {
            this.addTable(tableIterator.nextTable());
        }
    }

    public void addTable(SymbolPropertyTable table) throws NullPointerException {
        if (table == null) {
            throw new NullPointerException("table is null.");
        }
        this.map.put(table.getName(), table);
    }

    public SymbolPropertyTableIterator tableIterator() {
        return new SimpleSymbolPropertyTableIterator(this.map.values().iterator());
    }

    public int numTables() {
        return this.map.size();
    }

    public SymbolPropertyTable table(String name) throws IllegalIDException, NullPointerException {
        if (name == null) {
            throw new NullPointerException("name is null.");
        }
        if (!this.map.containsKey(name)) {
            throw new IllegalIDException("No table found with name " + name + ".");
        }
        return (SymbolPropertyTable)this.map.get(name);
    }

    public Set names() {
        return this.map.keySet();
    }

    private static final class SimpleSymbolPropertyTableIterator
    implements SymbolPropertyTableIterator {
        private Iterator iterator = null;

        public SimpleSymbolPropertyTableIterator(Iterator iterator) throws NullPointerException {
            if (iterator == null) {
                throw new NullPointerException("iterator is null.");
            }
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public SymbolPropertyTable nextTable() throws NoSuchElementException, BioException {
            return (SymbolPropertyTable)this.iterator.next();
        }
    }
}

