/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.xff;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.program.xff.PropertyWriter;
import org.biojava.bio.program.xff.XFFFeatureSetHandler;
import org.biojava.bio.program.xff.XFFWriter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.SequenceBuilderBase;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.DummySymbolList;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.biojava.utils.xml.PrettyXMLWriter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XFFTools {
    public static final String XFF_NS = "http://www.bioxml.org/2000/xff";
    public static final String XFF_BIOJAVA_NS = "http://www.biojava.org/2001/xff-biojava";

    public static void annotateXFF(File xffFile, Sequence sequence) throws IOException, SAXException, BioException {
        XFFTools.annotateXFF(xffFile, sequence, Annotation.EMPTY_ANNOTATION);
    }

    public static void annotateXFF(File xffFile, final Sequence sequence, Annotation ann) throws IOException, SAXException, BioException {
        XMLReader parser;
        SequenceBuilderBase sb = new SequenceBuilderBase(){
            {
                this.seq = sequence;
            }

            public void addSymbols(Alphabet alpha, Symbol[] syms, int start, int length) {
            }
        };
        XFFFeatureSetHandler xffHandler = new XFFFeatureSetHandler();
        xffHandler.setFeatureListener(sb);
        xffHandler.setMergeAnnotation(ann);
        SAX2StAXAdaptor saxHandler = new SAX2StAXAdaptor(xffHandler);
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(false);
            spf.setNamespaceAware(true);
            parser = spf.newSAXParser().getXMLReader();
        }
        catch (Exception ex) {
            throw new BioException("Error creating SAX parser", ex);
        }
        parser.setContentHandler(saxHandler);
        InputSource is = new InputSource(new FileReader(xffFile));
        parser.parse(is);
        sb.makeSequence();
    }

    public static Sequence readXFF(File xffFile, String seqID, FiniteAlphabet alpha) throws IOException, SAXException, BioException {
        DummySymbolList dummy = new DummySymbolList(alpha, Integer.MAX_VALUE);
        SimpleSequence ourSeq = new SimpleSequence(dummy, seqID, seqID, new SmallAnnotation());
        XFFTools.annotateXFF(xffFile, ourSeq);
        return ourSeq;
    }

    public static Sequence readXFF(File xffFile, String seqID) throws IOException, SAXException, BioException {
        DummySymbolList dummy = new DummySymbolList(Alphabet.EMPTY_ALPHABET, Integer.MAX_VALUE);
        SimpleSequence ourSeq = new SimpleSequence(dummy, seqID, seqID, new SmallAnnotation());
        XFFTools.annotateXFF(xffFile, ourSeq);
        return ourSeq;
    }

    public static void writeXFF(File xffFile, FeatureHolder features) throws IOException {
        PrintWriter xffPR = new PrintWriter(new FileWriter(xffFile));
        XFFTools.writeXFF(xffPR, features);
    }

    public static void writeXFF(PrintWriter xffPR, FeatureHolder features) throws IOException {
        PrettyXMLWriter xmlWriter = new PrettyXMLWriter(xffPR);
        XFFWriter xffWriter = new XFFWriter(new PropertyWriter());
        xffWriter.writeFeatureSet(features, xmlWriter);
        xffPR.flush();
        xffPR.close();
    }
}

