/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import org.biojava.bio.program.tagvalue.BoundaryFinder;
import org.biojava.bio.program.tagvalue.SimpleTagValueWrapper;
import org.biojava.bio.program.tagvalue.TagValueContext;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.utils.ParserException;

public class MultiTagger
extends SimpleTagValueWrapper {
    private final BoundaryFinder observer;
    boolean inTag;
    boolean seenValues;
    Object tag;

    public MultiTagger(TagValueListener listener, BoundaryFinder observer) {
        super(listener);
        this.observer = observer;
    }

    public BoundaryFinder getBoundaryFinder() {
        return this.observer;
    }

    public void startTag(Object tag) throws ParserException {
        this.tag = tag;
        this.inTag = false;
        this.seenValues = false;
    }

    public void value(TagValueContext ctxt, Object value) throws ParserException {
        this.seenValues = true;
        if (this.observer.isBoundaryStart(value)) {
            if (this.inTag) {
                super.endTag();
            }
            super.startTag(this.tag);
            if (!this.observer.dropBoundaryValues()) {
                super.value(ctxt, value);
            }
            this.inTag = true;
        } else if (this.observer.isBoundaryEnd(value)) {
            if (!this.inTag) {
                super.startTag(this.tag);
            }
            if (!this.observer.dropBoundaryValues()) {
                super.value(ctxt, value);
            }
            super.endTag();
            this.inTag = false;
        } else {
            if (!this.inTag) {
                super.startTag(this.tag);
                this.inTag = true;
            }
            super.value(ctxt, value);
        }
    }

    public void endTag() throws ParserException {
        if (this.inTag) {
            super.endTag();
        } else if (!this.seenValues) {
            super.startTag(this.tag);
            super.endTag();
        }
        this.inTag = false;
        this.seenValues = false;
    }
}

