/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.history;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryMetaData;
import edu.mayo.pipes.util.metadata.AddMetadataLines;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class HistoryInPipe
extends AbstractPipe<String, History> {
    List<Metadata> metadata = new ArrayList<Metadata>();
    private int mNumColumns = 0;
    private String[] knownHeader = null;
    private int expand2NumCols = -1;
    private final String COL_DELIMITER = "\t";
    private History firstHistory = null;
    private AddMetadataLines amdl = new AddMetadataLines();

    public HistoryInPipe(Metadata md) {
        this.metadata.add(md);
    }

    public HistoryInPipe(List<Metadata> md) {
        if (md != null) {
            this.metadata.addAll(md);
        }
    }

    public HistoryInPipe(String[] knownHeader) {
        this.knownHeader = knownHeader;
    }

    public HistoryInPipe() {
        this.firstHistory = null;
        this.expand2NumCols = -1;
    }

    public HistoryInPipe(int expand2NumCols) {
        this.firstHistory = null;
        this.expand2NumCols = expand2NumCols;
    }

    public void reset() {
        super.reset();
        this.firstHistory = null;
    }

    protected History processNextStart() throws NoSuchElementException {
        String line = (String)this.starts.next();
        History history = null;
        if (this.firstHistory == null) {
            history = new History();
            ArrayList<String> headerRows = new ArrayList<String>();
            while (line.startsWith("#")) {
                headerRows.add(line);
                try {
                    line = (String)this.starts.next();
                }
                catch (NoSuchElementException e) {
                    int numCols = line.split("\t").length;
                    this.initializeMetaData(history, headerRows, numCols);
                    throw e;
                }
            }
            this.mNumColumns = line.split("\t").length;
            history.setData(line);
            this.initializeMetaData(history, headerRows, this.mNumColumns);
            this.insertBIORLines(history);
            this.firstHistory = history;
        } else {
            history = new History(line);
            history.setMetaData(this.firstHistory.getMetaData());
        }
        if (history.getMetaData() == null || history.getMetaData().getOriginalHeader() == null) {
            throw new RuntimeException("Improper Header!");
        }
        return history;
    }

    private void initializeMetaData(History history, List<String> headerRows, int numCols) {
        HistoryMetaData hMeta = new HistoryMetaData(headerRows);
        if (headerRows.size() > 0 && headerRows.get(headerRows.size() - 1).startsWith("#") && !headerRows.get(headerRows.size() - 1).startsWith("##")) {
            String colHeaderLine = headerRows.get(headerRows.size() - 1);
            colHeaderLine = colHeaderLine.substring(1);
            for (String colName : colHeaderLine.split("\t")) {
                ColumnMetaData cmd = new ColumnMetaData(colName);
                hMeta.getColumns().add(cmd);
            }
        } else {
            if (numCols != this.expand2NumCols && this.expand2NumCols != -1) {
                while (history.size() < this.expand2NumCols) {
                    history.add("");
                }
                numCols = this.expand2NumCols;
            }
            if (this.knownHeader == null) {
                for (int i = 1; i <= numCols; ++i) {
                    ColumnMetaData cmd = new ColumnMetaData("#UNKNOWN_" + i);
                    hMeta.getColumns().add(cmd);
                }
            } else {
                for (int i = 1; i <= this.knownHeader.length; ++i) {
                    String s = this.knownHeader[i - 1];
                    ColumnMetaData cmd = new ColumnMetaData(s);
                    hMeta.getColumns().add(cmd);
                }
            }
        }
        history.setMetaData(hMeta);
    }

    public void insertBIORLines(History h) {
        if (this.metadata.size() < 1) {
            return;
        }
        HistoryMetaData hMeta = h.getMetaData();
        for (int i = 0; i < this.metadata.size(); ++i) {
            String col;
            Metadata meta = this.metadata.get(i);
            Metadata.CmdType theCmd = meta.getCmdType();
            if (theCmd.equals((Object)Metadata.CmdType.ToTJson)) {
                String cmdName = theCmd.toString();
                this.amdl.constructToTJsonLine(h, meta.getOperator(), cmdName);
                ColumnMetaData cmd = new ColumnMetaData((Object)((Object)AddMetadataLines.BiorMetaControlledVocabulary.BIOR) + cmdName);
                hMeta.getColumns().add(cmd);
                continue;
            }
            if (theCmd.equals((Object)Metadata.CmdType.Drill)) {
                col = this.amdl.constructDrillLines(h, meta.getOperator(), meta.getColNum(), meta.getDrillPaths());
                List<ColumnMetaData> columnMeta = h.getMetaData().getColumns();
                int colToRemove = this.toZeroBasedCol(meta.getColNum(), columnMeta.size());
                for (String path : meta.getDrillPaths()) {
                    ColumnMetaData cmd = new ColumnMetaData((Object)((Object)AddMetadataLines.BiorMetaControlledVocabulary.BIOR) + col + "." + path);
                    hMeta.getColumns().add(cmd);
                }
                if (!meta.isKeepJSON()) {
                    hMeta.getColumns().remove(colToRemove);
                    continue;
                }
                ColumnMetaData moveMe = hMeta.getColumns().get(colToRemove);
                hMeta.getColumns().remove(colToRemove);
                hMeta.getColumns().add(moveMe);
                continue;
            }
            if (theCmd.equals((Object)Metadata.CmdType.Query)) {
                try {
                    col = this.amdl.constructQueryLine(h, meta.getFullCanonicalPath(), meta.getOperator());
                    ColumnMetaData cmd = new ColumnMetaData((Object)((Object)AddMetadataLines.BiorMetaControlledVocabulary.BIOR) + col);
                    hMeta.getColumns().add(cmd);
                }
                catch (Exception e) {
                    String col2 = this.amdl.constructQueryLineOnNoDatasourceProperties(h, meta.getFullCanonicalPath(), meta.getOperator());
                    ColumnMetaData cmd = new ColumnMetaData((Object)((Object)AddMetadataLines.BiorMetaControlledVocabulary.BIOR) + col2);
                    hMeta.getColumns().add(cmd);
                }
                continue;
            }
            if (theCmd.equals((Object)Metadata.CmdType.Tool)) {
                try {
                    String shortname = this.amdl.constructToolLine(h, meta.getDatasourcePath(), meta.getColumnsPath(), meta.getOperator());
                    ColumnMetaData cmd = new ColumnMetaData((Object)((Object)AddMetadataLines.BiorMetaControlledVocabulary.BIOR) + shortname);
                    hMeta.getColumns().add(cmd);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException("Stupid Developer! You need to put the path of the VEP/SNPEFF/Tool into your project and pass it to the metadata object\n  Look at HistoryInPipeTest for an example.\n CurrentPath: " + meta.getFullCanonicalPath());
                }
            }
            if (theCmd.equals((Object)Metadata.CmdType.Annotate)) {
                try {
                    if (meta.getDataSourceCanonicalPath() != null) {
                        this.amdl.constructAnnotateLine(h, meta.getDataSourceCanonicalPath(), meta.getColumnCanonicalPath(), meta.getDataSourceCanonicalPath(), meta.getOperator(), meta.getNewColNamesForDrillPaths(), meta.getDrillPaths());
                    } else {
                        this.amdl.constructAnnotateLine(h, meta.getFullCanonicalPath(), meta.getOperator(), meta.getNewColNamesForDrillPaths(), meta.getDrillPaths());
                    }
                    for (String colName : meta.getNewColNamesForDrillPaths()) {
                        hMeta.getColumns().add(new ColumnMetaData(colName));
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not construct the metadata line for one of the columns.  " + e.getMessage());
                }
            }
            if (!theCmd.equals((Object)Metadata.CmdType.Compress)) continue;
            this.amdl.modifyCompressHeaders(h, meta, this.mNumColumns);
        }
    }

    private int toZeroBasedCol(int col, int numColHeaders) {
        if (col == 0) {
            throw new RuntimeException("You can't specify column number 0, use negative or positive numbers only!");
        }
        if (col > 0) {
            return col - 1;
        }
        return numColHeaders + col;
    }
}

