/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.WordUtils;

public class StringUtils {
    public static String[] safeSplit(String s, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        int fromIdx = 0;
        int delimiterIdx = 0;
        do {
            if ((delimiterIdx = s.indexOf(delimiter, fromIdx)) != -1) {
                list.add(s.substring(fromIdx, delimiterIdx));
            } else {
                list.add(s.substring(fromIdx));
            }
            fromIdx = delimiterIdx + 1;
        } while (delimiterIdx != -1);
        return list.toArray(new String[0]);
    }

    public static List<String> split(String strToSplit, List<String> delimiters) {
        ArrayList<String> strList = new ArrayList<String>();
        if (strToSplit == null || strToSplit.length() == 0) {
            return strList;
        }
        StringBuilder str = new StringBuilder();
        boolean isMidQuote = false;
        for (int i = 0; i < strToSplit.length(); ++i) {
            char chr = strToSplit.charAt(i);
            if (chr == '\"') {
                if (i > 0 && strToSplit.charAt(i - 1) == '\\') {
                    str.append(chr);
                    continue;
                }
                if (!isMidQuote) {
                    str.append(chr);
                    isMidQuote = true;
                    continue;
                }
                if (!isMidQuote) continue;
                str.append(chr);
                isMidQuote = false;
                continue;
            }
            if (isMidQuote) {
                str.append(chr);
                continue;
            }
            if (delimiters.contains(chr + "")) {
                StringUtils.addToListAndClear(str, strList);
                continue;
            }
            str.append(chr);
        }
        StringUtils.addToListAndClear(str, strList);
        return strList;
    }

    private static void addToListAndClear(StringBuilder strB, List<String> strList) {
        String s = strB.toString().trim();
        if (s.length() > 0) {
            strList.add(s);
        }
        strB.delete(0, strB.length());
    }

    public static String wrap(String str, int max_width) throws IOException {
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);
        StringReader sRdr = new StringReader(str);
        BufferedReader bRdr = new BufferedReader(sRdr);
        String line = bRdr.readLine();
        while (line != null) {
            line = line.trim().startsWith("<NOWRAP>") ? line.substring("<NOWRAP>".length()) : WordUtils.wrap((String)line, (int)max_width);
            pWtr.println(line);
            line = bRdr.readLine();
        }
        sWtr.close();
        String wrappedStr = sWtr.toString();
        if (wrappedStr.length() > 0) {
            wrappedStr = wrappedStr.substring(0, wrappedStr.length() - 1);
        }
        return wrappedStr;
    }

    public static String indent(String str, int numIndents) throws IOException {
        String indent = "";
        for (int i = 0; i < numIndents; ++i) {
            indent = indent + "\t";
        }
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);
        StringReader sRdr = new StringReader(str);
        BufferedReader bRdr = new BufferedReader(sRdr);
        String line = bRdr.readLine();
        while (line != null) {
            pWtr.print(indent);
            pWtr.println(line);
            line = bRdr.readLine();
        }
        sWtr.close();
        String indentedStr = sWtr.toString();
        if (indentedStr.length() > 0) {
            indentedStr = indentedStr.substring(0, indentedStr.length() - 1);
        }
        return indentedStr;
    }

    public static String stripOutsideQuotes(String s) {
        boolean isQuoted = s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"");
        return isQuoted ? s.substring(1, s.length() - 1) : s;
    }
}

