/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.iterators;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class Compressor {
    private File inFile;
    private File outFile;
    private BufferedReader reader;
    private BufferedWriter writer;
    private int comp;
    private static final int kNotAssigned = 0;
    public static final int kNoCompression = 1;
    public static final int kZipCompression = 2;
    public static final int kGZipCompression = 3;
    public static final int kBZipCompression = 4;
    private static final String gZipSuffix = ".zip";
    private static final String[] gGZipSuffixes = new String[]{".gz", ".bgz", ".tgz", ".taz", ".cpgz", ".z", ".gzip"};
    private static final String[] gBZipSuffixes = new String[]{".bz", ".bz2", ".tbz", ".tbz2"};

    public Compressor(File inFile, File outFile) throws IOException {
        this.inFile = inFile;
        this.outFile = outFile;
        this.reader = null;
        this.writer = null;
        this.comp = 0;
        this.buildAccessors(false);
    }

    public Compressor(File inFile, File outFile, boolean append) throws IOException {
        this.inFile = inFile;
        this.outFile = outFile;
        this.reader = null;
        this.writer = null;
        this.comp = 0;
        this.buildAccessors(append);
    }

    public void setInputStream(InputStream inStream, String name) {
        try {
            String suffix = Compressor.getSuffix(name);
            if (suffix != null && suffix.length() > 0) {
                if (Compressor.isZipSuffix(suffix)) {
                    this.makeZipReader(inStream);
                } else if (Compressor.isGZipSuffix(suffix)) {
                    this.makeGZipReader(inStream);
                } else if (Compressor.isBZipSuffix(suffix)) {
                    this.makeBZipReader(inStream);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(inStream));
        }
    }

    public final BufferedReader getReader() {
        return this.reader;
    }

    public final BufferedWriter getWriter() {
        return this.writer;
    }

    public final int getCompression() {
        return this.comp;
    }

    public static final int compressionUsed(File testFile) {
        String suffix = Compressor.getSuffix(testFile);
        if (suffix != null && suffix.length() > 0) {
            if (Compressor.isZipSuffix(suffix)) {
                return 2;
            }
            if (Compressor.isGZipSuffix(suffix)) {
                return 3;
            }
            if (Compressor.isBZipSuffix(suffix)) {
                return 4;
            }
        }
        return 1;
    }

    public final BufferedReader resetReader() throws IOException {
        File outHold = this.outFile;
        this.outFile = null;
        this.reader.close();
        this.reader = null;
        this.buildAccessors(false);
        this.outFile = outHold;
        return this.reader;
    }

    public static final String getSuffix(int compression) {
        switch (compression) {
            case 2: {
                return gZipSuffix;
            }
            case 3: {
                return gGZipSuffixes[0];
            }
            case 4: {
                return gBZipSuffixes[0];
            }
        }
        return "";
    }

    public static final String getSuffix(File file) {
        String name = file.getName();
        return Compressor.getSuffix(name);
    }

    public static final String getSuffix(String name) {
        int index = name.lastIndexOf(46);
        String end = index > 0 ? name.substring(index) : "";
        return end;
    }

    public static final boolean isZipSuffix(String suffix) {
        return suffix.equals(gZipSuffix);
    }

    public static final boolean isGZipSuffix(String suffix) {
        int numSuffix = gGZipSuffixes.length;
        for (int i = 0; i < numSuffix; ++i) {
            if (!suffix.equals(gGZipSuffixes[i])) continue;
            return true;
        }
        return false;
    }

    public static final boolean isBZipSuffix(String suffix) {
        int numSuffix = gBZipSuffixes.length;
        for (int i = 0; i < numSuffix; ++i) {
            if (!suffix.equals(gBZipSuffixes[i])) continue;
            return true;
        }
        return false;
    }

    public void buildAccessors(boolean append) throws IOException {
        String suffix;
        if (this.inFile != null) {
            suffix = Compressor.getSuffix(this.inFile);
            try {
                if (suffix != null && suffix.length() > 0) {
                    if (Compressor.isZipSuffix(suffix)) {
                        this.makeZipReader();
                    } else if (Compressor.isGZipSuffix(suffix)) {
                        this.makeGZipReader();
                    } else if (Compressor.isBZipSuffix(suffix)) {
                        this.makeBZipReader();
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.reader == null) {
                this.makeNormalReader();
            }
        }
        if (this.outFile != null) {
            suffix = Compressor.getSuffix(this.outFile);
            try {
                if (suffix != null && suffix.length() > 0) {
                    if (Compressor.isZipSuffix(suffix)) {
                        this.makeZipWriter();
                    } else if (Compressor.isGZipSuffix(suffix)) {
                        this.makeGZipWriter();
                    } else if (Compressor.isBZipSuffix(suffix)) {
                        this.makeBZipWriter();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.writer == null) {
                this.makeNormalWriter(append);
            }
        }
    }

    public BufferedReader makeNormalReader() throws IOException {
        FileReader rFile = new FileReader(this.inFile);
        this.reader = new BufferedReader(rFile);
        return this.reader;
    }

    public BufferedWriter makeNormalWriter(boolean append) throws IOException {
        FileWriter wFile = new FileWriter(this.outFile, append);
        this.writer = new BufferedWriter(wFile);
        return this.writer;
    }

    public void makeZipReader() throws IOException {
        if (this.inFile == null) {
            return;
        }
        this.makeZipReader(new FileInputStream(this.inFile));
    }

    public BufferedReader makeZipReader(InputStream inStream) throws IOException {
        ZipInputStream zipRead = new ZipInputStream(inStream);
        zipRead.getNextEntry();
        InputStreamReader rStream = new InputStreamReader(zipRead);
        this.reader = new BufferedReader(rStream);
        this.comp = 2;
        return this.reader;
    }

    public BufferedWriter makeZipWriter() throws IOException {
        if (this.outFile == null) {
            return null;
        }
        FileOutputStream outFileStream = new FileOutputStream(this.outFile);
        ZipOutputStream zipWrite = new ZipOutputStream(outFileStream);
        zipWrite.setMethod(8);
        zipWrite.setLevel(9);
        ZipEntry zE = new ZipEntry("Default");
        zipWrite.putNextEntry(zE);
        OutputStreamWriter wStream = new OutputStreamWriter(zipWrite);
        this.writer = new BufferedWriter(wStream);
        this.comp = 2;
        return this.writer;
    }

    public void makeGZipReader() throws IOException {
        if (this.inFile == null) {
            return;
        }
        this.makeGZipReader(new FileInputStream(this.inFile));
    }

    public BufferedReader makeGZipReader(InputStream inStream) throws IOException {
        GzipCompressorInputStream zipRead = new GzipCompressorInputStream(inStream, true);
        InputStreamReader rStream = new InputStreamReader((InputStream)zipRead);
        this.reader = new BufferedReader(rStream);
        this.comp = 3;
        return this.reader;
    }

    public BufferedWriter makeGZipWriter() throws IOException {
        if (this.outFile == null) {
            return null;
        }
        FileOutputStream outFileStream = new FileOutputStream(this.outFile);
        GzipCompressorOutputStream zipWrite = new GzipCompressorOutputStream((OutputStream)outFileStream);
        OutputStreamWriter wStream = new OutputStreamWriter((OutputStream)zipWrite);
        this.writer = new BufferedWriter(wStream);
        this.comp = 3;
        return this.writer;
    }

    public void makeBZipReader() throws IOException {
        if (this.inFile == null) {
            return;
        }
        this.makeBZipReader(new FileInputStream(this.inFile));
    }

    public BufferedReader makeBZipReader(InputStream inStream) throws IOException {
        BZip2CompressorInputStream zipRead = new BZip2CompressorInputStream(inStream);
        InputStreamReader rStream = new InputStreamReader((InputStream)zipRead);
        this.reader = new BufferedReader(rStream);
        this.comp = 4;
        return this.reader;
    }

    public BufferedWriter makeBZipWriter() throws IOException {
        if (this.outFile == null) {
            return null;
        }
        FileOutputStream outFileStream = new FileOutputStream(this.outFile);
        BZip2CompressorOutputStream zipWrite = new BZip2CompressorOutputStream((OutputStream)outFileStream);
        OutputStreamWriter wStream = new OutputStreamWriter((OutputStream)zipWrite);
        this.writer = new BufferedWriter(wStream);
        this.comp = 4;
        return this.writer;
    }
}

