/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.stats.svm.ItemValue;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.stats.svm.SimpleItemValue;

public class SimpleSVMTarget
implements SVMTarget {
    private Set itemTargetSet = new HashSet();
    private Map itemToItemTarget = new HashMap();

    public SimpleSVMTarget() {
    }

    public SimpleSVMTarget(Collection items) {
        this();
        Iterator i = items.iterator();
        while (i.hasNext()) {
            this.addItem(i.next());
        }
    }

    public Set items() {
        return this.itemToItemTarget.keySet();
    }

    public Set itemTargets() {
        return this.itemTargetSet;
    }

    public double getTarget(Object item) {
        return ((ItemValue)this.itemToItemTarget.get(item)).getValue();
    }

    public void setTarget(Object item, double target) {
        ItemValue iv = (ItemValue)this.itemToItemTarget.get(item);
        iv.setValue(target);
    }

    public void addItem(Object item) {
        SimpleItemValue iv = new SimpleItemValue(item, 0.0);
        this.itemToItemTarget.put(item, iv);
        this.itemTargetSet.add(iv);
    }

    public void addItemTarget(Object item, double target) {
        SimpleItemValue iv = new SimpleItemValue(item, target);
        this.itemToItemTarget.put(item, iv);
        this.itemTargetSet.add(iv);
    }

    public void removeItem(Object item) {
        this.itemToItemTarget.remove(item);
        this.itemTargetSet.remove(item);
    }

    public void clear() {
        this.itemToItemTarget.clear();
        this.itemTargetSet.clear();
    }
}

