/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.cli.CommandLineApp;
import edu.mayo.cli.CommandPlugin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class ConcatCommand
implements CommandPlugin {
    private static Logger sLogger = Logger.getLogger(CommandLineApp.class);
    private static final char OPTION_NO_ZIP = 'n';
    private static final char OPTION_INPUT_FILE = 'i';
    private static final char OPTION_OUTPUT_FILE = 'o';
    private static final char OPTION_SORT_INPUT_FILES = 's';

    public void init(Properties arg0) throws Exception {
    }

    public void execute(CommandLine cmdLine, Options options) throws Exception {
        String outfile = cmdLine.getOptionValue('o');
        boolean isZipOutput = !cmdLine.hasOption('n');
        boolean isInputFileListSorted = cmdLine.hasOption('s');
        sLogger.info((Object)("Output file: " + outfile));
        sLogger.info((Object)("Should output be zipped?: " + isZipOutput));
        sLogger.info((Object)("Sort the input files?: " + isInputFileListSorted));
        List<String> inputVcfs = Arrays.asList(cmdLine.getOptionValues('i'));
        sLogger.info((Object)"Input files (unsorted):");
        for (String input : inputVcfs) {
            sLogger.info((Object)("  " + input));
        }
        if (isInputFileListSorted) {
            Collections.sort(inputVcfs);
            sLogger.info((Object)"Sorted input file list:");
            for (String input : inputVcfs) {
                sLogger.info((Object)("  " + input));
            }
        }
        ConcatCommand.verifyInputFiles(inputVcfs);
        sLogger.info((Object)"Input files have been resolved");
        this.concatVcfs(inputVcfs, outfile, isZipOutput);
        sLogger.info((Object)"Done.");
    }

    private static void verifyInputFiles(List<String> inputVcfs) {
        if (inputVcfs == null || inputVcfs.size() == 0) {
            throw new IllegalArgumentException("No input vcf files were specified");
        }
        for (String inputVcf : inputVcfs) {
            if (new File(inputVcf).exists()) continue;
            throw new IllegalArgumentException("Input vcf file does not exist: " + inputVcf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concatVcfs(List<String> inputVcfPaths, String outputPath, boolean isZipOutput) throws FileNotFoundException, IOException {
        BufferedWriter fout = null;
        try {
            fout = isZipOutput ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(outputPath)))) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outputPath)));
            for (int i = 0; i < inputVcfPaths.size(); ++i) {
                String vcfInPath = inputVcfPaths.get(i);
                boolean isIncludeHeader = i == 0;
                this.writeFileContents(vcfInPath, fout, isIncludeHeader);
            }
        }
        finally {
            if (fout != null) {
                fout.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileContents(String vcfInPath, BufferedWriter fout, boolean isIncludeHeader) throws FileNotFoundException, IOException {
        BufferedReader fin = null;
        try {
            fin = this.isZippedInput(vcfInPath) ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(vcfInPath)))) : new BufferedReader(new InputStreamReader(new FileInputStream(vcfInPath)));
            String line = null;
            while ((line = fin.readLine()) != null) {
                if (!isIncludeHeader && line.startsWith("#")) continue;
                fout.write(line);
                fout.newLine();
            }
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
    }

    private boolean isZippedInput(String filePath) {
        boolean isZip = false;
        try {
            FileInputStream fin = new FileInputStream(filePath);
            PushbackInputStream pb = new PushbackInputStream(fin, 2);
            byte[] signature = new byte[2];
            pb.read(signature);
            pb.unread(signature);
            isZip = signature[0] == 31 && signature[1] == -117;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return isZip;
    }
}

