/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.pipes.bioinformatics.HeaderFieldDefinition;
import edu.mayo.pipes.bioinformatics.InfoHeaderFieldDefinition;
import edu.mayo.pipes.bioinformatics.MetaHeaderFieldDefinition;
import edu.mayo.pipes.bioinformatics.SampleDefinition;
import edu.mayo.pipes.bioinformatics.VCFHeaderParser;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import edu.mayo.pipes.bioinformatics.vocab.Type;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.GenomicObjectUtils;
import edu.mayo.senders.Sender;
import edu.mayo.senders.SystemOutSender;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;

public class VCF2VariantPipe
extends AbstractPipe<History, History> {
    private static final Logger sLogger = Logger.getLogger(VCF2VariantPipe.class);
    private Sender sender = new SystemOutSender("stderr");
    private static final int COL_CHROM = 0;
    private static final int COL_POS = 1;
    private static final int COL_ID = 2;
    private static final int COL_REF = 3;
    private static final int COL_ALT = 4;
    private static final int COL_QUAL = 5;
    private static final int COL_FILTER = 6;
    private static final int COL_INFO = 7;
    private static final int COL_FORMAT = 8;
    private static final String[] COL_HEADERS = new String[]{"CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER", "INFO"};
    private static final String NUMBER_SUPPORTING_SAMPLES = "NUMBER_SAMPLES";
    private boolean isHeaderProcessed = false;
    private int mDataLineNumber = 0;
    private HashMap<String, Integer> sampleKeys = new HashMap();
    private HashMap<String, Boolean> formatKeys = new HashMap();
    private VCFHeaderParser.WarningCallback senderCallback = new VCFHeaderParser.WarningCallback(){

        @Override
        public void warning(String message) {
            VCF2VariantPipe.this.sender.write(message);
        }
    };
    private VCFHeaderParser headerParser;
    private boolean allSamples = false;
    private boolean processSamples = false;
    boolean forceACANAF = false;
    public boolean firstSample = true;
    private int GenotypePostitiveCount = 0;
    private JsonArray GenotypePositiveSamples = new JsonArray();
    private JsonArray hetrozygus = new JsonArray();
    private JsonArray homozygus = new JsonArray();
    private JsonArray wildtype = new JsonArray();
    boolean hasSamplesChecked = false;

    public VCF2VariantPipe() {
    }

    public VCF2VariantPipe(Sender s) {
        this.sender = s;
    }

    public VCF2VariantPipe(boolean includeSamples) {
        this.processSamples = true;
    }

    public VCF2VariantPipe(Sender sender, boolean includeSamples) {
        this.sender = sender;
        this.processSamples = true;
    }

    public VCF2VariantPipe(boolean includeSamples, boolean AllSamples) {
        this.processSamples = true;
        this.allSamples = AllSamples;
    }

    public VCF2VariantPipe(Sender sender, boolean includeSamples, boolean AllSamples) {
        this.sender = sender;
        this.processSamples = true;
        this.allSamples = AllSamples;
    }

    protected History processNextStart() throws NoSuchElementException, InvalidPipeInputException {
        History history = (History)this.starts.next();
        ++this.mDataLineNumber;
        if (!this.isHeaderProcessed) {
            List<String> headerLines = history.getMetaData().getOriginalHeader();
            this.headerParser = new VCFHeaderParser(this.senderCallback);
            this.headerParser.parse(headerLines);
            this.isHeaderProcessed = true;
        }
        if (history.size() < COL_HEADERS.length) {
            int requiredColCount = COL_HEADERS.length;
            int actualColCount = history.size();
            StringBuilder sb = new StringBuilder();
            sb.append("Invalid VCF data line at data line # %s.\n");
            sb.append("The VCF format requires %s fixed fields per data line, but found only %s field(s).\n");
            sb.append("Make sure the VCF file has the necessary %s VCF fields delimited by TAB characters.\n");
            sb.append("Invalid VCF line content: \"%s\"");
            String errorMesg = String.format(sb.toString(), String.valueOf(this.mDataLineNumber), requiredColCount, actualColCount, requiredColCount, history.getMergedData("\t"));
            throw new InvalidPipeInputException(errorMesg, (Pipe)this);
        }
        this.hasSamples(history);
        String json = this.buildJSON(history);
        history.add(json);
        return history;
    }

    private String buildJSON(History history) {
        JsonObject root = new JsonObject();
        root.addProperty(COL_HEADERS[0], ((String)history.get(0)).trim());
        root.addProperty(COL_HEADERS[1], ((String)history.get(1)).trim());
        root.addProperty(COL_HEADERS[2], ((String)history.get(2)).trim());
        root.addProperty(COL_HEADERS[3], ((String)history.get(3)).trim());
        root.addProperty(COL_HEADERS[4], ((String)history.get(4)).trim());
        root.addProperty(COL_HEADERS[5], ((String)history.get(5)).trim());
        root.addProperty(COL_HEADERS[6], ((String)history.get(6)).trim());
        boolean error = false;
        for (int i = 0; i < 8; ++i) {
            String test = ((String)history.get(i)).trim();
            if (test.length() >= 1) continue;
            error = true;
        }
        if (error) {
            this.sender.write("ERROR: The following line does not have the required vcf fields (CHROM, POS, ID, REF, ALT, QUAL, FILTER, INFO, FORMAT): " + this.reformat(history));
        }
        JsonObject info = this.buildInfoJSON(((String)history.get(7)).trim(), history);
        root.add(COL_HEADERS[7], (JsonElement)info);
        this.addCoreAttributes(root, history);
        if (this.processSamples) {
            try {
                this.addSamples(root, history);
            }
            catch (ParseException ex) {
                this.sender.write("WARNING: Problem parsing samples: " + ex.getMessage());
            }
        }
        return root.toString();
    }

    public String reformat(List<String> line) {
        StringBuilder sb = new StringBuilder();
        for (String s : line) {
            sb.append(s);
            sb.append("\t");
        }
        String r = sb.toString();
        return r.substring(0, r.length() - 2);
    }

    private JsonObject buildInfoJSON(String infoCol, List<String> dataLine) {
        HeaderFieldDefinition defaultMeta = new HeaderFieldDefinition();
        defaultMeta.id = "not_defined";
        defaultMeta.number = 1;
        defaultMeta.type = HeaderFieldDefinition.ValueType.String;
        defaultMeta.fieldType = "INFO";
        JsonObject info = new JsonObject();
        for (String field : infoCol.split(";")) {
            if (field.indexOf(61) != -1) {
                int firstEq = field.indexOf(61);
                String id = field.substring(0, firstEq);
                String value = field.substring(firstEq + 1);
                HeaderFieldDefinition def = defaultMeta;
                if (this.headerParser.getInfoDefinition(id) != null) {
                    def = this.headerParser.getInfoDefinition(id);
                }
                if (def.number == null || def.number > 1) {
                    JsonArray arr = new JsonArray();
                    block19: for (String s : value.split(",")) {
                        switch (def.type) {
                            case Integer: {
                                if (this.isMissingValue(s)) continue block19;
                                try {
                                    arr.add((JsonElement)new JsonPrimitive((Number)Integer.parseInt(s.trim())));
                                }
                                catch (Exception e) {
                                    this.sender.write("WARNING: Invalid VCF Line, id=" + id + ", " + value.trim() + " does not appear to be an integer : " + this.reformat(dataLine));
                                }
                                continue block19;
                            }
                            case Float: {
                                if (this.isMissingValue(s)) continue block19;
                                try {
                                    arr.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(Float.parseFloat(s.trim()))));
                                }
                                catch (Exception e) {
                                    this.sender.write("WARNING: Invalid VCF Line, id=" + id + ", " + value.trim() + " does not appear to be a float : " + this.reformat(dataLine));
                                }
                                continue block19;
                            }
                            case Character: 
                            case String: {
                                arr.add((JsonElement)new JsonPrimitive(s));
                            }
                        }
                    }
                    if (arr.size() <= 0) continue;
                    info.add(id, (JsonElement)arr);
                    continue;
                }
                if (def.number != 1) continue;
                switch (def.type) {
                    case Integer: {
                        if (this.isMissingValue(value)) break;
                        try {
                            info.addProperty(id, (Number)Integer.parseInt(value.trim()));
                        }
                        catch (Exception e) {
                            this.sender.write("WARNING: Invalid VCF Line, id=" + id + ", " + value.trim() + " does not appear to be an integer : " + this.reformat(dataLine));
                        }
                        break;
                    }
                    case Float: {
                        if (this.isMissingValue(value)) break;
                        try {
                            info.addProperty(id, (Number)Float.valueOf(Float.parseFloat(value.trim())));
                        }
                        catch (Exception e) {
                            this.sender.write("WARNING: Invalid VCF Line, id=" + id + ", " + value.trim() + " does not appear to be a float : " + this.reformat(dataLine));
                        }
                        break;
                    }
                    case Character: 
                    case String: {
                        info.addProperty(id, value);
                    }
                }
                continue;
            }
            if (field.length() <= 0) continue;
            info.addProperty(field, Boolean.valueOf(true));
        }
        if (this.forceACANAF) {
            if (!info.has("AC")) {
                info.addProperty("AC", (Number)-1);
            }
            if (!info.has("AN")) {
                info.addProperty("AN", (Number)-1);
            }
            if (!info.has("AF")) {
                info.addProperty("AF", (Number)-1);
            }
        }
        return info;
    }

    public boolean getForceACANAF() {
        return this.forceACANAF;
    }

    public void setForceACANAF(boolean forceACANAF) {
        this.forceACANAF = forceACANAF;
    }

    private void addCoreAttributes(JsonObject root, List<String> history) {
        String accID = history.get(2).trim();
        root.addProperty(CoreAttributes._id.toString(), accID);
        root.addProperty(CoreAttributes._type.toString(), Type.VARIANT.toString());
        String chr = GenomicObjectUtils.computechr(history.get(0).trim());
        root.addProperty(CoreAttributes._landmark.toString(), chr);
        String refAllele = history.get(3).trim();
        root.addProperty(CoreAttributes._refAllele.toString(), refAllele);
        JsonArray altAlleles = new JsonArray();
        for (String allele : this.al(history.get(4).trim())) {
            altAlleles.add((JsonElement)new JsonPrimitive(allele));
        }
        root.add(CoreAttributes._altAlleles.toString(), (JsonElement)altAlleles);
        if (history.get(1) != null) {
            String pos = history.get(1).trim();
            int minBP = new Integer(pos);
            int maxBP = new Integer(minBP + history.get(3).trim().length() - 1);
            root.addProperty(CoreAttributes._minBP.toString(), (Number)minBP);
            root.addProperty(CoreAttributes._maxBP.toString(), (Number)maxBP);
        }
    }

    private String[] al(String raw) {
        ArrayList<String> finalList = new ArrayList<String>();
        if (raw.contains(",")) {
            String[] split = raw.split(",");
            for (int i = 0; i < split.length; ++i) {
                finalList.add(split[i]);
            }
        } else {
            finalList.add(raw);
        }
        return finalList.toArray(new String[0]);
    }

    private boolean isMissingValue(String value) {
        String trimVal = value.trim();
        return trimVal.equals(".");
    }

    private void addSamples(JsonObject root, History history) throws ParseException {
        this.GenotypePostitiveCount = 0;
        this.GenotypePositiveSamples = new JsonArray();
        this.hetrozygus = new JsonArray();
        this.homozygus = new JsonArray();
        this.wildtype = new JsonArray();
        if (this.firstSample) {
            String[] tokens;
            if (history.getMetaData().getColumns().size() > 8) {
                String format = history.getMetaData().getColumns().get(8).getColumnName();
                if (!format.contains("FORMAT")) {
                    return;
                }
            } else {
                return;
            }
            for (String tok : tokens = ((String)history.get(8)).split(":")) {
                this.formatKeys.put(tok, true);
            }
            JsonArray samples = new JsonArray();
            for (int i = 9; i < history.size(); ++i) {
                String col = history.getMetaData().getColumns().get(i).getColumnName();
                this.parseSample((String)history.get(i), samples, col, tokens);
                this.sampleKeys.put(col, i + 1);
            }
            root.add("samples", (JsonElement)samples);
            JsonObject format = this.buildFormatJSON(history);
            format.addProperty("GenotypePostitiveCount", (Number)this.GenotypePostitiveCount);
            format.add("GenotypePositiveList", (JsonElement)this.GenotypePositiveSamples);
            format.add("HeterozygousList", (JsonElement)this.hetrozygus);
            format.add("HomozygousList", (JsonElement)this.homozygus);
            format.add("WildtypeList", (JsonElement)this.wildtype);
            root.add("FORMAT", (JsonElement)format);
            JsonObject custom = new JsonObject();
            this.performCustomFormatFieldLogic(custom, history);
            root.add("CUSTOM", (JsonElement)custom);
        }
    }

    private int findGT(String[] t) {
        return this.findT(t, "GT");
    }

    private int findPL(String[] t) {
        return this.findT(t, "PL");
    }

    private int findAD(String[] t) {
        return this.findT(t, "AD");
    }

    private int findT(String[] t, String tok) {
        for (int i = 0; i < t.length; ++i) {
            if (!t[i].equalsIgnoreCase(tok)) continue;
            return i;
        }
        return -1;
    }

    public boolean sampleHasVariant(String genotype) {
        String s1 = genotype.replaceAll("\\.", "");
        String s2 = s1.replaceAll("0", "");
        String s3 = s2.replaceAll("\\|", "");
        String s4 = s3.replaceAll("/", "");
        return s4.length() > 0;
    }

    public boolean sampleHasNoVariantData(String genotype) {
        return genotype.startsWith(".");
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    public void parseSample(String sampleID, JsonArray samples, String sampleName, String[] tokens) throws ParseException {
        String[] split = sampleID.split(":");
        if (split.length > tokens.length) {
            String message = "WARNING: VCF2VariantPipe.parseSample: the number of tokens in the format field (" + tokens.length + ") and the number of tokens in the sample (" + split.length + ") do not agree. \nFORMAT:" + Arrays.toString(tokens) + "\nSAMPLE: " + sampleID + "\n";
            this.sender.write(message);
            throw new ParseException(message, 0);
        }
        int GTPosition = this.findGT(tokens);
        JsonObject genotype = new JsonObject();
        for (int i = 0; i < split.length; ++i) {
            if (split[i].contains(",")) {
                String[] arr = split[i].split(",");
                JsonArray jarr = new JsonArray();
                ArrayList<Double> values = new ArrayList<Double>();
                for (int j = 0; j < arr.length; ++j) {
                    if (VCF2VariantPipe.isNumeric(arr[j])) {
                        double d = Double.parseDouble(arr[j].trim());
                        jarr.add((JsonElement)new JsonPrimitive((Number)d));
                        values.add(d);
                        continue;
                    }
                    jarr.add((JsonElement)new JsonPrimitive(arr[j]));
                }
                genotype.add(tokens[i], (JsonElement)jarr);
                continue;
            }
            if (VCF2VariantPipe.isNumeric(split[i])) {
                genotype.addProperty(tokens[i], (Number)Double.parseDouble(split[i]));
                continue;
            }
            genotype.addProperty(tokens[i], split[i]);
        }
        if (GTPosition > -1) {
            Zygocity zygocity = this.calculateZygosity(split[GTPosition]);
            if (this.sampleHasVariant(split[GTPosition])) {
                JsonPrimitive zy;
                genotype.addProperty("GenotypePositive", (Number)1);
                ++this.GenotypePostitiveCount;
                JsonPrimitive prim = new JsonPrimitive(sampleName);
                this.GenotypePositiveSamples.add((JsonElement)prim);
                if (zygocity == Zygocity.Heterozygous) {
                    zy = new JsonPrimitive(sampleName);
                    this.hetrozygus.add((JsonElement)zy);
                } else if (zygocity == Zygocity.Homozygous) {
                    zy = new JsonPrimitive(sampleName);
                    this.homozygus.add((JsonElement)zy);
                }
            } else if (zygocity == Zygocity.WildType) {
                JsonPrimitive zy = new JsonPrimitive(sampleName);
                this.wildtype.add((JsonElement)zy);
            }
        }
        genotype.addProperty("sampleID", sampleName);
        if (this.hasCustomFormatField(tokens)) {
            // empty if block
        }
        if (this.allSamples) {
            samples.add((JsonElement)genotype);
        } else if (GTPosition > -1 && !this.sampleHasNoVariantData(split[GTPosition])) {
            samples.add((JsonElement)genotype);
        }
    }

    public JsonObject performCustomFormatFieldLogic(JsonObject custom, List<String> h) {
        JsonObject max = this.getSubClause(custom, "max");
        JsonObject min = this.getSubClause(custom, "min");
        Totals totalAD = new Totals();
        try {
            int i;
            String format = h.get(8);
            String[] formatTokens = format.split(":");
            int ADpos = -1;
            for (i = 0; i < formatTokens.length; ++i) {
                if (!formatTokens[i].equalsIgnoreCase("AD")) continue;
                ADpos = i;
            }
            for (i = 9; i < h.size(); ++i) {
                String[] sample = h.get(i).split(":");
                if (sample.length <= ADpos || ADpos == -1 || !sample[ADpos].contains(",") || !this.isNumericList(sample[ADpos], ",")) continue;
                ArrayList<Double> ADvalues = this.parseNumericList(sample[ADpos], ",");
                totalAD = this.addMinMaxAD(totalAD, ADvalues);
            }
        }
        catch (Exception e) {
            this.sender.write("WARNING: Parsing failed in, \"performCustomFormatFieldLogic\" we can't add all of the custom calculations for this variant, so some will be left out, default total values will be placed in the field: \n" + h.toString() + "\n" + e.getMessage());
        }
        max.addProperty("AD", (Number)totalAD.max);
        min.addProperty("AD", (Number)totalAD.min);
        return custom;
    }

    public boolean hasCustomFormatField(String[] tokens) {
        return 0 >= this.findAD(tokens);
    }

    public Totals addMinMaxAD(Totals totals, ArrayList<Double> values) {
        for (int i = 1; i < values.size(); ++i) {
            Double d = values.get(i);
            totals.allValues.add(d);
            if (d > totals.max) {
                totals.max = d;
            }
            if (!(d < totals.min)) continue;
            totals.min = d;
        }
        return totals;
    }

    public JsonObject getSubClause(JsonObject root, String subObjectName) {
        JsonObject subObject = root.getAsJsonObject(subObjectName);
        if (subObject == null) {
            subObject = new JsonObject();
            root.add(subObjectName, (JsonElement)subObject);
            return subObject;
        }
        return subObject;
    }

    public Zygocity calculateZygosity(String GT) {
        int zerocount = 0;
        int dotcount = 0;
        GT = GT.replaceAll("\\|", "/");
        String[] tokens = GT.split("/");
        int count = 0;
        for (String token : tokens) {
            if (token.trim().equalsIgnoreCase("0") || token.trim().equalsIgnoreCase(".")) {
                if (token.trim().equalsIgnoreCase("0")) {
                    ++zerocount;
                    continue;
                }
                ++dotcount;
                continue;
            }
            if (!token.matches(".*[0-9]+.*")) continue;
            ++count;
        }
        if (count == 1) {
            return Zygocity.Heterozygous;
        }
        if (count > 1) {
            return Zygocity.Homozygous;
        }
        if (zerocount > 1) {
            return Zygocity.WildType;
        }
        return Zygocity.NoCall;
    }

    public JsonObject buildFormatJSON(List<String> dataLine) {
        JsonObject format = new JsonObject();
        String formatStr = dataLine.get(8);
        String[] formatTokens = formatStr.split(":");
        if (formatTokens.length < 1) {
            return format;
        }
        HashMap<String, List<Double>> allVals = this.getSampleVals4Row(dataLine, formatTokens);
        JsonObject max = new JsonObject();
        JsonObject min = new JsonObject();
        for (String key : allVals.keySet()) {
            max.addProperty(key, (Number)VCF2VariantPipe.max(allVals.get(key)));
            min.addProperty(key, (Number)VCF2VariantPipe.min(allVals.get(key)));
        }
        format.add("max", (JsonElement)max);
        format.add("min", (JsonElement)min);
        return format;
    }

    public HashMap<String, List<Double>> getSampleVals4Row(List<String> dataLine, String[] formatTokens) {
        HashMap<String, List<Double>> allVals = new HashMap<String, List<Double>>();
        for (int i = 9; i < dataLine.size(); ++i) {
            String[] values = dataLine.get(i).split(":");
            if (values.length != formatTokens.length) continue;
            for (int j = 0; j < formatTokens.length; ++j) {
                List<Double> all;
                if (formatTokens[j].equals("GT") || values[j].equalsIgnoreCase(".")) continue;
                if (VCF2VariantPipe.isNumeric(values[j])) {
                    Double d = new Double(values[j]);
                    all = allVals.get(formatTokens[j]);
                    if (all == null) {
                        all = new ArrayList<Double>();
                    }
                    all.add(d);
                    allVals.put(formatTokens[j], all);
                    continue;
                }
                if (!this.isNumericList(values[j], ",")) continue;
                ArrayList<Double> l = this.parseNumericList(values[j], ",");
                all = allVals.get(formatTokens[j]);
                if (all == null) {
                    all = new ArrayList<Double>();
                }
                for (Double d : l) {
                    all.add(d);
                }
                allVals.put(formatTokens[j], all);
            }
        }
        return allVals;
    }

    public boolean isNumericList(String s, String delim) {
        String[] nums = s.split(delim);
        if (nums.length < 2) {
            return false;
        }
        for (int i = 0; i < nums.length; ++i) {
            if (VCF2VariantPipe.isNumeric(nums[i])) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Double> parseNumericList(String s, String delim) {
        ArrayList<Double> v = new ArrayList<Double>();
        String[] nums = s.split(delim);
        if (nums.length < 2) {
            return new ArrayList<Double>();
        }
        for (int i = 0; i < nums.length; ++i) {
            if (!VCF2VariantPipe.isNumeric(nums[i].trim())) {
                return new ArrayList<Double>();
            }
            v.add(new Double(nums[i].trim()));
        }
        return v;
    }

    public JsonObject getJSONMetadata() {
        JsonObject json = new JsonObject();
        JsonObject header = new JsonObject();
        JsonObject format = new JsonObject();
        JsonObject samples = new JsonObject();
        JsonObject infoJSON = new JsonObject();
        for (InfoHeaderFieldDefinition def : this.headerParser.getInfoDefinitions()) {
            JsonObject jsonDef = new JsonObject();
            this.addCommonProperties(def, jsonDef);
            if (def.source != null) {
                jsonDef.addProperty("Source", def.source);
            }
            if (def.version != null) {
                jsonDef.addProperty("Version", def.version);
            }
            infoJSON.add(def.id, (JsonElement)jsonDef);
        }
        header.add("INFO", (JsonElement)infoJSON);
        JsonObject formatJSON = new JsonObject();
        for (HeaderFieldDefinition def : this.headerParser.getFormatDefinitions()) {
            JsonObject jsonDef = new JsonObject();
            this.addCommonProperties(def, jsonDef);
            formatJSON.add(def.id, (JsonElement)jsonDef);
        }
        header.add("FORMAT", (JsonElement)formatJSON);
        JsonObject metaJSON = new JsonObject();
        for (MetaHeaderFieldDefinition def : this.headerParser.getMetaDefinitions()) {
            JsonObject jsonDef = new JsonObject();
            this.addCommonProperties(def, jsonDef);
            JsonArray valueArr = new JsonArray();
            for (Object value : def.values) {
                JsonPrimitive p;
                switch (def.type) {
                    case Integer: {
                        p = new JsonPrimitive((Number)((Integer)value));
                        break;
                    }
                    case Float: {
                        p = new JsonPrimitive((Number)((Float)value));
                        break;
                    }
                    default: {
                        p = new JsonPrimitive(value.toString());
                    }
                }
                valueArr.add((JsonElement)p);
            }
            jsonDef.add("Values", (JsonElement)valueArr);
            metaJSON.add(def.id, (JsonElement)jsonDef);
        }
        header.add("META", (JsonElement)metaJSON);
        for (String key : this.formatKeys.keySet()) {
            format.addProperty(key, (Number)1);
        }
        for (String key : this.sampleKeys.keySet()) {
            samples.addProperty(key, (Number)this.sampleKeys.get(key));
        }
        json.add("HEADER", (JsonElement)header);
        json.add("FORMAT", (JsonElement)format);
        json.add("SAMPLES", (JsonElement)samples);
        return json;
    }

    private void addCommonProperties(HeaderFieldDefinition def, JsonObject jsonDef) {
        if (def.number == null) {
            jsonDef.addProperty("number", ".");
        } else {
            jsonDef.addProperty("number", (Number)def.number);
        }
        jsonDef.addProperty("type", def.type.toString());
        jsonDef.addProperty("Description", def.desc);
        jsonDef.addProperty("EntryType", def.fieldType);
    }

    public static double min(List<Double> m) {
        double min = Double.MAX_VALUE;
        for (double d : m) {
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public static double max(List<Double> m) {
        double max = Double.NEGATIVE_INFINITY;
        for (double d : m) {
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public static double average(List<Double> m) {
        double sum = 0.0;
        for (double d : m) {
            sum += d;
        }
        if (m.size() == 0) {
            return Double.NaN;
        }
        return sum / (double)m.size();
    }

    public static double median(double[] m) {
        int middle = m.length / 2;
        if (m.length % 2 == 1) {
            return m[middle];
        }
        return (m[middle - 1] + m[middle]) / 2.0;
    }

    public boolean hasSamples(History h) {
        this.hasSamplesChecked = true;
        if (true) {
            return this.processSamples;
        }
        if (!this.processSamples) {
            return this.processSamples;
        }
        if (h.size() < 10) {
            this.hasSamplesChecked = true;
            this.processSamples = false;
            return false;
        }
        this.hasSamplesChecked = true;
        return true;
    }

    public Iterator<SampleDefinition> getSampleDefinitions() {
        return this.headerParser.getSampleDefinitions().iterator();
    }

    public Set<String> getFormatKeys() {
        return this.formatKeys.keySet();
    }

    public static enum Zygocity {
        WildType(0),
        Heterozygous(1),
        Homozygous(2),
        NoCall(3);

        private int type = 0;

        private Zygocity(int t) {
            this.type = t;
        }

        public int getType() {
            return this.type;
        }
    }

    private class Totals {
        public Double min = Double.MAX_VALUE;
        public Double max = Double.MIN_VALUE;
        public List<Double> allValues = new ArrayList<Double>();

        private Totals() {
        }
    }
}

