/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat;

public class VariantInfo {
    private String chromosome;
    private String ref;
    private String alt;
    private int startPos;
    private int endPos;
    private int entrezGeneID;
    private int firstBuild;
    private String dbSNPsID;
    private String suspectRegion;
    private String clinicalSig;
    private String alleleOrigin;
    private boolean diseaseVariant;
    private String geneSymbol;
    private String ensemblGeneID;
    private int mutationID;
    private String cosmicCDS;
    private String cosmicAA;
    private boolean strand;
    private String omimDisease;
    private boolean blacklisted;
    private boolean conserved;
    private boolean enhancer;
    private boolean tfbs;
    private boolean tss;
    private boolean unique;
    private boolean repeat;
    private boolean regulatory;
    private String landmark;
    private String type;
    private int minBP;
    private int maxBP;
    private boolean miRStrand;
    private String acc;
    private String miRBId;

    public VariantInfo(String chromosome, int startPos, int endPos, String ref, String alt, int entrezGeneID, int firstBuild, String dbSNPsID, String suspectRegion, String clinicalSig, String alleleOrigin, boolean diseaseVariant, String geneSymbol, String ensemblGeneID, int mutationID, String cosmicCDS, String cosmicAA, boolean strand, String omimDisease, boolean blacklisted, boolean conserved, boolean enhancer, boolean tfbs, boolean tss, boolean unique, boolean repeat, boolean regulatory, String landmark, String type, int minBP, int maxBP, boolean miRStrand, String acc, String id) {
        this.chromosome = chromosome;
        this.startPos = startPos;
        this.endPos = endPos;
        this.ref = ref;
        this.alt = alt;
        this.entrezGeneID = entrezGeneID;
        this.firstBuild = firstBuild;
        this.geneSymbol = geneSymbol;
        this.dbSNPsID = dbSNPsID;
        this.ensemblGeneID = ensemblGeneID;
        this.mutationID = mutationID;
        this.cosmicCDS = cosmicCDS;
        this.cosmicAA = cosmicAA;
        this.strand = strand;
        this.omimDisease = omimDisease;
        this.blacklisted = blacklisted;
        this.conserved = conserved;
        this.enhancer = enhancer;
        this.tfbs = tfbs;
        this.tss = tss;
        this.unique = unique;
        this.repeat = repeat;
        this.regulatory = regulatory;
        this.landmark = landmark;
        this.type = type;
        this.minBP = minBP;
        this.maxBP = maxBP;
        this.miRStrand = miRStrand;
        this.acc = acc;
        this.miRBId = id;
    }

    public final String getChromosome() {
        return this.chromosome;
    }

    public final String getRef() {
        return this.ref;
    }

    public final String getAlt() {
        return this.alt;
    }

    public final int getStartPos() {
        return this.startPos;
    }

    public final int getEndPos() {
        return this.endPos;
    }

    public final int getEntrezGeneID() {
        return this.entrezGeneID;
    }

    public final int getFirstBuild() {
        return this.firstBuild;
    }

    public final String getDbSNPsID() {
        return this.dbSNPsID;
    }

    public final String getSuspectRegion() {
        return this.suspectRegion;
    }

    public final String getClinicalSig() {
        return this.clinicalSig;
    }

    public final String getAlleleOrigin() {
        return this.alleleOrigin;
    }

    public final boolean isDiseaseVariant() {
        return this.diseaseVariant;
    }

    public final String getGeneSymbol() {
        return this.geneSymbol;
    }

    public final String getEnsemblGeneID() {
        return this.ensemblGeneID;
    }

    public final int getMutationID() {
        return this.mutationID;
    }

    public final String getCosmicCDS() {
        return this.cosmicCDS;
    }

    public final String getCosmicAA() {
        return this.cosmicAA;
    }

    public final boolean isStrand() {
        return this.strand;
    }

    public final String getOMIMDisease() {
        return this.omimDisease;
    }

    public final boolean isBlacklisted() {
        return this.blacklisted;
    }

    public final boolean isConserved() {
        return this.conserved;
    }

    public final boolean isEnhancer() {
        return this.enhancer;
    }

    public final boolean isTfbs() {
        return this.tfbs;
    }

    public final boolean isTss() {
        return this.tss;
    }

    public final boolean isUnique() {
        return this.unique;
    }

    public final boolean isRepeat() {
        return this.repeat;
    }

    public final boolean isRegulatory() {
        return this.regulatory;
    }

    public final String getOmimDisease() {
        return this.omimDisease;
    }

    public final String getLandmark() {
        return this.landmark;
    }

    public final String getType() {
        return this.type;
    }

    public final int getMinBP() {
        return this.minBP;
    }

    public final int getMaxBP() {
        return this.maxBP;
    }

    public final boolean isMiRStrand() {
        return this.miRStrand;
    }

    public final String getAcc() {
        return this.acc;
    }

    public final String getId() {
        return this.miRBId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.blacklisted ? 1231 : 1237);
        result = 31 * result + (this.chromosome == null ? 0 : this.chromosome.hashCode());
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        result = 31 * result + (this.alt == null ? 0 : this.alt.hashCode());
        result = 31 * result + (this.conserved ? 1231 : 1237);
        result = 31 * result + (this.dbSNPsID == null ? 0 : this.dbSNPsID.hashCode());
        result = 31 * result + (this.suspectRegion == null ? 0 : this.suspectRegion.hashCode());
        result = 31 * result + (this.clinicalSig == null ? 0 : this.clinicalSig.hashCode());
        result = 31 * result + (this.alleleOrigin == null ? 0 : this.alleleOrigin.hashCode());
        result = 31 * result + (this.diseaseVariant ? 1231 : 1237);
        result = 31 * result + this.endPos;
        result = 31 * result + (this.enhancer ? 1231 : 1237);
        result = 31 * result + (this.ensemblGeneID == null ? 0 : this.ensemblGeneID.hashCode());
        result = 31 * result + this.entrezGeneID;
        result = 31 * result + this.firstBuild;
        result = 31 * result + (this.geneSymbol == null ? 0 : this.geneSymbol.hashCode());
        result = 31 * result + (this.omimDisease == null ? 0 : this.omimDisease.hashCode());
        result = 31 * result + (this.regulatory ? 1231 : 1237);
        result = 31 * result + (this.repeat ? 1231 : 1237);
        result = 31 * result + this.startPos;
        result = 31 * result + (this.tfbs ? 1231 : 1237);
        result = 31 * result + (this.tss ? 1231 : 1237);
        result = 31 * result + (this.unique ? 1231 : 1237);
        result = 31 * result + this.mutationID;
        result = 31 * result + (this.miRBId == null ? 0 : this.miRBId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariantInfo)) {
            return false;
        }
        VariantInfo other = (VariantInfo)obj;
        if (this.blacklisted != other.blacklisted) {
            return false;
        }
        if (this.diseaseVariant != other.diseaseVariant) {
            return false;
        }
        if (this.conserved != other.conserved) {
            return false;
        }
        if (this.endPos != other.endPos) {
            return false;
        }
        if (this.enhancer != other.enhancer) {
            return false;
        }
        if (this.entrezGeneID != other.entrezGeneID) {
            return false;
        }
        if (this.firstBuild != other.firstBuild) {
            return false;
        }
        if (this.regulatory != other.regulatory) {
            return false;
        }
        if (this.repeat != other.repeat) {
            return false;
        }
        if (this.startPos != other.startPos) {
            return false;
        }
        if (this.tfbs != other.tfbs) {
            return false;
        }
        if (this.tss != other.tss) {
            return false;
        }
        if (this.unique != other.unique) {
            return false;
        }
        if (this.mutationID != other.mutationID) {
            return false;
        }
        if (this.miRBId == null ? other.miRBId != null : !this.miRBId.equals(other.miRBId)) {
            return false;
        }
        if (this.chromosome == null ? other.chromosome != null : !this.chromosome.equals(other.chromosome)) {
            return false;
        }
        if (this.ref == null ? other.ref != null : !this.ref.equals(other.ref)) {
            return false;
        }
        if (this.alt == null ? other.alt != null : !this.alt.equals(other.alt)) {
            return false;
        }
        if (this.dbSNPsID == null ? other.dbSNPsID != null : !this.dbSNPsID.equals(other.dbSNPsID)) {
            return false;
        }
        if (this.ensemblGeneID == null ? other.ensemblGeneID != null : !this.ensemblGeneID.equals(other.ensemblGeneID)) {
            return false;
        }
        if (this.geneSymbol == null ? other.geneSymbol != null : !this.geneSymbol.equals(other.geneSymbol)) {
            return false;
        }
        if (this.omimDisease == null ? other.omimDisease != null : !this.omimDisease.equals(other.omimDisease)) {
            return false;
        }
        if (this.suspectRegion == null ? other.suspectRegion != null : !this.suspectRegion.equals(other.suspectRegion)) {
            return false;
        }
        if (this.clinicalSig == null ? other.clinicalSig != null : !this.clinicalSig.equals(other.clinicalSig)) {
            return false;
        }
        return !(this.alleleOrigin == null ? other.alleleOrigin != null : !this.alleleOrigin.equals(other.alleleOrigin));
    }

    public static String tabHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append("chromosome\tref\talt\tstartPos\tendPos\tentrezGeneID\tdbSNPsID\tfirstBuild\t");
        builder.append("alleleOrigin\tclinicalSig\tsuspectRegion\tdiseaseVariant\t");
        builder.append("geneSymbol\tensemblGeneID\tmutationID\tcosmicCDS\tcosmicAA\tstrand\tOMIMDisease\t");
        builder.append("blacklisted\tconserved\tenhancer\ttfbs\ttss\tunique\trepeat\tregulatory\t");
        builder.append("landmark\ttype\tmnBP\tmaxBP\tstrand\tacc\tID");
        return builder.toString();
    }

    public String toTabString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.chromosome);
        builder.append("\t");
        builder.append(this.ref);
        builder.append("\t");
        builder.append(this.alt);
        builder.append("\t");
        builder.append(this.startPos);
        builder.append("\t");
        builder.append(this.endPos);
        builder.append("\t");
        builder.append(this.entrezGeneID);
        builder.append("\t");
        builder.append(this.dbSNPsID);
        builder.append("\t");
        builder.append(this.firstBuild);
        builder.append("\t");
        builder.append(this.alleleOrigin);
        builder.append("\t");
        builder.append(this.clinicalSig);
        builder.append("\t");
        builder.append(this.suspectRegion);
        builder.append("\t");
        builder.append(this.diseaseVariant);
        builder.append("\t");
        builder.append(this.geneSymbol);
        builder.append("\t");
        builder.append(this.ensemblGeneID);
        builder.append("\t");
        if (this.mutationID > 0) {
            builder.append(this.mutationID);
            builder.append("\t");
            builder.append(this.cosmicCDS);
            builder.append("\t");
            builder.append(this.cosmicAA);
            if (this.strand) {
                builder.append("\t+\t");
            } else {
                builder.append("\t-\t");
            }
        } else {
            builder.append("-1\t\t\t\t");
        }
        builder.append(this.omimDisease);
        builder.append("\t");
        builder.append(this.blacklisted);
        builder.append("\t");
        builder.append(this.conserved);
        builder.append("\t");
        builder.append(this.enhancer);
        builder.append("\t");
        builder.append(this.tfbs);
        builder.append("\t");
        builder.append(this.tss);
        builder.append("\t");
        builder.append(this.unique);
        builder.append("\t");
        builder.append(this.repeat);
        builder.append("\t");
        builder.append(this.regulatory);
        if (this.miRBId != null) {
            builder.append("\t");
            builder.append(this.landmark);
            builder.append("\t");
            builder.append(this.type);
            builder.append("\t");
            builder.append(this.minBP);
            builder.append("\t");
            builder.append(this.maxBP);
            if (this.miRStrand) {
                builder.append("\t+\t");
            } else {
                builder.append("\t-\t");
            }
            builder.append(this.acc);
            builder.append("\t");
            builder.append(this.miRBId);
        } else {
            builder.append("\t\t\t\t\t\t\t");
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VariantInfo [chromosome = ");
        builder.append(this.chromosome);
        builder.append(", (");
        builder.append(this.ref);
        builder.append(" -> ");
        builder.append(this.alt);
        builder.append("), [");
        builder.append(this.startPos);
        if (this.endPos >= 0) {
            builder.append(", ");
            builder.append(this.endPos);
        }
        builder.append("], entrezGeneID = ");
        builder.append(this.entrezGeneID);
        builder.append(", dbSNPsID = ");
        builder.append(this.dbSNPsID);
        builder.append(", firstBuild = ");
        builder.append(this.firstBuild);
        builder.append(", alleleOrigin = ");
        builder.append(this.alleleOrigin);
        builder.append(", clinicalSig = ");
        builder.append(this.clinicalSig);
        builder.append(", suspectRegion = ");
        builder.append(this.suspectRegion);
        builder.append(", diseaseVariant = ");
        builder.append(this.diseaseVariant);
        builder.append(", geneSymbol = ");
        builder.append(this.geneSymbol);
        builder.append(", ensemblGeneID = ");
        builder.append(this.ensemblGeneID);
        builder.append(", mutationID = ");
        if (this.mutationID > 0) {
            builder.append(this.mutationID);
            builder.append(", cosmicCDS = ");
            builder.append(this.cosmicCDS);
            builder.append(", cosmicAA = ");
            builder.append(this.cosmicAA);
            builder.append(", strand = ");
            if (this.strand) {
                builder.append("+");
            } else {
                builder.append("-");
            }
        } else {
            builder.append("-1");
        }
        builder.append(", omimDisease = ");
        builder.append(this.omimDisease);
        builder.append(", blacklisted = ");
        builder.append(this.blacklisted);
        builder.append(", conserved = ");
        builder.append(this.conserved);
        builder.append(", enhancer = ");
        builder.append(this.enhancer);
        builder.append(", tfbs = ");
        builder.append(this.tfbs);
        builder.append(", tss = ");
        builder.append(this.tss);
        builder.append(", unique = ");
        builder.append(this.unique);
        builder.append(", repeat = ");
        builder.append(this.repeat);
        builder.append(", regulatory = ");
        builder.append(this.regulatory);
        builder.append("]");
        if (this.miRBId != null) {
            builder.append(", landmark = ");
            builder.append(this.landmark);
            builder.append(", type = ");
            builder.append(this.type);
            builder.append(", minBP = ");
            builder.append(this.minBP);
            builder.append(", maxBP = ");
            builder.append(this.maxBP);
            if (this.miRStrand) {
                builder.append(", miRStrand = '+'");
            } else {
                builder.append(", miRStrand = '-'");
            }
            builder.append(", acc = ");
            builder.append(this.acc);
            builder.append(", miRBId = ");
            builder.append(this.miRBId);
        } else {
            builder.append(", miRBId = Nothing");
        }
        return builder.toString();
    }
}

