/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.IdentityPipe;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.pipeline.Treat.Cleaner;
import edu.mayo.bior.pipeline.Treat.TreatPipe;
import edu.mayo.bior.util.BiorProperties;
import edu.mayo.pipes.JSON.DrillPipe;
import edu.mayo.pipes.JSON.RemoveAllJSONPipe;
import edu.mayo.pipes.JSON.tabix.SameVariantPipe;
import edu.mayo.pipes.bioinformatics.VCF2VariantPipe;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryMetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AlleleFrequenciesPipeline
extends Pipeline
implements Cleaner {
    private BiorProperties biorProps = new BiorProperties();
    private String baseDir;
    private boolean header = true;
    private int deleteColCount = 0;
    private int numCols = 0;
    private int firstCol = 0;
    private int refPos = 0;
    private int altPos = 0;
    private static final int kBGIMajorAllele = 0;
    private static final int kBGIMinorAllele = 1;
    private static final int kBGIMajorFreq = 2;
    private static final int kBGIMinorFreq = 3;
    private static final int kBGICols = 4;
    private static final String[] kBgiDrill = new String[]{"major_allele", "minor_allele", "estimated_major_allele_freq", "estimated_minor_allele_freq"};
    private static final int kESPCeuCounts = 0;
    private static final int kESPAfrCounts = 1;
    private static final int kESPTotalCounts = 2;
    private static final int kESPMAF = 3;
    private static final int kESPRefAllele = 4;
    private static final int kESPAltAllele = 5;
    private static final int kESPCols = 6;
    private static final String[] kEspDrill = new String[]{"INFO.EA_AC", "INFO.AA_AC", "INFO.TAC", "INFO.MAF", "_refAllele", "_altAlleles"};
    private static final int kHapMapRefAllele = 0;
    private static final int kHapMapAltAllele = 1;
    private static final int kHapMapCeuRefFreq = 2;
    private static final int kHapMapCeuAltFreq = 3;
    private static final int kHapMapYriRefFreq = 4;
    private static final int kHapMapYriAltFreq = 5;
    private static final int kHapMapJptRefCount = 6;
    private static final int kHapMapJptAltCount = 7;
    private static final int kHapMapJptTotalCount = 8;
    private static final int kHapMapChbRefCount = 9;
    private static final int kHapMapChbAltCount = 10;
    private static final int kHapMapChbTotalCount = 11;
    private static final int kHapMapCols = 12;
    private static final String[] kHapMapDrill = new String[]{"refallele", "otherallele", "CEU.refallele_freq", "CEU.otherallele_freq", "YRI.refallele_freq", "YRI.otherallele_freq", "JPT.refallele_count", "JPT.otherallele_count", "JPT.totalcount", "CHB.refallele_count", "CHB.otherallele_count", "CHB.totalcount"};
    private static final int k1kGenomeAll = 0;
    private static final int k1kGenomeEUR = 1;
    private static final int k1kGenomeASN = 2;
    private static final int k1kGenomeAFR = 3;
    private static final int k1kGenomeAMR = 4;
    private static final int k1kGenomeRef = 5;
    private static final int k1kGenomeAlt = 6;
    private static final int k1kGenomeCols = 7;
    private static final String[] k1kGenomeDrill = new String[]{"INFO.AF", "INFO.EUR_AF", "INFO.ASN_AF", "INFO.AFR_AF", "INFO.AMR_AF", "_refAllele", "_altAlleles"};
    private static final int kRefOffset = 0;
    private static final int kAltOffset = 1;
    private static final int kTotalOffset = 2;
    private static final int kNumOffsets = 3;
    private static final int kNumResults = 2;
    private static final String kBlank = ".";
    private static final String[] kBaseStrs = new String[]{"CHROM", "POS", "REF", "ALT"};
    private static final int kChromPos = 0;
    private static final int kPositionPos = 1;
    private static final int kRefPos = 2;
    private static final int kAltPos = 3;
    private static final String kEspEurMaf = "ESP6500_EUR_maf";
    private static final String kEspAfrMaf = "ESP6500_AFR_maf";
    private static final String kBGIFreq = "BGI200_Danish";
    private static final String[] kHapMapFreq = new String[]{"HapMap_CEU_allele_freq", "HapMap_YRI_allele_freq", "HapMap_JPT+CHB_allele_freq"};
    private static final String[] k1kGenomeFreq = new String[]{"1kGenome_EUR_allele_freq", "1kGenome_ASN_allele_freq", "1kGenome_AFR_allele_freq", "1kGenome_AMR_allele_freq"};
    private static final double kPercentAdjust = 100.0;
    protected static final boolean kConvertFromPercent = true;
    private static final boolean kDoNotConvert = false;
    private static final String kMajorSplit = ",";
    private static final String kMinorSplit = "/";

    public AlleleFrequenciesPipeline() throws IOException {
        this.baseDir = this.biorProps.get("fileBase");
        this.init((Pipe)new IdentityPipe(), (Pipe)new IdentityPipe(), false);
    }

    public AlleleFrequenciesPipeline(Pipe input, Pipe output) throws IOException {
        this.baseDir = this.biorProps.get("fileBase");
        this.init(input, output, false);
    }

    public AlleleFrequenciesPipeline(Pipe input, Pipe output, boolean clean) throws IOException {
        this.baseDir = this.biorProps.get("fileBase");
        this.init(input, output, clean);
    }

    public AlleleFrequenciesPipeline(Pipe input, Pipe output, String baseDir, boolean clean) throws IOException {
        if (baseDir != null) {
            this.baseDir = baseDir;
        }
        this.init(input, output, clean);
    }

    public void init(Pipe input, Pipe output, boolean clean) throws IOException {
        Object cleaner = clean ? new TransformFunctionPipe((PipeFunction)new TreatPipe(this)) : new IdentityPipe();
        if (this.baseDir == null) {
            this.baseDir = this.biorProps.get("fileBase");
        }
        if (this.baseDir == null) {
            this.baseDir = "";
        }
        String bgiFile = this.baseDir + this.biorProps.get("bgiFile");
        String espFile = this.baseDir + this.biorProps.get("espFile");
        String hapMapFile = this.baseDir + this.biorProps.get("hapMapFile");
        String genomeFile = this.baseDir + this.biorProps.get("kGenomeFile");
        String[] bgiDrill = kBgiDrill;
        String[] espDrill = kEspDrill;
        String[] hapMapDrill = kHapMapDrill;
        String[] genomeDrill = k1kGenomeDrill;
        int posCol = -1;
        Pipeline p = new Pipeline(new Pipe[]{input, new VCF2VariantPipe(), new SameVariantPipe(bgiFile, posCol), new DrillPipe(false, bgiDrill), new SameVariantPipe(espFile, posCol -= bgiDrill.length), new DrillPipe(false, espDrill), new SameVariantPipe(hapMapFile, posCol -= espDrill.length), new DrillPipe(false, hapMapDrill), new SameVariantPipe(genomeFile, posCol -= hapMapDrill.length), new DrillPipe(false, genomeDrill), new RemoveAllJSONPipe(), cleaner, output});
        this.setPipes(p.getPipes());
        this.deleteColCount = genomeDrill.length - posCol;
    }

    @Override
    public History doClean(History history) {
        if (this.header) {
            this.header = false;
            this.numCols = history.size();
            this.firstCol = this.numCols - this.deleteColCount + 1;
            int[] poses = AlleleFrequenciesPipeline.getPositions(history, kBaseStrs);
            this.refPos = poses[2];
            this.altPos = poses[3];
            HistoryMetaData metaData = history.getMetaData();
            List columns = metaData.getColumns();
            for (int i = this.numCols - 1; i >= this.firstCol; --i) {
                columns.remove(i);
            }
            this.addAlleleColumns(columns);
        }
        int startCol = this.firstCol;
        String ref = (String)history.get(this.refPos);
        String alt = (String)history.get(this.altPos);
        String bgiMajAllele = (String)history.get(startCol + 0);
        String bgiMinAllele = (String)history.get(startCol + 1);
        double bgiMajFreq = AlleleFrequenciesPipeline.parseDouble((String)history.get(startCol + 2), false);
        double bgiMinFreq = AlleleFrequenciesPipeline.parseDouble((String)history.get(startCol + 3), false);
        String espMafs = (String)history.get((startCol += 4) + 3);
        String hapRefAllele = (String)history.get((startCol += 6) + 0);
        String hapAltAllele = (String)history.get(startCol + 1);
        double hapCeuRefFreq = AlleleFrequenciesPipeline.parseDouble((String)history.get(startCol + 2), false);
        double hapCeuAltFreq = AlleleFrequenciesPipeline.parseDouble((String)history.get(startCol + 3), false);
        double hapYriRefFreq = AlleleFrequenciesPipeline.parseDouble((String)history.get(startCol + 4), false);
        double hapYriAltFreq = AlleleFrequenciesPipeline.parseDouble((String)history.get(startCol + 5), false);
        double[] hapJptChbFreq = AlleleFrequenciesPipeline.getCombinedFreq(history, startCol);
        double genomeEURFreq = AlleleFrequenciesPipeline.parseDouble((String)history.get((startCol += 12) + 1), false);
        double genomeASNFreq = AlleleFrequenciesPipeline.parseDouble((String)history.get(startCol + 2), false);
        double genomeAFRFreq = AlleleFrequenciesPipeline.parseDouble((String)history.get(startCol + 3), false);
        double genomeAMRFreq = AlleleFrequenciesPipeline.parseDouble((String)history.get(startCol + 4), false);
        String genomeRefAllele = (String)history.get(startCol + 5);
        String genomeAltAllele = (String)history.get(startCol + 6);
        for (int i = (startCol += 7) - 1; i >= this.firstCol; --i) {
            history.remove(i);
        }
        history.addAll(this.getESPMAFs(espMafs, ref, alt));
        history.add((Object)this.getBGIMAFs(bgiMajAllele, bgiMinAllele, bgiMajFreq, bgiMinFreq));
        history.add((Object)this.getHapMapMAFs(hapRefAllele, hapAltAllele, hapCeuRefFreq, hapCeuAltFreq));
        history.add((Object)this.getHapMapMAFs(hapRefAllele, hapAltAllele, hapYriRefFreq, hapYriAltFreq));
        history.add((Object)this.getHapMapMAFs(hapRefAllele, hapAltAllele, hapJptChbFreq[0], hapJptChbFreq[1]));
        history.add((Object)this.get1kGenomeMAFs(genomeRefAllele, genomeAltAllele, genomeEURFreq));
        history.add((Object)this.get1kGenomeMAFs(genomeRefAllele, genomeAltAllele, genomeASNFreq));
        history.add((Object)this.get1kGenomeMAFs(genomeRefAllele, genomeAltAllele, genomeAFRFreq));
        history.add((Object)this.get1kGenomeMAFs(genomeRefAllele, genomeAltAllele, genomeAMRFreq));
        return history;
    }

    private void addAlleleColumns(List<ColumnMetaData> columns) {
        columns.add(new ColumnMetaData(kEspEurMaf));
        columns.add(new ColumnMetaData(kEspAfrMaf));
        columns.add(new ColumnMetaData(kBGIFreq));
        for (String columnName : kHapMapFreq) {
            columns.add(new ColumnMetaData(columnName));
        }
        for (String columnName : k1kGenomeFreq) {
            columns.add(new ColumnMetaData(columnName));
        }
    }

    private List<String> getESPMAFs(String espMafs, String ref, String alt) {
        boolean hasAFR;
        int end;
        int len = espMafs.length();
        if (espMafs.equals(kBlank) || len < 4) {
            return AlleleFrequenciesPipeline.makeEmptiesList(2);
        }
        int pos = (espMafs = espMafs.substring(2, len - 2)).indexOf(34);
        if (pos < 0) {
            return AlleleFrequenciesPipeline.makeEmptiesList(2);
        }
        double ceuMaf = AlleleFrequenciesPipeline.parseDouble(espMafs.substring(0, pos), false);
        double afrMaf = Double.NaN;
        if ((pos = espMafs.indexOf(34, pos + 1) + 1) > 0 && (end = espMafs.indexOf(34, pos + 1)) > 0) {
            afrMaf = AlleleFrequenciesPipeline.parseDouble(espMafs.substring(pos, end), false);
        }
        boolean hasCEU = ceuMaf != 0.0 && !Double.isNaN(ceuMaf);
        boolean bl = hasAFR = afrMaf != 0.0 && !Double.isNaN(afrMaf);
        if (!hasCEU && !hasAFR) {
            return AlleleFrequenciesPipeline.makeEmptiesList(2);
        }
        ArrayList<String> results = new ArrayList<String>(2);
        char majorBase = ref.charAt(0);
        char minorBase = AlleleFrequenciesPipeline.getFirstBase(alt);
        if (hasCEU) {
            results.add(AlleleFrequenciesPipeline.makeAlleleFrequency(majorBase, minorBase, ceuMaf, 1.0 - ceuMaf));
        } else {
            results.add(kBlank);
        }
        if (hasAFR) {
            results.add(AlleleFrequenciesPipeline.makeAlleleFrequency(majorBase, minorBase, afrMaf, 1.0 - afrMaf));
        } else {
            results.add(kBlank);
        }
        return results;
    }

    private String getBGIMAFs(String bgiMajAllele, String bgiMinAllele, double bgiMajFreq, double bgiMinFreq) {
        boolean hasAlt;
        if (bgiMajAllele.equals(kBlank) || bgiMinAllele.equals(kBlank)) {
            return kBlank;
        }
        boolean hasRef = bgiMajFreq != 0.0 && !Double.isNaN(bgiMajFreq);
        boolean bl = hasAlt = bgiMinFreq != 0.0 && !Double.isNaN(bgiMinFreq);
        if (!hasRef || !hasAlt) {
            return kBlank;
        }
        char majorBase = bgiMajAllele.charAt(0);
        char minorBase = AlleleFrequenciesPipeline.getFirstBase(bgiMinAllele);
        return AlleleFrequenciesPipeline.makeAlleleFrequency(majorBase, minorBase, bgiMinFreq, bgiMajFreq);
    }

    private String getHapMapMAFs(String hapRefAllele, String hapAltAllele, double hapRefFreq, double hapAltFreq) {
        boolean hasAlt;
        if (hapRefAllele.equals(kBlank) || hapAltAllele.equals(kBlank)) {
            return kBlank;
        }
        boolean hasRef = hapRefFreq != 0.0 && !Double.isNaN(hapRefFreq);
        boolean bl = hasAlt = hapAltFreq != 0.0 && !Double.isNaN(hapAltFreq);
        if (!hasRef || !hasAlt) {
            return kBlank;
        }
        char majorBase = hapRefAllele.charAt(0);
        char minorBase = AlleleFrequenciesPipeline.getFirstBase(hapAltAllele);
        return AlleleFrequenciesPipeline.makeAlleleFrequency(majorBase, minorBase, hapAltFreq, hapRefFreq);
    }

    private String get1kGenomeMAFs(String ref, String alt, double altFreq) {
        if (altFreq == 0.0 || Double.isNaN(altFreq)) {
            return kBlank;
        }
        char majorBase = ref.charAt(0);
        char minorBase = AlleleFrequenciesPipeline.getFirstBase(alt);
        return AlleleFrequenciesPipeline.makeAlleleFrequency(majorBase, minorBase, altFreq, 1.0 - altFreq);
    }

    private static final int[] getPositions(History history, String[] baseStrs) {
        HistoryMetaData metaData = history.getMetaData();
        List columns = metaData.getColumns();
        int numStrs = baseStrs.length;
        int[] results = new int[numStrs];
        int leftToFind = numStrs;
        for (int i = 0; i < numStrs; ++i) {
            results[i] = -1;
        }
        int pos = 0;
        for (ColumnMetaData column : columns) {
            String test = column.getColumnName().toUpperCase();
            for (int i = 0; i < numStrs; ++i) {
                if (!test.equals(baseStrs[i])) continue;
                results[i] = pos;
                if (--leftToFind != 0) break;
                return results;
            }
            ++pos;
        }
        return results;
    }

    private static final double[] getCombinedFreq(History history, int startCol) {
        int[] jptCounts = AlleleFrequenciesPipeline.getCounts(history, startCol + 6);
        int[] chbCounts = AlleleFrequenciesPipeline.getCounts(history, startCol + 9);
        int ref = jptCounts[0] + chbCounts[0];
        int alt = jptCounts[1] + chbCounts[1];
        int total = jptCounts[2] + chbCounts[2];
        double[] results = new double[2];
        if (total == 0 || alt == 0) {
            results[0] = Double.NaN;
            results[0] = Double.NaN;
        } else {
            results[0] = (double)ref / (double)total;
            results[1] = (double)alt / (double)total;
        }
        return results;
    }

    private static final int[] getCounts(History history, int startCol) {
        int[] results = new int[]{AlleleFrequenciesPipeline.parseInt((String)history.get(startCol + 0)), AlleleFrequenciesPipeline.parseInt((String)history.get(startCol + 1)), AlleleFrequenciesPipeline.parseInt((String)history.get(startCol + 2))};
        return results;
    }

    private static final char getFirstBase(String baseStr) {
        char base;
        int i;
        baseStr = baseStr.toUpperCase();
        int numBases = baseStr.length();
        for (i = 0; i < numBases; ++i) {
            base = baseStr.charAt(i);
            switch (base) {
                case 'A': 
                case 'C': 
                case 'G': 
                case 'T': {
                    return base;
                }
            }
        }
        for (i = 0; i < numBases; ++i) {
            base = baseStr.charAt(i);
            if (!Character.isLetter(base)) continue;
            return base;
        }
        return 'A';
    }

    private static final String makeAlleleFrequency(char ref, char alt, double minor, double major) {
        StringBuilder result = new StringBuilder();
        result.append(alt);
        result.append(kMinorSplit);
        result.append(ref);
        result.append(kMajorSplit);
        result.append(minor);
        result.append(kMinorSplit);
        result.append(major);
        return result.toString();
    }

    private static final List<String> makeEmptiesList(int count) {
        ArrayList<String> results = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            results.add(kBlank);
        }
        return results;
    }

    private static final int parseInt(String theInt) {
        int result = 0;
        if (!theInt.equals(kBlank)) {
            try {
                result = Integer.parseInt(theInt);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private static final double parseDouble(String theDouble, boolean convertFromPercent) {
        double result = Double.NaN;
        if (!theDouble.equals(kBlank)) {
            try {
                result = Double.parseDouble(theDouble);
                if (convertFromPercent) {
                    result /= 100.0;
                }
            }
            catch (NumberFormatException oops) {
                // empty catch block
            }
        }
        return result;
    }
}

