/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Fmath;
import flanagan.math.MinimisationFunction;
import flanagan.math.MinimizationFunction;
import java.util.ArrayList;

public class Minimisation {
    protected boolean iseOption = true;
    protected int nParam = 0;
    protected double[] paramValue = null;
    protected String[] paraName = null;
    protected double functValue = 0.0;
    protected double lastFunctValNoCnstrnt = 0.0;
    protected double minimum = 0.0;
    protected int prec = 4;
    protected int field = 13;
    protected boolean convStatus = false;
    protected boolean suppressNoConvergenceMessage = false;
    protected int scaleOpt = 0;
    protected double[] scale = null;
    protected boolean penalty = false;
    protected boolean sumPenalty = false;
    protected int nConstraints = 0;
    protected int nSumConstraints = 0;
    protected int maxConstraintIndex = -1;
    protected ArrayList<Object> penalties = new ArrayList();
    protected ArrayList<Object> sumPenalties = new ArrayList();
    protected int[] penaltyCheck = null;
    protected int[] sumPenaltyCheck = null;
    protected double penaltyWeight = 1.0E30;
    protected int[] penaltyParam = null;
    protected int[][] sumPenaltyParam = null;
    protected double[][] sumPlusOrMinus = null;
    protected int[] sumPenaltyNumber = null;
    protected double[] constraints = null;
    protected double constraintTolerance = 1.0E-4;
    protected double[] sumConstraints = null;
    protected int constraintMethod = 0;
    protected int nMax = 3000;
    protected int nIter = 0;
    protected int konvge = 3;
    protected int kRestart = 0;
    protected double fTol = 1.0E-13;
    protected double rCoeff = 1.0;
    protected double eCoeff = 2.0;
    protected double cCoeff = 0.5;
    protected double[] startH = null;
    protected double[] step = null;
    protected double dStep = 0.5;
    protected int minTest = 0;
    protected double simplexSd = 0.0;

    public void suppressNoConvergenceMessage() {
        this.suppressNoConvergenceMessage = true;
    }

    public void supressNoConvergenceMessage() {
        this.suppressNoConvergenceMessage = true;
    }

    public void nelderMead(MinimisationFunction gg, double[] start, double[] step, double fTol, int nMax) {
        MinimisationFunction g = gg;
        this.nelderMead((Object)g, start, step, fTol, nMax);
    }

    public void nelderMead(MinimizationFunction gg, double[] start, double[] step, double fTol, int nMax) {
        MinimizationFunction g = gg;
        this.nelderMead((Object)g, start, step, fTol, nMax);
    }

    public void nelderMead(Object g, double[] start, double[] step, double fTol, int nMax) {
        int i;
        int i2;
        int i3;
        Integer itemp;
        boolean testContract = false;
        int np = start.length;
        if (this.maxConstraintIndex >= np) {
            throw new IllegalArgumentException("You have entered more constrained parameters (" + this.maxConstraintIndex + ") than minimisation parameters (" + np + ")");
        }
        this.nParam = np;
        this.convStatus = true;
        int nnp = np + 1;
        this.lastFunctValNoCnstrnt = 0.0;
        if (this.scaleOpt < 2) {
            this.scale = new double[np];
        }
        if (this.scaleOpt == 2 && this.scale.length != start.length) {
            throw new IllegalArgumentException("scale array and initial estimate array are of different lengths");
        }
        if (step.length != start.length) {
            throw new IllegalArgumentException("step array length " + step.length + " and initial estimate array length " + start.length + " are of different");
        }
        for (int i4 = 0; i4 < np; ++i4) {
            if (step[i4] != 0.0) continue;
            if (start[i4] != 0.0) {
                step[i4] = start[i4] * 0.1;
                continue;
            }
            step[i4] = 1.0;
            System.out.println("As no step size has been entered for an itial estimate of zero an initial step size of unity has been used");
            System.out.println("You are advised to repeat the minimization using one of the methods allowing the setting of an appropriate non-zero initial step size");
        }
        this.paramValue = new double[np];
        this.startH = new double[np];
        this.step = new double[np];
        double[] pmin = new double[np];
        double[][] pp = new double[nnp][nnp];
        double[] yy = new double[nnp];
        double[] pbar = new double[nnp];
        double[] pstar = new double[nnp];
        double[] p2star = new double[nnp];
        if (this.penalty) {
            itemp = (Integer)this.penalties.get(1);
            this.nConstraints = itemp;
            this.penaltyParam = new int[this.nConstraints];
            this.penaltyCheck = new int[this.nConstraints];
            this.constraints = new double[this.nConstraints];
            Double dtemp = null;
            int j = 2;
            for (i3 = 0; i3 < this.nConstraints; ++i3) {
                itemp = (Integer)this.penalties.get(j);
                this.penaltyParam[i3] = itemp;
                itemp = (Integer)this.penalties.get(++j);
                this.penaltyCheck[i3] = itemp;
                dtemp = (Double)this.penalties.get(++j);
                this.constraints[i3] = dtemp;
                ++j;
            }
        }
        if (this.sumPenalty) {
            itemp = (Integer)this.sumPenalties.get(1);
            this.nSumConstraints = itemp;
            this.sumPenaltyParam = new int[this.nSumConstraints][];
            this.sumPlusOrMinus = new double[this.nSumConstraints][];
            this.sumPenaltyCheck = new int[this.nSumConstraints];
            this.sumPenaltyNumber = new int[this.nSumConstraints];
            this.sumConstraints = new double[this.nSumConstraints];
            int[] itempArray = null;
            double[] dtempArray = null;
            Double dtemp = null;
            int j = 2;
            for (int i5 = 0; i5 < this.nSumConstraints; ++i5) {
                itemp = (Integer)this.sumPenalties.get(j);
                this.sumPenaltyNumber[i5] = itemp;
                itempArray = (int[])this.sumPenalties.get(++j);
                this.sumPenaltyParam[i5] = itempArray;
                dtempArray = (double[])this.sumPenalties.get(++j);
                this.sumPlusOrMinus[i5] = dtempArray;
                itemp = (Integer)this.sumPenalties.get(++j);
                this.sumPenaltyCheck[i5] = itemp;
                dtemp = (Double)this.sumPenalties.get(++j);
                this.sumConstraints[i5] = dtemp;
                ++j;
            }
        }
        for (i2 = 0; i2 < np; ++i2) {
            this.startH[i2] = start[i2];
        }
        if (this.scaleOpt > 0) {
            boolean testzero = false;
            for (int i6 = 0; i6 < np; ++i6) {
                if (start[i6] != 0.0) continue;
                testzero = true;
            }
            if (testzero) {
                System.out.println("Neler and Mead Simplex: a start value of zero precludes scaling");
                System.out.println("Regression performed without scaling");
                this.scaleOpt = 0;
            }
        }
        switch (this.scaleOpt) {
            case 0: {
                for (i2 = 0; i2 < np; ++i2) {
                    this.scale[i2] = 1.0;
                }
                break;
            }
            case 1: {
                for (i2 = 0; i2 < np; ++i2) {
                    this.scale[i2] = 1.0 / start[i2];
                    step[i2] = step[i2] / start[i2];
                    start[i2] = 1.0;
                }
                break;
            }
            case 2: {
                for (i2 = 0; i2 < np; ++i2) {
                    int n = i2;
                    step[n] = step[n] * this.scale[i2];
                    int n2 = i2;
                    start[n2] = start[n2] * this.scale[i2];
                }
                break;
            }
        }
        this.fTol = fTol;
        this.nMax = nMax;
        this.nIter = 0;
        for (i2 = 0; i2 < np; ++i2) {
            this.step[i2] = step[i2];
            this.scale[i2] = this.scale[i2];
        }
        double sho = 0.0;
        for (int i7 = 0; i7 < np; ++i7) {
            pstar[i7] = sho = start[i7];
            p2star[i7] = sho;
            pmin[i7] = sho;
        }
        int jcount = this.konvge;
        for (i3 = 0; i3 < np; ++i3) {
            pp[i3][nnp - 1] = start[i3];
        }
        yy[nnp - 1] = this.functionValue(g, start);
        for (int j = 0; j < np; ++j) {
            start[j] = start[j] + step[j];
            for (int i8 = 0; i8 < np; ++i8) {
                pp[i8][j] = start[i8];
            }
            yy[j] = this.functionValue(g, start);
            start[j] = start[j] - step[j];
        }
        double ynewlo = 0.0;
        double ystar = 0.0;
        double y2star = 0.0;
        double ylo = 0.0;
        double curMin = 0.0;
        double sumnm = 0.0;
        double summnm = 0.0;
        double zn = 0.0;
        int ilo = 0;
        int ihi = 0;
        int ln = 0;
        boolean test = true;
        while (test) {
            int i9;
            int j;
            ynewlo = ylo = yy[0];
            ilo = 0;
            ihi = 0;
            for (i = 1; i < nnp; ++i) {
                if (yy[i] < ylo) {
                    ylo = yy[i];
                    ilo = i;
                }
                if (!(yy[i] > ynewlo)) continue;
                ynewlo = yy[i];
                ihi = i;
            }
            for (i = 0; i < np; ++i) {
                zn = 0.0;
                for (int j2 = 0; j2 < nnp; ++j2) {
                    zn += pp[i][j2];
                }
                pbar[i] = (zn -= pp[i][ihi]) / (double)np;
            }
            for (i = 0; i < np; ++i) {
                pstar[i] = (1.0 + this.rCoeff) * pbar[i] - this.rCoeff * pp[i][ihi];
            }
            ystar = this.functionValue(g, pstar);
            ++this.nIter;
            if (ystar < ylo) {
                for (i = 0; i < np; ++i) {
                    p2star[i] = pstar[i] * (1.0 + this.eCoeff) - this.eCoeff * pbar[i];
                }
                y2star = this.functionValue(g, p2star);
                ++this.nIter;
                if (y2star < ylo) {
                    for (i = 0; i < np; ++i) {
                        pp[i][ihi] = p2star[i];
                    }
                    yy[ihi] = y2star;
                } else {
                    for (i = 0; i < np; ++i) {
                        pp[i][ihi] = pstar[i];
                    }
                    yy[ihi] = ystar;
                }
            } else {
                ln = 0;
                for (i = 0; i < nnp; ++i) {
                    if (i == ihi || !(ystar > yy[i])) continue;
                    ++ln;
                }
                if (ln == np) {
                    if (ystar <= yy[ihi]) {
                        for (i = 0; i < np; ++i) {
                            pp[i][ihi] = pstar[i];
                        }
                        yy[ihi] = ystar;
                    }
                    for (i = 0; i < np; ++i) {
                        p2star[i] = this.cCoeff * pp[i][ihi] + (1.0 - this.cCoeff) * pbar[i];
                    }
                    y2star = this.functionValue(g, p2star);
                    ++this.nIter;
                    if (y2star > yy[ihi]) {
                        for (j = 0; j < nnp; ++j) {
                            for (i9 = 0; i9 < np; ++i9) {
                                pp[i9][j] = 0.5 * (pp[i9][j] + pp[i9][ilo]);
                                pmin[i9] = pp[i9][j];
                            }
                            yy[j] = this.functionValue(g, pmin);
                        }
                        this.nIter += nnp;
                    } else {
                        for (i = 0; i < np; ++i) {
                            pp[i][ihi] = p2star[i];
                        }
                        yy[ihi] = y2star;
                    }
                } else {
                    for (i = 0; i < np; ++i) {
                        pp[i][ihi] = pstar[i];
                    }
                    yy[ihi] = ystar;
                }
            }
            sumnm = 0.0;
            ynewlo = yy[0];
            ilo = 0;
            for (i = 0; i < nnp; ++i) {
                sumnm += yy[i];
                if (!(ynewlo > yy[i])) continue;
                ynewlo = yy[i];
                ilo = i;
            }
            sumnm /= (double)nnp;
            summnm = 0.0;
            for (i = 0; i < nnp; ++i) {
                zn = yy[i] - sumnm;
                summnm += zn * zn;
            }
            curMin = Math.sqrt(summnm / (double)np);
            switch (this.minTest) {
                case 0: {
                    if (!(curMin < fTol)) break;
                    test = false;
                }
            }
            this.minimum = ynewlo;
            if (!test) {
                for (i = 0; i < np; ++i) {
                    pmin[i] = pp[i][ilo];
                }
                yy[nnp - 1] = ynewlo;
                this.simplexSd = curMin;
                if (--jcount > 0) {
                    test = true;
                    for (j = 0; j < np; ++j) {
                        pmin[j] = pmin[j] + step[j];
                        for (i9 = 0; i9 < np; ++i9) {
                            pp[i9][j] = pmin[i9];
                        }
                        yy[j] = this.functionValue(g, pmin);
                        pmin[j] = pmin[j] - step[j];
                    }
                }
            }
            if (!test || this.nIter <= this.nMax) continue;
            if (!this.suppressNoConvergenceMessage) {
                System.out.println("Maximum iteration number reached, in Minimisation.simplex(...)");
                System.out.println("without the convergence criterion being satisfied");
                System.out.println("Current parameter estimates and function value returned");
            }
            this.convStatus = false;
            for (i = 0; i < np; ++i) {
                pmin[i] = pp[i][ilo];
            }
            yy[nnp - 1] = ynewlo;
            test = false;
        }
        for (i = 0; i < np; ++i) {
            pmin[i] = pp[i][ilo];
            this.paramValue[i] = pmin[i] / this.scale[i];
        }
        this.minimum = ynewlo;
        this.kRestart = this.konvge - jcount;
    }

    public void nelderMead(MinimisationFunction g, double[] start, double[] step, double fTol) {
        int nMaxx = this.nMax;
        this.nelderMead(g, start, step, fTol, nMaxx);
    }

    public void nelderMead(MinimizationFunction g, double[] start, double[] step, double fTol) {
        int nMaxx = this.nMax;
        this.nelderMead(g, start, step, fTol, nMaxx);
    }

    public void nelderMead(MinimisationFunction g, double[] start, double[] step, int nMax) {
        double fToll = this.fTol;
        this.nelderMead(g, start, step, fToll, nMax);
    }

    public void nelderMead(MinimizationFunction g, double[] start, double[] step, int nMax) {
        double fToll = this.fTol;
        this.nelderMead(g, start, step, fToll, nMax);
    }

    public void nelderMead(MinimisationFunction g, double[] start, double[] step) {
        double fToll = this.fTol;
        int nMaxx = this.nMax;
        this.nelderMead(g, start, step, fToll, nMaxx);
    }

    public void nelderMead(MinimizationFunction g, double[] start, double[] step) {
        double fToll = this.fTol;
        int nMaxx = this.nMax;
        this.nelderMead(g, start, step, fToll, nMaxx);
    }

    public void nelderMead(MinimisationFunction g, double[] start, double fTol, int nMax) {
        int n = start.length;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.nelderMead(g, start, stepp, fTol, nMax);
    }

    public void nelderMead(MinimizationFunction g, double[] start, double fTol, int nMax) {
        int n = start.length;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.nelderMead(g, start, stepp, fTol, nMax);
    }

    public void nelderMead(MinimisationFunction g, double[] start, double fTol) {
        int n = start.length;
        int nMaxx = this.nMax;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.nelderMead(g, start, stepp, fTol, nMaxx);
    }

    public void nelderMead(MinimizationFunction g, double[] start, double fTol) {
        int n = start.length;
        int nMaxx = this.nMax;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.nelderMead(g, start, stepp, fTol, nMaxx);
    }

    public void nelderMead(MinimisationFunction g, double[] start, int nMax) {
        int n = start.length;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.nelderMead(g, start, stepp, fToll, nMax);
    }

    public void nelderMead(MinimizationFunction g, double[] start, int nMax) {
        int n = start.length;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.nelderMead(g, start, stepp, fToll, nMax);
    }

    public void nelderMead(MinimisationFunction g, double[] start) {
        int n = start.length;
        int nMaxx = this.nMax;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.nelderMead(g, start, stepp, fToll, nMaxx);
    }

    public void nelderMead(MinimizationFunction g, double[] start) {
        int n = start.length;
        int nMaxx = this.nMax;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.nelderMead(g, start, stepp, fToll, nMaxx);
    }

    protected double functionValue(Object g, double[] x) {
        if (this.iseOption) {
            return this.functionValue((MinimisationFunction)g, x);
        }
        return this.functionValue((MinimizationFunction)g, x);
    }

    protected double functionValue(MinimisationFunction g, double[] x) {
        double[] param = new double[this.nParam];
        for (int i = 0; i < this.nParam; ++i) {
            param[i] = x[i] / this.scale[i];
        }
        boolean test = this.functionValueCommon(x, param);
        if (test) {
            this.lastFunctValNoCnstrnt = this.functValue = g.function(param);
        }
        return this.functValue;
    }

    protected double functionValue(MinimizationFunction g, double[] x) {
        double[] param = new double[this.nParam];
        for (int i = 0; i < this.nParam; ++i) {
            param[i] = x[i] / this.scale[i];
        }
        boolean test = this.functionValueCommon(x, param);
        if (test) {
            this.lastFunctValNoCnstrnt = this.functValue = g.function(param);
        }
        return this.functValue;
    }

    protected boolean functionValueCommon(double[] x, double[] param) {
        double tempFunctVal = this.lastFunctValNoCnstrnt;
        boolean test = true;
        if (this.penalty) {
            int k = 0;
            block10: for (int i = 0; i < this.nConstraints; ++i) {
                k = this.penaltyParam[i];
                switch (this.penaltyCheck[i]) {
                    case -1: {
                        if (!(param[k] < this.constraints[i])) continue block10;
                        this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(this.constraints[i] - param[k]);
                        test = false;
                        continue block10;
                    }
                    case 0: {
                        if (param[k] < this.constraints[i] * (1.0 - this.constraintTolerance)) {
                            this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(this.constraints[i] * (1.0 - this.constraintTolerance) - param[k]);
                            test = false;
                        }
                        if (!(param[k] > this.constraints[i] * (1.0 + this.constraintTolerance))) continue block10;
                        this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(param[k] - this.constraints[i] * (1.0 + this.constraintTolerance));
                        test = false;
                        continue block10;
                    }
                    case 1: {
                        if (!(param[k] > this.constraints[i])) continue block10;
                        this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(param[k] - this.constraints[i]);
                        test = false;
                    }
                }
            }
        }
        if (this.sumPenalty) {
            int kk = 0;
            double pSign = 0.0;
            block11: for (int i = 0; i < this.nSumConstraints; ++i) {
                double sumPenaltySum = 0.0;
                for (int j = 0; j < this.sumPenaltyNumber[i]; ++j) {
                    kk = this.sumPenaltyParam[i][j];
                    pSign = this.sumPlusOrMinus[i][j];
                    sumPenaltySum += param[kk] * pSign;
                }
                switch (this.sumPenaltyCheck[i]) {
                    case -1: {
                        if (!(sumPenaltySum < this.sumConstraints[i])) continue block11;
                        this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(this.sumConstraints[i] - sumPenaltySum);
                        test = false;
                        continue block11;
                    }
                    case 0: {
                        if (sumPenaltySum < this.sumConstraints[i] * (1.0 - this.constraintTolerance)) {
                            this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(this.sumConstraints[i] * (1.0 - this.constraintTolerance) - sumPenaltySum);
                            test = false;
                        }
                        if (!(sumPenaltySum > this.sumConstraints[i] * (1.0 + this.constraintTolerance))) continue block11;
                        this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(sumPenaltySum - this.sumConstraints[i] * (1.0 + this.constraintTolerance));
                        test = false;
                        continue block11;
                    }
                    case 1: {
                        if (!(sumPenaltySum > this.sumConstraints[i])) continue block11;
                        this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(sumPenaltySum - this.sumConstraints[i]);
                        test = false;
                    }
                }
            }
        }
        return test;
    }

    public void addConstraint(int paramIndex, int conDir, double constraint) {
        this.penalty = true;
        if (this.penalties.isEmpty()) {
            this.penalties.add(new Integer(this.constraintMethod));
        }
        if (this.penalties.size() == 1) {
            this.penalties.add(new Integer(1));
        } else {
            int nPC = (Integer)this.penalties.get(1);
            this.penalties.set(1, new Integer(++nPC));
        }
        this.penalties.add(new Integer(paramIndex));
        this.penalties.add(new Integer(conDir));
        this.penalties.add(new Double(constraint));
        if (paramIndex > this.maxConstraintIndex) {
            this.maxConstraintIndex = paramIndex;
        }
    }

    public void addConstraint(int[] paramIndices, int[] plusOrMinus, int conDir, double constraint) {
        ArrayMaths am = new ArrayMaths(plusOrMinus);
        double[] dpom = am.getArray_as_double();
        this.addConstraint(paramIndices, dpom, conDir, constraint);
    }

    public void addConstraint(int[] paramIndices, double[] plusOrMinus, int conDir, double constraint) {
        int nCon = paramIndices.length;
        int nPorM = plusOrMinus.length;
        if (nCon != nPorM) {
            throw new IllegalArgumentException("num of parameters, " + nCon + ", does not equal number of parameter signs, " + nPorM);
        }
        this.sumPenalty = true;
        if (this.sumPenalties.isEmpty()) {
            this.sumPenalties.add(new Integer(this.constraintMethod));
        }
        if (this.sumPenalties.size() == 1) {
            this.sumPenalties.add(new Integer(1));
        } else {
            int nPC = (Integer)this.sumPenalties.get(1);
            this.sumPenalties.set(1, new Integer(++nPC));
        }
        this.sumPenalties.add(new Integer(nCon));
        this.sumPenalties.add(paramIndices);
        this.sumPenalties.add(plusOrMinus);
        this.sumPenalties.add(new Integer(conDir));
        this.sumPenalties.add(new Double(constraint));
        ArrayMaths am = new ArrayMaths(paramIndices);
        int maxI = am.getMaximum_as_int();
        if (maxI > this.maxConstraintIndex) {
            this.maxConstraintIndex = maxI;
        }
    }

    public void setConstraintMethod(int conMeth) {
        this.constraintMethod = conMeth;
        if (!this.penalties.isEmpty()) {
            this.penalties.set(0, new Integer(this.constraintMethod));
        }
    }

    public void removeConstraints() {
        int i;
        int m;
        if (!this.penalties.isEmpty()) {
            m = this.penalties.size();
            for (i = m - 1; i >= 0; --i) {
                this.penalties.remove(i);
            }
        }
        this.penalty = false;
        this.nConstraints = 0;
        if (!this.sumPenalties.isEmpty()) {
            m = this.sumPenalties.size();
            for (i = m - 1; i >= 0; --i) {
                this.sumPenalties.remove(i);
            }
        }
        this.sumPenalty = false;
        this.nSumConstraints = 0;
        this.maxConstraintIndex = -1;
    }

    public void setConstraintTolerance(double tolerance) {
        this.constraintTolerance = tolerance;
    }

    public void print(String filename, int prec) {
        this.prec = prec;
        this.print(filename);
    }

    public void print(int prec) {
        this.prec = prec;
        String filename = "MinimisationOutput.txt";
        this.print(filename);
    }

    public void print(String filename) {
        int i;
        if (filename.indexOf(46) == -1) {
            filename = filename + ".txt";
        }
        FileOutput fout = new FileOutput(filename, 'n');
        fout.dateAndTimeln(filename);
        fout.println(" ");
        fout.println("Simplex minimisation, using the method of Nelder and Mead,");
        fout.println("of the function y = f(c[0], c[1], c[2] . . .)");
        this.paraName = new String[this.nParam];
        for (i = 0; i < this.nParam; ++i) {
            this.paraName[i] = "c[" + i + "]";
        }
        fout.println();
        if (!this.convStatus) {
            fout.println("Convergence criterion was not satisfied");
            fout.println("The following results are the current estimates on exiting the minimisation method");
            fout.println();
        }
        fout.println("Value of parameters at the minimum");
        fout.println(" ");
        fout.printtab(" ", this.field);
        fout.printtab("Value at", this.field);
        fout.printtab("Initial", this.field);
        fout.println("Initial");
        fout.printtab(" ", this.field);
        fout.printtab("mimium", this.field);
        fout.printtab("estimate", this.field);
        fout.println("step");
        for (i = 0; i < this.nParam; ++i) {
            fout.printtab(this.paraName[i], this.field);
            fout.printtab(Fmath.truncate(this.paramValue[i], this.prec), this.field);
            fout.printtab(Fmath.truncate(this.startH[i], this.prec), this.field);
            fout.println(Fmath.truncate(this.step[i], this.prec));
        }
        fout.println();
        fout.println(" ");
        fout.printtab("Number of paramaters");
        fout.println(this.nParam);
        fout.printtab("Number of iterations taken");
        fout.println(this.nIter);
        fout.printtab("Maximum number of iterations allowed");
        fout.println(this.nMax);
        fout.printtab("Number of restarts taken");
        fout.println(this.kRestart);
        fout.printtab("Maximum number of restarts allowed");
        fout.println(this.konvge);
        fout.printtab("Standard deviation of the simplex at the minimum");
        fout.println(Fmath.truncate(this.simplexSd, this.prec));
        fout.printtab("Convergence tolerance");
        fout.println(this.fTol);
        switch (this.minTest) {
            case 0: {
                if (this.convStatus) {
                    fout.println("simplex sd < the tolerance");
                    break;
                }
                fout.println("NOTE!!! simplex sd > the tolerance");
            }
        }
        fout.println();
        fout.println("End of file");
        fout.close();
    }

    public void print() {
        String filename = "MinimisationOutput.txt";
        this.print(filename);
    }

    public boolean getConvStatus() {
        return this.convStatus;
    }

    public void setScale(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("The argument must be 0 (no scaling) 1(initial estimates all scaled to unity) or the array of scaling factors");
        }
        this.scaleOpt = n;
    }

    public void setScale(double[] sc) {
        this.scale = sc;
        this.scaleOpt = 2;
    }

    public double[] getScale() {
        return this.scale;
    }

    public void setMinTest(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("minTest must be 0 or 1");
        }
        this.minTest = n;
    }

    public int getMinTest() {
        return this.minTest;
    }

    public double getSimplexSd() {
        return this.simplexSd;
    }

    public double[] getParamValues() {
        return this.paramValue;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public int getNiter() {
        return this.nIter;
    }

    public void setNmax(int nmax) {
        this.nMax = nmax;
    }

    public int getNmax() {
        return this.nMax;
    }

    public int getNrestarts() {
        return this.kRestart;
    }

    public void setNrestartsMax(int nrs) {
        this.konvge = nrs;
    }

    public int getNrestartsMax() {
        return this.konvge;
    }

    public void setNMreflect(double refl) {
        this.rCoeff = refl;
    }

    public double getNMreflect() {
        return this.rCoeff;
    }

    public void setNMextend(double ext) {
        this.eCoeff = ext;
    }

    public double getNMextend() {
        return this.eCoeff;
    }

    public void setNMcontract(double con) {
        this.cCoeff = con;
    }

    public double getNMcontract() {
        return this.cCoeff;
    }

    public void setTolerance(double tol) {
        this.fTol = tol;
    }

    public double getTolerance() {
        return this.fTol;
    }
}

