/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util.test;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.pipes.history.History;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;

public class PipeTestUtils {
    public static List<String> getResults(Pipe pipe) {
        ArrayList<String> results = new ArrayList<String>();
        while (pipe.hasNext()) {
            Object obj = pipe.next();
            if (obj instanceof String) {
                results.add((String)obj);
                continue;
            }
            if (obj instanceof History) {
                results.add(((History)obj).getMergedData("\t"));
                continue;
            }
            results.add(obj.toString());
        }
        return results;
    }

    @Deprecated
    public static List<String> pipeOutputToStrings(Pipe<History, History> pipe) {
        ArrayList<String> lines = new ArrayList<String>();
        while (pipe.hasNext()) {
            History history = (History)pipe.next();
            lines.add(history.getMergedData("\t"));
        }
        return lines;
    }

    @Deprecated
    public static List<String> pipeOutputToStrings2(Pipe<Object, String> pipe) {
        ArrayList<String> lines = new ArrayList<String>();
        while (pipe.hasNext()) {
            String str = (String)pipe.next();
            lines.add(str);
        }
        return lines;
    }

    public static void printLines(List<String> lines) {
        for (String s : lines) {
            System.out.println(s);
        }
    }

    public static void assertListsEqual(List<String> expected, List<String> actual, boolean isIgnorePaths) {
        int smallestSize = Math.min(expected.size(), actual.size());
        if (expected.size() != actual.size()) {
            System.out.println("Expected size (" + expected.size() + ") does not match actual size (" + actual.size() + ") - comparing up to lowest # of lines:");
        }
        for (int i = 0; i < smallestSize; ++i) {
            String expectedStr = isIgnorePaths ? PipeTestUtils.wipePath(expected.get(i)) : expected.get(i);
            String actualStr = isIgnorePaths ? PipeTestUtils.wipePath(actual.get(i)) : actual.get(i);
            Assert.assertEquals((String)("Array item not equal!  Line: " + (i + 1) + "\nExpected: " + expectedStr + "\nActual:   " + actualStr + "\n"), (Object)expectedStr, (Object)actualStr);
        }
        Assert.assertEquals((String)"Array sizes are not equal!", (long)expected.size(), (long)actual.size());
    }

    public static void assertListsEqual(List<String> expected, List<String> actual) {
        PipeTestUtils.assertListsEqual(expected, actual, false);
    }

    public static String wipePath(String line) {
        String PATH = "Path=\"";
        if (line != null && line.startsWith("##") && line.contains("Path=\"")) {
            int start = line.indexOf("Path=\"");
            int end = line.indexOf("\"", start + "Path=\"".length());
            return line.substring(0, start + "Path=\"".length()) + line.substring(end);
        }
        return line;
    }

    public static void walkPipeline(Pipeline pipeline, int depth) {
        List pipes = pipeline.getPipes();
        for (Pipe pipe : pipes) {
            if (pipe instanceof Pipeline) {
                PipeTestUtils.walkPipeline((Pipeline)pipe, depth + 1);
                continue;
            }
            System.out.println(PipeTestUtils.getDepthSpaces(depth) + pipe.getClass().getCanonicalName());
        }
    }

    private static String getDepthSpaces(int depth) {
        StringBuilder str = new StringBuilder();
        while (str.length() < depth) {
            str.append("\t");
        }
        return str.toString();
    }
}

