/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.ExponentialProbPlotFunc;
import flanagan.analysis.FrechetProbPlotFunc;
import flanagan.analysis.GaussProbPlotFunc;
import flanagan.analysis.GumbelMaxProbPlotFunc;
import flanagan.analysis.GumbelMinProbPlotFunc;
import flanagan.analysis.LogisticProbPlotFunc;
import flanagan.analysis.ParetoProbPlotFunc;
import flanagan.analysis.RayleighProbPlotFunc;
import flanagan.analysis.Regression;
import flanagan.analysis.RegressionFunction;
import flanagan.analysis.Stat;
import flanagan.analysis.WeibullProbPlotFunc;
import flanagan.analysis.WeibullStandardProbPlotFunc;
import flanagan.analysis.WeibullTwoParProbPlotFunc;
import flanagan.interpolation.CubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Vector;

public class ProbabilityPlot {
    private double[] array = null;
    private Stat arrayAsStat = null;
    private double[] sortedData = null;
    private double[] weights = null;
    private boolean weighted = false;
    private double mean = Double.NaN;
    private double standardDeviation = Double.NaN;
    private double minimum = Double.NaN;
    private double maximum = Double.NaN;
    private double range = Double.NaN;
    private double halfWidth = Double.NaN;
    private double peakPoint = Double.NaN;
    private int numberOfDataPoints = 0;
    private double dataOffset = 0.0;
    private boolean dataShifted = false;
    private double[] initialEstimates = null;
    private int lastMethod = 0;
    private boolean supressPlot = false;
    private int gaussianNumberOfParameters = 2;
    private double[] gaussianOrderMedians = null;
    private double[] gaussianParam = null;
    private double[] gaussianParamErrors = null;
    private double gaussianSumOfSquares = Double.NaN;
    private double gaussianUnweightedSumOfSquares = Double.NaN;
    private double[] gaussianLine = null;
    private double[] gaussianLineErrors = null;
    private double gaussianCorrCoeff = Double.NaN;
    private boolean gaussianDone = false;
    private int gaussianStandardNumberOfParameters = 0;
    private double[] gaussianStandardOrderMedians = null;
    private double gaussianStandardSumOfSquares = Double.NaN;
    private double[] gaussianStandardLine = null;
    private double[] gaussianStandardLineErrors = null;
    private double gaussianStandardCorrCoeff = Double.NaN;
    private boolean gaussianStandardDone = false;
    private int exponentialNumberOfParameters = 2;
    private double[] exponentialOrderMedians = null;
    private double[] exponentialParam = null;
    private double[] exponentialParamErrors = null;
    private double exponentialSumOfSquares = Double.NaN;
    private double[] exponentialLine = null;
    private double[] exponentialLineErrors = null;
    private double exponentialCorrCoeff = Double.NaN;
    private boolean exponentialDone = false;
    private int fDistributionNumberOfParameters = 0;
    private double[] fDistributionOrderMedians = null;
    private double fDistributionSumOfSquares = Double.NaN;
    private double[] fDistributionLine = null;
    private double[] fDistributionLineErrors = null;
    private double fDistributionCorrCoeff = Double.NaN;
    private boolean fDistributionDone = false;
    private int frechetNumberOfParameters = 3;
    private double[] frechetOrderMedians = null;
    private double[] frechetParam = null;
    private double[] frechetParamErrors = null;
    private double frechetSumOfSquares = Double.NaN;
    private double[] frechetLine = null;
    private double[] frechetLineErrors = null;
    private double frechetCorrCoeff = Double.NaN;
    private boolean frechetDone = false;
    private int gumbelMinNumberOfParameters = 3;
    private double[] gumbelMinOrderMedians = null;
    private double[] gumbelMinParam = null;
    private double[] gumbelMinParamErrors = null;
    private double gumbelMinSumOfSquares = Double.NaN;
    private double[] gumbelMinLine = null;
    private double[] gumbelMinLineErrors = null;
    private double gumbelMinCorrCoeff = Double.NaN;
    private boolean gumbelMinDone = false;
    private int gumbelMaxNumberOfParameters = 3;
    private double[] gumbelMaxOrderMedians = null;
    private double[] gumbelMaxParam = null;
    private double[] gumbelMaxParamErrors = null;
    private double gumbelMaxSumOfSquares = Double.NaN;
    private double[] gumbelMaxLine = null;
    private double[] gumbelMaxLineErrors = null;
    private double gumbelMaxCorrCoeff = Double.NaN;
    private boolean gumbelMaxDone = false;
    private int logisticNumberOfParameters = 3;
    private double[] logisticOrderMedians = null;
    private double[] logisticParam = null;
    private double[] logisticParamErrors = null;
    private double logisticSumOfSquares = Double.NaN;
    private double[] logisticLine = null;
    private double[] logisticLineErrors = null;
    private double logisticCorrCoeff = Double.NaN;
    private boolean logisticDone = false;
    private int paretoNumberOfParameters = 2;
    private double[] paretoOrderMedians = null;
    private double[] paretoParam = null;
    private double[] paretoParamErrors = null;
    private double paretoSumOfSquares = Double.NaN;
    private double[] paretoLine = null;
    private double[] paretoLineErrors = null;
    private double paretoCorrCoeff = Double.NaN;
    private boolean paretoDone = false;
    private int rayleighNumberOfParameters = 2;
    private double[] rayleighOrderMedians = null;
    private double[] rayleighParam = null;
    private double[] rayleighParamErrors = null;
    private double rayleighSumOfSquares = Double.NaN;
    private double[] rayleighLine = null;
    private double[] rayleighLineErrors = null;
    private double rayleighCorrCoeff = Double.NaN;
    private boolean rayleighDone = false;
    private int weibullNumberOfParameters = 3;
    private double[] weibullOrderMedians = null;
    private double[] weibullParam = null;
    private double[] weibullParamErrors = null;
    private double weibullSumOfSquares = Double.NaN;
    private double[] weibullLine = null;
    private double[] weibullLineErrors = null;
    private double weibullCorrCoeff = Double.NaN;
    private boolean weibullDone = false;
    private int weibullTwoParNumberOfParameters = 2;
    private double[] weibullTwoParOrderMedians = null;
    private double[] weibullTwoParParam = null;
    private double[] weibullTwoParParamErrors = null;
    private double weibullTwoParSumOfSquares = Double.NaN;
    private double[] weibullTwoParLine = null;
    private double[] weibullTwoParLineErrors = null;
    private double weibullTwoParCorrCoeff = Double.NaN;
    private boolean weibullTwoParDone = false;
    private int weibullStandardNumberOfParameters = 1;
    private double[] weibullStandardOrderMedians = null;
    private double[] weibullStandardParam = null;
    private double[] weibullStandardParamErrors = null;
    private double weibullStandardSumOfSquares = Double.NaN;
    private double[] weibullStandardLine = null;
    private double[] weibullStandardLineErrors = null;
    private double weibullStandardCorrCoeff = Double.NaN;
    private boolean weibullStandardDone = false;
    private boolean probPlotDone = false;
    private double delta = 0.001;
    private boolean nFactorOptionI = false;
    private boolean nFactorReset = false;

    public ProbabilityPlot(double[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(Double[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(float[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(Float[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(long[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(Long[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(int[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(Integer[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(short[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(Short[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(byte[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(Byte[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(BigDecimal[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.initialize();
    }

    public ProbabilityPlot(BigInteger[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(Object[] xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(Vector<Object> xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(ArrayList<Object> xx) {
        this.arrayAsStat = new Stat(xx);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(ArrayMaths xx) {
        double[] aa = xx.array();
        this.arrayAsStat = new Stat(aa);
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    public ProbabilityPlot(Stat xx) {
        this.arrayAsStat = xx;
        this.array = this.arrayAsStat.array();
        this.initialize();
    }

    private void initialize() {
        this.numberOfDataPoints = this.array.length;
        ArrayMaths sorted = this.arrayAsStat.sort();
        this.sortedData = sorted.array();
        this.mean = this.arrayAsStat.mean();
        this.standardDeviation = this.arrayAsStat.standardDeviation();
        this.minimum = this.arrayAsStat.minimum();
        this.maximum = this.arrayAsStat.maximum();
        this.range = this.maximum - this.minimum;
        this.weights = new double[this.numberOfDataPoints];
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            this.weights[i] = 1.0;
        }
    }

    public void supressDisplay() {
        this.supressPlot = true;
    }

    public void restoreDisplay() {
        this.supressPlot = false;
    }

    public void weightedRegression() {
        this.weighted = true;
    }

    public void unweightedRegression() {
        this.weighted = false;
    }

    public String getWeightingOption() {
        if (this.weighted) {
            return "Weighted Regression";
        }
        return "Unweighted Regression";
    }

    public boolean getBooleanWeightingOption() {
        return this.weighted;
    }

    private void negativeAndNonZeroDataShift() {
        this.dataShifted = false;
        if (this.minimum <= 0.0) {
            this.dataOffset = this.range * 0.01 - this.minimum;
            this.dataShift();
        }
    }

    private void negativeDataShift() {
        this.dataShifted = false;
        if (this.minimum < 0.0) {
            this.dataOffset = -this.minimum;
            this.dataShift();
        }
    }

    private void dataShift() {
        int i = 0;
        while (i < this.numberOfDataPoints) {
            int n = i++;
            this.sortedData[n] = this.sortedData[n] + this.dataOffset;
        }
        this.minimum += this.dataOffset;
        this.maximum += this.dataOffset;
        this.mean += this.dataOffset;
        this.dataShifted = true;
    }

    public double getdataOffset() {
        return this.dataOffset;
    }

    private double peakWidth() {
        this.halfWidth = 0.0;
        double[] interpData = null;
        int nInterp = 10000;
        if (this.numberOfDataPoints >= 1000) {
            interpData = this.sortedData;
            nInterp = this.numberOfDataPoints;
        } else {
            double[] dataX = new double[this.numberOfDataPoints];
            for (int i = 0; i < this.numberOfDataPoints; ++i) {
                dataX[i] = i;
            }
            double incrI = (double)(this.numberOfDataPoints - 1) / (double)(nInterp - 1);
            interpData = new double[nInterp];
            CubicSpline cs = new CubicSpline(dataX, this.sortedData);
            double interp = 0.0;
            for (int i = 0; i < nInterp - 1; ++i) {
                interpData[i] = cs.interpolate(interp);
                interp += incrI;
            }
            interpData[nInterp - 1] = this.numberOfDataPoints - 1;
        }
        int nBins = 100;
        double[] binnedData = new double[nBins];
        double[] bins = new double[nBins];
        double binWidth = this.range / (double)nBins;
        double binLower = this.minimum;
        double binUpper = binLower + binWidth;
        int counter = 0;
        for (int i = 0; i < nBins; ++i) {
            bins[i] = (binUpper + binLower) / 2.0;
            binnedData[i] = 0.0;
            boolean test = true;
            if (counter >= nInterp) {
                test = false;
            }
            while (test) {
                if (interpData[counter] < binUpper) {
                    int n = i;
                    binnedData[n] = binnedData[n] + 1.0;
                } else {
                    test = false;
                }
                if (++counter < nInterp) continue;
                test = false;
            }
            binLower = binUpper;
            binUpper = binLower + binWidth;
        }
        if (counter < nInterp) {
            int n = nBins - 1;
            binnedData[n] = binnedData[n] + (double)(nInterp - counter);
        }
        ArrayMaths am = new ArrayMaths(binnedData);
        double maxI = am.maximum();
        int maxIindex = am.maximumIndex();
        this.peakPoint = bins[maxIindex];
        double halfHeight = maxI / 2.0;
        double widthLower = 0.0;
        boolean lowerCheck = false;
        double widthUpper = 0.0;
        boolean upperCheck = false;
        if (binnedData[0] == halfHeight) {
            widthLower = bins[0];
            lowerCheck = true;
        } else if (binnedData[0] < halfHeight) {
            if (maxIindex >= 2) {
                double[] interpLy = new double[maxIindex + 1];
                double[] interpLx = new double[maxIindex + 1];
                for (int i = 0; i <= maxIindex; ++i) {
                    interpLy[i] = binnedData[i];
                    interpLx[i] = bins[i];
                }
                CubicSpline csl = new CubicSpline(interpLx, interpLy);
                double[] tempx = new double[100];
                double[] tempy = new double[100];
                double incr = (interpLx[maxIindex] - interpLx[0]) / 99.0;
                double intr = interpLx[0];
                for (int i = 0; i < 99; ++i) {
                    tempx[i] = intr;
                    tempy[i] = csl.interpolate(intr);
                    intr += incr;
                }
                tempy[99] = interpLy[maxIindex];
                tempx[99] = interpLx[maxIindex];
                boolean testt = true;
                int ii = 0;
                while (testt) {
                    if (halfHeight <= tempy[ii]) {
                        if (ii == 0) {
                            widthLower = tempx[0];
                            testt = false;
                            lowerCheck = true;
                        } else if (ii == 99) {
                            widthLower = tempx[99];
                            testt = false;
                            lowerCheck = true;
                        } else {
                            widthLower = (tempx[ii] + tempx[ii - 1]) / 2.0;
                            testt = false;
                            lowerCheck = true;
                        }
                    }
                    if (++ii < 100) continue;
                    testt = false;
                }
            } else if (maxIindex == 2) {
                if (binnedData[1] >= halfHeight) {
                    widthLower = bins[0] + (bins[1] - bins[0]) * (halfHeight - binnedData[0]) / (binnedData[1] - binnedData[0]);
                    lowerCheck = true;
                } else {
                    widthLower = bins[1] + (bins[2] - bins[1]) * (halfHeight - binnedData[1]) / (binnedData[2] - binnedData[1]);
                    lowerCheck = true;
                }
            } else {
                widthLower = bins[0] + (bins[1] - bins[0]) * (halfHeight - binnedData[0]) / (binnedData[1] - binnedData[0]);
                lowerCheck = true;
            }
        } else if (maxIindex > 2 && binnedData[maxIindex] - binnedData[0] > halfHeight * 0.5) {
            widthLower = bins[0] + (bins[1] - bins[0]) * (halfHeight - binnedData[0]) / (binnedData[1] - binnedData[0]);
            lowerCheck = true;
        }
        int nTop = nBins - 1;
        int nDif = nBins - maxIindex;
        if (binnedData[nTop] == halfHeight) {
            widthUpper = bins[nTop];
            upperCheck = true;
        } else if (binnedData[nTop] < halfHeight) {
            if (nDif >= 3) {
                double[] interpLy = new double[nDif];
                double[] interpLx = new double[nDif];
                int ii = 0;
                for (int i = maxIindex; i < nBins; ++i) {
                    interpLy[ii] = binnedData[i];
                    interpLx[ii] = bins[i];
                    ++ii;
                }
                CubicSpline csl = new CubicSpline(interpLx, interpLy);
                double[] tempx = new double[100];
                double[] tempy = new double[100];
                double incr = (interpLx[nDif - 1] - interpLx[0]) / 99.0;
                double intr = interpLx[0];
                for (int i = 0; i < 99; ++i) {
                    tempx[i] = intr;
                    tempy[i] = csl.interpolate(intr);
                    intr += incr;
                }
                tempy[99] = interpLy[nDif - 1];
                tempx[99] = interpLx[nDif - 1];
                boolean testt = true;
                ii = 0;
                while (testt) {
                    if (halfHeight <= tempy[ii]) {
                        if (ii == 0) {
                            widthUpper = tempx[0];
                            testt = false;
                            upperCheck = true;
                        } else if (ii == 99) {
                            widthUpper = tempx[99];
                            testt = false;
                            upperCheck = true;
                        } else {
                            widthUpper = (tempx[ii] + tempx[ii - 1]) / 2.0;
                            testt = false;
                            upperCheck = true;
                        }
                    }
                    if (++ii < 100) continue;
                    testt = false;
                }
            } else if (nDif == 2) {
                if (binnedData[nTop - 1] >= halfHeight) {
                    widthUpper = bins[nTop - 1] + (bins[nTop] - bins[nTop - 1]) * (halfHeight - binnedData[nTop - 1]) / (binnedData[nTop] - binnedData[nTop - 1]);
                    upperCheck = true;
                } else {
                    widthUpper = bins[nTop - 2] + (bins[nTop - 1] - bins[nTop - 2]) * (halfHeight - binnedData[nTop - 2]) / (binnedData[nTop - 1] - binnedData[nTop - 2]);
                    upperCheck = true;
                }
            } else {
                widthUpper = bins[nTop - 1] + (bins[nTop] - bins[nTop - 1]) * (halfHeight - binnedData[nTop - 1]) / (binnedData[nTop] - binnedData[nTop - 1]);
                upperCheck = true;
            }
        } else if (nDif > 2 && binnedData[maxIindex] - binnedData[nTop] > halfHeight * 0.5) {
            widthUpper = bins[nTop - 1] + (bins[nTop] - bins[nTop - 1]) * (halfHeight - binnedData[nTop - 1]) / (binnedData[nTop] - binnedData[nTop - 1]);
            upperCheck = true;
        }
        if (lowerCheck) {
            this.halfWidth = upperCheck ? widthUpper - widthLower : (this.peakPoint - widthLower) * 1.3;
        } else if (upperCheck) {
            this.halfWidth = (widthUpper - this.peakPoint) * 1.3;
        } else {
            System.out.println("Half height width could not be calculated - half range returned");
            this.halfWidth = this.range / 2.0;
        }
        return this.halfWidth;
    }

    public void gaussianProbabilityPlot() {
        this.lastMethod = 0;
        this.gaussianNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression min = new Regression(this.sortedData, this.sortedData);
        double meanest = this.mean;
        if (this.mean == 0.0) {
            meanest = this.standardDeviation / 3.0;
        }
        double[] start = new double[]{meanest, this.standardDeviation};
        this.initialEstimates = start;
        double[] step = new double[]{0.3 * meanest, 0.3 * this.standardDeviation};
        double tolerance = 1.0E-10;
        min.addConstraint(1, -1, 0.0);
        GaussProbPlotFunc gppf = new GaussProbPlotFunc();
        gppf.setDataArray(this.numberOfDataPoints);
        min.simplex((RegressionFunction)gppf, start, step, tolerance);
        this.gaussianParam = min.getBestEstimates();
        this.gaussianParamErrors = min.getBestEstimatesErrors();
        this.gaussianOrderMedians = Stat.gaussianOrderStatisticMedians(this.gaussianParam[0], this.gaussianParam[1], this.numberOfDataPoints);
        Regression reg = new Regression(this.gaussianOrderMedians, this.sortedData);
        reg.linear();
        this.gaussianLine = reg.getBestEstimates();
        this.gaussianLineErrors = reg.getBestEstimatesErrors();
        this.gaussianCorrCoeff = reg.getSampleR();
        double[][] data = PlotGraph.data(2, this.numberOfDataPoints);
        data[0] = this.gaussianOrderMedians;
        data[1] = this.sortedData;
        data[2] = this.gaussianOrderMedians;
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            data[3][i] = this.gaussianLine[0] + this.gaussianLine[1] * this.gaussianOrderMedians[i];
        }
        this.gaussianSumOfSquares = min.getSumOfSquares();
        if (!this.supressPlot) {
            PlotGraph pg = new PlotGraph(data);
            int[] points = new int[]{4, 0};
            pg.setPoint(points);
            int[] lines = new int[]{0, 3};
            pg.setLine(lines);
            pg.setXaxisLegend("Gaussian Order Statistic Medians");
            pg.setYaxisLegend("Ordered Data Values");
            pg.setGraphTitle("Gaussian probability plot:   gradient = " + Fmath.truncate(this.gaussianLine[1], 4) + ", intercept = " + Fmath.truncate(this.gaussianLine[0], 4) + ",  R = " + Fmath.truncate(this.gaussianCorrCoeff, 4));
            pg.setGraphTitle2("  mu = " + Fmath.truncate(this.gaussianParam[0], 4) + ", sigma = " + Fmath.truncate(this.gaussianParam[1], 4));
            pg.plot();
        }
        this.gaussianDone = true;
    }

    public void normalProbabilityPlot() {
        this.gaussianProbabilityPlot();
    }

    public double gaussianMu() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianParam[0];
    }

    public double gaussianMuError() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianParamErrors[0];
    }

    public double gaussianSigma() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianParam[1];
    }

    public double gaussianSigmaError() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianParamErrors[1];
    }

    public double gaussianGradient() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianLine[1];
    }

    public double gaussianGradientError() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianLineErrors[1];
    }

    public double gaussianIntercept() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianLine[0];
    }

    public double gaussianInterceptError() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianLineErrors[0];
    }

    public double gaussianCorrelationCoefficient() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianCorrCoeff;
    }

    public double gaussianSumOfSquares() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianSumOfSquares;
    }

    public double gaussianUnweightedSumOfSquares() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianUnweightedSumOfSquares;
    }

    public double[] gaussianOrderStatisticMedians() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianOrderMedians;
    }

    public double normalMu() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianParam[0];
    }

    public double normalMuError() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianParamErrors[0];
    }

    public double normalSigma() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianParam[1];
    }

    public double normalSigmaError() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianParamErrors[1];
    }

    public double normalGradient() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianLine[1];
    }

    public double normalGradientError() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianLineErrors[1];
    }

    public double normalIntercept() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianLine[0];
    }

    public double normalInterceptError() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianLineErrors[0];
    }

    public double normalCorrelationCoefficient() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianCorrCoeff;
    }

    public double normalSumOfSquares() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianSumOfSquares;
    }

    public double[] normalOrderStatisticMedians() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianOrderMedians;
    }

    public void gaussianStandardProbabilityPlot() {
        this.lastMethod = 14;
        this.gaussianStandardNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        this.gaussianStandardOrderMedians = Stat.gaussianOrderStatisticMedians(this.numberOfDataPoints);
        Regression reg = new Regression(this.gaussianStandardOrderMedians, this.sortedData);
        reg.linear();
        this.gaussianStandardLine = reg.getBestEstimates();
        this.gaussianStandardLineErrors = reg.getBestEstimatesErrors();
        this.gaussianStandardCorrCoeff = reg.getSampleR();
        double[][] data = PlotGraph.data(2, this.numberOfDataPoints);
        data[0] = this.gaussianStandardOrderMedians;
        data[1] = this.sortedData;
        data[2] = this.gaussianStandardOrderMedians;
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            data[3][i] = this.gaussianStandardLine[0] + this.gaussianStandardLine[1] * this.gaussianStandardOrderMedians[i];
        }
        PlotGraph pg = new PlotGraph(data);
        int[] points = new int[]{4, 0};
        pg.setPoint(points);
        int[] lines = new int[]{0, 3};
        pg.setLine(lines);
        pg.setXaxisLegend("Standard Gaussian Order Statistic Medians");
        pg.setYaxisLegend("Ordered Data Values");
        pg.setGraphTitle("Standard Gaussian probability plot:   gradient = " + Fmath.truncate(this.gaussianStandardLine[1], 4) + ", intercept = " + Fmath.truncate(this.gaussianStandardLine[0], 4) + ",  R = " + Fmath.truncate(this.gaussianStandardCorrCoeff, 4));
        pg.plot();
        this.gaussianStandardDone = true;
    }

    public void normalStandardProbabilityPlot() {
        this.gaussianStandardProbabilityPlot();
    }

    public double gaussianStandardGradient() {
        if (!this.gaussianStandardDone) {
            this.supressDisplay();
            this.gaussianStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianStandardLine[1];
    }

    public double gaussianStandardGradientError() {
        if (!this.gaussianStandardDone) {
            this.supressDisplay();
            this.gaussianStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianStandardLineErrors[1];
    }

    public double gaussianStandardIntercept() {
        if (!this.gaussianStandardDone) {
            this.supressDisplay();
            this.gaussianStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianStandardLine[0];
    }

    public double gaussianStandardInterceptError() {
        if (!this.gaussianStandardDone) {
            this.supressDisplay();
            this.gaussianStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianStandardLineErrors[0];
    }

    public double gaussianStandardCorrelationCoefficient() {
        if (!this.gaussianStandardDone) {
            this.supressDisplay();
            this.gaussianStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianStandardCorrCoeff;
    }

    public double gaussianStandardSumOfSquares() {
        if (!this.gaussianStandardDone) {
            this.supressDisplay();
            this.gaussianStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianStandardSumOfSquares;
    }

    public double[] gaussianStandardOrderStatisticMedians() {
        if (!this.gaussianStandardDone) {
            this.supressDisplay();
            this.gaussianStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianStandardOrderMedians;
    }

    public double normalStandardGradient() {
        if (!this.gaussianStandardDone) {
            this.supressDisplay();
            this.gaussianStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianStandardLine[1];
    }

    public double normalstandardGradientError() {
        if (!this.gaussianStandardDone) {
            this.supressDisplay();
            this.gaussianStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianStandardLineErrors[1];
    }

    public double normalStandardInterceptError() {
        if (!this.gaussianStandardDone) {
            this.supressDisplay();
            this.gaussianStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianStandardLineErrors[0];
    }

    public double normalStandardCorrelationCoefficient() {
        if (!this.gaussianStandardDone) {
            this.supressDisplay();
            this.gaussianStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianStandardCorrCoeff;
    }

    public double normalStandardSumOfSquares() {
        if (!this.gaussianStandardDone) {
            this.supressDisplay();
            this.gaussianStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianStandardSumOfSquares;
    }

    public double[] normalStandardOrderStatisticMedians() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.gaussianStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gaussianStandardOrderMedians;
    }

    public void logisticProbabilityPlot() {
        this.lastMethod = 8;
        this.logisticNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression min = new Regression(this.sortedData, this.sortedData);
        double muest = this.mean;
        if (muest == 0.0) {
            muest = this.standardDeviation / 3.0;
        }
        double betaest = this.standardDeviation;
        double[] start = new double[]{muest, betaest};
        this.initialEstimates = start;
        double[] step = new double[]{0.3 * muest, 0.3 * betaest};
        double tolerance = 1.0E-10;
        min.addConstraint(1, -1, 0.0);
        LogisticProbPlotFunc lppf = new LogisticProbPlotFunc();
        lppf.setDataArray(this.numberOfDataPoints);
        min.simplex((RegressionFunction)lppf, start, step, tolerance);
        this.logisticParam = min.getBestEstimates();
        this.logisticParamErrors = min.getBestEstimatesErrors();
        this.logisticSumOfSquares = min.getSumOfSquares();
        this.logisticOrderMedians = Stat.logisticOrderStatisticMedians(this.logisticParam[0], this.logisticParam[1], this.numberOfDataPoints);
        Regression reg = new Regression(this.logisticOrderMedians, this.sortedData);
        reg.linear();
        this.logisticLine = reg.getBestEstimates();
        this.logisticLineErrors = reg.getBestEstimatesErrors();
        this.logisticCorrCoeff = reg.getSampleR();
        double[][] data = PlotGraph.data(2, this.numberOfDataPoints);
        data[0] = this.logisticOrderMedians;
        data[1] = this.sortedData;
        data[2] = this.logisticOrderMedians;
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            data[3][i] = this.logisticLine[0] + this.logisticLine[1] * this.logisticOrderMedians[i];
        }
        PlotGraph pg = new PlotGraph(data);
        int[] points = new int[]{4, 0};
        pg.setPoint(points);
        int[] lines = new int[]{0, 3};
        pg.setLine(lines);
        pg.setXaxisLegend("Logistic Order Statistic Medians");
        pg.setYaxisLegend("Ordered Data Values");
        pg.setGraphTitle("Logistic probability plot:   gradient = " + Fmath.truncate(this.logisticLine[1], 4) + ", intercept = " + Fmath.truncate(this.logisticLine[0], 4) + ",  R = " + Fmath.truncate(this.logisticCorrCoeff, 4));
        pg.setGraphTitle2("  mu = " + Fmath.truncate(this.logisticParam[0], 4) + ", beta = " + Fmath.truncate(this.logisticParam[1], 4));
        pg.plot();
        this.logisticDone = true;
        this.probPlotDone = true;
    }

    public double logisticMu() {
        if (!this.logisticDone) {
            this.supressDisplay();
            this.logisticProbabilityPlot();
            this.restoreDisplay();
        }
        return this.logisticParam[0];
    }

    public double logisticMuError() {
        if (!this.logisticDone) {
            this.supressDisplay();
            this.logisticProbabilityPlot();
            this.restoreDisplay();
        }
        return this.logisticParamErrors[0];
    }

    public double logisticBeta() {
        if (!this.logisticDone) {
            this.supressDisplay();
            this.logisticProbabilityPlot();
            this.restoreDisplay();
        }
        return this.logisticParam[1];
    }

    public double logisticBetaError() {
        if (!this.logisticDone) {
            this.supressDisplay();
            this.logisticProbabilityPlot();
            this.restoreDisplay();
        }
        return this.logisticParamErrors[1];
    }

    public double[] logisticOrderStatisticMedians() {
        if (!this.logisticDone) {
            this.supressDisplay();
            this.logisticProbabilityPlot();
            this.restoreDisplay();
        }
        return this.logisticOrderMedians;
    }

    public double logisticGradient() {
        if (!this.logisticDone) {
            this.supressDisplay();
            this.logisticProbabilityPlot();
            this.restoreDisplay();
        }
        return this.logisticLine[1];
    }

    public double logisticGradientError() {
        if (!this.logisticDone) {
            this.supressDisplay();
            this.logisticProbabilityPlot();
            this.restoreDisplay();
        }
        return this.logisticLineErrors[1];
    }

    public double logisticIntercept() {
        if (!this.logisticDone) {
            this.supressDisplay();
            this.logisticProbabilityPlot();
            this.restoreDisplay();
        }
        return this.logisticLine[0];
    }

    public double logisticInterceptError() {
        if (!this.logisticDone) {
            this.supressDisplay();
            this.logisticProbabilityPlot();
            this.restoreDisplay();
        }
        return this.logisticLineErrors[0];
    }

    public double logisticCorrelationCoefficient() {
        if (!this.logisticDone) {
            this.supressDisplay();
            this.logisticProbabilityPlot();
            this.restoreDisplay();
        }
        return this.logisticCorrCoeff;
    }

    public double logisticSumOfSquares() {
        if (!this.logisticDone) {
            this.supressDisplay();
            this.logisticProbabilityPlot();
            this.restoreDisplay();
        }
        return this.logisticSumOfSquares;
    }

    public void weibullProbabilityPlot() {
        this.lastMethod = 1;
        this.weibullNumberOfParameters = 3;
        if (this.numberOfDataPoints < 4) {
            throw new IllegalArgumentException("There must be at least four data points - preferably considerably more");
        }
        Regression min = new Regression(this.sortedData, this.sortedData);
        double[] start = new double[3];
        start[0] = this.minimum - 0.1 * Math.abs(this.minimum);
        start[1] = this.peakWidth();
        if (start[1] == 0.0) {
            start[1] = this.range * 0.1;
        }
        start[2] = 4.0;
        this.initialEstimates = start;
        double[] step = new double[]{Math.abs(0.3 * start[0]), Math.abs(0.3 * start[1]), Math.abs(0.3 * start[2])};
        if (step[0] == 0.0) {
            step[0] = this.range * 0.01;
        }
        if (step[1] == 0.0) {
            step[1] = this.range * 0.01;
        }
        double tolerance = 1.0E-10;
        min.addConstraint(0, 1, this.minimum);
        min.addConstraint(1, -1, 0.0);
        min.addConstraint(2, -1, 0.0);
        WeibullProbPlotFunc wppf = new WeibullProbPlotFunc();
        wppf.setDataArray(this.numberOfDataPoints);
        min.simplex((RegressionFunction)wppf, Conv.copy(start), step, tolerance);
        double[] firstBests = min.getBestEstimates();
        double[] firstErrors = min.getBestEstimatesErrors();
        double ss = min.getSumOfSquares();
        double[] start2 = new double[this.weibullNumberOfParameters];
        start2[0] = 2.0 * firstBests[0] - start[0];
        if (start2[0] > this.minimum) {
            start2[0] = this.minimum * (1.0 - Math.abs(this.minimum) * 0.05);
        }
        step[0] = Math.abs(start2[0] * 0.1);
        if (step[0] == 0.0) {
            step[0] = this.range * 0.01;
        }
        start2[1] = 2.0 * firstBests[1] - start[1];
        if (start2[1] <= 0.0) {
            start2[1] = Math.abs(2.0 * firstBests[1] - 0.98 * start[1]);
        }
        step[1] = Math.abs(start2[1] * 0.1);
        start2[2] = 2.0 * firstBests[2] - start[2];
        if (start2[1] <= 0.0) {
            start2[2] = Math.abs(2.0 * firstBests[2] - 0.98 * start[2]);
        }
        step[2] = Math.abs(start2[2] * 0.1);
        min.simplex((RegressionFunction)wppf, Conv.copy(start2), step, tolerance);
        this.weibullParam = min.getBestEstimates();
        this.weibullParamErrors = min.getBestEstimatesErrors();
        this.weibullSumOfSquares = min.getSumOfSquares();
        if (ss < this.weibullSumOfSquares) {
            this.weibullParam = firstBests;
            this.weibullParamErrors = firstErrors;
            this.weibullSumOfSquares = ss;
        }
        this.weibullOrderMedians = Stat.weibullOrderStatisticMedians(this.weibullParam[0], this.weibullParam[1], this.weibullParam[2], this.numberOfDataPoints);
        Regression reg = new Regression(this.weibullOrderMedians, this.sortedData);
        reg.linear();
        this.weibullLine = reg.getBestEstimates();
        this.weibullLineErrors = reg.getBestEstimatesErrors();
        this.weibullCorrCoeff = reg.getSampleR();
        double[][] data = PlotGraph.data(2, this.numberOfDataPoints);
        data[0] = this.weibullOrderMedians;
        data[1] = this.sortedData;
        data[2] = this.weibullOrderMedians;
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            data[3][i] = this.weibullLine[0] + this.weibullLine[1] * this.weibullOrderMedians[i];
        }
        PlotGraph pg = new PlotGraph(data);
        int[] points = new int[]{4, 0};
        pg.setPoint(points);
        int[] lines = new int[]{0, 3};
        pg.setLine(lines);
        pg.setXaxisLegend("Weibull Order Statistic Medians");
        pg.setYaxisLegend("Ordered Data Values");
        pg.setGraphTitle("Weibull probability plot:   gradient = " + Fmath.truncate(this.weibullLine[1], 4) + ", intercept = " + Fmath.truncate(this.weibullLine[0], 4) + ",  R = " + Fmath.truncate(this.weibullCorrCoeff, 4));
        pg.setGraphTitle2("  mu = " + Fmath.truncate(this.weibullParam[0], 4) + ", sigma = " + Fmath.truncate(this.weibullParam[1], 4) + ", gamma = " + Fmath.truncate(this.weibullParam[2], 4));
        pg.plot();
        this.weibullDone = true;
        this.probPlotDone = true;
    }

    public void weibullThreeParProbabilityPlot() {
        this.weibullProbabilityPlot();
    }

    public double weibullMu() {
        if (!this.weibullDone) {
            this.supressDisplay();
            this.weibullProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullParam[0];
    }

    public double weibullMuError() {
        if (!this.weibullDone) {
            this.supressDisplay();
            this.weibullProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullParamErrors[0];
    }

    public double weibullSigma() {
        if (!this.weibullDone) {
            this.supressDisplay();
            this.weibullProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullParam[1];
    }

    public double weibullSigmaError() {
        if (!this.weibullDone) {
            this.supressDisplay();
            this.weibullProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullParamErrors[1];
    }

    public double weibullGamma() {
        if (!this.weibullDone) {
            this.supressDisplay();
            this.weibullProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullParam[2];
    }

    public double weibullGammaError() {
        if (!this.weibullDone) {
            this.supressDisplay();
            this.weibullProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullParamErrors[2];
    }

    public double[] weibullOrderStatisticMedians() {
        if (!this.weibullDone) {
            this.supressDisplay();
            this.weibullProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullOrderMedians;
    }

    public double weibullGradient() {
        if (!this.weibullDone) {
            this.supressDisplay();
            this.weibullProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullLine[1];
    }

    public double weibullGradientError() {
        if (!this.weibullDone) {
            this.supressDisplay();
            this.weibullProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullLineErrors[1];
    }

    public double weibullIntercept() {
        if (!this.weibullDone) {
            this.supressDisplay();
            this.weibullProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullLine[0];
    }

    public double weibullInterceptError() {
        if (!this.weibullDone) {
            this.supressDisplay();
            this.weibullProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullLineErrors[0];
    }

    public double weibullCorrelationCoefficient() {
        if (!this.weibullDone) {
            this.supressDisplay();
            this.weibullProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullCorrCoeff;
    }

    public double weibullSumOfSquares() {
        if (!this.gaussianDone) {
            this.supressDisplay();
            this.weibullProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullSumOfSquares;
    }

    public void weibullTwoParProbabilityPlot() {
        this.lastMethod = 12;
        if (this.sortedData[0] < 0.0) {
            System.out.println("Method weibullTwoParProbabilityPlot: negative x value found - weibullThreeParProbabilityPlot called");
            this.weibullThreeParProbabilityPlot();
        }
        this.weibullTwoParNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression min = new Regression(this.sortedData, this.sortedData);
        double[] start = new double[]{this.peakWidth(), 4.0};
        this.initialEstimates = start;
        double[] step = new double[]{Math.abs(0.3 * start[0]), Math.abs(0.3 * start[1])};
        if (step[0] == 0.0) {
            step[0] = this.range * 0.01;
        }
        double tolerance = 1.0E-10;
        min.addConstraint(0, -1, 0.0);
        min.addConstraint(1, -1, 0.0);
        WeibullTwoParProbPlotFunc wppf = new WeibullTwoParProbPlotFunc();
        wppf.setDataArray(this.numberOfDataPoints);
        min.simplex((RegressionFunction)wppf, Conv.copy(start), step, tolerance);
        double[] firstBests = min.getBestEstimates();
        double[] firstErrors = min.getBestEstimatesErrors();
        double ss = min.getSumOfSquares();
        double[] start2 = new double[this.weibullTwoParNumberOfParameters];
        start2[0] = 2.0 * firstBests[0] - start[0];
        if (start2[0] > this.minimum) {
            start2[0] = this.minimum * (1.0 - Math.abs(this.minimum) * 0.05);
        }
        step[0] = Math.abs(start2[0] * 0.1);
        if (step[0] == 0.0) {
            step[0] = this.range * 0.01;
        }
        start2[1] = 2.0 * firstBests[1] - start[1];
        if (start2[1] <= 0.0) {
            start2[1] = Math.abs(2.0 * firstBests[1] - 0.98 * start[1]);
        }
        step[1] = Math.abs(start2[1] * 0.1);
        min.simplex((RegressionFunction)wppf, Conv.copy(start2), step, tolerance);
        this.weibullTwoParParam = min.getBestEstimates();
        this.weibullTwoParParamErrors = min.getBestEstimatesErrors();
        this.weibullTwoParSumOfSquares = min.getSumOfSquares();
        if (ss < this.weibullSumOfSquares) {
            this.weibullTwoParParam = firstBests;
            this.weibullTwoParParamErrors = firstErrors;
            this.weibullTwoParSumOfSquares = ss;
        }
        this.weibullTwoParOrderMedians = Stat.weibullOrderStatisticMedians(this.weibullTwoParParam[0], this.weibullTwoParParam[1], this.numberOfDataPoints);
        Regression reg = new Regression(this.weibullTwoParOrderMedians, this.sortedData);
        reg.linear();
        this.weibullTwoParLine = reg.getBestEstimates();
        this.weibullTwoParLineErrors = reg.getBestEstimatesErrors();
        this.weibullTwoParCorrCoeff = reg.getSampleR();
        double[][] data = PlotGraph.data(2, this.numberOfDataPoints);
        data[0] = this.weibullTwoParOrderMedians;
        data[1] = this.sortedData;
        data[2] = this.weibullTwoParOrderMedians;
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            data[3][i] = this.weibullTwoParLine[0] + this.weibullTwoParLine[1] * this.weibullTwoParOrderMedians[i];
        }
        PlotGraph pg = new PlotGraph(data);
        int[] points = new int[]{4, 0};
        pg.setPoint(points);
        int[] lines = new int[]{0, 3};
        pg.setLine(lines);
        pg.setXaxisLegend("Weibull Order Statistic Medians");
        pg.setYaxisLegend("Ordered Data Values");
        pg.setGraphTitle("Two Parameter Weibull probability plot:   gradient = " + Fmath.truncate(this.weibullTwoParLine[1], 4) + ", intercept = " + Fmath.truncate(this.weibullTwoParLine[0], 4) + ",  R = " + Fmath.truncate(this.weibullTwoParCorrCoeff, 4));
        pg.setGraphTitle2("  mu = 0, sigma = " + Fmath.truncate(this.weibullTwoParParam[0], 4) + ", gamma = " + Fmath.truncate(this.weibullTwoParParam[1], 4));
        pg.plot();
        this.weibullTwoParDone = true;
        this.probPlotDone = true;
    }

    public double weibullTwoParSigma() {
        if (!this.weibullTwoParDone) {
            this.supressDisplay();
            this.weibullTwoParProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullTwoParParam[0];
    }

    public double weibullTwoParSigmaError() {
        if (!this.weibullTwoParDone) {
            this.supressDisplay();
            this.weibullTwoParProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullTwoParParamErrors[0];
    }

    public double weibullTwoParGamma() {
        if (!this.weibullTwoParDone) {
            this.supressDisplay();
            this.weibullTwoParProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullTwoParParam[1];
    }

    public double weibullTwoParGammaError() {
        if (!this.weibullTwoParDone) {
            this.supressDisplay();
            this.weibullTwoParProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullTwoParParamErrors[1];
    }

    public double[] weibullTwoParOrderStatisticMedians() {
        if (!this.weibullTwoParDone) {
            this.supressDisplay();
            this.weibullTwoParProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullTwoParOrderMedians;
    }

    public double weibullTwoParGradient() {
        if (!this.weibullTwoParDone) {
            this.supressDisplay();
            this.weibullTwoParProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullTwoParLine[1];
    }

    public double weibullTwoParGradientError() {
        if (!this.weibullTwoParDone) {
            this.supressDisplay();
            this.weibullTwoParProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullTwoParLineErrors[1];
    }

    public double weibullTwoParIntercept() {
        if (!this.weibullTwoParDone) {
            this.supressDisplay();
            this.weibullTwoParProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullTwoParLine[0];
    }

    public double weibullTwoParInterceptError() {
        if (!this.weibullTwoParDone) {
            this.supressDisplay();
            this.weibullTwoParProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullTwoParLineErrors[0];
    }

    public double weibullTwoParCorrelationCoefficient() {
        if (!this.weibullTwoParDone) {
            this.supressDisplay();
            this.weibullTwoParProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullTwoParCorrCoeff;
    }

    public double weibullTwoParSumOfSquares() {
        if (!this.weibullTwoParDone) {
            this.supressDisplay();
            this.weibullTwoParProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullTwoParSumOfSquares;
    }

    public void weibullStandardProbabilityPlot() {
        this.lastMethod = 13;
        if (this.sortedData[0] < 0.0) {
            System.out.println("Method weibullStandardProbabilityPlot: negative x value found - weibullThreeParProbabilityPlot called");
            this.weibullThreeParProbabilityPlot();
        }
        this.weibullStandardNumberOfParameters = 1;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression min = new Regression(this.sortedData, this.sortedData);
        double[] start = new double[]{4.0};
        double[] step = new double[]{Math.abs(0.3 * start[0])};
        this.initialEstimates = start;
        double tolerance = 1.0E-10;
        min.addConstraint(0, -1, 0.0);
        WeibullStandardProbPlotFunc wppf = new WeibullStandardProbPlotFunc();
        wppf.setDataArray(this.numberOfDataPoints);
        min.simplex((RegressionFunction)wppf, Conv.copy(start), step, tolerance);
        double[] firstBests = min.getBestEstimates();
        double[] firstErrors = min.getBestEstimatesErrors();
        double ss = min.getSumOfSquares();
        double[] start2 = new double[this.weibullStandardNumberOfParameters];
        start2[0] = 2.0 * firstBests[0] - start[0];
        if (start2[0] > this.minimum) {
            start2[0] = this.minimum * (1.0 - Math.abs(this.minimum) * 0.05);
        }
        step[0] = Math.abs(start2[0] * 0.1);
        if (step[0] == 0.0) {
            step[0] = this.range * 0.01;
        }
        min.simplex((RegressionFunction)wppf, Conv.copy(start2), step, tolerance);
        this.weibullStandardParam = min.getBestEstimates();
        this.weibullStandardParamErrors = min.getBestEstimatesErrors();
        this.weibullStandardSumOfSquares = min.getSumOfSquares();
        this.weibullStandardOrderMedians = Stat.weibullOrderStatisticMedians(this.weibullStandardParam[0], this.numberOfDataPoints);
        Regression reg = new Regression(this.weibullStandardOrderMedians, this.sortedData);
        reg.linear();
        this.weibullStandardLine = reg.getBestEstimates();
        this.weibullStandardLineErrors = reg.getBestEstimatesErrors();
        this.weibullStandardCorrCoeff = reg.getSampleR();
        double[][] data = PlotGraph.data(2, this.numberOfDataPoints);
        data[0] = this.weibullStandardOrderMedians;
        data[1] = this.sortedData;
        data[2] = this.weibullStandardOrderMedians;
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            data[3][i] = this.weibullStandardLine[0] + this.weibullStandardLine[1] * this.weibullStandardOrderMedians[i];
        }
        PlotGraph pg = new PlotGraph(data);
        int[] points = new int[]{4, 0};
        pg.setPoint(points);
        int[] lines = new int[]{0, 3};
        pg.setLine(lines);
        pg.setXaxisLegend("Weibull Order Statistic Medians");
        pg.setYaxisLegend("Ordered Data Values");
        pg.setGraphTitle("Standard Weibull probability plot:   gradient = " + Fmath.truncate(this.weibullStandardLine[1], 4) + ", intercept = " + Fmath.truncate(this.weibullStandardLine[0], 4) + ",  R = " + Fmath.truncate(this.weibullStandardCorrCoeff, 4));
        pg.setGraphTitle2("  mu = 0, sigma = 1, gamma = " + Fmath.truncate(this.weibullStandardParam[0], 4));
        pg.plot();
        this.weibullStandardDone = true;
        this.probPlotDone = true;
    }

    public void weibullOneParProbabilityPlot() {
        this.weibullStandardProbabilityPlot();
    }

    public double weibullStandardGamma() {
        if (!this.weibullStandardDone) {
            this.supressDisplay();
            this.weibullStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullStandardParam[0];
    }

    public double weibullStandardGammaError() {
        if (!this.weibullStandardDone) {
            this.supressDisplay();
            this.weibullStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullStandardParamErrors[0];
    }

    public double[] weibullStandardOrderStatisticMedians() {
        if (!this.weibullStandardDone) {
            this.supressDisplay();
            this.weibullStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullStandardOrderMedians;
    }

    public double weibullStandardGradient() {
        if (!this.weibullStandardDone) {
            this.supressDisplay();
            this.weibullStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullStandardLine[1];
    }

    public double weibullStandardGradientError() {
        if (!this.weibullStandardDone) {
            this.supressDisplay();
            this.weibullStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullStandardLineErrors[1];
    }

    public double weibullStandardIntercept() {
        if (!this.weibullStandardDone) {
            this.supressDisplay();
            this.weibullStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullStandardLine[0];
    }

    public double weibullStandardInterceptError() {
        if (!this.weibullStandardDone) {
            this.supressDisplay();
            this.weibullStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullStandardLineErrors[0];
    }

    public double weibullStandardCorrelationCoefficient() {
        if (!this.weibullStandardDone) {
            this.supressDisplay();
            this.weibullStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullStandardCorrCoeff;
    }

    public double weibullStandardSumOfSquares() {
        if (!this.weibullStandardDone) {
            this.supressDisplay();
            this.weibullStandardProbabilityPlot();
            this.restoreDisplay();
        }
        return this.weibullStandardSumOfSquares;
    }

    public void exponentialProbabilityPlot() {
        this.lastMethod = 2;
        this.exponentialNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression min = new Regression(this.sortedData, this.sortedData);
        double muest = this.minimum;
        if (muest == 0.0) {
            muest = this.standardDeviation / 3.0;
        }
        double sigmaest = this.standardDeviation;
        double[] start = new double[]{muest, sigmaest};
        this.initialEstimates = start;
        double[] step = new double[]{0.3 * muest, 0.3 * sigmaest};
        double tolerance = 1.0E-10;
        min.addConstraint(1, -1, 0.0);
        ExponentialProbPlotFunc eppf = new ExponentialProbPlotFunc();
        eppf.setDataArray(this.numberOfDataPoints);
        min.simplex((RegressionFunction)eppf, start, step, tolerance);
        this.exponentialParam = min.getBestEstimates();
        this.exponentialParamErrors = min.getBestEstimatesErrors();
        this.exponentialSumOfSquares = min.getSumOfSquares();
        this.exponentialOrderMedians = Stat.weibullOrderStatisticMedians(this.exponentialParam[0], this.exponentialParam[1], 1.0, this.numberOfDataPoints);
        Regression reg = new Regression(this.exponentialOrderMedians, this.sortedData);
        reg.linear();
        this.exponentialLine = reg.getBestEstimates();
        this.exponentialLineErrors = reg.getBestEstimatesErrors();
        this.exponentialCorrCoeff = reg.getSampleR();
        double[][] data = PlotGraph.data(2, this.numberOfDataPoints);
        data[0] = this.exponentialOrderMedians;
        data[1] = this.sortedData;
        data[2] = this.exponentialOrderMedians;
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            data[3][i] = this.exponentialLine[0] + this.exponentialLine[1] * this.exponentialOrderMedians[i];
        }
        PlotGraph pg = new PlotGraph(data);
        int[] points = new int[]{4, 0};
        pg.setPoint(points);
        int[] lines = new int[]{0, 3};
        pg.setLine(lines);
        pg.setXaxisLegend("Exponential Order Statistic Medians");
        pg.setYaxisLegend("Ordered Data Values");
        pg.setGraphTitle("Exponential probability plot:   gradient = " + Fmath.truncate(this.exponentialLine[1], 4) + ", intercept = " + Fmath.truncate(this.exponentialLine[0], 4) + ",  R = " + Fmath.truncate(this.exponentialCorrCoeff, 4));
        pg.setGraphTitle2("  mu = " + Fmath.truncate(this.exponentialParam[0], 4) + ", sigma = " + Fmath.truncate(this.exponentialParam[1], 4));
        pg.plot();
        this.exponentialDone = true;
        this.probPlotDone = true;
    }

    public double exponentialMu() {
        if (!this.exponentialDone) {
            this.supressDisplay();
            this.exponentialProbabilityPlot();
            this.restoreDisplay();
        }
        return this.exponentialParam[0];
    }

    public double exponentialMuError() {
        if (!this.exponentialDone) {
            this.supressDisplay();
            this.exponentialProbabilityPlot();
            this.restoreDisplay();
        }
        return this.exponentialParamErrors[0];
    }

    public double exponentialSigma() {
        if (!this.exponentialDone) {
            this.supressDisplay();
            this.exponentialProbabilityPlot();
            this.restoreDisplay();
        }
        return this.exponentialParam[1];
    }

    public double exponentialSigmaError() {
        if (!this.exponentialDone) {
            this.supressDisplay();
            this.exponentialProbabilityPlot();
            this.restoreDisplay();
        }
        return this.exponentialParamErrors[1];
    }

    public double[] exponentialOrderStatisticMedians() {
        if (!this.exponentialDone) {
            this.supressDisplay();
            this.exponentialProbabilityPlot();
            this.restoreDisplay();
        }
        return this.exponentialOrderMedians;
    }

    public double exponentialGradient() {
        if (!this.exponentialDone) {
            this.supressDisplay();
            this.exponentialProbabilityPlot();
            this.restoreDisplay();
        }
        return this.exponentialLine[1];
    }

    public double exponentialGradientError() {
        if (!this.exponentialDone) {
            this.supressDisplay();
            this.exponentialProbabilityPlot();
            this.restoreDisplay();
        }
        return this.exponentialLineErrors[1];
    }

    public double exponentialIntercept() {
        if (!this.exponentialDone) {
            this.supressDisplay();
            this.exponentialProbabilityPlot();
            this.restoreDisplay();
        }
        return this.exponentialLine[0];
    }

    public double exponentialInterceptError() {
        if (!this.exponentialDone) {
            this.supressDisplay();
            this.exponentialProbabilityPlot();
            this.restoreDisplay();
        }
        return this.exponentialLineErrors[0];
    }

    public double exponentialCorrelationCoefficient() {
        if (!this.exponentialDone) {
            this.supressDisplay();
            this.exponentialProbabilityPlot();
            this.restoreDisplay();
        }
        return this.exponentialCorrCoeff;
    }

    public double exponentialSumOfSquares() {
        if (!this.exponentialDone) {
            this.supressDisplay();
            this.exponentialProbabilityPlot();
            this.restoreDisplay();
        }
        return this.exponentialSumOfSquares;
    }

    public void frechetProbabilityPlot() {
        this.lastMethod = 7;
        this.frechetNumberOfParameters = 3;
        if (this.numberOfDataPoints < 4) {
            throw new IllegalArgumentException("There must be at least four data points - preferably considerably more");
        }
        Regression min = new Regression(this.sortedData, this.sortedData);
        double[] start = new double[3];
        start[0] = this.minimum - 0.1 * Math.abs(this.minimum);
        start[1] = this.peakWidth() / 3.0;
        if (start[1] < 1.0) {
            start[1] = 2.0;
        }
        start[2] = 4.0;
        this.initialEstimates = start;
        double[] step = new double[]{Math.abs(0.3 * start[0]), Math.abs(0.3 * start[1]), Math.abs(0.3 * start[2])};
        if (step[0] == 0.0) {
            step[0] = this.range * 0.01;
        }
        double tolerance = 1.0E-10;
        min.addConstraint(0, 1, this.minimum);
        min.addConstraint(1, -1, 0.0);
        min.addConstraint(2, -1, 0.0);
        FrechetProbPlotFunc fppf = new FrechetProbPlotFunc();
        fppf.setDataArray(this.numberOfDataPoints);
        min.simplex((RegressionFunction)fppf, Conv.copy(start), step, tolerance);
        double[] firstBests = min.getBestEstimates();
        double ss = min.getSumOfSquares();
        double[] start2 = new double[this.frechetNumberOfParameters];
        start2[0] = 2.0 * firstBests[0] - start[0];
        if (start2[0] > this.minimum) {
            start2[0] = this.minimum * (1.0 - Math.abs(this.minimum) * 0.05);
        }
        step[0] = Math.abs(start2[0] * 0.1);
        if (step[0] == 0.0) {
            step[0] = this.range * 0.01;
        }
        start2[1] = 2.0 * firstBests[1] - start[1];
        if (start2[1] <= 0.0) {
            start2[1] = Math.abs(2.0 * firstBests[1] - 0.98 * start[1]);
        }
        step[1] = Math.abs(start2[1] * 0.1);
        start2[2] = 2.0 * firstBests[2] - start[2];
        if (start2[1] <= 0.0) {
            start2[2] = Math.abs(2.0 * firstBests[2] - 0.98 * start[2]);
        }
        step[2] = Math.abs(start2[2] * 0.1);
        min.simplex((RegressionFunction)fppf, Conv.copy(start2), step, tolerance);
        this.frechetParam = min.getBestEstimates();
        double ss2 = min.getSumOfSquares();
        if (ss < ss2) {
            this.frechetParam = firstBests;
        }
        this.frechetOrderMedians = Stat.frechetOrderStatisticMedians(this.frechetParam[0], this.frechetParam[1], this.frechetParam[2], this.numberOfDataPoints);
        Regression reg = new Regression(this.frechetOrderMedians, this.sortedData);
        reg.linear();
        this.frechetLine = reg.getBestEstimates();
        this.frechetLineErrors = reg.getBestEstimatesErrors();
        this.frechetCorrCoeff = reg.getSampleR();
        double[][] data = PlotGraph.data(2, this.numberOfDataPoints);
        data[0] = this.frechetOrderMedians;
        data[1] = this.sortedData;
        data[2] = this.frechetOrderMedians;
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            data[3][i] = this.frechetLine[0] + this.frechetLine[1] * this.frechetOrderMedians[i];
        }
        PlotGraph pg = new PlotGraph(data);
        int[] points = new int[]{4, 0};
        pg.setPoint(points);
        int[] lines = new int[]{0, 3};
        pg.setLine(lines);
        pg.setXaxisLegend("Frechet Order Statistic Medians");
        pg.setYaxisLegend("Ordered Data Values");
        pg.setGraphTitle("Frechet probability plot:   gradient = " + Fmath.truncate(this.frechetLine[1], 4) + ", intercept = " + Fmath.truncate(this.frechetLine[0], 4) + ",  R = " + Fmath.truncate(this.frechetCorrCoeff, 4));
        pg.setGraphTitle2("  mu = " + Fmath.truncate(this.frechetParam[0], 4) + ", sigma = " + Fmath.truncate(this.frechetParam[1], 4) + ", gamma = " + Fmath.truncate(this.frechetParam[2], 4));
        pg.plot();
        this.frechetDone = true;
        this.probPlotDone = true;
    }

    public double frechetMu() {
        if (!this.frechetDone) {
            this.supressDisplay();
            this.frechetProbabilityPlot();
            this.restoreDisplay();
        }
        return this.frechetParam[0];
    }

    public double frechetMuError() {
        if (!this.frechetDone) {
            this.supressDisplay();
            this.frechetProbabilityPlot();
            this.restoreDisplay();
        }
        return this.frechetParamErrors[0];
    }

    public double frechetSigma() {
        if (!this.frechetDone) {
            this.supressDisplay();
            this.frechetProbabilityPlot();
            this.restoreDisplay();
        }
        return this.frechetParam[1];
    }

    public double frechetSigmaError() {
        if (!this.frechetDone) {
            this.supressDisplay();
            this.frechetProbabilityPlot();
            this.restoreDisplay();
        }
        return this.frechetParamErrors[1];
    }

    public double frechetGamma() {
        if (!this.frechetDone) {
            this.supressDisplay();
            this.frechetProbabilityPlot();
            this.restoreDisplay();
        }
        return this.frechetParam[2];
    }

    public double frechetGammaError() {
        if (!this.frechetDone) {
            this.supressDisplay();
            this.frechetProbabilityPlot();
            this.restoreDisplay();
        }
        return this.frechetParamErrors[2];
    }

    public double[] frechetOrderStatisticMedians() {
        if (!this.frechetDone) {
            this.supressDisplay();
            this.frechetProbabilityPlot();
            this.restoreDisplay();
        }
        return this.frechetOrderMedians;
    }

    public double frechetGradient() {
        if (!this.frechetDone) {
            this.supressDisplay();
            this.frechetProbabilityPlot();
            this.restoreDisplay();
        }
        return this.frechetLine[1];
    }

    public double frechetGradientError() {
        if (!this.frechetDone) {
            this.supressDisplay();
            this.frechetProbabilityPlot();
            this.restoreDisplay();
        }
        return this.frechetLineErrors[1];
    }

    public double frechetIntercept() {
        if (!this.frechetDone) {
            this.supressDisplay();
            this.frechetProbabilityPlot();
            this.restoreDisplay();
        }
        return this.frechetLine[0];
    }

    public double frechetInterceptError() {
        if (!this.frechetDone) {
            this.supressDisplay();
            this.frechetProbabilityPlot();
            this.restoreDisplay();
        }
        return this.frechetLineErrors[0];
    }

    public double frechetCorrelationCoefficient() {
        if (!this.frechetDone) {
            this.supressDisplay();
            this.frechetProbabilityPlot();
            this.restoreDisplay();
        }
        return this.frechetCorrCoeff;
    }

    public double frechetSumOfSquares() {
        if (!this.frechetDone) {
            this.supressDisplay();
            this.frechetProbabilityPlot();
            this.restoreDisplay();
        }
        return this.frechetSumOfSquares;
    }

    public void gumbelMinProbabilityPlot() {
        this.lastMethod = 5;
        this.gumbelMinNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression min = new Regression(this.sortedData, this.sortedData);
        double muest = this.mean;
        if (muest == 0.0) {
            muest = this.standardDeviation / 3.0;
        }
        double sigmaest = this.standardDeviation;
        double[] start = new double[]{muest, sigmaest};
        double[] step = new double[]{0.3 * muest, 0.3 * sigmaest};
        this.initialEstimates = start;
        double tolerance = 1.0E-10;
        min.addConstraint(1, -1, 0.0);
        GumbelMinProbPlotFunc gmippf = new GumbelMinProbPlotFunc();
        gmippf.setDataArray(this.numberOfDataPoints);
        min.simplex((RegressionFunction)gmippf, start, step, tolerance);
        this.gumbelMinParam = min.getBestEstimates();
        this.gumbelMinParamErrors = min.getBestEstimatesErrors();
        this.gumbelMinSumOfSquares = min.getSumOfSquares();
        this.gumbelMinOrderMedians = Stat.gumbelMinOrderStatisticMedians(this.gumbelMinParam[0], this.gumbelMinParam[1], this.numberOfDataPoints);
        Regression reg = new Regression(this.gumbelMinOrderMedians, this.sortedData);
        reg.linear();
        this.gumbelMinLine = reg.getBestEstimates();
        this.gumbelMinLineErrors = reg.getBestEstimatesErrors();
        this.gumbelMinCorrCoeff = reg.getSampleR();
        double[][] data = PlotGraph.data(2, this.numberOfDataPoints);
        data[0] = this.gumbelMinOrderMedians;
        data[1] = this.sortedData;
        data[2] = this.gumbelMinOrderMedians;
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            data[3][i] = this.gumbelMinLine[0] + this.gumbelMinLine[1] * this.gumbelMinOrderMedians[i];
        }
        PlotGraph pg = new PlotGraph(data);
        int[] points = new int[]{4, 0};
        pg.setPoint(points);
        int[] lines = new int[]{0, 3};
        pg.setLine(lines);
        pg.setXaxisLegend("Gumbel (minimum order statistic) Order Statistic Medians");
        pg.setYaxisLegend("Ordered Data Values");
        pg.setGraphTitle("Gumbel (minimum order statistic) probability plot:   gradient = " + Fmath.truncate(this.gumbelMinLine[1], 4) + ", intercept = " + Fmath.truncate(this.gumbelMinLine[0], 4) + ",  R = " + Fmath.truncate(this.gumbelMinCorrCoeff, 4));
        pg.setGraphTitle2("  mu = " + Fmath.truncate(this.gumbelMinParam[0], 4) + ", sigma = " + Fmath.truncate(this.gumbelMinParam[1], 4));
        pg.plot();
        this.gumbelMinDone = true;
        this.probPlotDone = true;
    }

    public double gumbelMinMu() {
        if (!this.gumbelMinDone) {
            this.supressDisplay();
            this.gumbelMinProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMinParam[0];
    }

    public double gumbelMinMuError() {
        if (!this.gumbelMinDone) {
            this.supressDisplay();
            this.gumbelMinProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMinParamErrors[0];
    }

    public double gumbelMinSigma() {
        if (!this.gumbelMinDone) {
            this.supressDisplay();
            this.gumbelMinProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMinParam[1];
    }

    public double gumbelMinSigmaError() {
        if (!this.gumbelMinDone) {
            this.supressDisplay();
            this.gumbelMinProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMinParamErrors[1];
    }

    public double[] gumbelMinOrderStatisticMedians() {
        if (!this.gumbelMinDone) {
            this.supressDisplay();
            this.gumbelMinProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMinOrderMedians;
    }

    public double gumbelMinGradient() {
        if (!this.gumbelMinDone) {
            this.supressDisplay();
            this.gumbelMinProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMinLine[1];
    }

    public double gumbelMinGradientError() {
        if (!this.gumbelMinDone) {
            this.supressDisplay();
            this.gumbelMinProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMinLineErrors[1];
    }

    public double gumbelMinIntercept() {
        if (!this.gumbelMinDone) {
            this.supressDisplay();
            this.gumbelMinProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMinLine[0];
    }

    public double gumbelMinInterceptError() {
        if (!this.gumbelMinDone) {
            this.supressDisplay();
            this.gumbelMinProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMinLineErrors[0];
    }

    public double gumbelMinCorrelationCoefficient() {
        if (!this.gumbelMinDone) {
            this.supressDisplay();
            this.gumbelMinProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMinCorrCoeff;
    }

    public double gumbelMinSumOfSquares() {
        if (!this.gumbelMinDone) {
            this.supressDisplay();
            this.gumbelMinProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMinSumOfSquares;
    }

    public void gumbelMaxProbabilityPlot() {
        this.lastMethod = 6;
        this.gumbelMaxNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression min = new Regression(this.sortedData, this.sortedData);
        double muest = this.mean;
        if (muest == 0.0) {
            muest = this.standardDeviation / 3.0;
        }
        double sigmaest = this.standardDeviation;
        double[] start = new double[]{muest, sigmaest};
        this.initialEstimates = start;
        double[] step = new double[]{0.3 * muest, 0.3 * sigmaest};
        double tolerance = 1.0E-10;
        min.addConstraint(1, -1, 0.0);
        GumbelMaxProbPlotFunc gmappf = new GumbelMaxProbPlotFunc();
        gmappf.setDataArray(this.numberOfDataPoints);
        min.simplex((RegressionFunction)gmappf, start, step, tolerance);
        this.gumbelMaxParam = min.getBestEstimates();
        this.gumbelMaxParamErrors = min.getBestEstimatesErrors();
        this.gumbelMaxSumOfSquares = min.getSumOfSquares();
        this.gumbelMaxOrderMedians = Stat.gumbelMaxOrderStatisticMedians(this.gumbelMaxParam[0], this.gumbelMaxParam[1], this.numberOfDataPoints);
        Regression reg = new Regression(this.gumbelMaxOrderMedians, this.sortedData);
        reg.linear();
        this.gumbelMaxLine = reg.getBestEstimates();
        this.gumbelMaxCorrCoeff = reg.getSampleR();
        double[][] data = PlotGraph.data(2, this.numberOfDataPoints);
        data[0] = this.gumbelMaxOrderMedians;
        data[1] = this.sortedData;
        data[2] = this.gumbelMaxOrderMedians;
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            data[3][i] = this.gumbelMaxLine[0] + this.gumbelMaxLine[1] * this.gumbelMaxOrderMedians[i];
        }
        PlotGraph pg = new PlotGraph(data);
        int[] points = new int[]{4, 0};
        pg.setPoint(points);
        int[] lines = new int[]{0, 3};
        pg.setLine(lines);
        pg.setXaxisLegend("Gumbel (maximum order statistic) Order Statistic Medians");
        pg.setYaxisLegend("Ordered Data Values");
        pg.setGraphTitle("Gumbel (maximum order statistic) probability plot:   gradient = " + Fmath.truncate(this.gumbelMaxLine[1], 4) + ", intercept = " + Fmath.truncate(this.gumbelMaxLine[0], 4) + ",  R = " + Fmath.truncate(this.gumbelMaxCorrCoeff, 4));
        pg.setGraphTitle2("  mu = " + Fmath.truncate(this.gumbelMaxParam[0], 4) + ", sigma = " + Fmath.truncate(this.gumbelMaxParam[1], 4));
        pg.plot();
        this.gumbelMaxDone = true;
        this.probPlotDone = true;
    }

    public double gumbelMaxMu() {
        if (!this.gumbelMaxDone) {
            this.supressDisplay();
            this.gumbelMaxProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMaxParam[0];
    }

    public double gumbelMaxMuError() {
        if (!this.gumbelMaxDone) {
            this.supressDisplay();
            this.gumbelMaxProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMaxParamErrors[0];
    }

    public double gumbelMaxSigma() {
        if (!this.gumbelMaxDone) {
            this.supressDisplay();
            this.gumbelMaxProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMaxParam[1];
    }

    public double gumbelMaxSigmaError() {
        if (!this.gumbelMaxDone) {
            this.supressDisplay();
            this.gumbelMaxProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMaxParamErrors[1];
    }

    public double[] gumbelMaxOrderStatisticMedians() {
        if (!this.gumbelMaxDone) {
            this.supressDisplay();
            this.gumbelMaxProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMaxOrderMedians;
    }

    public double gumbelMaxGradient() {
        if (!this.gumbelMaxDone) {
            this.supressDisplay();
            this.gumbelMaxProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMaxLine[1];
    }

    public double gumbelMaxGradientError() {
        if (!this.gumbelMaxDone) {
            this.supressDisplay();
            this.gumbelMaxProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMaxLineErrors[1];
    }

    public double gumbelMaxIntercept() {
        if (!this.gumbelMaxDone) {
            this.supressDisplay();
            this.gumbelMaxProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMaxLine[0];
    }

    public double gumbelMaxInterceptError() {
        if (!this.gumbelMaxDone) {
            this.supressDisplay();
            this.gumbelMaxProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMaxLineErrors[0];
    }

    public double gumbelMaxCorrelationCoefficient() {
        if (!this.gumbelMaxDone) {
            this.supressDisplay();
            this.gumbelMaxProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMaxCorrCoeff;
    }

    public double gumbelMaxSumOfSquares() {
        if (!this.gumbelMaxDone) {
            this.supressDisplay();
            this.gumbelMaxProbabilityPlot();
            this.restoreDisplay();
        }
        return this.gumbelMaxSumOfSquares;
    }

    public void rayleighProbabilityPlot() {
        this.lastMethod = 3;
        this.rayleighNumberOfParameters = 1;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression min = new Regression(this.sortedData, this.sortedData);
        double sigmaest = this.standardDeviation;
        double[] start = new double[]{sigmaest};
        double[] step = new double[]{0.3 * sigmaest};
        this.initialEstimates = start;
        double tolerance = 1.0E-10;
        min.addConstraint(0, -1, 0.0);
        RayleighProbPlotFunc rppf = new RayleighProbPlotFunc();
        rppf.setDataArray(this.numberOfDataPoints);
        min.simplex((RegressionFunction)rppf, start, step, tolerance);
        this.rayleighParam = min.getBestEstimates();
        this.rayleighParamErrors = min.getBestEstimatesErrors();
        this.rayleighSumOfSquares = min.getSumOfSquares();
        this.rayleighOrderMedians = Stat.weibullOrderStatisticMedians(0.0, this.rayleighParam[0] * Math.sqrt(2.0), 2.0, this.numberOfDataPoints);
        Regression reg = new Regression(this.rayleighOrderMedians, this.sortedData);
        reg.linear();
        this.rayleighLine = reg.getBestEstimates();
        this.rayleighLineErrors = reg.getBestEstimatesErrors();
        this.rayleighCorrCoeff = reg.getSampleR();
        double[][] data = PlotGraph.data(2, this.numberOfDataPoints);
        data[0] = this.rayleighOrderMedians;
        data[1] = this.sortedData;
        data[2] = this.rayleighOrderMedians;
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            data[3][i] = this.rayleighLine[0] + this.rayleighLine[1] * this.rayleighOrderMedians[i];
        }
        PlotGraph pg = new PlotGraph(data);
        int[] points = new int[]{4, 0};
        pg.setPoint(points);
        int[] lines = new int[]{0, 3};
        pg.setLine(lines);
        pg.setXaxisLegend("Rayleigh Order Statistic Medians");
        pg.setYaxisLegend("Ordered Data Values");
        pg.setGraphTitle("Rayleigh probability plot:   gradient = " + Fmath.truncate(this.rayleighLine[1], 4) + ", intercept = " + Fmath.truncate(this.rayleighLine[0], 4) + ",  R = " + Fmath.truncate(this.rayleighCorrCoeff, 4));
        pg.setGraphTitle2("  beta = " + Fmath.truncate(this.rayleighParam[0], 4));
        pg.plot();
        this.rayleighDone = true;
        this.probPlotDone = true;
    }

    public double rayleighBeta() {
        if (!this.rayleighDone) {
            this.supressDisplay();
            this.rayleighProbabilityPlot();
            this.restoreDisplay();
        }
        return this.rayleighParam[0];
    }

    public double rayleighBetaError() {
        if (!this.rayleighDone) {
            this.supressDisplay();
            this.rayleighProbabilityPlot();
            this.restoreDisplay();
        }
        return this.rayleighParamErrors[0];
    }

    public double[] rayleighOrderStatisticMedians() {
        if (!this.rayleighDone) {
            this.supressDisplay();
            this.rayleighProbabilityPlot();
            this.restoreDisplay();
        }
        return this.rayleighOrderMedians;
    }

    public double rayleighGradient() {
        if (!this.rayleighDone) {
            this.supressDisplay();
            this.rayleighProbabilityPlot();
            this.restoreDisplay();
        }
        return this.rayleighLine[1];
    }

    public double rayleighGradientError() {
        if (!this.rayleighDone) {
            this.supressDisplay();
            this.rayleighProbabilityPlot();
            this.restoreDisplay();
        }
        return this.rayleighLineErrors[1];
    }

    public double rayleighIntercept() {
        if (!this.rayleighDone) {
            this.supressDisplay();
            this.rayleighProbabilityPlot();
            this.restoreDisplay();
        }
        return this.rayleighLine[0];
    }

    public double rayleighInterceptError() {
        if (!this.rayleighDone) {
            this.supressDisplay();
            this.rayleighProbabilityPlot();
            this.restoreDisplay();
        }
        return this.rayleighLineErrors[0];
    }

    public double rayleighCorrelationCoefficient() {
        if (!this.rayleighDone) {
            this.supressDisplay();
            this.rayleighProbabilityPlot();
            this.restoreDisplay();
        }
        return this.rayleighCorrCoeff;
    }

    public double rayleighSumOfSquares() {
        if (!this.rayleighDone) {
            this.supressDisplay();
            this.rayleighProbabilityPlot();
            this.restoreDisplay();
        }
        return this.rayleighSumOfSquares;
    }

    public void paretoProbabilityPlot() {
        this.lastMethod = 4;
        this.paretoNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression min = new Regression(this.sortedData, this.sortedData);
        double betaest = this.minimum;
        double alphaest = this.mean / (this.mean - betaest);
        double[] start = new double[]{alphaest, betaest};
        double[] step = new double[]{0.3 * alphaest, 0.3 * betaest};
        this.initialEstimates = start;
        double tolerance = 1.0E-10;
        ParetoProbPlotFunc pppf = new ParetoProbPlotFunc();
        pppf.setDataArray(this.numberOfDataPoints);
        min.simplex((RegressionFunction)pppf, start, step, tolerance);
        this.paretoParam = min.getBestEstimates();
        this.paretoParamErrors = min.getBestEstimatesErrors();
        this.paretoSumOfSquares = min.getSumOfSquares();
        this.paretoOrderMedians = Stat.paretoOrderStatisticMedians(this.paretoParam[0], this.paretoParam[1], this.numberOfDataPoints);
        Regression reg = new Regression(this.paretoOrderMedians, this.sortedData);
        reg.linear();
        this.paretoLine = reg.getBestEstimates();
        this.paretoLineErrors = reg.getBestEstimatesErrors();
        this.paretoCorrCoeff = reg.getSampleR();
        double[][] data = PlotGraph.data(2, this.numberOfDataPoints);
        data[0] = this.paretoOrderMedians;
        data[1] = this.sortedData;
        data[2] = this.paretoOrderMedians;
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            data[3][i] = this.paretoLine[0] + this.paretoLine[1] * this.paretoOrderMedians[i];
        }
        PlotGraph pg = new PlotGraph(data);
        int[] points = new int[]{4, 0};
        pg.setPoint(points);
        int[] lines = new int[]{0, 3};
        pg.setLine(lines);
        pg.setXaxisLegend("Pareto Order Statistic Medians");
        pg.setYaxisLegend("Ordered Data Values");
        pg.setGraphTitle("Pareto probability plot:   gradient = " + Fmath.truncate(this.paretoLine[1], 4) + ", intercept = " + Fmath.truncate(this.paretoLine[0], 4) + ",  R = " + Fmath.truncate(this.paretoCorrCoeff, 4));
        pg.setGraphTitle2("  alpha = " + Fmath.truncate(this.paretoParam[0], 4) + ", beta = " + Fmath.truncate(this.paretoParam[1], 4));
        pg.plot();
        this.paretoDone = true;
        this.probPlotDone = true;
    }

    public double paretoAlpha() {
        if (!this.paretoDone) {
            this.supressDisplay();
            this.paretoProbabilityPlot();
            this.restoreDisplay();
        }
        return this.paretoParam[0];
    }

    public double paretoAlphaError() {
        if (!this.paretoDone) {
            this.supressDisplay();
            this.paretoProbabilityPlot();
            this.restoreDisplay();
        }
        return this.paretoParamErrors[0];
    }

    public double paretoBeta() {
        if (!this.paretoDone) {
            this.supressDisplay();
            this.paretoProbabilityPlot();
            this.restoreDisplay();
        }
        return this.paretoParam[1];
    }

    public double paretoBetaError() {
        if (!this.paretoDone) {
            this.supressDisplay();
            this.paretoProbabilityPlot();
            this.restoreDisplay();
        }
        return this.paretoParamErrors[1];
    }

    public double[] paretoOrderStatisticMedians() {
        if (!this.paretoDone) {
            this.supressDisplay();
            this.paretoProbabilityPlot();
            this.restoreDisplay();
        }
        return this.paretoOrderMedians;
    }

    public double paretoGradient() {
        if (!this.paretoDone) {
            this.supressDisplay();
            this.paretoProbabilityPlot();
            this.restoreDisplay();
        }
        return this.paretoLine[1];
    }

    public double paretoGradientError() {
        if (!this.paretoDone) {
            this.supressDisplay();
            this.paretoProbabilityPlot();
            this.restoreDisplay();
        }
        return this.paretoLineErrors[1];
    }

    public double paretoIntercept() {
        if (!this.paretoDone) {
            this.supressDisplay();
            this.paretoProbabilityPlot();
            this.restoreDisplay();
        }
        return this.paretoLine[0];
    }

    public double paretoInterceptError() {
        if (!this.paretoDone) {
            this.supressDisplay();
            this.paretoProbabilityPlot();
            this.restoreDisplay();
        }
        return this.paretoLineErrors[0];
    }

    public double paretoCorrelationCoefficient() {
        if (!this.paretoDone) {
            this.supressDisplay();
            this.paretoProbabilityPlot();
            this.restoreDisplay();
        }
        return this.paretoCorrCoeff;
    }

    public double paretoSumOfSquares() {
        if (!this.paretoDone) {
            this.supressDisplay();
            this.paretoProbabilityPlot();
            this.restoreDisplay();
        }
        return this.paretoSumOfSquares;
    }

    public void fDistributionProbabilityPlot(int nu1, int nu2) {
        this.lastMethod = 15;
        this.fDistributionNumberOfParameters = 0;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        this.fDistributionOrderMedians = Stat.fDistributionOrderStatisticMedians(nu1, nu2, this.numberOfDataPoints);
        Regression reg = new Regression(this.fDistributionOrderMedians, this.sortedData);
        reg.linear();
        this.fDistributionLine = reg.getBestEstimates();
        this.fDistributionLineErrors = reg.getBestEstimatesErrors();
        this.fDistributionCorrCoeff = reg.getSampleR();
        double[][] data = PlotGraph.data(2, this.numberOfDataPoints);
        data[0] = this.fDistributionOrderMedians;
        data[1] = this.sortedData;
        data[2] = this.fDistributionOrderMedians;
        for (int i = 0; i < this.numberOfDataPoints; ++i) {
            data[3][i] = this.fDistributionLine[0] + this.fDistributionLine[1] * this.fDistributionOrderMedians[i];
        }
        PlotGraph pg = new PlotGraph(data);
        int[] points = new int[]{4, 0};
        pg.setPoint(points);
        int[] lines = new int[]{0, 3};
        pg.setLine(lines);
        pg.setXaxisLegend("F-distribution Order Statistic Medians");
        pg.setYaxisLegend("Ordered Data Values");
        pg.setGraphTitle("F-distribution probability plot:   gradient = " + Fmath.truncate(this.fDistributionLine[1], 4) + ", intercept = " + Fmath.truncate(this.fDistributionLine[0], 4) + ",  R = " + Fmath.truncate(this.fDistributionCorrCoeff, 4));
        pg.setGraphTitle2("  nu1 = " + nu1 + ", nu2 = " + nu2);
        pg.plot();
        this.fDistributionDone = true;
        this.probPlotDone = true;
    }

    public double[] fDistributionOrderStatisticMedians() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionOrderMedians;
    }

    public double fDistributionGradient() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionLine[1];
    }

    public double fDistributionGradientError() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionLineErrors[1];
    }

    public double fDistributionIntercept() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionLine[0];
    }

    public double fDistributionInterceptError() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionLineErrors[0];
    }

    public double fDistributionCorrelationCoefficient() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionCorrCoeff;
    }

    public double fDistributionSumOfSquares() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionSumOfSquares;
    }

    public double[] orderedData() {
        return this.sortedData;
    }

    public int numberOfDataPoints() {
        return this.numberOfDataPoints;
    }

    public double mean() {
        return this.mean;
    }

    public double standardDeviation() {
        if (!this.probPlotDone) {
            throw new IllegalArgumentException("no probability plot method has been called");
        }
        return this.standardDeviation;
    }

    public double minimum() {
        return this.minimum;
    }

    public double maximum() {
        return this.maximum;
    }

    public double delta() {
        return this.delta;
    }

    public void resetDelta(double delta) {
        this.delta = delta;
    }

    public void setDenominatorToN() {
        this.nFactorOptionI = true;
        this.arrayAsStat.setDenominatorToN();
        this.standardDeviation = this.arrayAsStat.standardDeviation();
        this.nFactorReset = true;
    }

    public void setDenominatorToNminusOne() {
        this.nFactorOptionI = false;
        this.arrayAsStat.setDenominatorToNminusOne();
        this.standardDeviation = this.arrayAsStat.standardDeviation();
        this.nFactorReset = true;
    }

    public double[] getInitialEstimates() {
        return this.initialEstimates;
    }
}

