/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.bior.pipeline.Treat.AnnotateCache;
import edu.mayo.bior.pipeline.Treat.TreatPipelineMultiCmd;
import edu.mayo.bior.pipeline.Treat.TreatPipelineSingleThread;
import edu.mayo.exec.AbnormalExitException;
import edu.mayo.pipes.history.History;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;

public class AnnotatePipe
extends AbstractPipe<History, History> {
    private List<History> mOutputQueue = new ArrayList<History>();
    private AnnotateCache mAnnotateCache = null;
    private boolean mIsMultiProcess = false;
    private TreatPipelineMultiCmd mTreatPipelineMulti = null;
    private TreatPipelineSingleThread mTreatPipelineSingle = null;
    private String mUuid = UUID.randomUUID().toString();
    private String mCachePath;
    private String mCacheMissDir;
    private String mCacheMissPath;
    private String mConfigFilePropsPath;
    private int mLineNum = 0;

    public AnnotatePipe(String cachePath, String cacheMissDir, String configFilePropsPath) throws IOException {
        this.mCachePath = cachePath;
        this.mCacheMissDir = cacheMissDir;
        this.mCacheMissPath = cacheMissDir + "/" + this.mUuid + ".cache.misses";
        this.mConfigFilePropsPath = configFilePropsPath;
        this.mAnnotateCache = new AnnotateCache(this.mCachePath, this.mCacheMissPath);
    }

    protected History processNextStart() throws NoSuchElementException {
        try {
            ++this.mLineNum;
            if (this.mOutputQueue.size() > 0) {
                return this.mOutputQueue.remove(0);
            }
            if (!this.starts.hasNext()) {
                throw new NoSuchElementException("No more input to AnnotatePipe");
            }
            while (this.mOutputQueue.size() == 0) {
                History histIn = (History)this.starts.next();
                List<History> cacheOutput = this.getFromCache(histIn);
                if (cacheOutput != null) {
                    this.addToOutputQueue(cacheOutput);
                    continue;
                }
                List<History> annotatePipeOutput = this.getFromAnnotatePipe(histIn);
                this.addToOutputQueue(annotatePipeOutput);
            }
            return this.mOutputQueue.remove(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private void addToOutputQueue(List<History> output) {
        if (output.size() > 1) {
            System.err.println("WARNING: Input produced " + output.size() + " output lines!  Data line " + this.mLineNum);
        }
        for (History hist : output) {
            this.mOutputQueue.add(hist);
        }
    }

    private List<History> getFromCache(History histIn) throws IOException {
        if (this.mAnnotateCache == null) {
            return new ArrayList<History>();
        }
        String chrom = (String)histIn.get(0);
        int start = Integer.parseInt((String)histIn.get(1));
        int end = Integer.parseInt((String)histIn.get(1));
        List<String> matchingLines = this.mAnnotateCache.getCacheLines(chrom, start, end);
        ArrayList<History> matchingHistoryList = new ArrayList<History>();
        for (String s : matchingLines) {
            matchingHistoryList.add(new History(s));
        }
        return matchingHistoryList;
    }

    private List<History> getFromAnnotatePipe(History histIn) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException, URISyntaxException {
        History histOut = null;
        if (this.mIsMultiProcess) {
            if (this.mTreatPipelineMulti == null) {
                this.mTreatPipelineMulti = new TreatPipelineMultiCmd(this.mConfigFilePropsPath);
            }
            this.mTreatPipelineMulti.setStarts(Arrays.asList(histIn));
            histOut = (History)this.mTreatPipelineMulti.next();
        } else {
            if (this.mTreatPipelineSingle == null) {
                this.mTreatPipelineSingle = new TreatPipelineSingleThread(this.mConfigFilePropsPath);
            }
            this.mTreatPipelineSingle.setStarts(Arrays.asList(histIn));
            histOut = (History)this.mTreatPipelineSingle.next();
        }
        return Arrays.asList(histOut);
    }
}

