/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat;

import edu.mayo.pipes.JSON.tabix.TabixReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AnnotateCache {
    private String mCachePath;
    private String mCacheMissFilePath;
    private TabixReader mTabixReader;
    private boolean mIsCacheReadable = false;
    private boolean mIsMissFileWritable = false;
    FileOutputStream mMissFileOut = null;

    public AnnotateCache(String cachePath, String cacheMissFilePath) throws IOException {
        this.mCachePath = cachePath;
        this.mCacheMissFilePath = cacheMissFilePath;
        File cacheFile = new File(cachePath);
        boolean bl = this.mIsCacheReadable = cacheFile.exists() && cacheFile.canRead();
        if (this.mIsCacheReadable) {
            this.mTabixReader = new TabixReader(cacheFile.getCanonicalPath());
        }
        File cacheMissFile = new File(cacheMissFilePath);
        try {
            boolean bl2 = this.mIsMissFileWritable = (cacheMissFile.exists() || cacheMissFile.createNewFile()) && cacheMissFile.canWrite();
            if (this.mIsMissFileWritable) {
                this.mMissFileOut = new FileOutputStream(this.mCacheMissFilePath, true);
            }
        }
        catch (Exception e) {
            System.err.println("Warning: Could not write to cache-miss file: " + cacheMissFilePath);
            System.err.println(e.getMessage());
        }
    }

    public List<String> getCacheLines(String chrom, int start, int end) throws IOException {
        if (!this.mIsCacheReadable) {
            return new ArrayList<String>();
        }
        String chrMinMaxQuery = String.format("%s:%d-%d", chrom.replace("chr", ""), start, end);
        String line = null;
        ArrayList<String> matches = new ArrayList<String>();
        TabixReader.Iterator records = this.mTabixReader.query(chrMinMaxQuery);
        while (records != null && (line = records.next()) != null) {
            matches.add(line);
        }
        return matches;
    }

    public void appendCacheMiss(String line) {
        try {
            if (!this.mIsMissFileWritable || line == null || line.length() == 0) {
                return;
            }
            String[] parts = line.split("\t");
            if (parts.length >= 5) {
                this.mMissFileOut.write(this.getVcfLine5(parts).getBytes());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getVcfLine5(String[] parts) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            str.append(parts[i]).append("\t");
        }
        str.append(".\t.\t.\n");
        return str.toString();
    }

    public void closeMissFileStream() {
        try {
            this.mMissFileOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

